/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.common.errorcode.QmcErrorCodeUtils;
import kd.qmc.qcbd.common.util.AverageAssignUtil;
import kd.qmc.qcbd.common.util.UpgradeSqlUtil;

public class QmcRouteServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(QmcRouteServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String qmcRouteKey, String sqlFileName) {
        try {
            ORM orm = ORM.create();
            DBRoute routeQmc = DBRoute.of((String)"qmc");
            SqlBuilder sbSql = new SqlBuilder();
            sbSql.append("select routeEntry.fid,routeEntry.fentryid,routeEntry.frouteprocentryid,routeEntry.fsrcopentryid,routeEntry.fparentid,routeEntry.foperationno from t_qcbd_qroute route ", new Object[0]);
            sbSql.append("inner join t_qcbd_rproentry routeEntry on route.fid =routeEntry.fid ", new Object[0]);
            sbSql.append("where  route.forigin='A' and (routeEntry.frouteprocentryid=0 or routeEntry.frouteprocentryid is null)", new Object[0]);
            DataSet routeRS = DB.queryDataSet((String)QmcRouteServiceImpl.class.getName(), (DBRoute)routeQmc, (SqlBuilder)sbSql);
            DynamicObjectCollection routeObj = orm.toPlainDynamicObjectCollection(routeRS);
            Map<Long, List<DynamicObject>> routeMap = routeObj.stream().collect(Collectors.groupingBy(x -> x.getLong("fid")));
            List idLst = routeObj.stream().map(p -> p.getLong("fid")).collect(Collectors.toList());
            List routeIdLstGrp = AverageAssignUtil.getAssignListByMaxSize(idLst, (int)10000);
            int i = 0;
            for (List routeIdLst : routeIdLstGrp) {
                try {
                    logger.info("AssignList Count" + ++i);
                    this.updateRoute(orm, routeMap, routeIdLst);
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        }
        catch (Exception ex) {
            logger.error("beforeExecuteSqlWithResult AssignList" + ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
        }
        return new UpgradeResult();
    }

    private void updateRoute(ORM orm, Map<Long, List<DynamicObject>> routeMap, List<Long> routeIdLst) {
        UpgradeResult result;
        DBRoute routeQmc = DBRoute.of((String)"qmc");
        DBRoute routeMMC = DBRoute.of((String)"scm");
        if (!DB.exitsTable((DBRoute)routeMMC, (String)"t_pdm_routeoperation")) {
            throw new KDException(QmcErrorCodeUtils.create((String)"exsittablet_pdm_routeoperation", (String)"error no table t_pdm_routeoperation").getErrorCode(), new Object[0]);
        }
        SqlBuilder sbSql = new SqlBuilder();
        Boolean existSecOpentryIdCol = DB.existColumn((DBRoute)routeMMC, (String)"t_pdm_routeoperation", (String)"fsrcopentryid");
        sbSql.append("select fid,fentryid,fparentid,foperationno", new Object[0]);
        if (existSecOpentryIdCol.booleanValue()) {
            sbSql.append(",fsrcopentryid", new Object[0]);
        }
        sbSql.append(" from t_pdm_routeoperation where", new Object[0]);
        sbSql.appendIn("fid", routeIdLst.toArray());
        DataSet routeMMCRS = DB.queryDataSet((String)QmcRouteServiceImpl.class.getName(), (DBRoute)routeMMC, (SqlBuilder)sbSql);
        DynamicObjectCollection routeMMCObj = orm.toPlainDynamicObjectCollection(routeMMCRS);
        Map<Long, List<DynamicObject>> routeMMCMap = routeMMCObj.stream().collect(Collectors.groupingBy(x -> x.getLong("fid")));
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (Long routId : routeIdLst) {
            List<DynamicObject> routeRows = routeMap.get(routId);
            List<DynamicObject> routeMMCRows = routeMMCMap.get(routId);
            if (routeRows == null || routeRows.size() <= 0 || routeMMCRows == null || routeMMCRows.size() <= 0) continue;
            for (DynamicObject routeRow : routeRows) {
                Long srcopentryidMMCS;
                Long entryIDMMC;
                String fparentid = routeRow.getString("fparentid");
                String foperationno = routeRow.getString("foperationno");
                Long fentryIdQmc = routeRow.getLong("fentryid");
                List routeMMCRowsMatch = routeMMCRows.stream().filter(p -> StringUtils.equalsIgnoreCase((CharSequence)fparentid, (CharSequence)p.getString("fparentid")) && StringUtils.equalsIgnoreCase((CharSequence)foperationno, (CharSequence)p.getString("foperationno"))).collect(Collectors.toList());
                if (routeMMCRowsMatch == null || routeMMCRowsMatch.size() <= 0) continue;
                DynamicObject routeMMCRow = (DynamicObject)routeMMCRowsMatch.get(0);
                Long srcopentryidMMC = entryIDMMC = Long.valueOf(routeMMCRow.getLong("fentryid"));
                if (existSecOpentryIdCol.booleanValue() && 0L != (srcopentryidMMCS = Long.valueOf(routeMMCRow.getLong("fsrcopentryid")))) {
                    srcopentryidMMC = srcopentryidMMCS;
                }
                Object[] param = new Object[]{entryIDMMC, srcopentryidMMC, routId, fentryIdQmc};
                paramList.add(param);
            }
        }
        String updateSql = "update t_qcbd_rproentry set frouteprocentryid=?,fsrcopentryid=?  where fid =? and fentryid =?";
        if (paramList.size() > 0 && !(result = UpgradeSqlUtil.excuteSqlBatch((String)QmcRouteServiceImpl.class.getName(), (String)updateSql, (DBRoute)routeQmc, paramList)).isSuccess()) {
            throw new KDException(QmcErrorCodeUtils.create((String)"updaterproentry", (String)result.getErrorInfo()).getErrorCode(), new Object[0]);
        }
    }
}

