/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.business.repairtool.DataRepairUpgradeHelper;
import kd.qmc.qcbd.common.util.AverageAssignUtil;
import kd.qmc.qcbd.common.util.ParameterUtil;
import kd.qmc.qcbd.common.util.UpgradeSqlUtil;

public class TransacTypeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TransacTypeServiceImpl.class);
    private static final DBRoute dbRoute = new DBRoute("qmc");
    private static final Long[] stdBiztypeArr = new Long[]{959929179238017024L, 959929527046481920L, 960041773667747840L, 960042738642880512L, 960042976074041344L, 1377522299225319424L, 1408539848628799488L, 1157790804945938432L, 1157791038325170176L, 1176040910430171136L};
    private static final Long[] DIMENIDS_WITHSUP = new Long[]{1615104834913007616L, 1599303399160004608L, 1599887438686307328L};
    private static final Long[] DIMENIDS_QROUTE = new Long[]{1615104834913007616L, 1599908243205898240L, 1599908442980597760L, 1599908959274254336L};
    private static final Long[] DIMENIDS_MAT = new Long[]{1615104834913007616L, 1599303399160004608L};
    private static final Long[] DIMENIDS_QROUTEWITHMAT_E = new Long[]{1615104834913007616L, 1599908243205898240L, 1599908442980597760L, 1599908959274254336L, 1599303399160004608L};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String qmcRouteKey, String sqlFileName) {
        String className = this.getClass().getName();
        ThreadPools.executeOnce((String)className, () -> {
            UpgradeResult result = new UpgradeResult();
            try {
                boolean newCustomer = UpgradeSqlUtil.isNewCustomer((String)this.getClass().getName());
                if (newCustomer) {
                    DataRepairUpgradeHelper.updateDataStatusByDb((String)"transactype_updata", (String)"1");
                    return;
                }
                if (sqlFileName.contains("_qcbd_")) {
                    result = this.repairDataSingleApp(new String[]{"qcp_inspecapbill_example", "qcp_inspecpbill_example", "qcp_baddealpbill_example", "qcbd_joininspect_example"}, null);
                } else if (sqlFileName.contains("_qcp_")) {
                    result = this.repairDataSingleApp(new String[]{"qcp_inspecapply", "qcp_incominginspct", "qcp_baddeal", "qcp_joininspect", "qcp_taiguinspct"}, null);
                } else if (sqlFileName.contains("_qcpp_")) {
                    result = this.repairDataSingleApp(new String[]{"qcpp_manuinspecapply", "qcpp_manuinspec", "qcpp_manubaddeal", "qcpp_joininspect"}, null);
                } else if (sqlFileName.contains("_qcas_")) {
                    result = this.repairDataSingleApp(new String[]{"qcas_inspecapply", "qcas_saleinspec", "qcas_salebaddeal", "qcas_joininspect"}, null);
                } else if (sqlFileName.contains("_qcnp_")) {
                    result = this.repairDataSingleApp(new String[]{"qcnp_inspecapply", "qcnp_invbalinspec", "qcnp_invbalbaddeal", "qcnp_joininspect"}, null);
                }
                if (result.isSuccess()) {
                    DataRepairUpgradeHelper.updateDataStatusByDb((String)"transactype_updata", (String)"1");
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            finally {
                logger.info(result.isSuccess() + "\uff1a" + result.getErrorInfo());
            }
        });
        return new UpgradeResult();
    }

    public UpgradeResult executeStd() {
        UpgradeResult resultQcnp;
        UpgradeResult resultQcas;
        UpgradeResult resultQcpp;
        UpgradeResult result = new UpgradeResult();
        StringBuilder errMsg = new StringBuilder();
        UpgradeResult resultQcp = this.repairDataSingleApp(new String[]{"qcp_inspecapply", "qcp_incominginspct", "qcp_baddeal", "qcp_joininspect", "qcp_taiguinspct"}, null);
        if (!resultQcp.isSuccess()) {
            errMsg.append(resultQcp.getErrorInfo());
        }
        if (!(resultQcpp = this.repairDataSingleApp(new String[]{"qcpp_manuinspecapply", "qcpp_manuinspec", "qcpp_manubaddeal", "qcpp_joininspect"}, null)).isSuccess()) {
            errMsg.append(resultQcp.getErrorInfo());
        }
        if (!(resultQcas = this.repairDataSingleApp(new String[]{"qcas_inspecapply", "qcas_saleinspec", "qcas_salebaddeal", "qcas_joininspect"}, null)).isSuccess()) {
            errMsg.append(resultQcp.getErrorInfo());
        }
        if (!(resultQcnp = this.repairDataSingleApp(new String[]{"qcnp_inspecapply", "qcnp_invbalinspec", "qcnp_invbalbaddeal", "qcnp_joininspect"}, null)).isSuccess()) {
            errMsg.append(resultQcp.getErrorInfo());
        }
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            result.setSuccess(false);
            String errInfoStr = errMsg.toString();
            result.setErrorInfo(errInfoStr);
        } else {
            DataRepairUpgradeHelper.updateDataStatusByDb((String)"transactype_updata", (String)"1");
        }
        return result;
    }

    public UpgradeResult executeAccurate(Map<String, Object> params) {
        UpgradeResult result = new UpgradeResult();
        if (Objects.nonNull(params)) {
            Long[] dataIdArray = (Long[])Arrays.stream(params.get("dataid_tag").toString().split(",")).map(Long::valueOf).toArray(Long[]::new);
            String entityName = params.get("entryobjectid").toString();
            result = this.repairDataSingleBill(entityName, null, dataIdArray);
        }
        return result;
    }

    private UpgradeResult repairDataSingleApp(String[] entityArr, Object[] biztypeIdArr) {
        UpgradeResult result = new UpgradeResult();
        StringBuilder errMsg = new StringBuilder();
        for (String entity : entityArr) {
            logger.info(entity + "repari start\uff1b");
            result = this.repairDataSingleBill(entity, biztypeIdArr, null);
            if (!result.isSuccess()) {
                errMsg.append(entity);
                errMsg.append(" exeute fail:");
                errMsg.append(result.getErrorInfo());
                errMsg.append("\r\n");
                logger.error(errMsg.toString());
            }
            logger.info(entity + "repari end\uff1b");
        }
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            result.setSuccess(false);
            result.setErrorInfo(errMsg.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult repairDataSingleBill(String entityName, Object[] bizTypeIds, Long[] dataIdArray) {
        UpgradeResult result = new UpgradeResult();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        String tableName = mainEntityType.getAlias();
        String appId = mainEntityType.getBizAppNumber();
        if (!DB.exitsTable((DBRoute)dbRoute, (String)tableName)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8868\u540d%s\u4e0d\u5b58\u5728\u3002", (String)"TransacTypeServiceImpl_0", (String)"qmc-qcbd-mservice", (Object[])new Object[0]), tableName);
            return UpgradeSqlUtil.buildResult((UpgradeResult)result, (boolean)Boolean.FALSE, (String)errMsg);
        }
        List columnNames = DB.getColumnNames((DBRoute)dbRoute, (String)tableName);
        if (!this.containsFieldIngoreCase(columnNames, "ftransactypeid")) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8868%s\u5b57\u6bb5ftransactypeid\u4e0d\u5b58\u5728\u3002", (String)"TransacTypeServiceImpl_1", (String)"qmc-qcbd-mservice", (Object[])new Object[0]), tableName);
            return UpgradeSqlUtil.buildResult((UpgradeResult)result, (boolean)Boolean.FALSE, (String)errMsg);
        }
        boolean hasJoinField = this.containsFieldIngoreCase(columnNames, "fjoininspectflag");
        String biztypeField = this.containsFieldIngoreCase(columnNames, "fbiztypeid") ? "fbiztypeid" : "fbiztype";
        HashMap<String, Boolean> cacheMap = new HashMap<String, Boolean>(16);
        boolean excuteStatus = true;
        HashMap<String, Long> tracsacTypeIdCacheMap = new HashMap<String, Long>(16);
        HashMap<Long, Long> biztypeTraGrpCacheMap = new HashMap<Long, Long>(16);
        while (excuteStatus) {
            DynamicObjectCollection bills = this.getRepairBills(bizTypeIds, tableName, hasJoinField, biztypeField, dataIdArray);
            if (bills.size() <= 0) {
                return result;
            }
            if (100000 > bills.size()) {
                excuteStatus = false;
            }
            List assignList = AverageAssignUtil.getAssignListByMaxSize((List)bills, (int)5000);
            for (List onceRepairBills : assignList) {
                if (!hasJoinField) {
                    this.setJoinFlag(mainEntityType, onceRepairBills);
                }
                Map<Object, List<DynamicObject>> orgGroupMap = onceRepairBills.stream().collect(Collectors.groupingBy(o -> o.getInt("fjoininspectflag") + "_" + o.getLong("forgid") + "_" + o.getLong(biztypeField)));
                for (Map.Entry<Object, List<DynamicObject>> longListEntry : orgGroupMap.entrySet()) {
                    List<DynamicObject> dyoList = longListEntry.getValue();
                    DynamicObject afterGroupDyo = dyoList.get(0);
                    long bizTypeId = afterGroupDyo.getLong(biztypeField);
                    long orgId = afterGroupDyo.getLong("forgid");
                    TransacTypeServiceImpl.cacheIsInspItemMod(cacheMap, appId, orgId);
                    String inspItemMod = (Boolean)cacheMap.get(appId + orgId) != false ? "1" : "0";
                    String joininspectflag = afterGroupDyo.getInt("fjoininspectflag") == 1 ? "1" : "0";
                    SqlBuilder updateSql = new SqlBuilder();
                    updateSql.append(String.format("update %s", tableName), new Object[0]);
                    Long tracsacTypeId = this.getTracsacTypeId(tracsacTypeIdCacheMap, biztypeTraGrpCacheMap, bizTypeId, joininspectflag, inspItemMod);
                    updateSql.append(" set ftransactypeid = ? where", new Object[]{tracsacTypeId});
                    List<Object> fids = dyoList.stream().map(o -> o.getLong("fid")).collect(Collectors.toList());
                    updateSql.appendIn("fid", fids);
                    TXHandle h1 = TX.requiresNew();
                    Throwable throwable = null;
                    try {
                        try {
                            result = UpgradeSqlUtil.updateBySqlBuild((DBRoute)dbRoute, (SqlBuilder)updateSql);
                            if (!result.isSuccess()) {
                                UpgradeResult upgradeResult = result;
                                return upgradeResult;
                            }
                            result = this.repairInspResultByEntity(appId, entityName, fids, tracsacTypeId);
                        }
                        finally {
                            if (result.isSuccess()) continue;
                            excuteStatus = false;
                            h1.markRollback();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (h1 == null) continue;
                        if (throwable != null) {
                            try {
                                h1.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        h1.close();
                    }
                }
            }
        }
        return result;
    }

    private UpgradeResult repairInspResultByEntity(String appId, String entityName, List<Object> fids, Long tracsacTypeId) {
        UpgradeResult result = new UpgradeResult();
        String resultTableName = "t_" + appId + "_inspresult";
        if (!DB.exitsTable((DBRoute)dbRoute, (String)resultTableName)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8868\u540d%s\u4e0d\u5b58\u5728\u3002", (String)"TransacTypeServiceImpl_0", (String)"qmc-qcbd-mservice", (Object[])new Object[0]), resultTableName);
            return UpgradeSqlUtil.buildResult((UpgradeResult)result, (boolean)Boolean.FALSE, (String)errMsg);
        }
        List columnNames = DB.getColumnNames((DBRoute)dbRoute, (String)resultTableName);
        if (!this.containsFieldIngoreCase(columnNames, "ftransactypeid")) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8868%s\u5b57\u6bb5ftransactypeid\u4e0d\u5b58\u5728\u3002", (String)"TransacTypeServiceImpl_1", (String)"qmc-qcbd-mservice", (Object[])new Object[0]), resultTableName);
            return UpgradeSqlUtil.buildResult((UpgradeResult)result, (boolean)Boolean.FALSE, (String)errMsg);
        }
        SqlBuilder updateSql = new SqlBuilder();
        updateSql.append(String.format("update %s a set ftransactypeid = ? where fassentitynumberid = ? and", resultTableName), new Object[]{tracsacTypeId, entityName});
        updateSql.appendIn("a.fassbillid", fids.stream().map(o -> o.toString()).toArray());
        return UpgradeSqlUtil.updateBySqlBuild((DBRoute)dbRoute, (SqlBuilder)updateSql);
    }

    private DynamicObjectCollection getRepairBills(Object[] bizTypeIds, String tableName, boolean hasJoinField, String biztypeField, Long[] dataIdArray) {
        SqlBuilder selectSql = new SqlBuilder();
        selectSql.append("select top 100000 fid,forgid,", new Object[0]);
        selectSql.append(biztypeField, new Object[0]);
        if (hasJoinField) {
            selectSql.append(String.format(",fjoininspectflag from %s where ftransactypeid = 0 and", tableName), new Object[0]);
        } else {
            selectSql.append(String.format(",'1' fjoininspectflag from %s where ftransactypeid = 0 and", tableName), new Object[0]);
        }
        if (!ArrayUtils.isEmpty((Object[])dataIdArray)) {
            selectSql.appendIn("fid", (Object[])dataIdArray);
        } else if (Objects.nonNull(bizTypeIds)) {
            selectSql.appendIn(biztypeField, bizTypeIds);
        } else {
            selectSql.append(biztypeField + "!=0", new Object[0]);
        }
        DataSet rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (SqlBuilder)selectSql);
        return new ORMImpl().toPlainDynamicObjectCollection(rows);
    }

    private void setJoinFlag(MainEntityType mainEntityType, List<DynamicObject> bills) {
        Map allEntities = mainEntityType.getAllEntities();
        if (allEntities.containsKey("materialentry")) {
            List<Object> billPks = bills.stream().map(o -> o.get("fid")).collect(Collectors.toList());
            String matTable = ((EntityType)allEntities.get("materialentry")).getAlias();
            SqlBuilder getSrcTableSql = new SqlBuilder();
            getSrcTableSql.append(String.format("select fsrcbillentity from %s where", matTable), new Object[0]);
            getSrcTableSql.appendIn("fid", billPks);
            DataSet srcEntityRows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (SqlBuilder)getSrcTableSql);
            HashSet<String> srcEntitySet = new HashSet<String>(16);
            for (Row srcEntityRow : srcEntityRows) {
                String srcEntity = srcEntityRow.getString("fsrcbillentity");
                if (!StringUtils.isNotBlank((CharSequence)srcEntity)) continue;
                srcEntitySet.add(srcEntity);
            }
            HashMap<Object, Integer> badBillFidJoinFlagMap = new HashMap<Object, Integer>(16);
            for (String srcEntity : srcEntitySet) {
                String srcTableName = MetadataServiceHelper.getDataEntityType((String)srcEntity).getAlias();
                this.buildBadFidJoinFlagMap(billPks, matTable, badBillFidJoinFlagMap, srcTableName);
            }
            Iterator<Object> iterator = bills.iterator();
            while (iterator.hasNext()) {
                DynamicObject bill;
                Integer joinFlag = (Integer)badBillFidJoinFlagMap.get((bill = (DynamicObject)iterator.next()).get("fid"));
                bill.set("fjoininspectflag", (Object)(Objects.isNull(joinFlag) ? Integer.valueOf(0) : joinFlag));
            }
        }
    }

    private void buildBadFidJoinFlagMap(List<Object> billPks, String matTable, Map<Object, Integer> badBillSelfMap, String srcTableName) {
        if (this.containsFieldIngoreCase(DB.getColumnNames((DBRoute)dbRoute, (String)srcTableName), "fjoininspectflag")) {
            SqlBuilder selectSql = new SqlBuilder();
            selectSql.append(String.format("select bad.fid fid,insp.fjoininspectflag fjoininspectflag from %s bad,", matTable), new Object[0]);
            selectSql.append(String.format("%s insp where bad.fsrcbillid = insp.fid and", srcTableName), new Object[0]);
            selectSql.appendIn("bad.fid", billPks);
            DataSet badRows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (SqlBuilder)selectSql);
            DynamicObjectCollection badBills = new ORMImpl().toPlainDynamicObjectCollection(badRows);
            badBillSelfMap.putAll(badBills.stream().collect(Collectors.toMap(item -> item.get("fid"), item -> item.getInt("fjoininspectflag"), (a, b) -> a)));
        }
    }

    private Long getTracsacTypeId(Map<String, Long> tracsacTypeIdCacheMap, Map<Long, Long> biztypeTraGrpCacheMap, long bizTypeId, String joininspectflag, String inspitemmodflg) {
        Long tracsacTypeId = 0L;
        String key = bizTypeId + "_" + joininspectflag + "_" + inspitemmodflg;
        Long cacheValue = tracsacTypeIdCacheMap.get(key);
        if (Objects.nonNull(cacheValue)) {
            tracsacTypeId = cacheValue;
        } else {
            SqlBuilder selectSql = new SqlBuilder();
            selectSql.append("select fid from t_qcbd_transactype where fbiztypeid = ? ", new Object[]{bizTypeId});
            selectSql.append(" and fjoininspectflag = ?", new Object[]{joininspectflag});
            selectSql.append(" and finspitemmodflg = ?;", new Object[]{inspitemmodflg});
            DataSet rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (SqlBuilder)selectSql);
            if (rows.iterator().hasNext()) {
                tracsacTypeId = ((Row)rows.iterator().next()).getLong("fid");
            } else if (!ArrayUtils.contains((Object[])stdBiztypeArr, (Object)bizTypeId)) {
                tracsacTypeId = this.autoCreateTracsacType(biztypeTraGrpCacheMap, bizTypeId, joininspectflag, inspitemmodflg, tracsacTypeId);
            }
            tracsacTypeIdCacheMap.put(key, tracsacTypeId);
        }
        return tracsacTypeId;
    }

    private Long autoCreateTracsacType(Map<Long, Long> biztypeTraGrpCacheMap, long bizTypeId, String joininspectflag, String inspitemmodflg, Long tracsacTypeId) {
        HashMap bizTypeMap = new HashMap();
        String biztypeSql = "select fid,fnumber,fname from t_qcbd_biztype";
        DataSet bizTypes = DB.queryDataSet((String)"TransacTypeServiceImpl", (DBRoute)dbRoute, (String)biztypeSql);
        for (Row bizType : bizTypes) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("number", bizType.getString("fnumber"));
            map.put("name", bizType.getString("fname"));
            bizTypeMap.put(bizType.getLong("fid"), map);
        }
        try (TXHandle h1 = TX.requiresNew();){
            try {
                Map bizType = (Map)bizTypeMap.get(bizTypeId);
                String number = (String)bizType.get("number");
                String name = (String)bizType.get("name");
                Long tracsacTypeGrpId = biztypeTraGrpCacheMap.get(bizTypeId);
                if (Objects.isNull(tracsacTypeGrpId)) {
                    SqlBuilder selectGrpSql = new SqlBuilder();
                    selectGrpSql.append("select fid from t_qcbd_transactypegrp where fnumber = ?", new Object[]{number});
                    DataSet grpRows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (SqlBuilder)selectGrpSql);
                    if (grpRows.iterator().hasNext()) {
                        tracsacTypeGrpId = ((Row)grpRows.iterator().next()).getLong("fid");
                    } else {
                        long id = DB.genLongId((String)"T_QCBD_TRANSACTYPEGRP");
                        tracsacTypeGrpId = id;
                        String sql = String.format("INSERT INTO T_QCBD_TRANSACTYPEGRP (FID,FNUMBER,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FLONGNUMBER,FLEVEL,FISLEAF,FPARENTID,FCREATEORGID,FORGID,FUSEORGID,FCTRLSTRATEGY,FSOURCEDATAID,FBITINDEX,FSOURCEBITINDEX,FTEXTFIELD) VALUES (?,?,'C',1,1,'1',{ts'2018-08-08 18:08:08'},{ts'2018-08-08 18:08:08'},?,?,1,'1',0,%s,%s,%s,'5',0,0,0,' ');", OrgUnitServiceHelper.getRootOrgId(), OrgUnitServiceHelper.getRootOrgId(), OrgUnitServiceHelper.getRootOrgId());
                        Object[] params = new Object[]{id, number, id, number};
                        DB.execute((DBRoute)dbRoute, (String)sql, (Object[])params);
                        String uuid = DB.genStringId((String)"T_QCBD_TRANSACTYPEGRP_L");
                        String uuid_tw = DB.genStringId((String)"T_QCBD_TRANSACTYPEGRP_L");
                        sql = "INSERT INTO T_QCBD_TRANSACTYPEGRP_L (FPKID,FID,FLOCALEID,FNAME,FFULLNAME) VALUES (?,?,'zh_CN',?,?);INSERT INTO T_QCBD_TRANSACTYPEGRP_L (FPKID,FID,FLOCALEID,FNAME,FFULLNAME) VALUES (?,?,'zh_TW',?,?);";
                        params = new Object[]{uuid, id, name, name, uuid_tw, id, name, name};
                        DB.execute((DBRoute)dbRoute, (String)sql, (Object[])params);
                    }
                    biztypeTraGrpCacheMap.put(bizTypeId, tracsacTypeGrpId);
                }
                long id = DB.genLongId((String)"T_QCBD_TRANSACTYPE");
                long amount = 1L;
                DataSet traNumbers = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (String)"select fnumber from T_QCBD_TRANSACTYPE where fnumber like'%ZDYSW_%' order by fnumber desc");
                if (traNumbers.iterator().hasNext()) {
                    String fnumber = ((Row)traNumbers.iterator().next()).getString("fnumber");
                    String amountStr = fnumber.substring(fnumber.lastIndexOf("_") + 1);
                    amount = Long.parseLong(amountStr) + amount;
                }
                String traNumber = "ZDYSW_" + this.getThreeNumberAmount(amount);
                String sql = String.format("INSERT INTO T_QCBD_TRANSACTYPE (FID,FNUMBER,FNAME,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FGROUPID,FORGID,FCREATEORGID,FCTRLSTRATEGY,FSOURCEDATAID,FBITINDEX,FSOURCEBITINDEX,FAUDITORID,FAUDITDATE,FJOININSPECTFLAG,FINSPITEMMODFLG,FINSPSAMPPROJFLAG,FCKVALFLAG,FSAMPNUMRULE,FSUSPICIOUSRULE,FISPRESET,FBIZTYPEID,FMATCHMATTYPE,FMATCHPRIORITY,FISDEFAULT) VALUES (?,?,?,'C',1,1,'1',{ts'2018-08-08 18:08:08'},{ts'2018-08-08 18:08:08'},?,?,%s,%s,'5',0,0,0,1,{ts'2018-08-08 18:08:08'},?,?,'1','1','A',' ','0',?,'0','0','0');", OrgUnitServiceHelper.getRootOrgId(), OrgUnitServiceHelper.getRootOrgId());
                String transacTypeName = name + "_" + this.getThreeNumberAmount(amount);
                Object[] params = new Object[]{id, traNumber, transacTypeName, id, tracsacTypeGrpId, joininspectflag, inspitemmodflg, bizTypeId};
                DB.execute((DBRoute)dbRoute, (String)sql, (Object[])params);
                String uuid = DB.genStringId((String)"T_QCBD_TRANSACTYPEGRP_L");
                String uuid_tw = DB.genStringId((String)"T_QCBD_TRANSACTYPEGRP_L");
                sql = "INSERT INTO T_QCBD_TRANSACTYPE_L (FPKID,FID,FLOCALEID,FNAME) VALUES (?,?,'zh_CN',?);INSERT INTO T_QCBD_TRANSACTYPE_L (FPKID,FID,FLOCALEID,FNAME) VALUES (?,?,'zh_TW',?)";
                params = new Object[]{uuid, id, transacTypeName, uuid_tw, id, transacTypeName};
                DB.execute((DBRoute)dbRoute, (String)sql, (Object[])params);
                TransacTypeServiceImpl.autoCreateDimens(bizTypeId, id);
                tracsacTypeId = id;
            }
            catch (Exception e) {
                logger.error("execute DB fail:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                h1.markRollback();
            }
        }
        return tracsacTypeId;
    }

    private static void autoCreateDimens(long bizTypeId, long id) {
        Map inspproBiztypeReflexE = ParameterUtil.getQmcSystemPropMap((String)"insppro_biztype_reflex_E");
        Optional<Map.Entry> bizTypeEflexOpt = inspproBiztypeReflexE.entrySet().stream().filter(o -> Long.parseLong((String)o.getValue()) == bizTypeId).findFirst();
        if (bizTypeEflexOpt.isPresent()) {
            String bizTypeProComboValue = (String)bizTypeEflexOpt.get().getKey();
            Long[] dimenIds = new Long[]{};
            Map inspectproMatchtypeE = ParameterUtil.getQmcSystemPropMap((String)"inspectpro_matchtype_E");
            if (!CollectionUtils.isEmpty((Map)inspectproMatchtypeE)) {
                Object[] bizMatWithSups = ((String)inspectproMatchtypeE.get("bizMatWithSup")).split(",");
                Object[] bizMatNoSups = ((String)inspectproMatchtypeE.get("bizMatNoSup")).split(",");
                Object[] bizTecs = ((String)inspectproMatchtypeE.get("bizTec")).split(",");
                if (ArrayUtils.contains((Object[])bizMatWithSups, (Object)bizTypeProComboValue)) {
                    dimenIds = DIMENIDS_WITHSUP;
                } else if (ArrayUtils.contains((Object[])bizMatNoSups, (Object)bizTypeProComboValue)) {
                    dimenIds = DIMENIDS_MAT;
                } else if (ArrayUtils.contains((Object[])bizTecs, (Object)bizTypeProComboValue)) {
                    String inspectproDimenE = ParameterUtil.getQmcSystemProp((String)"inspectpro_dimen_E", (String)bizTypeProComboValue);
                    dimenIds = StringUtils.isNotBlank((CharSequence)inspectproDimenE) && ArrayUtils.contains((Object[])inspectproDimenE.split(","), (Object)"mat") ? DIMENIDS_QROUTEWITHMAT_E : DIMENIDS_QROUTE;
                }
            }
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("insert into t_qcbd_tra_mulpmd (fpkid,fid,fbasedataid) values (?,?,?)");
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(32);
            long[] ids = DB.genLongIds((String)"t_qcbd_tra_mulpmd", (int)dimenIds.length);
            for (int i = 0; i < dimenIds.length; ++i) {
                Object[] param = new Object[]{ids[i], id, dimenIds[i]};
                paramsList.add(param);
            }
            if (!CollectionUtils.isEmpty(paramsList)) {
                UpgradeSqlUtil.excuteSqlBatchNoTransaction((String)insertSql.toString(), (DBRoute)dbRoute, paramsList);
            }
        }
    }

    public static void cacheIsInspItemMod(Map<String, Boolean> cacheMap, String appNumber, Long orgId) {
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)appNumber);
        String key = appNumber + orgId;
        if (cacheMap.containsKey(key)) {
            return;
        }
        AppParam appParam = new AppParam(appId, orgId);
        Boolean param = Boolean.TRUE.equals(SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"inspitemmod"));
        cacheMap.put(key, param);
    }

    private boolean containsFieldIngoreCase(List<String> columnNames, String field) {
        return columnNames.stream().anyMatch(o -> StringUtils.equalsIgnoreCase((CharSequence)o, (CharSequence)field));
    }

    private String getThreeNumberAmount(long amount) {
        String amountStr = amount < 10L ? "00" + amount : (10L <= amount && amount < 100L ? "0" + amount : String.valueOf(amount));
        return amountStr;
    }
}

