/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class DataSelectPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String ENTITYID = "entityid";
    private static final String ID = "id";
    private static final String PREVIOUSPAGE = "previouspage";
    private static final String NEXTPAGE = "nextpage";
    private static final String ALLPAGE = "allpage";
    private static final String CURRENTPAGE = "currentpage";
    private static final String QUERY = "query";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        String entityid = this.getEntityId((FormShowParameter)e.getSource());
        if (null == entityid) {
            return;
        }
        ExtendEntryentity extendEntryentity = new ExtendEntryentity(entityid, KEY_ENTRYENTITY);
        EntryAp entryAp = extendEntryentity.createDynamicEntryAp();
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put(ID, KEY_ENTRYENTITY);
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        String entityid = this.getEntityId(this.getView().getFormShowParameter());
        if (null == entityid) {
            return;
        }
        ExtendEntryentity extendEntryentity = new ExtendEntryentity(entityid, KEY_ENTRYENTITY);
        extendEntryentity.registDynamicProps(e);
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        String entityid = this.getEntityId(this.getView().getFormShowParameter());
        if (null == entityid) {
            return;
        }
        ExtendEntryentity extendEntryentity = new ExtendEntryentity(entityid, KEY_ENTRYENTITY);
        e.setDataEntity((Object)extendEntryentity.extendInCreateNewData(dataEntity, 1, null));
    }

    public void beforeBindData(EventObject e) {
        String entityid = this.getEntityId(this.getView().getFormShowParameter());
        if (null == entityid) {
            return;
        }
        EntryAp dynamicEntryAp = new ExtendEntryentity(entityid, KEY_ENTRYENTITY).createDynamicEntryAp();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button bt = (Button)evt.getSource();
        int currentPage = this.getModel().getDataEntity().getInt(CURRENTPAGE);
        int allPage = this.getModel().getDataEntity().getInt(ALLPAGE);
        String query = this.getModel().getDataEntity().getString(QUERY);
        switch (bt.getKey()) {
            case "btnok": {
                this.backfillMessage();
                break;
            }
            case "previouspage": {
                this.prePage(currentPage, query);
                break;
            }
            case "nextpage": {
                this.nextPage(currentPage, allPage, query);
                break;
            }
            case "selectall": {
                EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
                DynamicObjectCollection entrys = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
                int[] indexs = new int[entrys.size()];
                for (int i = 0; i < entrys.size(); ++i) {
                    indexs[i] = i;
                }
                entryGrid.selectRows(indexs, 1);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)QUERY, (CharSequence)name)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String query = dataEntity.getString(QUERY);
            int currentPage = 1;
            this.currentData(currentPage, query);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel", PREVIOUSPAGE, NEXTPAGE, "selectall"});
    }

    private void nextPage(int currentPage, int allPage, String query) {
        if (currentPage < allPage) {
            this.currentData(++currentPage, query);
        }
    }

    private void prePage(int currentPage, String query) {
        if (currentPage > 1) {
            this.currentData(--currentPage, query);
        }
    }

    private void currentData(int currentPage, String query) {
        this.getView().updateView();
        this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String entityid = this.getEntityId(this.getView().getFormShowParameter());
        if (null == entityid) {
            return;
        }
        ExtendEntryentity extendEntryentity = new ExtendEntryentity(entityid, KEY_ENTRYENTITY);
        extendEntryentity.extendInCreateNewData(dataEntity, currentPage, query);
        this.getView().updateView(KEY_ENTRYENTITY);
        this.getView().updateView(CURRENTPAGE);
    }

    private void backfillMessage() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        int[] indexs = entryGrid.getSelectRows();
        StringBuilder pksb = new StringBuilder();
        if (indexs.length == 0) {
            this.getView().returnDataToParent((Object)pksb.toString());
            this.getView().close();
            return;
        }
        for (int i = 0; i < indexs.length; ++i) {
            DynamicObject dyn = this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, indexs[i]);
            pksb.append(dyn.getString(ID)).append(',');
        }
        pksb.delete(pksb.length() - 1, pksb.length());
        this.getView().returnDataToParent((Object)pksb.toString());
        this.getView().close();
    }

    protected String getEntityId(FormShowParameter fsp) {
        return (String)fsp.getCustomParam(ENTITYID);
    }

    public static class ExtendEntryentity {
        String entityId;
        MainEntityType mainEntityType;
        List<IDataEntityProperty> dataEntityPropertyCol;
        String entryentity;
        Map<String, IDataEntityProperty> keyPropMap;

        public ExtendEntryentity(String entityId, String entryentity) {
            if (entityId == null) {
                return;
            }
            this.entityId = entityId;
            this.entryentity = entryentity;
            this.mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            this.dataEntityPropertyCol = new ArrayList<IDataEntityProperty>();
            this.mainEntityType.getProperties().forEach(iDataEntityProperty -> {
                boolean notAdd;
                boolean bl = notAdd = DataSelectPlugin.ID.equals(iDataEntityProperty.getName()) || iDataEntityProperty instanceof LongProp || iDataEntityProperty instanceof CurrencyProp || iDataEntityProperty instanceof MuliLangTextProp || iDataEntityProperty instanceof ModifierProp || !(iDataEntityProperty instanceof DynamicSimpleProperty) || iDataEntityProperty instanceof DateTimeProp || StringUtils.isNotEmpty((CharSequence)iDataEntityProperty.getTableGroup()) || StringUtils.isEmpty((CharSequence)iDataEntityProperty.getAlias());
                if (StringQMCUtil.inside((String)iDataEntityProperty.getName(), (String[])new String[]{"biztype", "billtype", "transactype"}).booleanValue()) {
                    notAdd = false;
                }
                if (!notAdd) {
                    this.dataEntityPropertyCol.add((IDataEntityProperty)iDataEntityProperty);
                }
                if (!this.dataEntityPropertyCol.contains(iDataEntityProperty) && "masterid".equals(iDataEntityProperty.getName())) {
                    this.dataEntityPropertyCol.add((IDataEntityProperty)iDataEntityProperty);
                }
                if ("name".equals(iDataEntityProperty.getName())) {
                    TextProp nameTextProp = new TextProp();
                    IDataEntityProperty idProp = (IDataEntityProperty)this.mainEntityType.getProperties().get((Object)"name");
                    nameTextProp.setAlias(idProp.getAlias());
                    nameTextProp.setDisplayName(idProp.getDisplayName());
                    nameTextProp.setName(idProp.getName());
                    this.dataEntityPropertyCol.add((IDataEntityProperty)nameTextProp);
                }
            });
            TextProp idTextProp = new TextProp();
            IDataEntityProperty idProp = (IDataEntityProperty)this.mainEntityType.getProperties().get((Object)DataSelectPlugin.ID);
            idTextProp.setAlias(idProp.getAlias());
            idTextProp.setDisplayName(idProp.getDisplayName());
            idTextProp.setName(idProp.getName());
            this.dataEntityPropertyCol.add((IDataEntityProperty)idTextProp);
            this.keyPropMap = new HashMap<String, IDataEntityProperty>();
            this.dataEntityPropertyCol.forEach(iDataEntityProperty -> {
                IDataEntityProperty refProp = null;
                if (iDataEntityProperty instanceof BasedataProp && !(refProp = ((BasedataProp)iDataEntityProperty).getRefIdProp()).isDbIgnore()) {
                    this.keyPropMap.put(iDataEntityProperty.getName(), (IDataEntityProperty)iDataEntityProperty);
                }
                if (!iDataEntityProperty.isDbIgnore()) {
                    this.keyPropMap.put(iDataEntityProperty.getName() + ".number", (IDataEntityProperty)iDataEntityProperty);
                }
                if ("name".equals(iDataEntityProperty.getName())) {
                    this.keyPropMap.put(iDataEntityProperty.getName(), (IDataEntityProperty)iDataEntityProperty);
                }
            });
        }

        EntryAp createDynamicEntryAp() {
            EntryAp entryAp = new EntryAp();
            entryAp.setKey("entryap");
            this.dataEntityPropertyCol.forEach(iDataEntityProperty -> {
                EntryFieldAp fieldAp = new EntryFieldAp();
                fieldAp.setId(iDataEntityProperty.getName());
                fieldAp.setKey(iDataEntityProperty.getName());
                fieldAp.setName(iDataEntityProperty.getDisplayName());
                TextField field = new TextField();
                if (DataSelectPlugin.ID.equals(iDataEntityProperty.getName())) {
                    fieldAp.setName(new LocaleString(ResManager.loadKDString((String)"\u4e3b\u952e", (String)"MalPreinDataSelectPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0])));
                }
                field.setId(iDataEntityProperty.getName());
                field.setKey(iDataEntityProperty.getName());
                fieldAp.setField((Field)field);
                entryAp.getItems().add(fieldAp);
            });
            return entryAp;
        }

        void registDynamicProps(GetEntityTypeEventArgs e) {
            MainEntityType oldMainType = e.getOriginalEntityType();
            MainEntityType newMainType = null;
            try {
                newMainType = (MainEntityType)oldMainType.clone();
            }
            catch (CloneNotSupportedException exp) {
                throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
            }
            EntryType entryType = (EntryType)newMainType.getAllEntities().get(this.entryentity);
            this.dataEntityPropertyCol.forEach(prop -> {
                try {
                    if (prop instanceof DynamicSimpleProperty) {
                        entryType.registerSimpleProperty((DynamicSimpleProperty)prop.clone());
                    } else if (prop instanceof BasedataProp) {
                        entryType.registerComplexProperty((DynamicComplexProperty)prop.clone());
                    }
                }
                catch (CloneNotSupportedException e1) {
                    throw new KDBizException(e1.getMessage());
                }
            });
            e.setNewEntityType(newMainType);
        }

        public DynamicObject extendInCreateNewData(DynamicObject dataEntity, int page, String query) {
            DynamicObject[] dynamicArrays;
            DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection(this.entryentity);
            String orderBy = this.getOrderBy(BusinessDataServiceHelper.newDynamicObject((String)this.entityId).getDynamicObjectType());
            int count = 0;
            if (StringUtils.isNotEmpty((CharSequence)query)) {
                QFilter filter;
                String[] field = this.getSelectField().split(",");
                String queryField = "";
                ArrayList<String> fieldList = new ArrayList<String>(16);
                fieldList.addAll(Arrays.asList(field));
                if (fieldList.contains("number")) {
                    queryField = "number";
                } else if (fieldList.contains("billno")) {
                    queryField = "billno";
                }
                if (query.contains(" ")) {
                    String[] split = query.split(" ");
                    filter = new QFilter(queryField, "in", (Object)split);
                } else {
                    filter = new QFilter(queryField, "like", (Object)("%" + query + "%"));
                }
                dynamicArrays = BusinessDataServiceHelper.load((String)this.entityId, (String)this.getSelectField(), (QFilter[])new QFilter[]{filter}, (String)orderBy, (int)(page - 1), (int)5000);
                count = dynamicArrays.length / 5000 + 1;
            } else {
                DataSet idSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entityId, (String)DataSelectPlugin.ID, null, (String)orderBy);
                count = idSet.count(DataSelectPlugin.ID, true) / 5000 + 1;
                dynamicArrays = BusinessDataServiceHelper.load((String)this.entityId, (String)this.getSelectField(), null, (String)orderBy, (int)(page - 1), (int)5000);
            }
            dataEntity.set(DataSelectPlugin.ALLPAGE, (Object)count);
            dataEntity.set(DataSelectPlugin.CURRENTPAGE, (Object)page);
            for (DynamicObject dynamicArray : dynamicArrays) {
                DynamicObject dynamicObject = rows.addNew();
                for (Map.Entry<String, IDataEntityProperty> entry : this.keyPropMap.entrySet()) {
                    String propKey = entry.getKey();
                    IDataEntityProperty propVal = entry.getValue();
                    if (propVal instanceof BasedataProp) {
                        Object valObj;
                        if ("masterid".equals(propKey)) {
                            valObj = dynamicArray.get(propKey + ".number");
                            dynamicObject.set(propKey, (Object)(valObj == null ? "" : String.valueOf(valObj)));
                            continue;
                        }
                        valObj = dynamicArray.get(propKey + ".name");
                        dynamicObject.set(propKey, (Object)(valObj == null ? "" : String.valueOf(valObj)));
                        continue;
                    }
                    dynamicObject.set(propVal.getName(), dynamicArray.get(propVal.getName()));
                }
            }
            return dataEntity;
        }

        private String getOrderBy(DynamicObjectType dynamicObjectType) {
            DataEntityPropertyCollection dataEntityPropertyCollection = dynamicObjectType.getProperties();
            for (IDataEntityProperty property : dataEntityPropertyCollection) {
                if (!(property instanceof CreateDateProp)) continue;
                return property.getName() + " desc";
            }
            return "";
        }

        String getSelectField() {
            StringBuilder sb = new StringBuilder();
            this.mainEntityType.getProperties();
            this.dataEntityPropertyCol.forEach(iDataEntityProperty -> {
                IDataEntityProperty refProp = null;
                if (iDataEntityProperty instanceof BasedataProp && !(refProp = ((BasedataProp)iDataEntityProperty).getRefIdProp()).isDbIgnore()) {
                    sb.append(iDataEntityProperty.getName()).append(',');
                    sb.append(iDataEntityProperty.getName()).append(".name").append(',');
                }
                if (!iDataEntityProperty.isDbIgnore()) {
                    sb.append(iDataEntityProperty.getName()).append(',');
                }
            });
            sb.delete(sb.length() - 1, sb.length());
            return sb.toString();
        }
    }
}

