/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.qmc.qcbd.business.commonmodel.helper.InspectStdHelper;
import kd.qmc.qcbd.common.constant.basedata.inspectstd.InspectstdConst;
import kd.qmc.qcbd.common.model.InspectProjModel;
import kd.qmc.qcbd.common.util.BigDecimalUtil;
import kd.qmc.qcbd.common.util.ControlUtil;
import kd.qmc.qcbd.common.util.ParameterUtil;

public class InspecStandardBasePlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit checkitems = (BasedataEdit)this.getView().getControl("checkitems");
        checkitems.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit matchflag = (BasedataEdit)this.getView().getControl("matchflag");
        matchflag.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        BasedataEdit basedataEdit = (BasedataEdit)e.getSource();
        String key = basedataEdit.getKey();
        ControlUtil.setAfterF7InputPk((AfterF7SelectEvent)e);
        ListSelectedRowCollection selectedRowColls = e.getListSelectedRowCollection();
        if ("checkitems".equals(key)) {
            this.checkItemAfterF7(selectedRowColls);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        block13: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            switch (name) {
                case "normtype": {
                    this.normTypeChange(changeData);
                    continue block13;
                }
                case "matchflag": {
                    this.matchFlagChange(changeData);
                    continue block13;
                }
                case "specvalue": {
                    this.specValueChange(changeData);
                    continue block13;
                }
                case "topvalue": 
                case "downvalue": {
                    this.topDownValueChange(changeData, name);
                    continue block13;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "newentry": 
            case "deleteentry": 
            case "copyentryrow": 
            case "insertentry": {
                this.beforeAddDeleteEntry(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String oprKey;
        super.afterDoOperation(args);
        switch (oprKey = args.getOperateKey()) {
            case "copyentryrow": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                int rowCount = this.getModel().getEntryRowCount("entryentity");
                this.getModel().setValue("matchflag", this.getModel().getValue("matchflag", rowIndex), rowCount - 1);
                this.getModel().setValue("specvalue", this.getModel().getValue("specvalue", rowIndex), rowCount - 1);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey = arg.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"matchflag")) {
            QFilter qFilter = new QFilter("number", "in", (Object)new Object[]{"=", "\u2260"});
            if (InspectstdConst.NORMTYPEENUM.B.name().equals(this.getModel().getValue("normtype"))) {
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
            showParameter.getListFilterParameter().setOrderBy("createtime");
            this.getPageCache().getAll();
        }
    }

    private void checkItemAfterF7(ListSelectedRowCollection selectedRowColls) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection projEntrys = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        int curProjRowIndex = model.getEntryCurrentRowIndex("entryentity");
        InspectProjModel projModel = new InspectProjModel(false);
        DynamicObjectCollection returnDyos = InspectStdHelper.checkItemAfterF7((int)curProjRowIndex, (ListSelectedRowCollection)selectedRowColls, (DynamicObjectCollection)projEntrys, (InspectProjModel)projModel);
        returnDyos.forEach(o -> o.set("normtype", (Object)InspectstdConst.NORMTYPEENUM.A.name()));
        model.updateEntryCache(projEntrys);
        for (int i = 0; i < projEntrys.size(); ++i) {
            model.setValue("checkitems", ((DynamicObject)projEntrys.get(i)).get("checkitems"), i);
        }
        view.updateView("entryentity");
    }

    private void specValueChange(ChangeData changeData) {
        IDataModel model = this.getModel();
        int index = changeData.getRowIndex();
        if ("A".equals(model.getValue("normtype"))) {
            String specvalue = (String)model.getValue("specvalue");
            if (StringUtils.isNotEmpty((CharSequence)specvalue) && !BigDecimalUtil.stringIsDouble((String)specvalue)) {
                model.setValue("specvalue", null, index);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6307\u6807\u7c7b\u578b\u4e3a\u5b9a\u91cf\u65f6\uff0c\u6807\u51c6\u503c\u8bf7\u8f93\u5165\u6570\u503c\u3002", (String)"InspecStandardBasePlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            } else {
                model.setValue("specvalue", (Object)BigDecimalUtil.parserBigDecimal((String)specvalue, (int)10), index);
            }
        }
    }

    private void matchFlagChange(ChangeData changeData) {
        IDataModel model = this.getModel();
        int index = changeData.getRowIndex();
        model.beginInit();
        model.setValue("specvalue", (Object)"", index);
        model.setValue("topvalue", null, index);
        model.setValue("downvalue", null, index);
        model.endInit();
        IFormView view = this.getView();
        view.updateView("specvalue", index);
        view.updateView("topvalue", index);
        view.updateView("downvalue", index);
    }

    private void normTypeChange(ChangeData changeData) {
        IDataModel model = this.getModel();
        int index = changeData.getRowIndex();
        model.beginInit();
        model.setValue("matchflag", null, index);
        model.setValue("specvalue", null, index);
        model.setValue("topvalue", null, index);
        model.setValue("downvalue", null, index);
        model.endInit();
        IFormView view = this.getView();
        view.updateView("matchflag", index);
        view.updateView("specvalue", index);
        view.updateView("topvalue", index);
        view.updateView("downvalue", index);
    }

    private boolean topDownValueChange(ChangeData changeData, String name) {
        int index = changeData.getRowIndex();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject matchflagValue = (DynamicObject)model.getValue("matchflag", index);
        if (null == matchflagValue) {
            return true;
        }
        if ("A".equals(model.getValue("normtype")) && ("[ ]".equals(matchflagValue.getString("number")) || "( )".equals(matchflagValue.getString("number")) || "[ )".equals(matchflagValue.getString("number")) || "( ]".equals(matchflagValue.getString("number")))) {
            BigDecimal topvaluebig = (BigDecimal)model.getValue("topvalue");
            BigDecimal downvaluebig = (BigDecimal)model.getValue("downvalue");
            if (null == topvaluebig || null == downvaluebig) {
                return true;
            }
            if (downvaluebig.compareTo(topvaluebig) >= 0 && "topvalue".equals(name) && (topvaluebig.compareTo(BigDecimal.ZERO) != 0 || downvaluebig.compareTo(BigDecimal.ZERO) != 0)) {
                model.beginInit();
                model.setValue("topvalue", changeData.getOldValue(), index);
                model.endInit();
                view.updateView("topvalue", index);
                view.showTipNotification(ResManager.loadKDString((String)"\u4e0a\u9650\u503c\u987b\u5927\u4e8e\u4e0b\u9650\u503c,\u8bf7\u91cd\u65b0\u8f93\u5165\u4e0a\u9650\u503c\u3002", (String)"InspecStandardBasePlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            }
            if (downvaluebig.compareTo(topvaluebig) >= 0 && "downvalue".equals(name) && (topvaluebig.compareTo(BigDecimal.ZERO) != 0 || downvaluebig.compareTo(BigDecimal.ZERO) != 0)) {
                model.beginInit();
                model.setValue("downvalue", changeData.getOldValue());
                model.endInit();
                view.updateView("downvalue", index);
                view.showTipNotification(ResManager.loadKDString((String)"\u4e0b\u9650\u503c\u987b\u5c0f\u4e8e\u4e0a\u9650\u503c,\u8bf7\u91cd\u65b0\u8f93\u5165\u4e0b\u9650\u503c\u3002", (String)"InspecStandardBasePlugin_2", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            }
        }
        return false;
    }

    private void beforeAddDeleteEntry(BeforeDoOperationEventArgs args) {
        String entryOperateCheck = ParameterUtil.getQmcSystemProp((String)"inspect_std_cfg", (String)"entry_operate_check");
        if (!"true".equalsIgnoreCase(entryOperateCheck)) {
            return;
        }
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        if (Objects.equals(0L, pkValue)) {
            return;
        }
        QFilter qFilter = new QFilter("entryentity.inspectstd", "=", pkValue);
        qFilter.and("entryentity.joininspectflag", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection inspectProInfos = QueryServiceHelper.query((String)"qcbd_inspectpro", (String)"number", (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty((Collection)inspectProInfos)) {
            return;
        }
        String errMsgDemo = ResManager.loadKDString((String)"\u68c0\u9a8c\u65b9\u6848%s\u5df2\u5f15\u7528\u8be5\u68c0\u9a8c\u6807\u51c6\u8fdb\u884c\u8054\u5408\u68c0\u9a8c\u8bbe\u7f6e\uff0c\u4e0d\u5141\u8bb8\u589e\u884c\uff0c\u5220\u884c\uff0c\u590d\u5236\u884c\uff0c\u63d2\u5165\u884c\u3002", (String)"InspecStandardBasePlugin_3", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]);
        String inspectProNums = String.join((CharSequence)",", inspectProInfos.stream().map(x -> x.getString("number")).collect(Collectors.toSet()));
        this.getView().showTipNotification(String.format(errMsgDemo, inspectProNums));
        args.setCancel(true);
    }
}

