/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.common.util.BigDecimalUtil;
import kd.qmc.qcbd.common.util.DataImportUtil;

public class InspecStandardImportPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String COUNT_TYPE = "A";
    private static final String METER_TYPE = "B";
    private static final String SPEC_VALUE = "specvalue";
    private static final String NORM_TYPE = "normtype";
    private static final String MATCH_FLAG = "matchflag";
    private static final String TOP_VALUE = "topvalue";
    private static final String DOWN_VALUE = "downvalue";
    private static final Log logger = LogFactory.getLog(InspecStandardImportPlugin.class);
    private static final String SYSTEM_TYPE = "qmc-qcbd-formplugin";

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        Object entryEntryObject = sourceData.get(ENTRY_ENTITY);
        String createOrgNumber = ((JSONObject)sourceData.get("createorg")).getString("number");
        JSONArray entryArray = (JSONArray)entryEntryObject;
        HashMap cacheMap = new HashMap(16);
        int size = entryArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject entry = (JSONObject)entryArray.get(i);
            DataImportUtil.addKeyId((Map)entry.getJSONObject("checkitems"), (String)createOrgNumber, (String)"qcbd_inspectionitems", cacheMap);
            DataImportUtil.addKeyId((Map)entry.getJSONObject("checkmethod"), (String)createOrgNumber, (String)"qcbd_inspectionmethod", cacheMap);
            DataImportUtil.addKeyId((Map)entry.getJSONObject("checkbasis"), (String)createOrgNumber, (String)"qcbd_inspectioncrit", cacheMap);
            DataImportUtil.addKeyId((Map)entry.getJSONObject("checkinstruct"), (String)createOrgNumber, (String)"qcbd_inspectioninstru", cacheMap);
            DataImportUtil.addKeyId((Map)entry.getJSONObject("checkfreq"), (String)createOrgNumber, (String)"qcbd_inspectionfreq", cacheMap);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRY_ENTITY);
        if (entryEntity != null && !entryEntity.isEmpty()) {
            Map sourceData = e.getSourceData();
            Object entryEntryObject = sourceData.get(ENTRY_ENTITY);
            JSONArray entryArray = (JSONArray)entryEntryObject;
            int size = entryEntity.size();
            int arraySize = entryArray.size();
            for (int i = 0; i < size && i < arraySize; ++i) {
                LinkedList<String> warnList = new LinkedList<String>();
                DynamicObject obj = (DynamicObject)entryEntity.get(i);
                JSONObject entry = (JSONObject)entryArray.get(i);
                String normType = obj.getString(NORM_TYPE);
                if (METER_TYPE.equals(normType)) {
                    obj.set(SPEC_VALUE, entry.get((Object)SPEC_VALUE));
                    Object matchFlag = entry.get((Object)MATCH_FLAG);
                    DynamicObjectCollection matchFlags = QueryServiceHelper.query((String)"qcbd_matchflag", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("name", "in", (Object)new Object[]{"=", "\u2260"})});
                    if (null != matchFlag && !matchFlags.isEmpty()) {
                        Object matchNumber = ((JSONObject)matchFlag).get((Object)"number");
                        List idList = matchFlags.stream().filter(x -> matchNumber.equals(x.get("number"))).map(x -> x.get("id")).collect(Collectors.toList());
                        if (!idList.isEmpty()) {
                            model.setValue(MATCH_FLAG, idList.get(0), i);
                        }
                    }
                } else if (COUNT_TYPE.equals(normType)) {
                    String specValue = entry.getString(SPEC_VALUE);
                    if (StringUtils.isNotEmpty((String)specValue) && !BigDecimalUtil.stringIsDouble((String)specValue)) {
                        model.setValue(SPEC_VALUE, (Object)"", i);
                        warnList.add(ResManager.loadKDString((String)"\u6307\u6807\u7c7b\u578b\u4e3a\u5b9a\u91cf\u65f6\uff0c\u6807\u51c6\u503c\u53ea\u80fd\u5f55\u5165\u6570\u503c\u3002", (String)"InspecStandardImportPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    } else {
                        obj.set(SPEC_VALUE, (Object)BigDecimalUtil.parserBigDecimal((String)specValue, (int)10));
                    }
                    BigDecimal topValue = obj.getBigDecimal(TOP_VALUE);
                    BigDecimal downValue = obj.getBigDecimal(DOWN_VALUE);
                    if (null != topValue && null != downValue && topValue.compareTo(downValue) <= 0 && (BigDecimal.ZERO.compareTo(topValue) != 0 || BigDecimal.ZERO.compareTo(downValue) != 0)) {
                        warnList.add(ResManager.loadKDString((String)"\u4e0a\u9650\u503c\u987b\u5927\u4e8e\u4e0b\u9650\u503c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u4e0a\u9650\u503c\u3002", (String)"InspecStandardImportPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    }
                    if (StringUtils.isEmpty((String)obj.getString(MATCH_FLAG))) {
                        obj.set(SPEC_VALUE, null);
                    }
                }
                if (StringUtils.isEmpty((String)obj.getString(MATCH_FLAG))) {
                    obj.set(TOP_VALUE, null);
                    obj.set(DOWN_VALUE, null);
                }
                DataImportUtil.cancelAfterImport((ImportDataEventArgs)e, warnList, (int)i);
            }
        }
    }
}

