/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class InspecStandardRepairFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String AFTERCHECKITEMS = "aftercheckitems";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List idList = (List)formShowParameter.getCustomParam("selectIdSet");
        HashSet idSet = new HashSet(idList);
        String selectProperties = "id,number,status,enable,entryentity.checkitems,entryentity.checkcontent";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", idSet)};
        DynamicObject[] dynObjArr = BusinessDataServiceHelper.load((String)"qcbd_inspectionstd", (String)selectProperties, (QFilter[])qFilters);
        HashSet<Long> checkItemIdSet = new HashSet<Long>();
        for (DynamicObject dynObj : dynObjArr) {
            DynamicObjectCollection entryEntity = dynObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryObj : entryEntity) {
                Long checkItemId = entryObj.getLong("checkitems.id");
                checkItemIdSet.add(checkItemId);
            }
        }
        IPageCache pageCache = this.getPageCache();
        String beforeStr = SerializationUtils.serializeToBase64((Object)dynObjArr);
        pageCache.put("beforeRepairData", beforeStr);
        DynamicObject[] afterRepairData = this.repairByCover(dynObjArr, checkItemIdSet);
        DynamicObject[] beforeRepairData = (DynamicObject[])SerializationUtils.deSerializeFromBase64((String)pageCache.get("beforeRepairData"));
        this.setModelValue(beforeRepairData, afterRepairData);
        pageCache.remove("beforeRepairData");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit checkItems = (BasedataEdit)this.getView().getControl(AFTERCHECKITEMS);
        if (checkItems != null) {
            checkItems.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            checkItems.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)AFTERCHECKITEMS)) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            QFilter qFilter = new QFilter("itementryqty", "=", (Object)1);
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
            showParameter.setMultiSelect(Boolean.FALSE.booleanValue());
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        IDataModel model = this.getModel();
        BasedataEdit basedataEdit = (BasedataEdit)event.getSource();
        String fieldKey = basedataEdit.getKey();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)AFTERCHECKITEMS)) {
            DynamicObject aftercheckitems = (DynamicObject)model.getValue(AFTERCHECKITEMS);
            if (aftercheckitems != null) {
                String checkContent;
                DynamicObjectCollection entryentity = aftercheckitems.getDynamicObjectCollection("entryentity");
                if (entryentity.isEmpty()) {
                    checkContent = aftercheckitems.getString("name");
                } else {
                    DynamicObject dynamicObject = (DynamicObject)entryentity.get(0);
                    checkContent = dynamicObject.getString("checkcontent");
                }
                model.setValue("aftercheckcontent", (Object)checkContent);
            } else {
                model.setValue("aftercheckcontent", (Object)"");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult.isSuccess()) {
            String successTips = ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u5df2\u5b8c\u6210\u3002", (String)"InspecStandardRepairFormPlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]);
            this.getView().setEnable(Boolean.FALSE, new String[]{"excuterepair"});
            this.getView().showSuccessNotification(successTips, Integer.valueOf(3000));
        }
    }

    private DynamicObject[] repairByCover(DynamicObject[] selectedData, Set<Long> checkItemIdSet) {
        QFilter[] qFilters = new QFilter[]{new QFilter("sourceitemid", "in", checkItemIdSet)};
        DynamicObjectCollection query = QueryServiceHelper.query((String)"qcbd_inspectionitems", (String)"id,sourceitemid,entryentity.checkcontent as checkcontent", (QFilter[])qFilters);
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        for (DynamicObject dynQuery : query) {
            String sb = dynQuery.getString("sourceitemid") + dynQuery.getString("checkcontent");
            map.put(sb, dynQuery.getLong("id"));
        }
        for (DynamicObject dyn : selectedData) {
            DynamicObjectCollection entryEntity = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryObj : entryEntity) {
                String checkItemId = entryObj.getString("checkitems.id");
                String checkContent = entryObj.getString("checkcontent");
                Long aLong = (Long)map.get(checkItemId + checkContent);
                entryObj.set("checkitems", (Object)aLong);
            }
        }
        return selectedData;
    }

    private void setModelValue(DynamicObject[] beforeRepairData, DynamicObject[] afterRepairData) {
        int rowIndex = 0;
        for (DynamicObject beforeRepairDatum : beforeRepairData) {
            Long beforeStdId = beforeRepairDatum.getLong("id");
            DynamicObjectCollection beforeEntryEntity = beforeRepairDatum.getDynamicObjectCollection("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", beforeEntryEntity.size());
            for (DynamicObject dyn : beforeEntryEntity) {
                Long checkitems = dyn.getLong("checkitems.id");
                String checkContent = dyn.getString("checkcontent");
                this.getModel().setValue("preinspectstd", (Object)beforeStdId, rowIndex);
                this.getModel().setValue("precheckitems", (Object)checkitems, rowIndex);
                this.getModel().setValue("precheckcontent", (Object)checkContent, rowIndex);
                for (DynamicObject afterRepairDatum : afterRepairData) {
                    Long afterStdId = afterRepairDatum.getLong("id");
                    DynamicObjectCollection afterEntryEntity = afterRepairDatum.getDynamicObjectCollection("entryentity");
                    for (DynamicObject afterObj : afterEntryEntity) {
                        Long afterCheckitemsId = afterObj.getLong("checkitems");
                        String afterCheckContent = afterObj.getString("checkcontent");
                        if (!beforeStdId.equals(afterStdId) || !checkContent.equals(afterCheckContent)) continue;
                        this.getModel().setValue("afterinspectstd", (Object)afterStdId, rowIndex);
                        this.getModel().setValue(AFTERCHECKITEMS, (Object)afterCheckitemsId, rowIndex);
                        if (afterCheckitemsId == 0L || checkitems.equals(afterCheckitemsId)) continue;
                        this.getModel().setValue("matchstate", (Object)Boolean.TRUE, rowIndex);
                        this.getModel().setValue("aftercheckcontent", (Object)afterCheckContent, rowIndex);
                    }
                }
                ++rowIndex;
            }
        }
        this.getView().updateView("entryentity");
    }
}

