/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;

public class KsqlToolBillPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String PARTITION = ",";
    private static final String ENTITYID = "entityid";
    private static final String QCBD_SELECTDATA = "qcbd_selectdata";
    private static final String FPKID = "fpkid";
    private static final String FORMPLUGIN = "qmc-qcbd-formplugin";
    private static final String SELECTFPKID = "select fpkid from %s where %s = '%s'";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"lookbill", "translate", "selectdata", "oneksql", "ksql"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        if (!this.checkPassword()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u65e0\u6743\u9650\u3002", (String)"KsqlToolBillPlugin_0", (String)FORMPLUGIN, (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        switch (source.getKey()) {
            case "selectdata": {
                this.openSelectData();
                break;
            }
            case "oneksql": {
                this.oneKeyGenerateSql();
                break;
            }
            case "ksql": {
                this.generateSql();
                break;
            }
            case "lookbill": {
                this.openDetail();
                break;
            }
            case "translate": {
                this.openKsqlTransWindow();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (QCBD_SELECTDATA.equals(closedCallBackEvent.getActionId()) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            this.getModel().setValue("dataid", returnData);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "ksqlschemeid": {
                this.takeEntry();
                break;
            }
            case "entryobjectid": {
                this.takeTable();
                break;
            }
        }
    }

    private boolean checkPassword() {
        return Stream.of("tenant_devscm_dev", "tenant_feature_sit_scm_dev", "tenant_feature_sit_scm_smoke", "tenant_feature_sit_scm_test", "tenant_patchscm_smoke", "patchscm", "baseline_a", "baseline_b", "baseline_c", "baseline_d", "baseline_smoke", "patchscmauto").anyMatch(tenantCode -> StringUtils.equals((CharSequence)RequestContext.get().getTenantCode(), (CharSequence)tenantCode));
    }

    private void openSelectData() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(QCBD_SELECTDATA);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        String entityId = this.getEntityId();
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            return;
        }
        fsp.setCustomParam(ENTITYID, (Object)entityId);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, QCBD_SELECTDATA));
        this.getView().showForm(fsp);
    }

    private String getEntityId() {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("entryobjectid");
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"KsqlToolBillPlugin_1", (String)FORMPLUGIN, (Object[])new Object[0]));
            return "";
        }
        return dynamicObject.getString("number");
    }

    private void takeEntry() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("ksqlschemeid");
        if (ObjectUtils.isEmpty((Object)scheme)) {
            this.getModel().setValue("entryobjectid", null);
            return;
        }
        if (ObjectUtils.isEmpty((Object)scheme.get("entryobject"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u51fa\u65b9\u6848\u662f\u5426\u6b63\u786e\u3002", (String)"KsqlToolBillPlugin_11", (String)FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("entryobjectid", scheme.get("entryobject"));
    }

    private void takeTable() {
        ComboItem comboItem;
        this.getModel().setValue("dataid", null);
        DynamicObject entryObjectId = (DynamicObject)this.getModel().getValue("entryobjectid");
        if (ObjectUtils.isEmpty((Object)entryObjectId)) {
            return;
        }
        String entityKey = entryObjectId.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        String dbRouteKey = mainEntityType.getDBRouteKey();
        Map mapEntrys = mainEntityType.getAllEntities();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        HashSet<String> mlSets = new HashSet<String>();
        HashSet<String> splitSets = new HashSet<String>();
        HashSet<String> baseSets = new HashSet<String>();
        for (Map.Entry entrys : mapEntrys.entrySet()) {
            String entry = (String)entrys.getKey();
            EntityType entityType = (EntityType)entrys.getValue();
            String alias = entityType.getAlias();
            ComboItem comboItem2 = new ComboItem();
            comboItem2.setCaption(new LocaleString(alias));
            if (alias == null || alias.isEmpty()) continue;
            if (!"_lk".equals(alias.substring(alias.length() - 3))) {
                comboItem2.setValue(alias);
                comboItems.add(comboItem2);
            }
            DataEntityPropertyCollection properties = entityType.getProperties();
            for (IDataEntityProperty prop : properties) {
                if (prop instanceof MuliLangTextProp) {
                    mlSets.add(alias + "_l");
                }
                if (!StringUtils.isEmpty((CharSequence)prop.getTableGroup())) {
                    splitSets.add(alias + "_" + prop.getTableGroup());
                }
                if (!(prop instanceof MulBasedataProp)) continue;
                baseSets.add(prop.getAlias());
            }
        }
        for (String mlSet : mlSets) {
            comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(mlSet));
            comboItem.setValue(mlSet);
            comboItems.add(comboItem);
        }
        for (String splitSet : splitSets) {
            comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(splitSet));
            comboItem.setValue(splitSet);
            comboItems.add(comboItem);
        }
        for (String baseSet : baseSets) {
            comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(baseSet));
            comboItem.setValue(baseSet);
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("tablename");
        comboEdit.setComboItems(comboItems);
        this.getModel().setValue("database", (Object)dbRouteKey);
    }

    private void oneKeyGenerateSql() {
        int n;
        Object fpkidSets;
        SqlBuilder fpkid;
        ArrayList<Object> typeAndName;
        DataSet idSets;
        EntityType entityType;
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("ksqlschemeid");
        if (scheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u3002", (String)"KsqlToolBillPlugin_2", (String)FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (ObjectUtils.isEmpty((Object)scheme.get("entryobject"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u51fa\u65b9\u6848\u662f\u5426\u6b63\u786e\u3002", (String)"KsqlToolBillPlugin_11", (String)FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject entityDyn = (DynamicObject)this.getModel().getValue("entryobjectid");
        if (entityDyn == null) {
            return;
        }
        String entityKey = entityDyn.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        Map mapEntrys = mainEntityType.getAllEntities();
        ArrayList<String> splitTables = new ArrayList<String>();
        HashMap<String, String> targetTableFiled = new HashMap<String, String>();
        DynamicObjectCollection entryEntitys = scheme.getDynamicObjectCollection("entryentity");
        for (Map.Entry entrys : mapEntrys.entrySet()) {
            String entry = (String)entrys.getKey();
            boolean n2 = false;
            ArrayList desFields = new ArrayList();
            for (DynamicObject entryentity : entryEntitys) {
                if (!entryentity.getBoolean("select")) continue;
                EntityType entityType2 = (EntityType)entrys.getValue();
                DataEntityPropertyCollection dataEntityPropertyCollection = entityType2.getProperties();
                if (!StringUtils.equals((CharSequence)entry, (CharSequence)entryentity.get("identification").toString())) continue;
                if (!targetTableFiled.containsKey(entityType2.getAlias())) {
                    desFields.clear();
                }
                for (Iterator prop : dataEntityPropertyCollection) {
                    if (!StringUtils.equals((CharSequence)prop.getName(), (CharSequence)entryentity.getString("srcfieldtag"))) continue;
                    if (StringUtils.isEmpty((CharSequence)prop.getTableGroup())) {
                        if (!(ObjectUtils.isEmpty((Object)prop.getParent().getParent()) || n2 || prop instanceof MulBasedataProp)) {
                            if (prop instanceof MuliLangTextProp) {
                                if (((MuliLangTextProp)prop).isGL()) {
                                    desFields.add(prop.getParent().getParent().getPrimaryKey().getAlias());
                                    n2 = true;
                                }
                            } else {
                                desFields.add(prop.getParent().getParent().getPrimaryKey().getAlias());
                                n2 = true;
                            }
                        }
                        if (prop instanceof MulBasedataProp) continue;
                        if (prop instanceof MuliLangTextProp) {
                            if (!((MuliLangTextProp)prop).isGL()) continue;
                            desFields.add(prop.getAlias());
                            continue;
                        }
                        desFields.add(prop.getAlias());
                        continue;
                    }
                    if (splitTables.contains(entityType2.getAlias() + "_" + prop.getTableGroup()) || prop instanceof MulBasedataProp) continue;
                    splitTables.add(entityType2.getAlias() + "_" + prop.getTableGroup());
                }
                if (desFields.isEmpty()) continue;
                targetTableFiled.put(entityType2.getAlias(), desFields.toString());
            }
        }
        for (String splitTable : splitTables) {
            boolean i = true;
            ArrayList<String> desFields = new ArrayList<String>();
            for (Map.Entry entry : mapEntrys.entrySet()) {
                EntityType entityType3 = (EntityType)entry.getValue();
                DataEntityPropertyCollection properties = entityType3.getProperties();
                for (DynamicObject entryentity : entryEntitys) {
                    Iterator prop;
                    if (!entryentity.getBoolean("select")) continue;
                    prop = properties.iterator();
                    while (prop.hasNext()) {
                        IDataEntityProperty prop2 = (IDataEntityProperty)prop.next();
                        if (StringUtils.isEmpty((CharSequence)prop2.getTableGroup()) || !StringUtils.equals((CharSequence)splitTable, (CharSequence)(entityType3.getAlias() + "_" + prop2.getTableGroup())) || !StringUtils.equals((CharSequence)entryentity.getString("srcfieldtag"), (CharSequence)prop2.getName())) continue;
                        if (i) {
                            desFields.add(prop2.getParent().getPrimaryKey().getAlias());
                            if (prop2.getParent().getParent() != null) {
                                desFields.add(prop2.getParent().getParent().getPrimaryKey().getAlias());
                            }
                            i = false;
                        }
                        desFields.add(prop2.getAlias());
                        targetTableFiled.put(splitTable, desFields.toString());
                    }
                }
            }
        }
        String dataid = (String)this.getModel().getValue("dataid");
        if (StringUtils.isEmpty((CharSequence)dataid)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"KsqlToolBillPlugin_3", (String)FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String[] ids = dataid.split(PARTITION);
        StringBuilder result = new StringBuilder();
        String annotation = scheme.get("annotation").toString();
        result.append("-- Begin");
        if (!annotation.isEmpty()) {
            result.append(annotation);
        }
        result.append("\n");
        String criterion = this.getModel().getDataEntity().getString("generationtype");
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : mapEntrys.entrySet()) {
            entityType = (EntityType)entry.getValue();
            DynamicProperty id = entityType.getProperty("id");
            String tableName = entityType.getAlias();
            String dbRouteKey = entityType.getDBRouteKey();
            if (tableName == null) continue;
            HashMap<String, String> fields = this.getDataType(entityType, id, targetTableFiled);
            if (!targetTableFiled.containsKey(tableName)) continue;
            for (int i = 0; i < ids.length; ++i) {
                Object idSet2;
                SqlBuilder sqlSelectId = new SqlBuilder();
                IDataEntityType parent = entityType.getParent();
                if (!ObjectUtils.isEmpty((Object)parent)) {
                    int grade;
                    if (ObjectUtils.isEmpty((Object)parent.getParent())) {
                        sqlSelectId.append(String.format("select %s from %s", entityType.getPrimaryKey().getAlias(), entityType.getAlias()), new Object[0]);
                        sqlSelectId.append(String.format("where %s = '%s'", parent.getPrimaryKey().getAlias(), ids[i]), new Object[0]);
                        grade = 2;
                    } else {
                        sqlSelectId.append(String.format("select %s from %s where %s in", entityType.getPrimaryKey().getAlias(), entityType.getAlias(), parent.getPrimaryKey().getAlias()), new Object[0]);
                        sqlSelectId.append(String.format("(select %s from %s where %s = '%s')", parent.getPrimaryKey().getAlias(), parent.getAlias(), parent.getParent().getPrimaryKey().getAlias(), ids[i]), new Object[0]);
                        grade = 3;
                    }
                    idSets = this.selectResult(dbRouteKey, sqlSelectId);
                    for (Object idSet2 : idSets) {
                        String data = this.buildTableSql(targetTableFiled, id.getAlias(), tableName, idSet2.toString().substring(1, idSet2.toString().length() - 1), dbRouteKey, fields, ids[i]);
                        typeAndName = new ArrayList();
                        typeAndName.add(grade);
                        typeAndName.add(tableName);
                        hashMap.put(data, typeAndName);
                        for (String splitTable : splitTables) {
                            if (!StringUtils.equals((CharSequence)tableName, (CharSequence)splitTable.substring(0, splitTable.length() - 2))) continue;
                            data = this.buildTableSql(targetTableFiled, id.getAlias(), splitTable, idSet2.toString().substring(1, idSet2.toString().length() - 1), dbRouteKey, fields, ids[i]);
                            typeAndName = new ArrayList();
                            typeAndName.add(5);
                            typeAndName.add(splitTable);
                            hashMap.put(data, typeAndName);
                        }
                        if (!targetTableFiled.containsKey(tableName + "_l")) continue;
                        SqlBuilder fpkid2 = new SqlBuilder();
                        fpkid2.append(String.format(SELECTFPKID, tableName + "_l", id.getAlias(), idSet2.toString().substring(1, idSet2.toString().length() - 1)), new Object[0]);
                        Iterator fpkidSets2 = this.selectResult(dbRouteKey, fpkid2);
                        Iterator iterator = fpkidSets2.iterator();
                        while (iterator.hasNext()) {
                            Row fpkidSet = (Row)iterator.next();
                            data = this.buildTableSql(targetTableFiled, FPKID, tableName + "_l", fpkidSet.toString().substring(1, fpkidSet.toString().length() - 1), dbRouteKey, fields, ids[i]);
                            typeAndName = new ArrayList();
                            typeAndName.add(4);
                            typeAndName.add(tableName + "_l");
                            hashMap.put(data, typeAndName);
                        }
                    }
                    continue;
                }
                String data = this.buildTableSql(targetTableFiled, id.getAlias(), tableName, ids[i], dbRouteKey, fields, ids[i]);
                typeAndName = new ArrayList<Object>();
                if ("B".equals(criterion)) {
                    typeAndName.add(7);
                } else {
                    typeAndName.add(1);
                }
                typeAndName.add(tableName);
                hashMap.put(data, typeAndName);
                for (String splitTable : splitTables) {
                    if (!StringUtils.equals((CharSequence)tableName, (CharSequence)splitTable.substring(0, splitTable.length() - 2))) continue;
                    data = this.buildTableSql(targetTableFiled, id.getAlias(), splitTable, ids[i], dbRouteKey, fields, ids[i]);
                    typeAndName = new ArrayList();
                    typeAndName.add(5);
                    typeAndName.add(splitTable);
                    hashMap.put(data, typeAndName);
                }
                if (!targetTableFiled.containsKey(tableName + "_l")) continue;
                fpkid = new SqlBuilder();
                fpkid.append(String.format(SELECTFPKID, tableName + "_l", id.getAlias(), ids[i]), new Object[0]);
                fpkidSets = this.selectResult(dbRouteKey, fpkid);
                idSet2 = fpkidSets.iterator();
                while (idSet2.hasNext()) {
                    Row fpkidSet = (Row)idSet2.next();
                    data = this.buildTableSql(targetTableFiled, FPKID, tableName + "_l", fpkidSet.toString().substring(1, fpkidSet.toString().length() - 1), dbRouteKey, fields, ids[i]);
                    typeAndName = new ArrayList();
                    typeAndName.add(4);
                    typeAndName.add(tableName + "_l");
                    hashMap.put(data, typeAndName);
                }
            }
        }
        for (Map.Entry entry : mapEntrys.entrySet()) {
            entityType = (EntityType)entry.getValue();
            DataEntityPropertyCollection properties = entityType.getProperties();
            for (int i = 0; i < ids.length; ++i) {
                for (IDataEntityProperty prop3 : properties) {
                    Iterator fpkid322;
                    Throwable idSet22;
                    if (!(prop3 instanceof MulBasedataProp)) continue;
                    HashMap<String, String> fields = new HashMap<String, String>();
                    String alias = prop3.getParent().getPrimaryKey().getAlias();
                    SqlBuilder sqlSelectId = new SqlBuilder();
                    IDataEntityType parent = entityType.getParent();
                    if (!ObjectUtils.isEmpty((Object)parent)) {
                        if (ObjectUtils.isEmpty((Object)parent.getParent())) {
                            sqlSelectId.append(String.format("select %s from %s", entityType.getPrimaryKey().getAlias(), entityType.getAlias()), new Object[0]);
                            sqlSelectId.append(String.format("where %s = '%s'", parent.getPrimaryKey().getAlias(), ids[i]), new Object[0]);
                        } else {
                            sqlSelectId.append(String.format("select %s from %s where %s in", entityType.getPrimaryKey().getAlias(), entityType.getAlias(), parent.getPrimaryKey().getAlias()), new Object[0]);
                            sqlSelectId.append(String.format("(select %s from %s where fid = '%s')", parent.getPrimaryKey().getAlias(), parent.getAlias(), ids[i]), new Object[0]);
                        }
                        idSets = this.selectResult(entityType.getDBRouteKey(), sqlSelectId);
                        for (Throwable idSet22 : idSets) {
                            fpkid322 = new SqlBuilder();
                            fpkid322.append(String.format(SELECTFPKID, prop3.getAlias(), alias, ((Object)idSet22).toString().substring(1, ((Object)idSet22).toString().length() - 1)), new Object[0]);
                            DataSet fpkidSets3 = this.selectResult(entityType.getDBRouteKey(), (SqlBuilder)fpkid322);
                            for (Row fpkidSet : fpkidSets3) {
                                String data = this.buildTableSql(targetTableFiled, FPKID, prop3.getAlias(), fpkidSet.toString().substring(1, fpkidSet.toString().length() - 1), entityType.getDBRouteKey(), fields, ids[i]);
                                if (data.isEmpty()) continue;
                                typeAndName = new ArrayList();
                                typeAndName.add(6);
                                typeAndName.add(prop3.getAlias());
                                hashMap.put(data, typeAndName);
                            }
                        }
                        continue;
                    }
                    fpkid = new SqlBuilder();
                    fpkid.append(String.format(SELECTFPKID, prop3.getAlias(), alias, ids[i]), new Object[0]);
                    fpkidSets = this.selectResult(entityType.getDBRouteKey(), fpkid);
                    idSet22 = null;
                    try {
                        fpkid322 = fpkidSets.iterator();
                        while (fpkid322.hasNext()) {
                            Row fpkidSet = (Row)fpkid322.next();
                            String data = this.buildTableSql(targetTableFiled, FPKID, prop3.getAlias(), fpkidSet.toString().substring(1, fpkidSet.toString().length() - 1), entityType.getDBRouteKey(), fields, ids[i]);
                            if (data.isEmpty()) continue;
                            typeAndName = new ArrayList();
                            typeAndName.add(6);
                            typeAndName.add(prop3.getAlias());
                            hashMap.put(data, typeAndName);
                        }
                    }
                    catch (Throwable fpkid322) {
                        idSet22 = fpkid322;
                        throw fpkid322;
                    }
                    finally {
                        if (fpkidSets == null) continue;
                        if (idSet22 != null) {
                            try {
                                fpkidSets.close();
                            }
                            catch (Throwable fpkid322) {
                                idSet22.addSuppressed(fpkid322);
                            }
                            continue;
                        }
                        fpkidSets.close();
                    }
                }
            }
        }
        ArrayList<String> tableNames = new ArrayList<String>();
        boolean bl = true;
        if ("B".equals(criterion)) {
            n = 2;
        }
        for (void i = n; i <= n + 5; ++i) {
            for (Map.Entry entrys : hashMap.entrySet()) {
                ArrayList val = (ArrayList)entrys.getValue();
                String tableName = val.get(1).toString();
                if (tableNames.contains(tableName)) continue;
                tableNames.add(val.get(1).toString());
            }
            for (int j = tableNames.size() - 1; j >= 0; --j) {
                boolean enter = false;
                for (Map.Entry entry : hashMap.entrySet()) {
                    String data = (String)entry.getKey();
                    ArrayList val = (ArrayList)entry.getValue();
                    if (!val.get(0).equals((int)i) || !val.get(1).equals(tableNames.get(j))) continue;
                    for (Map.Entry entrys : mapEntrys.entrySet()) {
                        EntityType entityType4 = (EntityType)entrys.getValue();
                        String alias = entityType4.getAlias();
                        if (alias == null) continue;
                        String tableName = val.get(1).toString();
                        ArrayList<String> annoTable = new ArrayList<String>();
                        StringBuilder sb = new StringBuilder();
                        if (!ObjectUtils.isEmpty((Object)entityType4.getParent())) {
                            if (!ObjectUtils.isEmpty((Object)entityType4.getParent().getParent())) {
                                annoTable.add(entityType4.getParent().getParent().getDisplayName().getLocaleValue());
                            }
                            annoTable.add(entityType4.getParent().getDisplayName().getLocaleValue());
                        }
                        if (!annoTable.isEmpty()) {
                            for (int k = 0; k < annoTable.size() - 1; ++k) {
                                sb.append((String)annoTable.get(k));
                                sb.append("_");
                            }
                        }
                        if (enter) continue;
                        if (alias.equals(tableName)) {
                            result.append("-- ");
                            if (!annoTable.isEmpty()) {
                                String sql = sb.toString();
                                result.append(sql);
                            }
                            result.append(entityType4.getDisplayName().getLocaleValue());
                            result.append("\n");
                            continue;
                        }
                        if (i == 4 && alias.equals(tableName.substring(0, tableName.length() - 2))) {
                            result.append("-- ");
                            if (!annoTable.isEmpty()) {
                                String sql = sb.toString();
                                result.append(sql);
                            }
                            result.append(String.format(ResManager.loadKDString((String)"%s_\u591a\u8bed\u8a00\u8868", (String)"KsqlToolBillPlugin_15", (String)FORMPLUGIN, (Object[])new Object[0]), entityType4.getDisplayName().getLocaleValue()));
                            result.append("\n");
                            continue;
                        }
                        if (i == 5 && alias.equals(tableName.substring(0, tableName.length() - 2))) {
                            result.append("-- ");
                            if (!annoTable.isEmpty()) {
                                result.append((CharSequence)sb);
                            }
                            result.append(String.format(ResManager.loadKDString((String)"%s_\u62c6\u5206\u8868", (String)"KsqlToolBillPlugin_14", (String)FORMPLUGIN, (Object[])new Object[0]), entityType4.getDisplayName().getLocaleValue()));
                            result.append("\n");
                            continue;
                        }
                        if (i != 6) continue;
                        DataEntityPropertyCollection properties = entityType4.getProperties();
                        for (IDataEntityProperty prop4 : properties) {
                            if (!(prop4 instanceof MulBasedataProp) || !prop4.getAlias().equals(tableName)) continue;
                            result.append("-- ");
                            result.append(prop4.getDisplayName().toString());
                            result.append("_");
                            result.append(ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\u8868", (String)"KsqlToolBillPlugin_13", (String)FORMPLUGIN, (Object[])new Object[0]));
                            result.append("\n");
                        }
                    }
                    result.append(data);
                    enter = true;
                }
                if (!enter) continue;
                result.append("\n");
            }
        }
        result.append("-- End");
        CodeEdit codeSqlShow = (CodeEdit)this.getView().getControl("ksqltext");
        String sql = result.toString();
        sql = sql.replace("0E-10", "0");
        codeSqlShow.setText(sql);
        this.downloadFile(sql);
    }

    private DataSet selectResult(String dbRouteKey, SqlBuilder sqlSelectId) {
        DataSet idSets = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)new DBRoute(dbRouteKey), (SqlBuilder)sqlSelectId);
        return idSets;
    }

    private void generateSql() {
        EntityType entityType;
        if (this.getModel().getValue("entryobjectid") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"KsqlToolBillPlugin_4", (String)FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue("tablename"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8868\u540d\u3002", (String)"KsqlToolBillPlugin_5", (String)FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue("manualfield"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6240\u9700\u5b57\u6bb5\u3002", (String)"KsqlToolBillPlugin_6", (String)FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue("condition"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6761\u4ef6\u3002", (String)"KsqlToolBillPlugin_7", (String)FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String tableName = this.getModel().getValue("tablename").toString();
        String fields = this.getModel().getValue("manualfield").toString();
        String[] splitField = fields.split(PARTITION);
        StringBuilder result = new StringBuilder();
        String fileDescribe = (String)this.getModel().getValue("filedescribe");
        if (!fileDescribe.isEmpty()) {
            result.append("-- ");
            result.append(fileDescribe);
            result.append("\n");
        }
        DynamicObject entryObjectId = (DynamicObject)this.getModel().getValue("entryobjectid");
        String entityKey = entryObjectId.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        Map mapEntrys = mainEntityType.getAllEntities();
        HashMap<Object, Object> fieldTypes = new HashMap();
        String fid = "";
        for (Map.Entry entrys : mapEntrys.entrySet()) {
            entityType = (EntityType)entrys.getValue();
            if (StringUtils.equals((CharSequence)this.getModel().getValue("tablename").toString(), (CharSequence)entityType.getAlias())) {
                fid = entityType.getPrimaryKey().getAlias();
            }
            if (!StringUtils.equals((CharSequence)entityType.getAlias(), (CharSequence)tableName) && !StringUtils.equals((CharSequence)entityType.getAlias(), (CharSequence)tableName.substring(0, tableName.length() - 2))) continue;
            fid = entityType.getPrimaryKey().getAlias();
            DynamicProperty id = entityType.getProperty("id");
            fieldTypes = this.getDataType(entityType, id, new HashMap<String, String>());
        }
        if ("".equals(fid)) {
            for (Map.Entry entrys : mapEntrys.entrySet()) {
                entityType = (EntityType)entrys.getValue();
                DataEntityPropertyCollection properties = entityType.getProperties();
                for (IDataEntityProperty iDataEntityProperty : properties) {
                    if (!(iDataEntityProperty instanceof MulBasedataProp)) continue;
                    fid = FPKID;
                }
            }
        }
        int count = 0;
        int number = -1;
        HashMap countDataMap = new HashMap();
        for (int i = 0; i < splitField.length; ++i) {
            SqlBuilder sqlStr = new SqlBuilder();
            if (StringUtils.equals((CharSequence)splitField[i].toUpperCase(), (CharSequence)fid.toUpperCase())) {
                number = i;
            }
            sqlStr.append(String.format("select %s", splitField[i]), new Object[0]);
            sqlStr.append(String.format("from %s", tableName), new Object[0]);
            sqlStr.append(String.format("where %s", this.getModel().getValue("condition")), new Object[0]);
            if (!"".equals(this.getModel().getValue("orderby"))) {
                sqlStr.append(String.format("order by %s", this.getModel().getValue("orderby")), new Object[0]);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            try (DataSet rows = this.selectResult(mainEntityType.getDBRouteKey(), sqlStr);){
                for (Row row : rows) {
                    arrayList.add(row.toString().substring(1, row.toString().length() - 1));
                }
            }
            catch (Exception e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u89c4\u8303\u8f93\u5165\u67e5\u8be2\u8bed\u53e5\u7684\u5404\u9879\u5185\u5bb9\u3002", (String)"KsqlToolBillPlugin_8", (String)FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            count = arrayList.size();
            countDataMap.put(i, arrayList);
        }
        if (number == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5b57\u6bb5\u4e2d\u6dfb\u52a0\u4e3b\u952eid\u3002", (String)"KsqlToolBillPlugin_9", (String)FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        for (int j = 0; j < count; ++j) {
            result.append("DELETE FROM");
            result.append(String.format(" %s WHERE", tableName));
            result.append(String.format(" %s = ", fid));
            result.append(String.format("%s", ((ArrayList)countDataMap.get(number)).get(j)));
            result.append(";\n");
            result.append("INSERT INTO ");
            result.append(tableName);
            result.append(" (");
            result.append(fields);
            result.append(") ");
            result.append("VALUES ");
            result.append("(");
            for (Map.Entry entry : countDataMap.entrySet()) {
                int countData = (Integer)entry.getKey();
                ArrayList resultDatas = (ArrayList)entry.getValue();
                if (fieldTypes.containsKey(splitField[countData].toLowerCase())) {
                    switch ((String)fieldTypes.get(splitField[countData].toLowerCase())) {
                        case "String": 
                        case "Boolean": 
                        case "ILocaleString": {
                            if (!StringUtils.equals((CharSequence)((CharSequence)resultDatas.get(j)), (CharSequence)"") && !StringUtils.equals((CharSequence)((CharSequence)resultDatas.get(j)), (CharSequence)"null")) {
                                result.append("'");
                                result.append((String)resultDatas.get(j));
                                result.append("',");
                                break;
                            }
                            result.append("' ',");
                            break;
                        }
                        case "defDate": 
                        case "Date": {
                            if ("null".equals(resultDatas.get(j)) || ((String)resultDatas.get(j)).isEmpty()) {
                                result.append("NULL");
                                result.append(PARTITION);
                                break;
                            }
                            result.append("{ts'");
                            String substring = ((String)resultDatas.get(j)).replace(" ", "").substring(0, 18);
                            char[] chars = substring.toCharArray();
                            for (int k = 0; k < chars.length; ++k) {
                                if (k == 10) {
                                    result.append("  ");
                                }
                                result.append(chars[k]);
                            }
                            result.append("'},");
                            break;
                        }
                        default: {
                            result.append((String)resultDatas.get(j));
                            break;
                        }
                    }
                    continue;
                }
                result.append((String)resultDatas.get(j));
                result.append(PARTITION);
            }
            result.deleteCharAt(result.length() - 1);
            result.append(");\n");
        }
        CodeEdit codeSqlShow = (CodeEdit)this.getView().getControl("ksqltext");
        String sql = result.toString();
        sql = sql.replace("0E-10", "0");
        codeSqlShow.setText(sql);
        this.downloadFile(sql);
    }

    private HashMap<String, String> getDataType(EntityType entityType, DynamicProperty id, HashMap<String, String> targetTableFiled) {
        ArrayList<String> multiLanguageField = new ArrayList<String>();
        multiLanguageField.add(FPKID);
        multiLanguageField.add(id.getAlias());
        multiLanguageField.add("flocaleid");
        HashMap<String, String> fields = new HashMap<String, String>();
        ArrayList<String> baseDatas = new ArrayList<String>();
        fields.put(FPKID, "String");
        fields.put("flocaleid", "String");
        DataEntityPropertyCollection properties = entityType.getProperties();
        for (IDataEntityProperty prop : properties) {
            Class propertyType;
            ISimpleProperty primaryKey;
            Class type;
            if (!ObjectUtils.isEmpty((Object)prop.getParent().getParent()) && (type = (primaryKey = prop.getParent().getParent().getPrimaryKey()).getPropertyType()).equals(String.class)) {
                fields.put(primaryKey.getAlias(), "String");
            }
            if ((propertyType = prop.getPropertyType()) != null && !"".equals(prop.getAlias())) {
                if (StringUtils.equals((CharSequence)prop.getName(), (CharSequence)"createtime") || StringUtils.equals((CharSequence)prop.getName(), (CharSequence)"modifytime") || StringUtils.equals((CharSequence)prop.getName(), (CharSequence)"audittime") || StringUtils.equals((CharSequence)prop.getName(), (CharSequence)"auditdate")) {
                    fields.put(prop.getAlias(), "defDate");
                } else if (StringUtils.equals((CharSequence)prop.getName(), (CharSequence)"creator") || StringUtils.equals((CharSequence)prop.getName(), (CharSequence)"modifier") || StringUtils.equals((CharSequence)prop.getName(), (CharSequence)"auditor")) {
                    fields.put(prop.getAlias(), "User");
                } else if (StringUtils.equals((CharSequence)prop.getName(), (CharSequence)"org")) {
                    fields.put(prop.getAlias(), "Org");
                } else if (propertyType.equals(String.class)) {
                    fields.put(prop.getAlias(), "String");
                } else if (propertyType.equals(Boolean.class) || propertyType.equals(Boolean.TYPE)) {
                    fields.put(prop.getAlias(), "Boolean");
                } else if (propertyType.equals(Date.class)) {
                    fields.put(prop.getAlias(), "Date");
                } else if (propertyType.equals(ILocaleString.class)) {
                    fields.put(prop.getAlias(), "ILocaleString");
                } else if (propertyType.equals(DynamicObject.class)) {
                    if (prop instanceof MulBasedataProp) {
                        baseDatas.add(FPKID);
                        baseDatas.add(id.getAlias());
                        baseDatas.add("fbasedataid");
                        targetTableFiled.put(prop.getAlias(), baseDatas.toString());
                    } else {
                        DynamicObjectType dynamicComplexPropertyType = ((BasedataProp)prop).getDynamicComplexPropertyType();
                        Class type2 = dynamicComplexPropertyType.getProperty("id").getPropertyType();
                        if (type2.equals(String.class)) {
                            fields.put(prop.getAlias(), "String");
                        }
                    }
                }
            }
            if (!(prop instanceof MuliLangTextProp)) continue;
            multiLanguageField.add(prop.getAlias());
        }
        if (multiLanguageField.size() != 3) {
            targetTableFiled.put(entityType.getAlias() + "_l", multiLanguageField.toString());
        }
        return fields;
    }

    private String buildTableSql(HashMap<String, String> targetTableFiled, String alias, String tableName, String ids, String dbRouteKey, HashMap<String, String> difFields, String id) {
        String newFields = targetTableFiled.get(tableName).substring(1, targetTableFiled.get(tableName).length() - 1).replace(" ", "");
        String[] newField = newFields.split(PARTITION);
        String[] resultData = new String[newField.length];
        for (int i = 0; i < newField.length; ++i) {
            SqlBuilder sqlStr = new SqlBuilder();
            sqlStr.append(String.format("select %s", newField[i]), new Object[0]);
            sqlStr.append(String.format("from %s", tableName), new Object[0]);
            sqlStr.append(String.format("where %s = '%s'", alias, ids), new Object[0]);
            try (DataSet rows = this.selectResult(dbRouteKey, sqlStr);){
                for (Row row : rows) {
                    resultData[i] = row.toString().substring(1, row.toString().length() - 1);
                }
                continue;
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("ksql_nullfield", String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u4e2d\u7684%s\u662f\u5426\u5b58\u5728\u3002", (String)"KsqlToolBillPlugin_12", (String)FORMPLUGIN, (Object[])new Object[0]), newField[i])), new Object[]{ExceptionUtils.getExceptionStackTraceMessage((Exception)e)});
            }
        }
        String criterion = this.getModel().getDataEntity().getString("generationtype");
        DynamicObject entryObject = this.getModel().getDataEntity().getDynamicObject("entryobjectid");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entryObject.getString("number"));
        String entryTableName = mainEntityType.getAlias();
        String primaryKey = mainEntityType.getPrimaryKey().getAlias();
        DynamicObject entityDyn = (DynamicObject)this.getModel().getValue("ksqlschemeid");
        String presetDate = entityDyn.get("presetdate").toString();
        String presetUser = entityDyn.get("presetuser").toString();
        String presetOrg = entityDyn.get("presetorg").toString();
        Boolean disposeData = entityDyn.getBoolean("disposedata");
        StringBuilder sb = new StringBuilder();
        String idAlias = "";
        String idValue = "";
        if ("B".equals(criterion)) {
            sb.append(" IF NOT EXISTS ( SELECT 1 FROM ");
            sb.append(tableName);
            sb.append(" WHERE ");
            sb.append(alias);
            idAlias = alias;
            idValue = ids;
        } else {
            sb.append(" DELETE FROM ");
            sb.append(tableName);
            sb.append(" WHERE ");
            sb.append(alias);
            idAlias = alias;
            idValue = ids;
        }
        sb.append(" = ");
        if (difFields.containsKey(idAlias)) {
            switch (difFields.get(idAlias)) {
                case "String": {
                    sb.append("'");
                    sb.append(idValue);
                    sb.append("'");
                    difFields.put(idAlias, "String");
                    break;
                }
                default: {
                    sb.append(idValue);
                    break;
                }
            }
        } else {
            sb.append(idValue);
        }
        if ("B".equals(criterion)) {
            sb.append(" )\n");
        } else {
            sb.append(";\n");
        }
        sb.append(" INSERT INTO ");
        sb.append(tableName);
        sb.append(" (");
        String fields = targetTableFiled.get(tableName).substring(1, targetTableFiled.get(tableName).length() - 1).replace(" ", "");
        sb.append(fields);
        sb.append(")");
        sb.append(" VALUES ");
        sb.append("(");
        String[] field = fields.split(PARTITION);
        sb = new StringBuilder(sb.toString().toUpperCase());
        for (int i = 0; i < field.length; ++i) {
            if (!StringUtils.equals((CharSequence)resultData[i], (CharSequence)"")) {
                if (difFields.containsKey(field[i])) {
                    switch (difFields.get(field[i])) {
                        case "defDate": {
                            if ("null".equals(resultData[i]) || resultData[i].isEmpty()) {
                                sb.append("NULL");
                                sb.append(PARTITION);
                                break;
                            }
                            if (!presetDate.isEmpty()) {
                                sb.append("{ts'");
                                sb.append(presetDate);
                                sb.append("'},");
                                break;
                            }
                            sb.append("{ts'");
                            char[] subDate = resultData[i].replace(" ", "").substring(0, 18).toCharArray();
                            for (int j = 0; j < subDate.length; ++j) {
                                if (j == 10) {
                                    sb.append("  ");
                                }
                                sb.append(subDate[j]);
                            }
                            sb.append("'},");
                            break;
                        }
                        case "Org": {
                            if ("0".equals(resultData[i]) || presetOrg.isEmpty()) {
                                sb.append(resultData[i]);
                                sb.append(PARTITION);
                                break;
                            }
                            sb.append(presetOrg);
                            sb.append(PARTITION);
                            break;
                        }
                        case "User": {
                            if ("0".equals(resultData[i]) || presetUser.isEmpty()) {
                                sb.append(resultData[i]);
                                sb.append(PARTITION);
                                break;
                            }
                            sb.append(presetUser);
                            sb.append(PARTITION);
                            break;
                        }
                        case "String": 
                        case "Boolean": 
                        case "ILocaleString": {
                            if (!StringUtils.equals((CharSequence)resultData[i], (CharSequence)"") && !StringUtils.equals((CharSequence)resultData[i], (CharSequence)"null")) {
                                sb.append("'");
                                sb.append(resultData[i]);
                                sb.append("',");
                                break;
                            }
                            sb.append("' ',");
                            break;
                        }
                        case "Date": {
                            if ("null".equals(resultData[i]) || resultData[i].isEmpty()) {
                                sb.append("NULL");
                                sb.append(PARTITION);
                                break;
                            }
                            sb.append("{ts'");
                            String substring = resultData[i].replace(" ", "").substring(0, 18);
                            char[] chars = substring.toCharArray();
                            for (int j = 0; j < chars.length; ++j) {
                                if (j == 10) {
                                    sb.append("  ");
                                }
                                sb.append(chars[j]);
                            }
                            sb.append("'},");
                            break;
                        }
                    }
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)resultData[i]) || "null".equals(resultData[i])) {
                    if (disposeData.equals(Boolean.TRUE)) {
                        sb.append("0");
                        sb.append(PARTITION);
                        continue;
                    }
                    sb.append("null");
                    sb.append(PARTITION);
                    continue;
                }
                BigDecimal bigDecimal = new BigDecimal(resultData[i]);
                BigDecimal deleteEndZero = bigDecimal.stripTrailingZeros();
                String sDeleteEndZero = deleteEndZero.toPlainString();
                sb.append(sDeleteEndZero);
                sb.append(PARTITION);
                continue;
            }
            sb.append("' ',");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(");\n");
        return sb.toString();
    }

    private void downloadFile(String sql) {
        Object file = this.getModel().getValue("downloadsqlfile");
        if (file.equals(Boolean.TRUE)) {
            String entryObject = ((DynamicObject)this.getModel().getValue("entryobjectid")).getPkValue().toString();
            String sqlFileName = String.format("%s_%s.sql", entryObject, new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            ByteArrayInputStream ins = new ByteArrayInputStream(sql.getBytes(StandardCharsets.UTF_8));
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, (InputStream)ins, 5000);
            this.getView().openUrl(url);
        }
    }

    private void openDetail() {
        HashSet<Long> idSet;
        ArrayList<QFilter> qFilters;
        ListShowParameter listShowParameter;
        String ids = (String)this.getModel().getValue("dataid");
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            String[] idArr = ids.split(PARTITION);
            String entityId = this.getEntityId();
            listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId(entityId);
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            listShowParameter.setStatus(OperationStatus.VIEW);
            qFilters = new ArrayList<QFilter>();
            idSet = new HashSet<Long>(32);
            for (String id : idArr) {
                idSet.add(Long.valueOf(id));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"KsqlToolBillPlugin_3", (String)FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        qFilters.add(new QFilter("id", "in", idSet));
        listShowParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void openKsqlTransWindow() {
        IFormView parentView = this.getView();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_frame_ksqltrans");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("1200px");
        css.setHeight("900px");
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.setCaption(ResManager.loadKDString((String)"KSQL\u7ffb\u8bd1\u5de5\u5177\u3002", (String)"KsqlToolBillPlugin_10", (String)FORMPLUGIN, (Object[])new Object[0]));
        parentView.showForm(parameter);
    }
}

