/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;

public class MultilanguageRepairePlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(MultilanguageRepairePlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button repair = (Button)this.getView().getControl("repair");
        repair.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        IDataModel model = this.getModel();
        DynamicObjectCollection entityobjs = (DynamicObjectCollection)model.getValue("entityobjs");
        if (entityobjs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u590d\u7684\u5b9e\u4f53\u3002", (String)"MultilanguageRepairePlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder errInfo = new StringBuilder();
        StringBuilder sqlStr = new StringBuilder();
        for (DynamicObject entityObj : entityobjs) {
            String billnum = entityObj.getString(2);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billnum);
            String tableName = mainEntityType.getAlias();
            String tableLName = tableName + "_l";
            sqlStr.append(String.format("update %s t1 set fname = (select t2.fname from %s t2 where t1.fid = t2.fid and t2.flocaleid = 'zh_CN') where t1.fname is null or t1.fname = '' or t1.fname = ' '", tableName, tableLName));
            sqlStr.append(";");
        }
        try {
            DB.execute((DBRoute)new DBRoute("qmc"), (String)sqlStr.toString());
        }
        catch (Exception e) {
            errInfo.append(e.getMessage());
            logger.error(errInfo.toString());
        }
        if (errInfo.length() != 0) {
            model.setValue("errinfo_tag", (Object)errInfo);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fee\u590d\u51fa\u9519", (String)"MultilanguageRepairePlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f", (String)"MultilanguageRepairePlugin_2", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
        }
    }
}

