/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class RelateCtlToolFormPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(RelateCtlToolFormPlugin.class);
    private static final String FORMNUMBER = "formnumber";
    private static final String MULBASEDATCLOUD = "mulbasedatcloud";
    private static final String MULBASEDATAAPP = "mulbasedataapp";
    private static final String[] BUTTON_TAGS = new String[]{"getf7", "getmetadata", "getplugin"};
    private static final String CONSTANT_NUMBER = "number";
    private static final String CONSTANT_FBASEDATAID_ID = "fbasedataid_id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BUTTON_TAGS);
        IFormView formView = this.getView();
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)formView.getControl(MULBASEDATAAPP);
        mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Toolbar toolbar1 = (Toolbar)formView.getControl("advcontoolbarap");
        toolbar1.addItemClickListener((ItemClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals(MULBASEDATCLOUD)) {
            this.getModel().setValue(MULBASEDATAAPP, (Object)"");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (evt.getProperty().getName().equals(MULBASEDATAAPP)) {
            MulBasedataDynamicObjectCollection mulbasedatcloud = (MulBasedataDynamicObjectCollection)this.getModel().getValue(MULBASEDATCLOUD);
            ArrayList<Object> cloudIdList = new ArrayList<Object>();
            if (Objects.isNull(mulbasedatcloud) || mulbasedatcloud.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u4e91", (String)"GetRelateFormPlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                for (DynamicObject dynamicObject : mulbasedatcloud) {
                    cloudIdList.add(dynamicObject.get(CONSTANT_FBASEDATAID_ID));
                }
                if (!cloudIdList.isEmpty()) {
                    QFilter qFilter = new QFilter("bizcloud", "in", new HashSet(cloudIdList));
                    ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
            }
        }
    }

    public void itemClick(ItemClickEvent event) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button bt = (Button)evt.getSource();
        String keyValue = bt.getKey();
        IDataModel dataModel = this.getModel();
        this.search(keyValue, dataModel);
    }

    private void search(String keyValue, IDataModel dataModel) {
        long startTime = System.currentTimeMillis();
        LOG.info(ResManager.loadKDString((String)"\u63d0\u53d6\u64cd\u4f5c\u5f00\u59cb\u65f6\u95f4\uff1a", (String)"RelateCtlToolFormPlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]) + startTime);
        if (BUTTON_TAGS[1].equals(keyValue)) {
            new GetMetadata().doSearch(dataModel, this.getView());
        }
        LOG.info(ResManager.loadKDString((String)"\u63d0\u53d6\u64cd\u4f5c\u7ed3\u675f\u65f6\u95f4\uff1a", (String)"RelateCtlToolFormPlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]) + (System.currentTimeMillis() - startTime));
    }

    private void filterMetadata(DataEntityPropertyCollection properties, BiConsumer<String[], String> biConsumer) {
        for (IDataEntityProperty pro : properties) {
            String basedataName;
            String propertyName;
            String subPropertyKey = "";
            String subPropertyName = "";
            String propertyKey = pro.getName() != null ? pro.getName() : "";
            String string = propertyName = pro.getDisplayName() != null ? pro.getDisplayName().toString() : "";
            if (pro instanceof ItemClassTypeProp) {
                List basedataNames = ((ItemClassTypeProp)pro).getBaseEntityIds();
                for (String basedataName2 : basedataNames) {
                    biConsumer.accept(new String[]{propertyKey, propertyName, subPropertyKey, subPropertyName}, basedataName2);
                }
                continue;
            }
            if (pro instanceof MulBasedataProp) {
                basedataName = ((MulBasedataProp)pro).getBaseEntityId();
                biConsumer.accept(new String[]{propertyKey, propertyName, subPropertyKey, subPropertyName}, basedataName);
                continue;
            }
            if (pro instanceof BasedataProp) {
                basedataName = ((BasedataProp)pro).getBaseEntityId();
                biConsumer.accept(new String[]{propertyKey, propertyName, subPropertyKey, subPropertyName}, basedataName);
                continue;
            }
            if (pro instanceof EntryProp) {
                this.filterEntryEntityBaseData(biConsumer, (EntryProp)pro, propertyKey, propertyName);
                continue;
            }
            if (!(pro instanceof MuliLangTextProp)) continue;
            biConsumer.accept(new String[]{propertyKey, propertyName, subPropertyKey, subPropertyName}, "");
        }
    }

    private void filterEntryEntityBaseData(BiConsumer<String[], String> biConsumer, EntryProp entryProp, String propertyKey, String propertyName) {
        DataEntityPropertyCollection properties = entryProp._collectionItemPropertyType.getProperties();
        for (IDataEntityProperty pro : properties) {
            String basedataName;
            String subPropertyName;
            String subPropertyKey = pro.getName() != null ? pro.getName() : "";
            String string = subPropertyName = pro.getDisplayName() != null ? pro.getDisplayName().toString() : "";
            if (pro instanceof ItemClassTypeProp) {
                List basedataNames = ((ItemClassTypeProp)pro).getBaseEntityIds();
                for (String basedataName2 : basedataNames) {
                    biConsumer.accept(new String[]{propertyKey, propertyName, subPropertyKey, subPropertyName}, basedataName2);
                }
                continue;
            }
            if (pro instanceof MulBasedataProp) {
                basedataName = ((MulBasedataProp)pro).getBaseEntityId();
                biConsumer.accept(new String[]{propertyKey, propertyName, subPropertyKey, subPropertyName}, basedataName);
                continue;
            }
            if (pro instanceof BasedataProp) {
                basedataName = ((BasedataProp)pro).getBaseEntityId();
                biConsumer.accept(new String[]{propertyKey, propertyName, subPropertyKey, subPropertyName}, basedataName);
                continue;
            }
            if (!(pro instanceof EntryProp)) continue;
            this.filterEntryEntityBaseData(biConsumer, (EntryProp)pro, propertyKey, propertyName);
        }
    }

    private void populateEntryEntity(List<List<String>> resultList, String[] fields, String entryKey) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tvs = new TableValueSetter(fields);
        for (List<String> result : resultList) {
            tvs.addRow(result.toArray());
        }
        model.deleteEntryData(entryKey);
        model.batchCreateNewEntryRow(entryKey, tvs);
        model.endInit();
        this.getView().updateView(entryKey);
    }

    private class GetMetadata {
        private String baseDataNumber;
        private String baseDataAppNumber;
        private static final String ENTRYENTITY_TAG = "entryentity";
        private final String[] fields = new String[]{"cloud", "app", "page", "propertykey", "propertyname", "iscrossapp"};

        private GetMetadata() {
        }

        protected void doSearch(IDataModel dataModel, IFormView formView) {
            List<Map<String, String>> pagesInfoMaps = this.getPagesInfoMaps(dataModel, formView);
            String extractstyle = DynamicObjDataUtil.getDataModelStringData((IDataModel)dataModel, (String)"extractstyle");
            if (!CollectionUtils.isEmpty(pagesInfoMaps)) {
                ArrayList resultList = new ArrayList();
                for (Map<String, String> pagesInfo : pagesInfoMaps) {
                    MainEntityType mainEntityType;
                    String cloudId = pagesInfo.get("cloudId");
                    String appId = pagesInfo.get("appId");
                    String appNumber = pagesInfo.get("appNumber");
                    String pageId = pagesInfo.get("pageId");
                    String pageNumber = pagesInfo.get("pageNumber");
                    try {
                        mainEntityType = EntityMetadataCache.getDataEntityType((String)pageNumber);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    Boolean isMulProp = StringUtils.equalsIgnoreCase((CharSequence)extractstyle, (CharSequence)"2");
                    if (mainEntityType == null) continue;
                    DataEntityPropertyCollection properties = mainEntityType.getProperties();
                    RelateCtlToolFormPlugin.this.filterMetadata(properties, (propertyArray, basedataName) -> {
                        String propertyKey = propertyArray[0];
                        IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)propertyKey);
                        if (this.baseDataNumber != null && Objects.equals(this.baseDataNumber, basedataName) || isMulProp.booleanValue() && prop instanceof MuliLangTextProp) {
                            resultList.add(new ResultBuilder().setParam(cloudId).setParam(appId).setParam(pageId).setProperty(propertyArray[0], propertyArray[1], propertyArray[2], propertyArray[3]).isCrossApp(appNumber, this.baseDataAppNumber).build());
                        }
                    });
                }
                RelateCtlToolFormPlugin.this.populateEntryEntity(resultList, this.fields, ENTRYENTITY_TAG);
            }
        }

        private List<Map<String, String>> getPagesInfoMaps(IDataModel dataModel, IFormView formView) {
            List<Map<String, String>> pagesInfoList;
            DynamicObject formnumber = (DynamicObject)dataModel.getValue(RelateCtlToolFormPlugin.FORMNUMBER);
            String extractstyle = DynamicObjDataUtil.getDataModelStringData((IDataModel)dataModel, (String)"extractstyle");
            if (StringUtils.equalsIgnoreCase((CharSequence)extractstyle, (CharSequence)"1")) {
                if (Objects.isNull(formnumber)) {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u88ab\u5355\u636e\u5f15\u7528\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"RelateCtlToolFormPlugin_3", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
                    return Collections.emptyList();
                }
                this.baseDataNumber = formnumber.getString(RelateCtlToolFormPlugin.CONSTANT_NUMBER);
                this.baseDataAppNumber = ((RefEntityType)formnumber.getDataEntityType()).getAppId();
            }
            MulBasedataDynamicObjectCollection mulbasedatcloud = (MulBasedataDynamicObjectCollection)dataModel.getValue(RelateCtlToolFormPlugin.MULBASEDATCLOUD);
            ArrayList<Object> cloudIdList = new ArrayList<Object>();
            if (CollectionUtils.isEmpty((Collection)mulbasedatcloud)) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u4e91", (String)"RelateCtlToolFormPlugin_4", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
                return Collections.emptyList();
            }
            for (DynamicObject dynamicObject : mulbasedatcloud) {
                cloudIdList.add(dynamicObject.get(RelateCtlToolFormPlugin.CONSTANT_FBASEDATAID_ID));
            }
            MulBasedataDynamicObjectCollection mulbasedataapp = (MulBasedataDynamicObjectCollection)dataModel.getValue(RelateCtlToolFormPlugin.MULBASEDATAAPP);
            if (CollectionUtils.isEmpty((Collection)mulbasedataapp)) {
                pagesInfoList = this.getPagesInfo(cloudIdList.toArray());
            } else {
                ArrayList<Object> appIdList = new ArrayList<Object>();
                for (DynamicObject dynamicObject : mulbasedataapp) {
                    appIdList.add(dynamicObject.get(RelateCtlToolFormPlugin.CONSTANT_FBASEDATAID_ID));
                }
                pagesInfoList = this.getPagesInfo(cloudIdList.toArray(), appIdList.toArray());
            }
            return pagesInfoList;
        }

        private List<Map<String, String>> getPagesInfo(Object[] cloudIdArray) {
            return this.getPagesInfo(cloudIdArray, null);
        }

        private List<Map<String, String>> getPagesInfo(Object[] cloudIdArray, Object[] appIdArray) {
            StringBuilder sqlStr = new StringBuilder("select a.fdentityid pageId ,a.fid pageNumber, b.fid appId, b.fnumber appNumber, c.fid cloudId, c.fnumber cloudNumber from t_meta_mainentityinfo a inner join t_meta_bizapp b on a.fbizappid = b.fid inner join t_meta_bizcloud c on b.fbizcloudid = c.fid where ");
            if (appIdArray != null && appIdArray.length > 0) {
                sqlStr.append("b.fid in ('");
                sqlStr.append(StringUtils.join((Object[])appIdArray, (String)"','")).append("')");
            } else {
                sqlStr.append("c.fid in ('");
                sqlStr.append(StringUtils.join((Object[])cloudIdArray, (String)"','")).append("')");
            }
            sqlStr.append(" order by c.fnumber,b.fnumber,a.fid");
            return (List)DB.query((DBRoute)DBRoute.of((String)"sys.meta"), (String)sqlStr.toString(), rs -> {
                ArrayList list = new ArrayList(16);
                while (rs.next()) {
                    HashMap<String, String> map = new HashMap<String, String>(8);
                    map.put("pageId", rs.getString(1));
                    map.put("pageNumber", rs.getString(2));
                    map.put("appId", rs.getString(3));
                    map.put("appNumber", rs.getString(4));
                    map.put("cloudId", rs.getString(5));
                    map.put("cloudNumber", rs.getString(6));
                    list.add(map);
                }
                return list;
            });
        }

        protected Map<String, String[]> getExportInfo() {
            HashMap<String, String[]> map = new HashMap<String, String[]>(16);
            map.put(ENTRYENTITY_TAG, this.fields);
            return map;
        }
    }

    static class ResultBuilder {
        private final List<String> list = new ArrayList<String>();

        protected ResultBuilder() {
        }

        protected ResultBuilder setParam(String param) {
            this.list.add(param);
            return this;
        }

        protected ResultBuilder setProperty(String propertyKey, String propertyName, String subPropertyKey, String subPropertyName) {
            if (StringUtils.isBlank((CharSequence)subPropertyName)) {
                this.list.add(propertyKey);
                this.list.add(propertyName);
            } else {
                this.list.add(propertyKey + "." + subPropertyKey);
                this.list.add(propertyName + "." + subPropertyName);
            }
            return this;
        }

        protected ResultBuilder isCrossApp(String appNumber, String baseDataAppNumber) {
            if (Objects.equals(appNumber, baseDataAppNumber)) {
                this.list.add(ResManager.loadKDString((String)"\u5426", (String)"RelateCtlToolFormPlugin_6", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            } else {
                this.list.add(ResManager.loadKDString((String)"\u662f", (String)"RelateCtlToolFormPlugin_5", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            }
            return this;
        }

        private List<String> build() {
            return this.list;
        }
    }
}

