/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.acceptrecord;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.qmc.qcbd.business.commonmodel.helper.BillTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.BizTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.basedata.TransacTypeHelper;
import kd.qmc.qcbd.common.enums.ErrorTypeEnum;
import kd.qmc.qcbd.common.errorcode.QmcBaseErrorCode;
import kd.qmc.qcbd.common.errorcode.QmcErrorCode;
import kd.qmc.qcbd.common.errorcode.QmcErrorCodeUtils;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class AcceptRecordEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addF7Listener(this, "transactype", "biztype");
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String sourceId = event.getProperty().getName();
        IDataModel model = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        switch (sourceId) {
            case "biztype": {
                BizTypeHelper.selectBizType((IDataModel)model, (IFormView)this.getView(), (ListShowParameter)showParameter);
                break;
            }
            case "transactype": {
                this.beforeTransactypeF7(event, showParameter);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        BillTypeHelper.billTypeChange((IFormView)this.getView());
        DynamicObject bizType = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"biztype");
        DynamicObject org = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"org");
        if (Objects.nonNull(org) && Objects.nonNull(bizType)) {
            Long orgId = org.getLong("id");
            Long bizTypeId = bizType.getLong("id");
            DynamicObject firstTransacType = TransacTypeHelper.getFirstDefaultTransacType((Long)orgId, (Long)bizTypeId);
            model.setValue("transactype", (Object)firstTransacType);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String fieldName = e.getProperty().getName();
        block8: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            switch (fieldName) {
                case "billtype": {
                    BillTypeHelper.billTypeChange((IFormView)this.getView());
                    continue block8;
                }
                case "biztype": {
                    if (!Objects.isNull(newValue)) continue block8;
                    model.setValue("transactype", null);
                    continue block8;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "draw": {
                this.drawBeforeDoOpr(args);
                break;
            }
            case "deleteentry": {
                this.showConfirmInfo(args, formOperate);
                break;
            }
        }
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    private void drawBeforeDoOpr(BeforeDoOperationEventArgs args) {
        QmcErrorCode qmcErr = null;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            qmcErr = QmcBaseErrorCode.getErrorInfo((ErrorTypeEnum)ErrorTypeEnum.Msg_MustZJOrg);
        }
        DynamicObject biztype = (DynamicObject)this.getModel().getValue("biztype");
        if (qmcErr == null && biztype == null) {
            qmcErr = QmcBaseErrorCode.getErrorInfo((ErrorTypeEnum)ErrorTypeEnum.Msg_MustBizType);
        }
        if (qmcErr != null) {
            QmcErrorCodeUtils.showMessge((IFormView)this.getView(), (QmcErrorCode)qmcErr);
            args.setCancel(true);
        }
    }

    private void showConfirmInfo(BeforeDoOperationEventArgs args, FormOperate operate) {
        boolean isFromDb = this.getModel().getDataEntity(true).getDataEntityState().getFromDatabase();
        if (isFromDb && !operate.getOption().containsVariable("opt_onfirm")) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("deleteentry", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7684\u7269\u6599\u5206\u5f55\u5df2\u751f\u6210\u9a8c\u6536\u7f16\u53f7\uff0c\u5220\u9664\u5206\u5f55\u6216\u5355\u636e\u540e\uff0c\u5c06\u6e05\u9664\u7269\u6599\u5206\u5f55\u5728\u6765\u6599\u68c0\u9a8c\u5355\u4e2d\u7684\u9a8c\u6536\u7f16\u53f7\u3002", (String)"AcceptRecordEdit_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"deleteentry", (CharSequence)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("opt_onfirm", "true");
            this.getView().invokeOperation("deleteentry", operateOption);
        }
    }

    private void beforeTransactypeF7(BeforeF7SelectEvent event, ListShowParameter showParameter) {
        DynamicObject bizType = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"biztype");
        if (Objects.nonNull(bizType)) {
            showParameter.getListFilterParameter().setFilter(new QFilter("entryentity.biztype", "=", bizType.getPkValue()));
        } else {
            event.setCancel(Boolean.TRUE.booleanValue());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"AcceptRecordEdit_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
        }
    }
}

