/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.baddeal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.qmc.qcbd.business.commonmodel.helper.BizTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.LotNumberHelper;
import kd.qmc.qcbd.business.commonmodel.helper.basedata.TransacTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.control.CommonViewControlHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectDealArgs;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProDimenHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProGlobalCache;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProMatchHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.InspproVoluationKeyModel;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.factory.InspectProVoluationFactory;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.impl.InspectProVoluationBadDeal;
import kd.qmc.qcbd.common.constant.BadDealBillConst;
import kd.qmc.qcbd.common.util.ControlUtil;
import kd.qmc.qcbd.common.util.DeptSetUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.DynamicObjPropUtil;
import kd.qmc.qcbd.common.util.MainEntityTypeUtil;
import kd.qmc.qcbd.common.util.UserUtil;
import kd.qmc.qcbd.formplugin.common.InSpecBillCommon;

public class BadDealBillPlugin
extends InSpecBillCommon
implements EntryGridBindDataListener {
    private static final Map<String, Integer> mIngoreFields = new HashMap<String, Integer>(16);

    public void initialize() {
        BasedataEdit newHand;
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("materialentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        if (null != (newHand = (BasedataEdit)this.getView().getControl("newhandmode"))) {
            newHand.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String sourceID = event.getProperty().getName();
        IDataModel model = this.getModel();
        switch (sourceID) {
            case "inspector": {
                DynamicObject obj = (DynamicObject)model.getValue("org");
                QFilter qFilterx = UserUtil.getQualityOrgUserByOrgid((Long)((Long)obj.getPkValue()));
                event.addCustomQFilter(qFilterx);
                break;
            }
            case "inspedepartment": {
                this.checkOrg(event);
                break;
            }
            case "unit": {
                int rowIndex = event.getRow();
                DynamicObject material = (DynamicObject)model.getValue("materielid", rowIndex);
                ControlUtil.unitCheck((BeforeF7SelectEvent)event, (IFormView)this.getView(), (DynamicObject)material);
                break;
            }
            case "newhandmode": {
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                this.filterNewHandmode(model, showParameter);
                break;
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object materialEntry = model.getValue("materialentry");
        if (null != materialEntry) {
            DynamicObjectCollection materialEntrys = (DynamicObjectCollection)materialEntry;
            boolean isDraw = materialEntrys.stream().anyMatch(x -> null != x.get("srcordernum") && StringUtils.isNotEmpty((CharSequence)String.valueOf(x.get("srcordernum"))));
            if (isDraw) {
                view.setEnable(Boolean.FALSE, new String[]{"biztype", "org"});
            } else {
                view.setEnable(Boolean.TRUE, new String[]{"biztype", "org"});
            }
        }
        BizTypeHelper.qrouteDeal((IFormView)this.getView());
        this.transacTypeDeal();
        boolean isFromDb = this.isFromDB(this.getModel(), "materialentry");
        if (isFromDb && !this.isBotpConvertresultView().booleanValue()) {
            model.setDataChanged(false);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        InspectProGlobalCache inspectProGlobalCache = new InspectProGlobalCache();
        block14: for (ChangeData changeData : valueSet) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            this.setIgnorePro(propName, changeData, mIngoreFields);
            if (InspectProDimenHelper.getBillFieldByType((String)this.getModel().getDataEntityType().getName(), (DynamicObject)this.getModel().getDataEntity().getDynamicObject("transactype")).contains(propName) && !StringUtils.equals((CharSequence)"biztype", (CharSequence)propName)) {
                this.matchInspectPro(inspectProGlobalCache, true, new InspectDealArgs());
            }
            switch (propName) {
                case "materielid": {
                    this.getModel().setValue("unqualiqty", null, rowIndex);
                    this.changeMaterialEvent((DynamicObject)newValue, rowIndex);
                    continue block14;
                }
                case "biztype": {
                    BizTypeHelper.biztypeChange((Object)oldValue, (AbstractBillPlugIn)this);
                    continue block14;
                }
                case "newhandmode": {
                    this.newHandModeChange(newValue, rowIndex);
                    continue block14;
                }
                case "transactype": {
                    this.transacTypeChange((DynamicObject)oldValue, (DynamicObject)newValue);
                    continue block14;
                }
                case "responorg": {
                    DeptSetUtil.changeBizOrg((IDataModel)this.getModel(), (Object)newValue, (String)"respondepart", (int)rowIndex);
                    continue block14;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "draw": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d28\u68c0\u7ec4\u7ec7\u3002", (String)"BadDealBillPlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject biztype = (DynamicObject)this.getModel().getValue("biztype");
                if (biztype == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"BadDealBillPlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ControlUtil.deleteEmptyRows((IDataModel)this.getModel(), (String)"materialentry", (String)"materielid");
                break;
            }
            case "entryrowsplitop": {
                this.splitLineEntry(args);
                break;
            }
        }
    }

    @Override
    public void callBiztypeChange(MessageBoxResult result) {
        super.callBiztypeChange(result);
        IDataModel model = this.getModel();
        switch (result) {
            case Yes: {
                DynamicObjectCollection matintoentity = model.getEntryEntity("materialentry");
                for (int i = matintoentity.size() - 1; i >= 0; --i) {
                    model.deleteEntryRow("materialentry", i);
                }
                this.getView().invokeOperation("newentry");
                BizTypeHelper.qrouteDeal((IFormView)this.getView());
                this.initTransacType();
                break;
            }
            case Cancel: {
                model.beginInit();
                model.setValue("biztype", (Object)this.getPageCache().get("biztypetmp"));
                model.endInit();
                model.updateCache();
                this.getView().updateView("biztype");
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object source = e.getSource();
        if (source instanceof FieldEdit) {
            String fieldKey;
            FieldEdit fieldEdit = (FieldEdit)source;
            switch (fieldKey = fieldEdit.getFieldKey()) {
                case "unqualiqty": 
                case "handmethed": {
                    boolean permit = ControlUtil.dataChangePermit((IDataModel)model, (IFormView)view, (Object)fieldEdit, (int)e.getRowIndex());
                    e.setCancel(!permit);
                    break;
                }
            }
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        IDataModel md = this.getModel();
        String billStatusStr = DynamicObjDataUtil.getDataModelStringData((IDataModel)md, (String)"billstatus");
        if (StringUtils.equalsIgnoreCase((CharSequence)billStatusStr, (CharSequence)"A")) {
            LotNumberHelper.lotnumberEntryGridBind((IDataModel)this.getModel(), (IFormView)this.getView(), (EntryGridBindDataEvent)e, (String)"materialentry", (String)"materielid");
        }
    }

    public void afterCopyData(EventObject e) {
        IDataModel model = this.getModel();
        int size = model.getEntryEntity("materialentry").size();
        for (int i = 0; i < size; ++i) {
            if (null != model.getValue("materialcfg", i)) continue;
            model.setValue("materielid", null, i);
            model.setValue("unit", null, i);
            model.setValue("baseunit", null, i);
        }
    }

    private Boolean checkOrg(BeforeF7SelectEvent event) {
        if (null == this.getModel().getValue("org")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d28\u68c0\u7ec4\u7ec7\u3002", (String)"BadDealBillPlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return Boolean.FALSE;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"org")));
        CommonViewControlHelper.beforeRelationOrgF7((BeforeF7SelectEvent)event, orgIds);
        return Boolean.TRUE;
    }

    private void matchInspectProAfterDraw() {
        InspectDealArgs args = new InspectDealArgs();
        Boolean drawNow = DynamicObjPropUtil.isFirstDrawByDyo((DynamicObject)this.getModel().getDataEntity(true));
        args.setDrawNow(drawNow);
        this.matchInspectPro(new InspectProGlobalCache(), drawNow, args);
    }

    private void matchInspectPro(InspectProGlobalCache inspectProGlobalCache, boolean matchFlag, InspectDealArgs args) {
        args.setBillData(this.getModel().getDataEntity(true));
        args.setView(this.getView());
        args.setFactory((InspectProVoluationFactory)new InspectProVoluationBadDeal());
        InspproVoluationKeyModel voluationKeyModel = args.getVoluationKeyModel();
        voluationKeyModel.setEntryKey("materialentry");
        voluationKeyModel.setInspectDeptKey("inspedepartment");
        voluationKeyModel.setInspectUserKey("inspector");
        if (matchFlag && this.getModel().getEntryRowCount("materialentry") > 0) {
            args.getRowIndexSet().add(0);
        }
        InspectProMatchHelper.inspectProDeal((InspectDealArgs)args, (InspectProGlobalCache)inspectProGlobalCache);
    }

    private void splitLineEntry(BeforeDoOperationEventArgs args) {
        int curIndex;
        DynamicObjectCollection entryObjs;
        DynamicObject coll;
        BigDecimal unqualiqty;
        EntryGrid grid = (EntryGrid)this.getControl("materialentry");
        IFormView fv = this.getView();
        int[] selectRows = grid.getSelectRows();
        String errMessage = this.validSplitLineEntry(selectRows);
        if (errMessage.length() <= 0 && ((unqualiqty = (coll = (DynamicObject)(entryObjs = this.getModel().getEntryEntity("materialentry")).get(curIndex = selectRows[0])).getBigDecimal("unqualiqty")) == null || unqualiqty.compareTo(BigDecimal.ZERO) <= 0)) {
            errMessage = ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u7684\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"BadDealBillPlugin_2", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]);
        }
        if (errMessage.length() > 0) {
            args.setCancel(true);
            fv.showTipNotification(errMessage);
        }
    }

    private String validSplitLineEntry(int[] selectRows) {
        String errMessage = "";
        if (selectRows.length != 1) {
            errMessage = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u5206\u5f55\u8fdb\u884c\u62c6\u884c\u64cd\u4f5c\u3002", (String)"BadDealBillPlugin_3", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]);
        }
        return errMessage;
    }

    private void filterNewHandmode(IDataModel model, ListShowParameter showParameter) {
        DynamicObject billTypeObj = model.getDataEntity().getDynamicObject("billtype");
        if (null == billTypeObj) {
            return;
        }
        Long billType = billTypeObj.getLong("id");
        QFilter filter = new QFilter("entryentity.modebilltype", "=", (Object)billType);
        filter.and("entryentity.isshow", "=", (Object)"1");
        showParameter.getListFilterParameter().setFilter(this.qcasSpecialDeal(filter, model, billType));
    }

    private QFilter qcasSpecialDeal(QFilter filter, IDataModel model, Long billType) {
        DynamicObject bizType = model.getDataEntity().getDynamicObject("biztype");
        if (null == bizType) {
            return filter;
        }
        Long bizNum = bizType.getLong("id");
        if (BadDealBillConst.QCASSALEBAD.equals(billType)) {
            if (BadDealBillConst.SENDINSP.equals(bizNum)) {
                filter.and("id", "!=", (Object)BadDealBillConst.RECEIVE);
            }
            if (BadDealBillConst.BACKINSP.equals(bizNum)) {
                filter.and("id", "!=", (Object)BadDealBillConst.RELEASE);
            }
        }
        if (BadDealBillConst.QCPPMCBAD.equals(billType)) {
            if (BadDealBillConst.QCPPBACK.equals(bizNum) || BadDealBillConst.QCPPXUNJIAN.equals(bizNum)) {
                filter.and("id", "!=", (Object)BadDealBillConst.LIAOFEI);
                filter.and("id", "!=", (Object)BadDealBillConst.GONGFEI);
            }
            if (BadDealBillConst.GONGXU.equals(bizNum) || BadDealBillConst.GXSJ.equals(bizNum)) {
                filter.and("id", "!=", (Object)BadDealBillConst.BFEI);
                filter.and("id", "!=", (Object)BadDealBillConst.FANXIU);
            } else if (BadDealBillConst.WANGONG.equals(bizNum)) {
                filter.and("id", "!=", (Object)BadDealBillConst.BFEI);
            }
        }
        return filter;
    }

    private void newHandModeChange(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (null == newValue) {
            model.setValue("handmethed", null, rowIndex);
        } else {
            String oldBadDeal = ((DynamicObject)newValue).getString("oldbaddealstyle");
            model.setValue("handmethed", (Object)oldBadDeal, rowIndex);
        }
    }

    private void transacTypeChange(DynamicObject oldValue, DynamicObject newValue) {
        boolean matchFlag = TransacTypeHelper.isChangeDimenOfTransacType((DynamicObject)oldValue, (DynamicObject)newValue);
        this.matchInspectPro(new InspectProGlobalCache(), matchFlag, new InspectDealArgs());
    }

    private void transacTypeDeal() {
        this.matchInspectProAfterDraw();
        List applyBillEntityNames = MainEntityTypeUtil.getInheritChildNumberLst((String[])new String[]{"qcp_inspecpbill"});
        for (DynamicObject entry : this.getModel().getEntryEntity("materialentry")) {
            if (!applyBillEntityNames.contains(entry.getString("srcbillentity"))) continue;
            this.getView().setEnable(Boolean.FALSE, new String[]{"transactype"});
            break;
        }
    }

    static {
        mIngoreFields.put("materielid_id", -1);
    }
}

