/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.basedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.common.util.CalculatorEval;

public class CalculatorFormPlugin
extends AbstractFormPlugin {
    private static final String FORMULAFIELD = "formulafield";
    private static final String TESTBTN = "testbtn";
    private static final String DETERMINEBTN = "determinebtn";
    private static final String RESULTFIELD = "resultfield";
    private static final String BATCHFIELD = "batchfield";
    private static final String[] BTNSTR = new String[]{"7", "8", "9", "+", "4", "5", "6", "-", "1", "2", "3", "*", "0", ".", "sqrt()", "/", "(", ")", "sqr()", "cube()", "reciproc()", "backSpace", "allClear", "N", "testbtn", "determinebtn"};
    private static Log logger = LogFactory.getLog(CalculatorFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ArrayList<String> btnList = new ArrayList<String>(33);
        for (int i = 0; i < 24; ++i) {
            btnList.add("buttonap" + i);
        }
        btnList.add(TESTBTN);
        btnList.add(DETERMINEBTN);
        this.addClickListeners(btnList.toArray(new String[0]));
    }

    public void click(EventObject evt) {
        IDataModel model = this.getModel();
        super.click(evt);
        Control source = (Control)evt.getSource();
        Object fo = model.getValue(FORMULAFIELD);
        if (fo != null && source.getKey() != null && source.getKey().indexOf("buttonap") != -1) {
            String key = source.getKey();
            Integer keyIndex = Integer.valueOf(key.substring(8));
            String formula = fo.toString();
            int cursorIndex = FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)key, (String)FORMULAFIELD);
            if (keyIndex == 21) {
                if (formula.length() != 0) {
                    model.setValue(FORMULAFIELD, (Object)(formula.substring(0, cursorIndex - 1) + formula.substring(cursorIndex)));
                    FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)FORMULAFIELD, (int)(cursorIndex - 1));
                }
            } else if (keyIndex == 22) {
                model.setValue(FORMULAFIELD, (Object)"");
                model.setValue(RESULTFIELD, (Object)"");
                FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)FORMULAFIELD, (int)0);
            } else {
                if (cursorIndex == formula.length()) {
                    model.setValue(FORMULAFIELD, (Object)(formula + BTNSTR[keyIndex]));
                } else {
                    model.setValue(FORMULAFIELD, (Object)(formula.substring(0, cursorIndex) + BTNSTR[keyIndex] + formula.substring(cursorIndex)));
                }
                FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)FORMULAFIELD, (int)(cursorIndex + BTNSTR[keyIndex].length()));
            }
        } else if (TESTBTN.equals(source.getKey())) {
            this.count();
        } else if (DETERMINEBTN.equals(source.getKey())) {
            this.determine();
        }
    }

    public void afterCreateNewData(EventObject e) {
        String formulaStr = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        if (formulaStr != null && !"".equals(formulaStr)) {
            this.getModel().setValue(FORMULAFIELD, (Object)formulaStr);
        }
        this.setBatchFieldValue();
    }

    private void setBatchFieldValue() {
        Object customParam = this.getView().getFormShowParameter().getCustomParam("batchcutoffvalue");
        if (null == customParam) {
            return;
        }
        String customStr = String.valueOf(customParam);
        if (customStr.isEmpty() || StringUtils.isNumeric((String)customStr)) {
            return;
        }
        BigDecimal batchN = new BigDecimal(customStr);
        if (batchN.compareTo(BigDecimal.ZERO) != 0) {
            this.getModel().setValue(BATCHFIELD, (Object)batchN);
        }
    }

    private void determine() {
        if (this.count() != null) {
            this.getView().returnDataToParent((Object)this.getModel().getValue(FORMULAFIELD).toString());
            this.getView().close();
        }
    }

    private String count() {
        IDataModel model = this.getModel();
        try {
            String formula = model.getValue(FORMULAFIELD).toString();
            if (StringUtils.isEmpty((String)formula)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u516c\u5f0f\u3002", (String)"CalculatorFormPlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return null;
            }
            formula = formula.replace(BTNSTR[23], model.getValue(BATCHFIELD).toString());
            BigDecimal result = new CalculatorEval(formula).parse();
            model.setValue(RESULTFIELD, (Object)result.toString());
            return result.toString();
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u5f0f\u65e0\u6cd5\u6267\u884c\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u8bed\u6cd5\u3002", (String)"CalculatorFormPlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            logger.error("\u5f02\u5e38\u63cf\u8ff0\uff1a\u516c\u5f0f\u65e0\u6cd5\u6267\u884c\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u8bed\u6cd5\u3002 \u5f02\u5e38\u5185\u5bb9\uff1a" + e.getMessage());
            return null;
        }
    }
}

