/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.basedata;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.qmc.qcbd.business.commonmodel.helper.basedata.InspectProHelper;
import kd.qmc.qcbd.common.util.DataImportUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.UserUtil;

public class InspectProImportPlugin
extends AbstractFormPlugin {
    private static final String SYSTEMTYPE = "qmc-qcbd-formplugin";
    private static Log logger = LogFactory.getLog(InspectProImportPlugin.class);

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        Object entryEntryObject = sourceData.get("entryentity");
        if (!(entryEntryObject instanceof List)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u6570\u636e\u7ed3\u6784\u662f\u5426\u7b26\u5408\u8981\u6c42\u3002", (String)"InspectProImportPlugin_0", (String)SYSTEMTYPE, (Object[])new Object[0]));
        }
        List entryArray = (List)entryEntryObject;
        String createOrgNumber = (String)((Map)sourceData.get("createorg")).get("number");
        HashMap<Object, Object> cacheMap = new HashMap<Object, Object>(16);
        this.validEntryBeforeImport(e, entryArray, createOrgNumber, cacheMap);
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel model = this.getModel();
        DynamicObject bizTypeDyo = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"biztypeid");
        DynamicObject inspproBiztypeReflex = BusinessDataServiceHelper.loadSingleFromCache((Object)1597180334154288128L, (String)"qcbd_sysconfig");
        DynamicObjectCollection reflexEntrys = inspproBiztypeReflex.getDynamicObjectCollection("entryentity");
        for (DynamicObject reflexEntry : reflexEntrys) {
            if (bizTypeDyo.getLong("id") != reflexEntry.getLong("attrvalue")) continue;
            model.setValue("biztype", (Object)reflexEntry.getString("attrkey"));
        }
        LinkedList headErrs = new LinkedList();
        Map result = InspectProHelper.validDataByPromatchDimen((IFormView)this.getView(), headErrs, null);
        DataImportUtil.cancelAfterImport((ImportDataEventArgs)e, headErrs, (int)0);
        if (!"true".equalsIgnoreCase((String)result.get("passCheck"))) {
            return;
        }
        HashMap<Long, List<DynamicObject>> inspectStdCache = new HashMap<Long, List<DynamicObject>>(16);
        HashMap<Long, List<Long>> orgJoinInspCache = new HashMap<Long, List<Long>>(16);
        this.validEntryAfterImport(e, result, inspectStdCache, orgJoinInspCache);
    }

    private void validEntryBeforeImport(BeforeImportDataEventArgs e, List entryArray, String createOrgNumber, Map<Object, Object> cacheMap) {
        if (entryArray != null && !entryArray.isEmpty()) {
            int arraySize = entryArray.size();
            int beginIndex = 0;
            for (int i = 0; i < arraySize; ++i) {
                Map materiel;
                Object entryObj = entryArray.get(i);
                if (!(entryObj instanceof Map)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u6570\u636e\u7ed3\u6784\u662f\u5426\u7b26\u5408\u8981\u6c42\u3002", (String)"InspectProImportPlugin_0", (String)SYSTEMTYPE, (Object[])new Object[0]));
                }
                Map entry = (Map)entryObj;
                DataImportUtil.addKeyId((Map)((Map)entry.get("materielid")), (String)createOrgNumber, (String)"bd_material", cacheMap);
                DataImportUtil.addKeyId((Map)((Map)entry.get("samplepro")), (String)createOrgNumber, (String)"qcbd_sampscheme", cacheMap);
                DataImportUtil.addKeyId((Map)((Map)entry.get("inspectstd")), (String)createOrgNumber, (String)"qcbd_inspectionstd", cacheMap);
                DataImportUtil.addKeyId((Map)((Map)entry.get("supplier")), (String)createOrgNumber, (String)"bd_supplier", cacheMap);
                LinkedList<String> warnList = new LinkedList<String>();
                if (StringUtils.equals((CharSequence)"0", (CharSequence)((String)entry.get("setuptype")))) {
                    Map materielType = (Map)entry.get("materieltype");
                    if (Objects.nonNull(materielType)) {
                        if (Objects.nonNull(materielType.get("number"))) {
                            warnList.add(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7c7b\u578b\u4e3a\u7269\u6599\u65f6\uff0c\u201c\u7269\u6599\u5206\u7c7b.\u5206\u7c7b\u7f16\u7801\u201d\u4e0d\u5e94\u5f55\u5165\u503c", (String)"InspectProImportPlugin_1", (String)SYSTEMTYPE, (Object[])new Object[0]));
                        }
                        if (Objects.nonNull(materielType.get("name"))) {
                            warnList.add(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7c7b\u578b\u4e3a\u7269\u6599\u65f6\uff0c\u201c\u7269\u6599\u5206\u7c7b.\u5206\u7c7b\u540d\u79f0\u201d\u4e0d\u5e94\u5f55\u5165\u503c", (String)"InspectProImportPlugin_2", (String)SYSTEMTYPE, (Object[])new Object[0]));
                        }
                    }
                } else if (StringUtils.equals((CharSequence)"1", (CharSequence)((String)entry.get("setuptype"))) && Objects.nonNull(materiel = (Map)entry.get("materielid"))) {
                    if (Objects.nonNull(materiel.get("number"))) {
                        warnList.add(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7c7b\u578b\u4e3a\u7269\u6599\u5206\u7c7b\u65f6\uff0c\u201c\u7269\u6599\u7f16\u7801.\u7f16\u7801\u201d\u4e0d\u5e94\u5f55\u5165\u503c", (String)"InspectProImportPlugin_3", (String)SYSTEMTYPE, (Object[])new Object[0]));
                    }
                    if (Objects.nonNull(materiel.get("name"))) {
                        warnList.add(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7c7b\u578b\u4e3a\u7269\u6599\u5206\u7c7b\u65f6\uff0c\u201c\u7269\u6599\u7f16\u7801.\u540d\u79f0\u201d\u4e0d\u5e94\u5f55\u5165\u503c", (String)"InspectProImportPlugin_4", (String)SYSTEMTYPE, (Object[])new Object[0]));
                    }
                }
                this.validSubEntryBeforeImport(e, beginIndex, entry);
                DataImportUtil.cancelAfterImport((ImportDataEventArgs)e, warnList, (int)beginIndex);
                beginIndex = this.getNexBeginIndex(entry.get("subprojentry"), beginIndex);
            }
        }
    }

    private void validSubEntryBeforeImport(BeforeImportDataEventArgs e, int i, Map entry) {
        Object subProjEntryObj = entry.get("subprojentry");
        if (subProjEntryObj instanceof List) {
            List subProjEntry = (List)subProjEntryObj;
            int size = subProjEntry.size();
            for (int j = 0; j < size; ++j) {
                LinkedList<String> subWarnList = new LinkedList<String>();
                Object subProjObj = subProjEntry.get(j);
                if (subProjObj instanceof Map) {
                    Map subProjMap = (Map)subProjObj;
                    if (!StringUtils.equals((CharSequence)String.valueOf(j + 1), (CharSequence)String.valueOf(subProjMap.get("importseq")))) {
                        subWarnList.add(ResManager.loadKDString((String)"\u5f15\u5165\u5e8f\u53f7\u9700\u8981\u6309\u7167\u81ea\u7136\u987a\u5e8f\u8fdb\u884c\u6392\u5e8f\u3002", (String)"InspectProImportPlugin_7", (String)SYSTEMTYPE, (Object[])new Object[0]));
                    }
                }
                DataImportUtil.cancelAfterImport((ImportDataEventArgs)e, subWarnList, (int)(i + j));
            }
        }
    }

    private void validEntryAfterImport(ImportDataEventArgs e, Map<String, String> result, Map<Long, List<DynamicObject>> inspectStdCache, Map<Long, List<Long>> inspectorCache) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        List entryArray = (List)e.getSourceData().get("entryentity");
        int beginIndex = 0;
        int size = entryEntity.size();
        for (int i = 0; i < size; ++i) {
            List usrlst;
            DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
            LinkedList<String> warnList = new LinkedList<String>();
            DynamicObject createOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"createorg");
            DynamicObject inspector = entryObj.getDynamicObject("inspectuser");
            if (null != createOrg && null != inspector && (CollectionUtils.isEmpty((Collection)(usrlst = UserUtil.getQualityOrgUserByOrgid((Long)createOrg.getLong("id"), inspectorCache))) || !usrlst.contains(inspector.getLong("id")))) {
                warnList.add(ResManager.loadKDString((String)"\u8d28\u68c0\u5458\u4e0d\u5728\u8d28\u68c0\u4e1a\u52a1\u7ec4\u5185\u3002", (String)"InspectProImportPlugin_9", (String)SYSTEMTYPE, (Object[])new Object[0]));
            }
            logger.info("\u5f15\u5165\u540e\u6821\u9a8c\u5206\u5f55\u4fe1\u606f");
            if ("true".equalsIgnoreCase(result.get("chooseQmcRoute"))) {
                logger.info("\u5f15\u5165\u540e\u6821\u9a8c\u5de5\u827a\u8def\u7ebf\u4fe1\u606f");
                DynamicObject qroute = entryObj.getDynamicObject("qroute");
                String processSeq = entryObj.getString("processseq");
                String operationNo = entryObj.getString("operationno");
                DynamicObject bizType = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"biztypeid");
                logger.info("qroute" + qroute);
                logger.info("processSeq" + processSeq);
                logger.info("operationNo" + operationNo);
                logger.info("bizType" + bizType);
                if (null == qroute || StringUtils.isEmpty((CharSequence)processSeq) || StringUtils.isEmpty((CharSequence)operationNo)) {
                    warnList.add(ResManager.loadKDString((String)"\u7ef4\u5ea6\uff1a\u201c\u5de5\u827a\u8def\u7ebf\u7f16\u7801\u201d\u3001\u201c\u5de5\u5e8f\u5e8f\u5217\u53f7\u201d\u3001\u201c\u5de5\u5e8f\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InspectProImportPlugin_5", (String)SYSTEMTYPE, (Object[])new Object[0]));
                } else {
                    logger.info("\u5de5\u827a\u8def\u7ebf\u5339\u914d\u67e5\u8be2");
                    QFilter filter = new QFilter("processentry.operationno", "=", (Object)operationNo).and("id", "=", qroute.getPkValue()).and("processentry.parent", "=", (Object)processSeq);
                    if (bizType != null && "qcpp-003".equals(bizType.getString("number"))) {
                        filter.and("processentry.firstcheck", "=", (Object)true);
                    } else if (bizType != null && "qcpp-001".equals(bizType.getString("number"))) {
                        filter.and("processentry.checktype", "=", (Object)"1013");
                    } else {
                        filter.and(new QFilter("processentry.checktype", "=", (Object)"1013").or("processentry.firstcheck", "=", (Object)true));
                    }
                    logger.info("\u5de5\u827a\u8def\u7ebf\u5339\u914d\u67e5\u8be2filter" + filter);
                    boolean exists = QueryServiceHelper.exists((String)"qcbd_qmcroute", (QFilter[])filter.toArray());
                    if (!exists) {
                        warnList.add(ResManager.loadKDString((String)"\u7ef4\u5ea6\uff1a\u201c\u5de5\u827a\u8def\u7ebf\u7f16\u7801\u201d\u3001\u201c\u5de5\u5e8f\u5e8f\u5217\u53f7\u201d\u3001\u201c\u5de5\u5e8f\u53f7\u201d\u4e0d\u5339\u914d\u3002", (String)"InspectProImportPlugin_6", (String)SYSTEMTYPE, (Object[])new Object[0]));
                    }
                }
            }
            DynamicObject inspectStdObj = entryObj.getDynamicObject("inspectstd");
            HashMap<String, Object> otherParam = new HashMap<String, Object>(16);
            otherParam.put("createorg", createOrg);
            otherParam.put("inspectorCache", inspectorCache);
            otherParam.put("entryIndex", beginIndex);
            otherParam.put("eventArgs", e);
            this.validSubEntryAfterImport(inspectStdCache, entryObj, inspectStdObj, otherParam);
            DataImportUtil.cancelAfterImport((ImportDataEventArgs)e, warnList, (int)beginIndex);
            Map entryRow = (Map)entryArray.get(i);
            beginIndex = this.getNexBeginIndex(entryRow.get("subprojentry"), beginIndex);
        }
    }

    private void validSubEntryAfterImport(Map<Long, List<DynamicObject>> inspectStdCache, DynamicObject entryObj, DynamicObject inspectStdObj, Map<String, Object> otherParam) {
        DynamicObjectCollection subProEntry = entryObj.getDynamicObjectCollection("subprojentry");
        boolean joinInspectFlag = entryObj.getBoolean("joininspectflag");
        if (null == inspectStdObj || !joinInspectFlag) {
            subProEntry.clear();
        } else {
            Long inspectStdId = inspectStdObj.getLong("id");
            if (!inspectStdCache.containsKey(inspectStdId)) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("%s.id, ", "entryentity"));
                sb.append(String.format("%s.seq, ", "entryentity"));
                sb.append(String.format("%s.%s %s", "entryentity", "isjoininspect", "isjoininspect"));
                DynamicObjectCollection inspectStdInfos = QueryServiceHelper.query((String)"qcbd_inspectionstd", (String)sb.toString(), (QFilter[])new QFilter("id", "=", (Object)inspectStdId).toArray(), (String)String.format("%s.seq asc", "entryentity"));
                inspectStdCache.put(inspectStdId, (List<DynamicObject>)inspectStdInfos);
            }
            List<DynamicObject> inspectStdInfos = inspectStdCache.get(inspectStdId);
            int subProEntryLastIndex = subProEntry.size() - 1;
            int insStdLastIndex = inspectStdInfos.size() - 1;
            for (int i = subProEntryLastIndex; i >= 0; --i) {
                LinkedList<String> subEntryErrList = new LinkedList<String>();
                if (i > insStdLastIndex) {
                    subProEntry.remove(i);
                } else {
                    DynamicObject inspectStdRow = inspectStdInfos.get(i);
                    DynamicObject subProEntryRow = (DynamicObject)subProEntry.get(i);
                    boolean isJoinInspect = inspectStdRow.getBoolean("isjoininspect");
                    if (!isJoinInspect) {
                        subProEntryRow.set("joindept", null);
                        subProEntryRow.set("joininspector", null);
                    } else {
                        List usrlst;
                        DynamicObject createOrg = (DynamicObject)otherParam.get("createorg");
                        DynamicObject joinInspect = subProEntryRow.getDynamicObject("joininspector");
                        Map orgJoinInspCache = (Map)otherParam.get("inspectorCache");
                        if (null != createOrg && null != joinInspect && (CollectionUtils.isEmpty((Collection)(usrlst = UserUtil.getQualityOrgUserByOrgid((Long)createOrg.getLong("id"), (Map)orgJoinInspCache))) || !usrlst.contains(joinInspect.getLong("id")))) {
                            subEntryErrList.add(ResManager.loadKDString((String)"\u8054\u5408\u68c0\u9a8c\u5458\u4e0d\u5728\u8d28\u68c0\u4e1a\u52a1\u7ec4\u5185\u3002", (String)"InspectProImportPlugin_8", (String)SYSTEMTYPE, (Object[])new Object[0]));
                        }
                    }
                    subProEntryRow.set("stdentryid", (Object)inspectStdRow.getLong(String.format("%s.id", "entryentity")));
                }
                int entryIndex = (Integer)otherParam.get("entryIndex");
                ImportDataEventArgs e = (ImportDataEventArgs)otherParam.get("eventArgs");
                DataImportUtil.cancelAfterImport((ImportDataEventArgs)e, subEntryErrList, (int)(entryIndex + i));
            }
        }
    }

    private int getNexBeginIndex(Object subProjEnry, int beginIndex) {
        if (subProjEnry instanceof List) {
            return ((List)subProjEnry).size() + beginIndex;
        }
        return beginIndex + 1;
    }
}

