/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.basedata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.samplingscheme.SamplingSchemeHelper;
import kd.qmc.qcbd.common.enums.SamplingTypeEnum;
import kd.qmc.qcbd.common.util.CalculatorEval;
import kd.qmc.qcbd.common.util.DataImportUtil;

public class SamplingImportPlugin
extends AbstractBillPlugIn {
    private static final String SYSTEM_TYPE = "qmc-qcbd-formplugin";
    private static final String[] BTNSTR = new String[]{"7", "8", "9", "+", "4", "5", "6", "-", "1", "2", "3", "*", "0", ".", "sqrt()", "/", "(", ")", "sqr()", "cube()", "reciproc()", "backSpace", "allClear", "N", "testbtn", "determinebtn"};

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel model = this.getModel();
        String sampleType = String.valueOf(model.getValue("samplingtype"));
        DynamicObjectCollection entryEntity = model.getEntryEntity("receiveinfoentity");
        if (entryEntity != null && !entryEntity.isEmpty()) {
            Map sourceData = e.getSourceData();
            Object entryEntryObject = sourceData.get("receiveinfoentity");
            JSONArray entryArray = (JSONArray)entryEntryObject;
            int size = entryEntity.size();
            int arraySize = entryArray.size();
            for (int i = 0; i < size && i < arraySize; ++i) {
                BigDecimal batchinitialvalue;
                LinkedList<String> warnList = new LinkedList<String>();
                DynamicObject obj = (DynamicObject)entryEntity.get(i);
                JSONObject entry = (JSONObject)entryArray.get(i);
                Object sapPercentObj = entry.get((Object)"samppercentage");
                if (null != sapPercentObj && StringUtils.isNumeric((String)String.valueOf(sapPercentObj))) {
                    obj.set("samppercentage", sapPercentObj);
                }
                obj.set("samplingsize", entry.get((Object)"samplingsize"));
                String acstr = obj.getString("acstr");
                if (StringUtils.isNotEmpty((String)acstr) && !"0".equals(acstr) && !acstr.matches("[1-9][0-9]{0,17}")) {
                    warnList.add(ResManager.loadKDString((String)"\u5b57\u6bb5\u5141\u6536\u6570\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6574\u6570\u3002", (String)"SamplingImportPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if (StringUtils.isNotEmpty((String)acstr) && StringUtils.isNumeric((String)acstr)) {
                    BigDecimal acValue = new BigDecimal(acstr);
                    BigDecimal cutOffValue = obj.getBigDecimal("batchcutoffvalue");
                    if (null != cutOffValue && cutOffValue.compareTo(acValue) < 0) {
                        obj.set("acstr", (Object)cutOffValue.longValue());
                        obj.set("ac", (Object)cutOffValue.longValue());
                    }
                }
                if (0 == i && !SamplingTypeEnum.GB_2828.getValue().equals(sampleType) && null != (batchinitialvalue = obj.getBigDecimal("batchinitialvalue")) && 0 != batchinitialvalue.compareTo(BigDecimal.ZERO)) {
                    warnList.add(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c\u4e00\u884c\u7684\u8d77\u59cb\u503c\u53ea\u80fd\u4e3a0\u3002", (String)"SamplingImportPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                this.samplingtypeDeal(sampleType, i);
                if (SamplingTypeEnum.CUSTOM.getValue().equals(sampleType) || SamplingTypeEnum.CUSTOM_INSPECTION.getValue().equals(sampleType) && "E".equals(obj.get("inspectionrule"))) {
                    String replaceValue;
                    String formula = obj.getString("formula");
                    BigDecimal batChCutOffVal = obj.getBigDecimal("batchcutoffvalue");
                    String string = replaceValue = null == batChCutOffVal ? BigDecimal.ZERO.toPlainString() : batChCutOffVal.toPlainString();
                    if (StringUtils.isNotEmpty((String)formula)) {
                        this.checkFormula(formula, replaceValue, warnList);
                    }
                }
                DataImportUtil.cancelAfterImport((ImportDataEventArgs)e, warnList, (int)i);
            }
        }
        this.samplingtypeDeal(sampleType);
    }

    private void samplingtypeDeal(String samplingType) {
        if (SamplingTypeEnum.PERCENTAGE.getValue().equals(samplingType) || SamplingTypeEnum.FIXED_QUANTITY.getValue().equals(samplingType) || SamplingTypeEnum.CUSTOM.getValue().equals(samplingType) || SamplingTypeEnum.FULL_INSPECTION.getValue().equals(samplingType) || SamplingTypeEnum.CUSTOM_INSPECTION.getValue().equals(samplingType)) {
            this.clearValue("inspectionlevel", "strictness", "zeroaqlvalue", "aqlvalue");
        } else if (SamplingTypeEnum.GB_2828.getValue().equals(samplingType)) {
            this.clearValue("zeroaqlvalue");
            IDataModel model = this.getModel();
            Object aqlValueObject = model.getValue("aqlvalue");
            Object inspectionLevel = model.getValue("inspectionlevel");
            Object strictness = model.getValue("strictness");
            if (null == aqlValueObject || null == inspectionLevel || null == strictness) {
                return;
            }
            List initAqlGBList = SamplingSchemeHelper.initAqlGBList((String)aqlValueObject.toString(), (String)inspectionLevel.toString(), (String)strictness.toString(), (String)SamplingTypeEnum.GB_2828.getValue());
            SamplingSchemeHelper.batchCreateNewEntryRow((IDataModel)model, (List)initAqlGBList);
        } else if (SamplingTypeEnum.ZERO_AQL.getValue().equals(samplingType)) {
            this.clearValue("inspectionlevel", "strictness");
            IDataModel model = this.getModel();
            Object aqlValueObject = model.getValue("aqlvalue");
            if (null == aqlValueObject) {
                return;
            }
            List abl = SamplingSchemeHelper.initZeroAql((String)aqlValueObject.toString(), (String)SamplingTypeEnum.ZERO_AQL.getValue());
            SamplingSchemeHelper.batchCreateNewEntryRow((IDataModel)model, (List)abl);
        }
    }

    private void samplingtypeDeal(String samplingType, int rowIndex) {
        if (SamplingTypeEnum.GB_2828.getValue().equals(samplingType) || SamplingTypeEnum.ZERO_AQL.getValue().equals(samplingType) || SamplingTypeEnum.FULL_INSPECTION.getValue().equals(samplingType)) {
            this.clearValue(rowIndex, "batchinitialvalue", "batchcutoffvalue", "inspectionrule", "samppercentage", "formula", "samplingsizecode", "inspectionlevelentry", "strictnessentry", "aqlvalueentry", "samplingsize", "acstr", "ac", "re");
        } else if (SamplingTypeEnum.FIXED_QUANTITY.getValue().equals(samplingType)) {
            this.clearValue(rowIndex, "inspectionrule", "samppercentage", "formula", "samplingsizecode", "inspectionlevelentry", "strictnessentry", "aqlvalueentry", "re");
        } else if (SamplingTypeEnum.PERCENTAGE.getValue().equals(samplingType)) {
            this.clearValue(rowIndex, "inspectionrule", "formula", "samplingsizecode", "inspectionlevelentry", "strictnessentry", "aqlvalueentry", "samplingsize", "re");
        } else if (SamplingTypeEnum.CUSTOM.getValue().equals(samplingType)) {
            this.clearValue(rowIndex, "inspectionrule", "samppercentage", "samplingsizecode", "inspectionlevelentry", "strictnessentry", "aqlvalueentry", "samplingsize", "re");
        } else if (SamplingTypeEnum.CUSTOM_INSPECTION.getValue().equals(samplingType)) {
            this.clearValue(rowIndex, "samplingsizecode", "re");
            Object insepectionRule = this.getModel().getValue("inspectionrule", rowIndex);
            if ("A".equals(insepectionRule)) {
                this.clearValue(rowIndex, "samppercentage", "formula", "inspectionlevelentry", "strictnessentry", "aqlvalueentry", "samplingsize");
            } else if ("B".equals(insepectionRule)) {
                this.clearValue(rowIndex, "formula", "inspectionlevelentry", "strictnessentry", "aqlvalueentry", "samplingsize");
            } else if ("C".equals(insepectionRule)) {
                this.clearValue(rowIndex, "samppercentage", "formula", "inspectionlevelentry", "strictnessentry", "aqlvalueentry");
            } else if ("D".equals(insepectionRule)) {
                this.clearValue(rowIndex, "samppercentage", "formula");
            } else if ("E".equals(insepectionRule)) {
                this.clearValue(rowIndex, "samppercentage", "inspectionlevelentry", "strictnessentry", "aqlvalueentry", "samplingsize");
            }
        }
    }

    private void clearValue(int rowIndex, String ... keys) {
        IDataModel model = this.getModel();
        for (String key : keys) {
            model.setValue(key, null, rowIndex);
        }
    }

    private void clearValue(String ... keys) {
        IDataModel model = this.getModel();
        for (String key : keys) {
            model.setValue(key, null);
        }
    }

    private void checkFormula(String formula, String replacValue, List<String> warnList) {
        if (StringUtils.isEmpty((String)formula)) {
            warnList.add(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u516c\u5f0f\u3002", (String)"SamplingImportPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        try {
            formula = formula.replace(BTNSTR[23], replacValue);
            new CalculatorEval(formula).parse();
        }
        catch (Exception e) {
            warnList.add(ResManager.loadKDString((String)"\u516c\u5f0f\u65e0\u6cd5\u6267\u884c\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u8bed\u6cd5\u3002", (String)"SamplingImportPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }
}

