/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.basedata.inspectpro;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;

public class InepectProDimenPlugin
extends AbstractFormPlugin {
    private static final String[] REMOCENODEIDS = new String[]{"samplepro", "inspectstd", "inspectorg", "inspectuser", "setuptype", "joininspectflag", "materieltype", "wstrspro"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"profieldname"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)"profieldname", (CharSequence)key)) {
            this.showSelectFieldPage(key);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (StringUtils.equals((CharSequence)"profieldname", (CharSequence)actionId)) {
            this.setCloseBackValue(returnData);
        }
    }

    private void setCloseBackValue(Object returnData) {
        if (Objects.nonNull(returnData)) {
            String fieldName = ((IDataEntityProperty)MetadataServiceHelper.getDataEntityType((String)"qcbd_inspectpro").getAllFields().get(returnData)).getDisplayName().getLocaleValue();
            this.getModel().setValue("profieldname", (Object)fieldName);
            this.getModel().setValue("profield", returnData);
        }
    }

    private void showSelectFieldPage(String key) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"qcbd_inspectpro");
        EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)dataEntityType, (PropTreeBuildOption)option);
        this.removeUselessNode(srcBillNode);
        this.showSelectFieldForm(srcBillNode, key);
    }

    private void removeUselessNode(TreeNode srcBillNode) {
        srcBillNode.deleteChildNode("subprojentry");
        TreeNode billheadNode = srcBillNode.getTreeNode("billhead");
        billheadNode.getChildren().removeIf(o -> !StringUtils.equals((CharSequence)"biztypeid", (CharSequence)o.getId()));
        TreeNode entryNode = srcBillNode.getTreeNode("entryentity");
        entryNode.getChildren().removeIf(o -> ArrayUtils.contains((Object[])REMOCENODEIDS, (Object)o.getId()));
        for (TreeNode child1 : srcBillNode.getChildren()) {
            for (TreeNode child2 : child1.getChildren()) {
                child2.setChildren(null);
            }
        }
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

