/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.basedata.inspectpro;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class InspectFieldMapFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billfieldname"});
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(pkEvent -> {
            DynamicObject parent = (DynamicObject)pkEvent.getRowData().getParent();
            if (ObjectUtils.isEmpty((Object)parent)) {
                return;
            }
            String status = parent.getString("status");
            if (pkEvent.getSource() instanceof OperationColumn && "clearcontents".equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    if ("A".equals(status)) continue;
                    operationColItem.setLocked(true);
                }
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("submit".equals(operateKey) || "audit".equals(operateKey) || "unsubmit".equals(operateKey) || "unaudit".equals(operateKey)) {
            this.getView().updateView("entryentity");
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "billfieldname": {
                this.showTip(evt);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        switch (key = control.getKey()) {
            case "billfieldname": {
                this.showSelectFieldPage(key, rowIndex);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String oprKey = op.getOperateKey();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        switch (oprKey) {
            case "clearcontents": {
                this.getModel().setValue("entityobject", null, rowIndex);
                this.getModel().setValue("billfieldname", null, rowIndex);
                this.getModel().setValue("billfield", null, rowIndex);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object obj = event.getReturnData();
        switch (actionId) {
            case "billfieldname": {
                this.setCloseBackValue(obj, actionId);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        switch (name) {
            case "calfield": {
                this.getModel().deleteEntryData("entryentity");
                this.getModel().createNewEntryRow("entryentity");
                break;
            }
            case "entityobject": {
                this.getModel().setValue("billfieldname", null, rowIndex);
                this.getModel().setValue("billfield", null, rowIndex);
                break;
            }
        }
    }

    private void showTip(BeforeClickEvent evt) {
        DynamicObject calField = this.getModel().getDataEntity().getDynamicObject("calfield");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        DynamicObject entityObject = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"entityobject", (int)rows[0]);
        if (Objects.isNull(calField)) {
            String tipStr = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5339\u914d\u7ef4\u5ea6\u3002", (String)"InspectFieldMapFormPlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tipStr);
            evt.setCancel(true);
        } else if (Objects.isNull(entityObject)) {
            String tipStr = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b2c%s\u884c\u7684\u5355\u636e\u5b9e\u4f53\u3002", (String)"InspectFieldMapFormPlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), rows[0] + 1);
            this.getView().showTipNotification(tipStr);
            evt.setCancel(true);
        }
    }

    private void showSelectFieldPage(String key, int row) {
        IDataModel model = this.getModel();
        DynamicObject calField = model.getDataEntity().getDynamicObject("calfield");
        String proField = calField.getString("profield");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"qcbd_inspectpro");
        IDataEntityProperty targetProperty = entityType.findProperty(proField);
        Class type = targetProperty.getPropertyType();
        DynamicObject bussObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"entityobject", (int)row);
        String name = bussObj.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)name);
        PropTreeBuildOption option = new PropTreeBuildOption(null, targetProperty);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)dataEntityType, (PropTreeBuildOption)option);
        TreeNode afterNode = this.recBillRemoveNodeEffect(srcBillNode, dataEntityType, type);
        this.showSelectFieldForm(afterNode, key);
    }

    private TreeNode recBillRemoveNodeEffect(TreeNode srcBillNode, MainEntityType dataEntityType, Class<?> type) {
        TreeNode rootNode = new TreeNode();
        rootNode.setId(srcBillNode.getId());
        rootNode.setText(srcBillNode.getText());
        List treeNodes = srcBillNode.getChildren();
        if (Objects.isNull(treeNodes)) {
            return rootNode;
        }
        ArrayList<TreeNode> rootChilds = new ArrayList<TreeNode>();
        for (TreeNode node : treeNodes) {
            TreeNode childNode = new TreeNode();
            childNode.setId(node.getId());
            childNode.setText(node.getText());
            ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
            List zTreenodes = node.getChildren();
            if (Objects.isNull(zTreenodes)) {
                rootChilds.add(childNode);
                continue;
            }
            for (TreeNode znode : zTreenodes) {
                String znodeId = znode.getId();
                IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getAllFields().get(znodeId);
                Class newType = property.getPropertyType();
                if (!type.equals(newType)) continue;
                TreeNode cChildNode = new TreeNode();
                cChildNode.setId(znodeId);
                cChildNode.setText(znode.getText());
                childNodes.add(cChildNode);
            }
            childNode.setChildren(childNodes);
            childNode.setIsOpened(true);
            rootChilds.add(childNode);
        }
        rootNode.setChildren(rootChilds);
        rootNode.setIsOpened(true);
        return rootNode;
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String key) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void setCloseBackValue(Object obj, String actionId) {
        int row;
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length > 0 && !ObjectUtils.isEmpty((Object)obj) && this.validtorSelectField(obj, actionId, row = rows[0])) {
            DynamicObject bussObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"entityobject", (int)row);
            String name = bussObj.getString("number");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)name);
            String fieldName = ((IDataEntityProperty)dataEntityType.getAllFields().get(obj)).getDisplayName().getLocaleValue();
            String key = actionId.substring(0, actionId.length() - 4);
            this.getModel().setValue(key, obj, row);
            this.getModel().setValue(actionId, (Object)fieldName, row);
        }
    }

    private boolean validtorSelectField(Object obj, String actionId, int row) {
        boolean flag = false;
        switch (actionId) {
            case "billfieldname": {
                flag = this.validField(obj, row);
                break;
            }
        }
        return flag;
    }

    private boolean validField(Object obj, int row) {
        String key;
        DynamicObject bussObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"entityobject", (int)row);
        String name = bussObj.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)name);
        Set entryKeySet = dataEntityType.getAllEntities().keySet();
        return !entryKeySet.contains(key = String.valueOf(obj)) && !"billhead".equals(key);
    }
}

