/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.basedata.inspectpro;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.InspectStdHelper;
import kd.qmc.qcbd.business.commonmodel.helper.basedata.InspectProHelper;
import kd.qmc.qcbd.business.commonmodel.helper.control.CommonViewControlHelper;
import kd.qmc.qcbd.common.constant.InspectproConst;
import kd.qmc.qcbd.common.enums.BizTypeEnum;
import kd.qmc.qcbd.common.model.InspectProjModel;
import kd.qmc.qcbd.common.util.ControlUtil;
import kd.qmc.qcbd.common.util.DataModelUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.UserUtil;

public class InspectProBasePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBeforeF7Listener(this, "inspectuser", "qroute", "joininspector");
    }

    private void addBeforeF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setVisable(0);
        this.initDimen();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        CommonViewControlHelper.selectFirstMatRow((IDataModel)model, (IFormView)this.getView(), (String)"entryentity", (String)"setuptype");
        this.initProjInfo();
        this.setVisable(this.getShowType());
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "inspectuser": 
            case "joininspector": {
                this.fifterInspectUser(event);
                break;
            }
            case "qroute": {
                this.qmcrouteF7Deal(event);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeDataArr;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        block19: for (ChangeData changeData : changeDataArr = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            switch (name) {
                case "biztypeid": {
                    this.biztypeChanged(changeData);
                    continue block19;
                }
                case "setuptype": {
                    this.setuptypeChanged(changeData);
                    continue block19;
                }
                case "qroute": {
                    this.qrouteChanged((DynamicObject)newValue, rowIndex);
                    continue block19;
                }
                case "inspectstd": {
                    if (!DynamicObjDataUtil.getDataModelBooleanData((IDataModel)this.getModel(), (String)"joininspectflag").booleanValue()) continue block19;
                    this.matchItemsByStd((DynamicObject)newValue, rowIndex);
                    continue block19;
                }
                case "joininspectflag": {
                    if (((Boolean)newValue).booleanValue()) {
                        this.matchItemsByStd(DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"inspectstd", (int)rowIndex), rowIndex);
                        continue block19;
                    }
                    DataModelUtil.deleteSubEntry((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"entryentity", (String)"subprojentry", (int)rowIndex);
                    continue block19;
                }
                case "joindept": 
                case "joininspector": {
                    this.setNullValue(name, changeData, rowIndex);
                    continue block19;
                }
                case "promatchdimen": {
                    InspectProHelper.validDataByPromatchDimen((IFormView)this.getView(), null, (ChangeData)changeData);
                    continue block19;
                }
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)e.getEntryProp().getName())) {
            this.setVisable(this.getShowType());
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)e.getEntryProp().getName())) {
            this.setVisable(this.getShowType());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "previousentry": {
                ControlUtil.preEntryBeforeDoOpr((BeforeDoOperationEventArgs)args, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)"entryentity");
                break;
            }
            case "nextentry": {
                ControlUtil.nextEntryBeforeDoOpr((BeforeDoOperationEventArgs)args, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)"entryentity");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": {
                this.getView().updateView();
                break;
            }
            case "submit": {
                String msg;
                if (formOperate.getOption().containsVariable("msg") && !ObjectUtils.isEmpty((Object)(msg = formOperate.getOption().getVariableValue("msg")))) {
                    this.getView().showTipNotification(msg);
                }
                this.getView().updateView();
                break;
            }
        }
    }

    private void biztypeChanged(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        if (!BizTypeEnum.QCP_001.getValue().equals(newValue) || BizTypeEnum.QCPP_004.getValue().equals(newValue)) {
            InspectProHelper.setEntryValueEach((IDataModel)this.getModel(), (DynamicObjectCollection)entrys, (String)"wstrspro", null);
        }
    }

    private void setuptypeChanged(ChangeData changeData) {
        this.setVisable(this.getShowType());
        Object newValue = changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equals((CharSequence)InspectproConst.SETUPENUM.MAT.getValue(), (CharSequence)((String)newValue))) {
            this.getModel().setValue("materieltype", null, rowIndex);
        } else if (StringUtils.equals((CharSequence)InspectproConst.SETUPENUM.MATTYPE.getValue(), (CharSequence)((String)newValue))) {
            this.getModel().setValue("materielid", null, rowIndex);
        } else {
            this.getModel().setValue("materielid", null, rowIndex);
            this.getModel().setValue("materieltype", null, rowIndex);
        }
    }

    private void qrouteChanged(DynamicObject newValue, int rowIndex) {
        if (Objects.nonNull(newValue)) {
            DynamicObjectCollection processEntrys = newValue.getDynamicObjectCollection("processentry");
            List processList = processEntrys.stream().filter(o -> "1013".equals(o.getString("checktype"))).collect(Collectors.toList());
            DynamicObject process = (DynamicObject)processList.get(0);
            this.getModel().setValue("operationno", process.get("operationno"), rowIndex);
            this.getModel().setValue("oproperation", process.get("operation"), rowIndex);
        } else {
            this.getModel().setValue("operationno", null, rowIndex);
            this.getModel().setValue("oproperation", null, rowIndex);
            this.getModel().setValue("processseq", null, rowIndex);
        }
    }

    private void matchItemsByStd(DynamicObject inspectionstd, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObjectCollection parentEntrys = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObjectCollection projEntrys = ((DynamicObject)parentEntrys.get(rowIndex)).getDynamicObjectCollection("subprojentry");
        projEntrys.clear();
        InspectProjModel projModel = new InspectProjModel(false);
        projModel.setUnitField("unitid");
        InspectStdHelper.setProjEntryByStd((DynamicObject)inspectionstd, (DynamicObjectCollection)projEntrys, (InspectProjModel)projModel, (boolean)false);
        model.updateEntryCache(projEntrys);
        this.getView().updateView("subprojentry");
    }

    private void initProjInfo() {
        IDataModel model = this.getModel();
        DynamicObjectCollection setInfoEntrys = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (int i = 0; i < setInfoEntrys.size(); ++i) {
            DynamicObject parentEntry = (DynamicObject)setInfoEntrys.get(i);
            DynamicObjectCollection projEntrys = parentEntry.getDynamicObjectCollection("subprojentry");
            DynamicObject inspectionstd = parentEntry.getDynamicObject("inspectstd");
            if (!Objects.nonNull(inspectionstd)) continue;
            Map<Long, DynamicObject> stdEntryMyselfMap = inspectionstd.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
            InspectProjModel projModel = new InspectProjModel(false);
            projModel.setUnitField("unitid");
            for (int j = 0; j < projEntrys.size(); ++j) {
                DynamicObject projEntry = (DynamicObject)projEntrys.get(j);
                DynamicObject stdEntry = stdEntryMyselfMap.get(projEntry.getLong("stdentryid"));
                if (!Objects.nonNull(stdEntry)) continue;
                InspectStdHelper.setRow((InspectProjModel)projModel, (DynamicObject)stdEntry, (DynamicObject)projEntry, (int)j);
            }
            model.updateEntryCache(projEntrys);
            this.getView().updateView("subprojentry");
        }
    }

    private void setNullValue(String name, ChangeData changeData, int rowIndex) {
        DynamicObjectCollection subEntrys = DataModelUtil.getSubEntry((IDataModel)this.getModel(), (String)"entryentity", (String)"subprojentry", (int)this.getModel().getEntryCurrentRowIndex("entryentity"));
        if (!((DynamicObject)subEntrys.get(rowIndex)).getBoolean("isjoininspect")) {
            ControlUtil.setValueWithoutPropchange((IDataModel)this.getModel(), (IFormView)this.getView(), (String)name, null, (int)rowIndex, (int)changeData.getParentRowIndex());
        }
    }

    private void qmcrouteF7Deal(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "qroute");
        showParameter.setCloseCallBack(closeCallBack);
        HashMap<String, Comparable<Boolean>> params = new HashMap<String, Comparable<Boolean>>(16);
        params.put("writeoperationno", Boolean.valueOf(true));
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        params.put("startRow", Integer.valueOf(entryCurrentRowIndex));
        showParameter.setCustomParams(params);
        QFilter custfilter = new QFilter("processentry.checktype", "=", (Object)"1013").or("processentry.firstcheck", "=", (Object)true);
        DynamicObject dynObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"biztypeid");
        if (dynObj != null) {
            String bizTypeNumber = dynObj.getString("number");
            if (StringUtils.equals((CharSequence)BizTypeEnum.QCPP_003.getValue(), (CharSequence)bizTypeNumber)) {
                custfilter = new QFilter("processentry.firstcheck", "=", (Object)true);
            } else if (StringUtils.equals((CharSequence)BizTypeEnum.QCPP_001.getValue(), (CharSequence)bizTypeNumber)) {
                custfilter = new QFilter("processentry.checktype", "=", (Object)"1013");
            }
        }
        Date now = KDDateUtils.now();
        custfilter.and("processentry.entryvaliddate", "<=", (Object)now);
        custfilter.and("processentry.entryinvaliddate", ">", (Object)now);
        showParameter.getListFilterParameter().setFilter(custfilter);
    }

    private void fifterInspectUser(BeforeF7SelectEvent event) {
        DynamicObject obj = (DynamicObject)this.getModel().getValue("createorg");
        QFilter qFilterx = UserUtil.getQualityOrgUserByOrgid((Long)((Long)obj.getPkValue()));
        event.addCustomQFilter(qFilterx);
    }

    private int getShowType() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        List setupList = dynamicObjects.stream().map(o -> o.getString("setuptype")).collect(Collectors.toList());
        String setupMat = InspectproConst.SETUPENUM.MAT.getValue();
        String setupMattype = InspectproConst.SETUPENUM.MATTYPE.getValue();
        int showType = setupList.contains(setupMat) && !setupList.contains(setupMattype) ? 0 : (!setupList.contains(setupMat) && setupList.contains(setupMattype) ? 1 : (setupList.contains(setupMat) && setupList.contains(setupMattype) ? 2 : 3));
        return showType;
    }

    private void setVisable(int showType) {
        switch (showType) {
            case 0: {
                this.getView().setVisible(Boolean.FALSE, new String[]{"materieltype", "materieltypename"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"materielid", "materielname"});
                break;
            }
            case 1: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"materieltype", "materieltypename"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"materielid", "materielname"});
                break;
            }
            case 2: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"materielid", "materielname", "materieltype", "materieltypename"});
                break;
            }
            case 3: {
                this.getView().setVisible(Boolean.FALSE, new String[]{"materielid", "materielname", "materieltype", "materieltypename"});
                break;
            }
        }
    }

    private void initDimen() {
        DynamicObjectCollection dimens = DynamicObjDataUtil.getDataModelDynamicObjectCollectionData((IDataModel)this.getModel(), (String)"promatchdimen");
        Object[] ids = new Long[]{1615104834913007616L, 1599303399160004608L};
        DynamicObject[] queryDimenArray = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"qcbd_pro_matchdimen"));
        int dimenLength = queryDimenArray.length;
        long[] pkIds = ORM.create().genLongIds("qcbd_pro_matchdimen", dimenLength);
        for (int i = 0; i < dimenLength; ++i) {
            DynamicObject queryDimen = queryDimenArray[i];
            DynamicObject dimen = dimens.addNew();
            dimen.set("pkid", (Object)pkIds[i]);
            dimen.set("fbasedataid", (Object)queryDimen);
            dimen.set("fbasedataid_id", queryDimen.getPkValue());
        }
        this.getModel().setValue("promatchdimen", (Object)dimens);
    }
}

