/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.basedata.invinspectschem;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.commonmodel.helper.invhelper.InventoryInspHelper;
import kd.qmc.qcbd.common.constant.invinspectschem.InvInspectSchemConst;
import kd.qmc.qcbd.common.util.ChangeDataUtil;
import kd.qmc.qcbd.common.util.OrgUnitUtil;

public class InvInpsectSchemPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String FIELDNAME = "fieldName";
    private static final String FIRST_SETDATE = "C";
    private static final String SYSTEM_TYPE = "qmc-qcbd-formplugin";
    private static final String SHOW_INSPECT_APPLAN = "showInspectApplan";

    public void afterCreateNewData(EventObject e) {
        Object org = this.getModel().getValue("org");
        if (null != org) {
            this.getModel().setValue("org", org);
            this.getModel().setValue("useorg", org);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        String dataSource = (String)model.getValue("datasource");
        if ("A".equals(dataSource)) {
            this.setDefaultCustomFilter("im_inv_realbalance");
            return;
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        String dataSource = (String)model.getValue("datasource");
        if ("A".equals(dataSource)) {
            this.resetFilterColumns(filterGrid);
            this.setFilter();
            this.setDateMust("A");
            this.setSpecialDateMust();
            this.setSplitReason("A");
            return;
        }
        if ("B".equals(dataSource)) {
            this.setDateMust("B");
            this.setSplitReason("B");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        Object obj = args.getSource();
        switch (opKey = ((AbstractOperate)obj).getOperateKey()) {
            case "save": {
                this.setCustomFilter(args);
                break;
            }
            case "submit": {
                this.setCustomFilter(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object obj = args.getSource();
        String opKey = ((AbstractOperate)obj).getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("autoexec".equals(opKey) && operationResult.isSuccess()) {
            String message = operationResult.getMessage();
            if (StringUtils.isNotEmpty((String)message) && -1 == message.indexOf("#")) {
                this.getView().showErrorNotification(message);
                return;
            }
            String[] splitMessage = message.split("#");
            String targetIdsStr = splitMessage[0];
            List targetIds = (List)JSON.parse((String)targetIdsStr);
            this.getPageCache().put("targetIds", targetIdsStr);
            int totalCount = targetIds.size();
            if (totalCount > 0) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(SHOW_INSPECT_APPLAN, (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5df2\u751f\u6210%s\u5f20\u5e93\u5b58\u8bf7\u68c0\u5355\uff0c\u8bf7\u70b9\u51fb\u786e\u8ba4\uff0c\u8df3\u8f6c\u81f3\u5e93\u5b58\u8bf7\u68c0\u5355\u5217\u8868\u67e5\u770b\u3002", (String)"InvInpsectSchemPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), totalCount), MessageBoxOptions.OKCancel, confirmCallBackListener);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u5e93\u5b58\u8bf7\u68c0\u5355\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u6267\u884c\u65e5\u5fd7\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f\u3002", (String)"InvInpsectSchemPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit material;
        BasedataEdit quaorg;
        super.registerListener(e);
        BasedataEdit applyorg = (BasedataEdit)this.getView().getControl("applyorg");
        if (applyorg != null) {
            applyorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((quaorg = (BasedataEdit)this.getView().getControl("quaorg")) != null) {
            quaorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("materialsel")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String opKey = beforeF7SelectEvent.getProperty().getName();
        long userId = UserServiceHelper.getCurrentUserId();
        String entityName = this.getView().getEntityId();
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean allOrgPer = OrgUnitUtil.getHasAllOrgPer((Long)userId, (String)appId, (String)entityName);
        ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("applyorg".equals(opKey)) {
            if (allOrgPer) {
                return;
            }
            List<Long> orgList = this.filterApplyOrg(userId, entityName, appId);
            QFilter filter = new QFilter("id", "in", orgList);
            showPara.getListFilterParameter().setFilter(filter);
            return;
        }
        if ("quaorg".equals(opKey)) {
            if (allOrgPer) {
                return;
            }
            List<Long> orgList = this.filterApplyOrg(userId, entityName, appId);
            QFilter filter = new QFilter("id", "in", orgList);
            showPara.getListFilterParameter().setFilter(filter);
            return;
        }
        if ("materialsel".equals(opKey)) {
            if (allOrgPer) {
                return;
            }
            List<Long> orgList = this.filterApplyOrg(userId, entityName, appId);
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", orgList, (boolean)true);
            showPara.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (!ChangeDataUtil.valueCheck((Object)newValue, (Object)oldValue)) break;
            if ("datasource".equals(fieldName)) {
                this.changeDatasource(newValue);
                continue;
            }
            if ("firstinspectdate".equals(fieldName)) {
                this.changeSetDate(newValue);
                continue;
            }
            if ("splitreason".equals(fieldName)) {
                this.handleDimensionChangeEvent(rowIndex);
                continue;
            }
            if (!"applyorg".equals(fieldName)) continue;
            if (null == newValue) {
                this.getModel().setValue("quaorg", null);
                continue;
            }
            this.setQuaOrg(newValue);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (SHOW_INSPECT_APPLAN.equals(callBackId) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            String targetIdStr = this.getPageCache().get("targetIds");
            List targetIds = (List)JSON.parse((String)targetIdStr);
            InventoryInspHelper.showInspectPlanList((IFormView)this.getView(), (List)targetIds);
        }
    }

    private void setQuaOrg(Object newValue) {
        long orgId = ((DynamicObject)newValue).getLong("id");
        List orgIds = OrgUnitServiceHelper.getAllToOrg((String)"", (String)"06", (Long)orgId, (boolean)false);
        if (!orgIds.isEmpty()) {
            this.getModel().setValue("quaorg", orgIds.get(0));
        }
    }

    private void handleDimensionChangeEvent(int rowIndex) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        ArrayList<String> rowValueList = new ArrayList<String>();
        for (DynamicObject entry : entrys) {
            String rowValue = entry.getString("splitreason");
            if (StringUtils.isEmpty((String)rowValue)) continue;
            if (rowValueList.contains(rowValue)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u68c0\u9a8c\u7533\u8bf7\u5206\u5355\u4f9d\u636e\u4e0d\u53ef\u91cd\u590d\u3002", (String)"InvInpsectSchemPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[]{++rowIndex, 2000}), new Object[0]));
                return;
            }
            rowValueList.add(rowValue);
        }
    }

    private void setSpecialDateMust() {
        String firstStr = (String)this.getModel().getValue("firstinspectdate");
        DateEdit setDate = (DateEdit)this.getControl("setdate");
        if (StringUtils.isEmpty((String)firstStr)) {
            return;
        }
        if (FIRST_SETDATE.equals(firstStr)) {
            setDate.setMustInput(true);
        }
    }

    private void changeSetDate(Object newValue) {
        DateEdit setDate = (DateEdit)this.getControl("setdate");
        if (FIRST_SETDATE.equals(newValue)) {
            setDate.setMustInput(true);
        } else {
            setDate.setMustInput(false);
        }
    }

    private void setSplitReason(String type) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("splitreason");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(10);
        if ("B".equals(type)) {
            InvInspectSchemConst schemConst = new InvInspectSchemConst();
            data.add(new ComboItem(new LocaleString(schemConst.getQuaorgSplit()), "quaorg"));
            data.add(new ComboItem(new LocaleString(schemConst.getMaterialSplit()), "material"));
            comboEdit.setComboItems(data);
            return;
        }
        if ("A".equals(type)) {
            InvInspectSchemConst schemConst = new InvInspectSchemConst();
            Map dymaccModelDimensionMapExcludeqty = schemConst.getDymaccModelDimensionMapExcludeQty();
            for (Map.Entry entry : dymaccModelDimensionMapExcludeqty.entrySet()) {
                if ("biztime".equals(entry.getKey())) continue;
                data.add(new ComboItem((LocaleString)entry.getValue(), (String)entry.getKey()));
            }
            data.add(new ComboItem(new LocaleString(schemConst.getQuaorgSplit()), "quaorg"));
            comboEdit.setComboItems(data);
        }
    }

    private List<Long> filterApplyOrg(long userId, String entityName, String appId) {
        List orgIds = OrgUnitUtil.getHasPerOrg((Long)userId, (String)appId, (String)entityName);
        return orgIds;
    }

    private void changeDatasource(Object newValue) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        List listFilter = condition.getFilterRow();
        listFilter.clear();
        condition.setFilterRow(listFilter);
        filterGrid.SetValue(condition);
        if ("B".equals(newValue)) {
            this.clearSplitEntry();
            this.setSplitReason("B");
            this.setDateMust("B");
            return;
        }
        if ("A".equals(newValue)) {
            this.setDefaultCustomFilter("im_inv_realbalance");
            this.getView().updateView("filtergridap");
            this.resetFilterColumns(filterGrid);
            this.clearSplitEntry();
            this.setSplitReason("A");
            this.setDateMust("A");
        }
    }

    private void clearSplitEntry() {
        this.getModel().deleteEntryData("entryentity");
    }

    private void setDateMust(String type) {
        ComboEdit dateEdit = (ComboEdit)this.getControl("firstinspectdate");
        ComboEdit inspectnumstyle = (ComboEdit)this.getControl("inspectnumstyle");
        if ("A".equals(type)) {
            dateEdit.setMustInput(true);
            inspectnumstyle.setMustInput(true);
            return;
        }
        if ("B".equals(type)) {
            dateEdit.setMustInput(false);
            inspectnumstyle.setMustInput(false);
        }
    }

    private void setCustomFilter(BeforeDoOperationEventArgs args) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        List filterRows = filterCondition.getFilterRow();
        if (filterRows.isEmpty()) {
            this.getModel().getDataEntity().set("filterstring_tag", null);
        } else {
            for (SimpleFilterRow filterRow : filterRows) {
                int index = filterRow.getCompareType().indexOf("-");
                if (-1 != index) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6570\u636e\u8303\u56f4\uff0c\u4e0d\u652f\u6301\u5b57\u6bb5\u7b49\u4e8e\u3001\u5b57\u6bb5\u4e0d\u7b49\u4e8e\u3001\u5b57\u6bb5\u5927\u4e8e\u3001\u5b57\u6bb5\u5927\u4e8e\u7b49\u4e8e\u3002", (String)"InvInpsectSchemPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String compareType = filterRow.getCompareType();
                if (!CompareTypeEnum.CURRENTUSERDEPT.getId().equals(compareType) && !CompareTypeEnum.CURRENTUSERDEPTS.getId().equals(compareType) && !CompareTypeEnum.CURRENTUSERINCHARGEDEPT.getId().equals(compareType) && !CompareTypeEnum.CURRENTUSERINCHARGEDEPTS.getId().equals(compareType)) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u7684\u6761\u4ef6\u5b57\u6bb5\u503c\u4e0d\u652f\u6301\uff1a\u6211\u8d1f\u8d23\u7684\u90e8\u95e8\u3001\u6211\u8d1f\u8d23\u7684\u90e8\u95e8\u4ee5\u53ca\u4e0b\u7ea7\u3001\u6211\u7684\u90e8\u95e8\u3001\u6211\u7684\u90e8\u95e8\u4ee5\u53ca\u4e0b\u7ea7\u3002", (String)"InvInpsectSchemPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String filterString = SerializationUtils.toJsonString((Object)filterCondition);
            this.getModel().getDataEntity().set("filterstring_tag", (Object)filterString);
        }
    }

    private void setDefaultCustomFilter(String type) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        if (null != filterGrid) {
            filterGrid.setEntityNumber(type);
        }
    }

    private void resetFilterColumns(FilterGrid filterGrid) {
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> resetFilterColumns = new ArrayList<Map>(filterColumns.size());
        for (Map filterColumn : filterColumns) {
            String fieldName = (String)filterColumn.get(FIELDNAME);
            if (fieldName.contains("qty") || fieldName.contains("unit") || "lot.number".equals(fieldName) || "materialname".equals(fieldName) || "warehouse.isopenlocation".equals(fieldName) || "updatetime".equals(fieldName) || "keycol".equals(fieldName) || "configuredcode.name".equals(fieldName) || "auxpty".equals(fieldName)) continue;
            resetFilterColumns.add(filterColumn);
        }
        filterGrid.setFilterColumns(resetFilterColumns);
        this.getView().updateView("filtergridap");
    }

    private void setFilter() {
        String billfilterstr = (String)this.getModel().getDataEntity().get("filterstring_tag");
        if (StringUtils.isNotEmpty((String)billfilterstr)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billfilterstr, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            filterGrid.SetValue(filterCondition);
        }
    }
}

