/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.basedata.noticeproblem;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;

public class SeriousEvaSchemeEdit
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setFirstValue();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        block14: for (ChangeData changeData : changeSet) {
            int rowIndex = changeData.getRowIndex();
            switch (fieldName) {
                case "seriouslevel": {
                    this.computeMaxLevel("seriousentry", "seriouslevel", "seriousmax");
                    continue block14;
                }
                case "happenratelevel": {
                    this.computeMaxLevel("happenrateentry", "happenratelevel", "happenratemax");
                    continue block14;
                }
                case "searchdeeplevel": {
                    this.computeMaxLevel("searchdeepentry", "searchdeeplevel", "searchdeepmax");
                    continue block14;
                }
                case "levelstart": {
                    if (rowIndex <= 0) continue block14;
                    model.setValue("levelend", model.getValue("levelstart", rowIndex), rowIndex - 1);
                    continue block14;
                }
                case "levelend": {
                    Object startValue = model.getValue("levelend", rowIndex);
                    if (model.getEntryRowCount("eavschemeentry") <= rowIndex + 1) continue block14;
                    model.setValue("levelstart", startValue, rowIndex + 1);
                    if (BigDecimal.ZERO.compareTo((BigDecimal)startValue) == 0) {
                        model.setValue("levelstart", null, rowIndex + 1);
                        continue block14;
                    }
                    model.setValue("levelstart", startValue, rowIndex + 1);
                    continue block14;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IDataModel model = this.getModel();
        String oprKey = args.getOperateKey();
        int rowIndex = model.getEntryCurrentRowIndex("eavschemeentry");
        int rowCount = model.getEntryRowCount("eavschemeentry");
        switch (oprKey) {
            case "newschemeentry": {
                this.afterNewScheme(rowCount);
                break;
            }
            case "deleteschemeentry": {
                this.afterDelScheme(rowIndex, rowCount);
                break;
            }
            case "deleteseriousentry": {
                this.computeMaxLevel("seriousentry", "seriouslevel", "seriousmax");
                break;
            }
            case "delethappenrateeentry": {
                this.computeMaxLevel("happenrateentry", "happenratelevel", "happenratemax");
                break;
            }
            case "deletesearchdeepentry": {
                this.computeMaxLevel("searchdeepentry", "searchdeeplevel", "searchdeepmax");
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        IDataModel model = this.getModel();
        Object source = e.getSource();
        int rowIndex = e.getRowIndex();
        if (source instanceof FieldEdit) {
            String fieldKey;
            FieldEdit fieldEdit = (FieldEdit)source;
            switch (fieldKey = fieldEdit.getFieldKey()) {
                case "levelstart": {
                    this.levelFieldPostBack(e, model, rowIndex, "levelstart");
                    break;
                }
                case "levelend": {
                    this.levelFieldPostBack(e, model, rowIndex, "levelend");
                    break;
                }
            }
        }
    }

    private void afterNewScheme(int rowCount) {
        IDataModel model = this.getModel();
        if (rowCount == 1) {
            this.setFirstValue();
        } else {
            int lastRowIndex = rowCount - 1;
            int lastButOneRowIndex = rowCount - 2;
            if (BigDecimal.ZERO.compareTo((BigDecimal)model.getValue("levelend", lastButOneRowIndex)) == 0) {
                model.setValue("levelstart", null, lastRowIndex);
            } else {
                model.setValue("levelstart", model.getValue("levelend", lastButOneRowIndex), lastRowIndex);
            }
        }
    }

    private void afterDelScheme(int rowIndex, int rowCount) {
        IDataModel model = this.getModel();
        if (rowCount == 1) {
            this.setFirstValue();
        } else if (rowCount > rowIndex + 1) {
            if (BigDecimal.ZERO.compareTo((BigDecimal)model.getValue("levelend", rowIndex)) == 0) {
                model.setValue("levelstart", null, rowIndex + 1);
            } else {
                model.setValue("levelstart", model.getValue("levelend", rowIndex), rowIndex + 1);
            }
        }
    }

    private void levelFieldPostBack(BeforeFieldPostBackEvent e, IDataModel model, int rowIndex, String updateField) {
        if (Objects.isNull(e.getValue())) {
            return;
        }
        BigDecimal curStartValue = (BigDecimal)model.getValue("levelstart", rowIndex);
        BigDecimal curEndValue = (BigDecimal)model.getValue("levelend", rowIndex);
        BigDecimal beforeStartValue = (BigDecimal)model.getValue("levelstart", rowIndex - 1);
        BigDecimal nextEndValue = (BigDecimal)model.getValue("levelend", rowIndex + 1);
        BigDecimal newValue = new BigDecimal((String)e.getValue());
        switch (updateField) {
            case "levelstart": {
                if (BigDecimal.ZERO.compareTo(curEndValue) != 0 && newValue.compareTo(curEndValue) >= 0) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u503c\u9700\u5c0f\u4e8e\u622a\u6b62\u503c\u3002", (String)"SeriousEvaSchemeEdit_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (newValue.compareTo(beforeStartValue) > 0) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u503c\u9700\u5927\u4e8e\u4e0a\u4e00\u884c\u8d77\u59cb\u503c\u3002", (String)"SeriousEvaSchemeEdit_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
                break;
            }
            case "levelend": {
                if (!Objects.nonNull(curStartValue)) break;
                if (newValue.compareTo(curStartValue) <= 0) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u503c\u9700\u5927\u4e8e\u8d77\u59cb\u503c\u3002", (String)"SeriousEvaSchemeEdit_2", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!Objects.nonNull(nextEndValue) || BigDecimal.ZERO.compareTo(nextEndValue) == 0 || newValue.compareTo(nextEndValue) < 0) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u503c\u9700\u5c0f\u4e8e\u4e0b\u4e00\u884c\u622a\u6b62\u503c\u3002", (String)"SeriousEvaSchemeEdit_3", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        this.getView().updateView(updateField, rowIndex);
    }

    private void computeMaxLevel(String entryKey, String computeField, String maxField) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(entryKey);
        Optional<BigDecimal> maxOpt = entrys.stream().map(o -> o.getBigDecimal(computeField)).max(BigDecimal::compareTo);
        if (maxOpt.isPresent() && BigDecimal.ZERO.compareTo(maxOpt.get()) != 0) {
            this.getModel().setValue(maxField, (Object)maxOpt.get());
        } else {
            this.getModel().setValue(maxField, (Object)BigDecimal.ONE);
        }
    }

    private void setFirstValue() {
        this.getModel().setValue("levelstart", (Object)0, 0);
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"levelstart"});
    }
}

