/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.basedata.transactype;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TransacTypeListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String oprKey = evt.getOperateKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selects = billList.getSelectedRows();
        if ("setdefault".equals(oprKey)) {
            this.setDefault(selects);
        }
    }

    private void setDefault(ListSelectedRowCollection selects) {
        if (selects.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9ed8\u8ba4\u53ea\u80fd\u5355\u884c\u64cd\u4f5c\u3002", (String)"TransacTypeListPlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject billInfo = BusinessDataServiceHelper.loadSingle((Object)selects.get(0).getPrimaryKeyValue(), (String)"qcbd_transactype");
            if (this.checkCanDefault(billInfo)) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("isdefault", (IFormPlugin)this);
                DynamicObject creatOrg = billInfo.getDynamicObject("createorg");
                DynamicObject bizType = billInfo.getDynamicObject("biztypeid");
                QFilter qFilter = new QFilter("createorg", "=", creatOrg.getPkValue());
                qFilter.and("biztypeid", "=", bizType.getPkValue());
                qFilter.and("isdefault", "=", (Object)"1");
                if (QueryServiceHelper.exists((String)"qcbd_transactype", (QFilter[])qFilter.toArray())) {
                    String message = String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\uff1a%1$s\uff0c\u4e1a\u52a1\u7c7b\u578b\uff1a%2$s\u5df2\u8bbe\u7f6e\u9ed8\u8ba4\u7684\u8d28\u68c0\u4e8b\u52a1\u7c7b\u578b\u3002\u662f\u5426\u9700\u8981\u91cd\u65b0\u8bbe\u7f6e\uff1f", (String)"TransacTypeListPlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), creatOrg.getString("name"), bizType.getString("name"));
                    this.getView().showConfirm(message, MessageBoxOptions.OKCancel, confirmCallBackListener);
                } else {
                    this.saveDefault(billInfo);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"isdefault", (CharSequence)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selects = billList.getSelectedRows();
            DynamicObject billInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)selects.get(0).getPrimaryKeyValue(), (String)"qcbd_transactype");
            this.saveDefault(billInfo);
        }
    }

    private void saveDefault(DynamicObject billInfo) {
        DynamicObject[] queryList;
        Long id = billInfo.getLong("id");
        long bizTypeId = billInfo.getDynamicObject("biztypeid").getLong("id");
        QFilter qFilter = new QFilter("isdefault", "=", (Object)"1");
        qFilter.and("biztypeid", "=", (Object)bizTypeId);
        qFilter.or("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{qFilter};
        for (DynamicObject dynamicObject : queryList = BusinessDataServiceHelper.load((String)"qcbd_transactype", (String)"id,number,isdefault", (QFilter[])filters)) {
            dynamicObject.set("isdefault", (Object)(id.longValue() == dynamicObject.getLong("id") ? "1" : "0"));
        }
        SaveServiceHelper.save((DynamicObject[])queryList);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9ed8\u8ba4\u6210\u529f\u3002", (String)"TransacTypeListPlugin_2", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private boolean checkCanDefault(DynamicObject billInfo) {
        boolean canDefault = true;
        if (!billInfo.getBoolean("enable")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u72b6\u6001\u65e0\u6cd5\u8bbe\u4e3a\u9ed8\u8ba4\u3002", (String)"TransacTypeListPlugin_3", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            canDefault = false;
        }
        if (!StringUtils.equals((CharSequence)"C", (CharSequence)billInfo.getString("status"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u8bbe\u4e3a\u9ed8\u8ba4\u3002", (String)"TransacTypeListPlugin_4", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            canDefault = false;
        }
        if (billInfo.getBoolean("isdefault")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u9ed8\u8ba4\u72b6\u6001\uff0c\u65e0\u9700\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"TransacTypeListPlugin_5", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            canDefault = false;
        }
        return canDefault;
    }
}

