/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.basedata.widestrict;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class WideStrictRuleFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String SYSTEMTYPE = "qmc-qcbd-formplugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"startcondition", "rstartcondition"});
        this.addF7Listener(this, "nextstage", "rnextstage", "sapplan");
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (propName.equals("starttage")) {
                Long resetprd = (Long)model.getValue("resetprd");
                int length = entryEntity.size();
                if (rowIndex == 1 || rowIndex == 3) {
                    if (newValue.equals(Boolean.TRUE)) {
                        if (resetprd > 0L) {
                            model.beginInit();
                            model.setValue("starttage", (Object)Boolean.FALSE, rowIndex);
                            model.endInit();
                            model.updateCache();
                            this.getView().updateView("starttage", rowIndex);
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u5468\u671f\u5927\u4e8e0\u65f6\uff0c\u8d77\u59cb\u9636\u6bb5\u53ea\u80fd\u4e3a\u6b63\u5e38\u68c0\u9a8c\u6216\u52a0\u4e25\u68c0\u9a8c\u3002", (String)"WideStrictRuleFormPlugin_0", (String)SYSTEMTYPE, (Object[])new Object[0]));
                            return;
                        }
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{"resetprd"});
                    } else {
                        this.getView().setEnable(Boolean.valueOf(true), new String[]{"resetprd"});
                    }
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"resetprd"});
                }
                model.beginInit();
                for (int j = 0; j < length; ++j) {
                    if (j == rowIndex) continue;
                    model.setValue("starttage", (Object)Boolean.FALSE, j);
                    this.getView().updateView("starttage", j);
                }
                model.endInit();
                model.updateCache();
                continue;
            }
            if (!propName.equals("currentstage")) continue;
            DataEntityState dataEntityState = changeData.getDataEntity().getDataEntityState();
            List bizChangedProperties = (List)dataEntityState.getBizChangedProperties();
            int ordinal = ((IDataEntityProperty)bizChangedProperties.get(0)).getOrdinal();
            dataEntityState.setBizChanged(ordinal, false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        this.initCurrentStages();
        view.setEnable(Boolean.FALSE, 2, new String[]{"rnextstage", "rstartcondition"});
        view.setEnable(Boolean.FALSE, 3, new String[]{"sapplan", "rstartcondition", "rnextstage"});
        FieldEdit startStage = (FieldEdit)this.getControl("starttage");
        startStage.setMustInput(true);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (Objects.nonNull(source) && (StringUtils.equals((CharSequence)"startcondition", (CharSequence)key) || StringUtils.equals((CharSequence)"rstartcondition", (CharSequence)key))) {
            this.conditionClickEvent(key);
        }
    }

    private void conditionClickEvent(String key) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        FormShowParameter billShowParameter = new FormShowParameter();
        billShowParameter.setFormId("qcbd_ws_condition");
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e", (String)"WideStrictRuleFormPlugin_1", (String)SYSTEMTYPE, (Object[])new Object[0]));
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("type", key);
        customParams.put("rowNum", currentRowIndex);
        billShowParameter.setCustomParams(customParams);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "condition"));
        this.getView().showForm(billShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getReturnData() != null && StringUtils.equals((CharSequence)"condition", (CharSequence)event.getActionId())) {
            HashMap returnData = (HashMap)event.getReturnData();
            int rowNum = (Integer)returnData.get("rowNum");
            String prop = (String)returnData.get("prop");
            String value = (String)returnData.get("retrunInfo");
            this.getModel().setValue(prop, (Object)value, rowNum);
            if (StringUtils.equals((CharSequence)prop, (CharSequence)"startcondition")) {
                if (Objects.nonNull(returnData.get("lotNum"))) {
                    long lotNum = (Long)returnData.get("lotNum");
                    this.getModel().setValue("contacceptnum", (Object)lotNum, rowNum);
                }
                if (Objects.nonNull(returnData.get("dayNum"))) {
                    long dayNum = (Long)returnData.get("dayNum");
                    this.getModel().setValue("acceptvaliddt", (Object)dayNum, rowNum);
                }
            } else {
                long lotNum = (Long)returnData.get("lotNum");
                long unLotNum = (Long)returnData.get("unLotNum");
                this.getModel().setValue("continspectnum", (Object)lotNum, rowNum);
                this.getModel().setValue("rejectnum", (Object)unLotNum, rowNum);
            }
        }
    }

    private void initCurrentStages() {
        DynamicObjectCollection stages = this.getStages(new QFilter("number", "in", Arrays.asList("1", "2", "3", "4")));
        Map<Object, Object> stageMap = stages.stream().collect(Collectors.toMap(x -> x.get("number"), x -> x.get("id")));
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryRowCount("entryentity");
        for (int i = 0; i < rowIndex; ++i) {
            String idStr = String.valueOf(i + 1);
            model.setValue("currentstage", stageMap.get(idStr), i);
            model.setValue("ensuresave", (Object)true, i);
        }
    }

    private DynamicObjectCollection getStages(QFilter qfilter) {
        return QueryServiceHelper.query((String)"qcbd_widstrict_stage", (String)"id, number", (QFilter[])new QFilter[]{qfilter.and(new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1")))});
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if ("nextstage".equals(name) || "rnextstage".equals(name)) {
            showParameter.getListFilterParameter().setFilter(this.getStageFilter(name));
        }
        if ("sapplan".equals(name)) {
            showParameter.getListFilterParameter().setFilter(this.getPlanFilter());
        }
    }

    private QFilter getPlanFilter() {
        QFilter qFilter = new QFilter("samplingtype", "!=", (Object)"6");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (2 != rowIndex) {
            qFilter.and(new QFilter("samplingtype", "!=", (Object)"5"));
        }
        return qFilter;
    }

    private QFilter getStageFilter(String name) {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        List<String> numberList = new LinkedList();
        switch (rowIndex) {
            case 0: {
                numberList = "nextstage".equals(name) ? Arrays.asList("2", "3", "4") : new LinkedList<String>(){
                    {
                        this.add("3");
                    }
                };
                break;
            }
            case 1: {
                numberList = "nextstage".equals(name) ? Arrays.asList("1", "3", "4") : Arrays.asList("1", "3");
                break;
            }
            case 2: {
                numberList = "nextstage".equals(name) ? Arrays.asList("1", "2", "4") : new LinkedList();
                break;
            }
            case 3: {
                numberList = Arrays.asList("1", "2", "3");
                break;
            }
        }
        QFilter qFilter = new QFilter("number", "in", numberList);
        DynamicObjectCollection stages = this.getStages(qFilter);
        List idList = stages.stream().map(x -> x.get("id")).collect(Collectors.toList());
        return new QFilter("id", "in", idList);
    }
}

