/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.common;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.BillTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.BizTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.LotNumberHelper;
import kd.qmc.qcbd.business.commonmodel.helper.basedata.TransacTypeHelper;
import kd.qmc.qcbd.common.util.BizChangeWinUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class InSpecBillCommon
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String INSPECTOR = "inspector";
    private static final String INSPECTORID = "inspectorid";
    private static final String BILLTYPE = "billtype";
    private static final String BIZTYPE = "biztype";
    private static final String MATERIALCFG = "materialcfg";
    private static final String MATERIELID = "materielid";
    private static final String MATERIALID = "materialid";
    private static final String UNIT = "unit";
    private static final String BILLNO = "billno";
    private static final String ORG = "org";
    private static final String INSPEDEPTID = "inspedepartment";
    private static final String QROUTE = "qroute";
    private static final String TRANSACTYPE = "transactype";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, BIZTYPE, UNIT, ORG, INSPECTORID, INSPECTOR, INSPEDEPTID, MATERIALID, MATERIELID, MATERIALCFG, TRANSACTYPE);
        BasedataEdit location = (BasedataEdit)this.getView().getControl("location");
        if (location != null) {
            location.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillTypeHelper.billTypeChange((IFormView)this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean isFromDb = dataEntity.getDataEntityState().getFromDatabase();
        boolean pushChanged = dataEntity.getDataEntityState().isPushChanged();
        if (!isFromDb && !pushChanged && Objects.isNull(this.getModel().getValue(TRANSACTYPE))) {
            this.initTransacType();
            HashMap<String, Integer> ingoreFields = new HashMap<String, Integer>(1);
            ingoreFields.put("transactype_id", -1);
            BizChangeWinUtil.setIngoreHeadFields((IDataModel)this.getModel(), ingoreFields);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String sourceId = event.getProperty().getName();
        IDataModel model = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        switch (sourceId) {
            case "biztype": {
                BizTypeHelper.selectBizType((IDataModel)model, (IFormView)this.getView(), (ListShowParameter)showParameter);
                break;
            }
            case "org": {
                this.changeBillnoEvent();
                break;
            }
            case "materialcfg": {
                this.selectMaterial(model, showParameter);
                break;
            }
            case "location": {
                int rowIndex = event.getRow();
                this.beforeLocation(event, showParameter, model, rowIndex);
                break;
            }
            case "transactype": {
                this.beforeTransactypeF7(event, showParameter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] valueSet;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        block20: for (ChangeData changeData : valueSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            switch (name) {
                case "billtype": {
                    BillTypeHelper.billTypeChange((IFormView)this.getView());
                    this.callBiztypeChange(MessageBoxResult.Yes);
                    continue block20;
                }
                case "materielid": 
                case "materialid": {
                    this.matChangeDealRoute(newValue, rowIndex);
                    continue block20;
                }
                case "billno": 
                case "org": {
                    this.changeBillnoEvent();
                    continue block20;
                }
                case "location": {
                    if (this.locationCheck(newValue, rowIndex) || newValue == null) continue block20;
                    this.getModel().setValue("location", oldValue, rowIndex);
                    continue block20;
                }
                case "warehouse": {
                    this.getModel().setValue("location", null, rowIndex);
                    continue block20;
                }
                case "materialcfg": {
                    this.materialcfgChange(newValue, rowIndex);
                    continue block20;
                }
                case "qroute": {
                    this.qrouteChange((DynamicObject)newValue, rowIndex);
                    continue block20;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("save".equals(formOperate.getOperateKey()) || "submit".equals(formOperate.getOperateKey())) {
            this.saveUniqueCheck();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        switch (e.getCallBackId()) {
            case "biztypeChange": {
                this.callBiztypeChange(e.getResult());
                break;
            }
        }
    }

    protected void callBiztypeChange(MessageBoxResult result) {
    }

    private void saveUniqueCheck() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String billNo = DynamicObjDataUtil.getDataModelStringData((IDataModel)model, (String)BILLNO);
        DynamicObject org = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)ORG);
        if (null == org) {
            FieldTip oWarningTip = new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.others, ORG, ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"InSpecBillCommon_2", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            view.showFieldTip(oWarningTip);
            return;
        }
        long id = (Long)model.getDataEntity().get("id");
        QFilter[] unitFilter = new QFilter(BILLNO, "=", (Object)billNo).and(ORG, "=", org.getPkValue()).toArray();
        DynamicObjectCollection query = QueryServiceHelper.query((String)view.getEntityId(), (String)"id", (QFilter[])unitFilter);
        for (DynamicObject dynamicObject : query) {
            if (dynamicObject.getLong("id") == id) continue;
            FieldTip bWarningTip = new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.others, BILLNO, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728", (String)"InSpecBillCommon_3", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            FieldTip oWarningTip = new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.others, ORG, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728", (String)"InSpecBillCommon_3", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            view.showFieldTip(bWarningTip);
            view.showFieldTip(oWarningTip);
            break;
        }
    }

    private void selectMaterial(IDataModel model, ListShowParameter showParameter) {
        Object bizType = model.getValue(BIZTYPE);
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        if (null == bizType) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"InSpecBillCommon_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            qFilters.add(new QFilter("id", "=", (Object)-1L));
            return;
        }
        Long bizTypeId = ((DynamicObject)bizType).getLong("id");
        qFilters.add(new QFilter("entryentity.inspecttype.id", "=", (Object)bizTypeId));
    }

    private void beforeLocation(BeforeF7SelectEvent e, ListShowParameter showParameter, IDataModel bill, int rowIndex) {
        DynamicObject warehouse = (DynamicObject)bill.getValue("warehouse", rowIndex);
        if (null == warehouse) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u884c\u7684\u4ed3\u5e93\u3002", (String)"InSpecBillCommon_4", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
            List<Long> ids = this.getLoactionIds(locationCol);
            QFilter qFilter1 = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setFilter(qFilter1);
        }
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    private boolean locationCheck(Object object, int rowIndex) {
        boolean f = false;
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse", rowIndex);
        if (warehouse != null && object != null) {
            DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
            DynamicObject location = (DynamicObject)object;
            for (DynamicObject locDym : locationCol) {
                DynamicObject l = locDym.getDynamicObject("location");
                if (!location.getPkValue().toString().equals(l.getPkValue().toString())) continue;
                f = true;
                break;
            }
        }
        return f;
    }

    private void beforeTransactypeF7(BeforeF7SelectEvent event, ListShowParameter showParameter) {
        DynamicObject bizType = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)BIZTYPE);
        if (Objects.nonNull(bizType)) {
            showParameter.getListFilterParameter().setFilter(new QFilter("biztypeid", "=", bizType.getPkValue()));
        } else {
            event.setCancel(Boolean.TRUE.booleanValue());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"InSpecBillCommon_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
        }
    }

    protected void changeMaterialEvent(DynamicObject materialInfo, int rowIndex) {
        if (materialInfo != null) {
            this.getModel().setValue(UNIT, null, rowIndex);
            DynamicObject unit = materialInfo.getDynamicObject("baseunit");
            if (unit != null) {
                Long unitId = (Long)unit.getPkValue();
                this.getModel().setValue(UNIT, (Object)unitId, rowIndex);
            }
            LotNumberHelper.lotnumberEnable((IDataModel)this.getModel(), (IFormView)this.getView(), (DynamicObject)materialInfo, (int)rowIndex, (Boolean)Boolean.TRUE);
        }
    }

    private void changeBillnoEvent() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("pageId", this.getView().getPageId());
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("cleanFieldTips", map);
    }

    private void materialcfgChange(Object newValue, int rowIndex) {
        if (newValue != null) {
            DynamicObject m = ((DynamicObject)newValue).getDynamicObject("masterid");
            if (this.getControl(MATERIALID) != null) {
                this.getModel().setValue(MATERIALID, (Object)m, rowIndex);
            } else {
                this.getModel().setValue(MATERIELID, (Object)m, rowIndex);
            }
        } else if (this.getControl(MATERIALID) != null) {
            this.getModel().setValue(MATERIALID, null, rowIndex);
        } else {
            this.getModel().setValue(MATERIELID, null, rowIndex);
        }
    }

    private void qrouteChange(DynamicObject newValue, int rowIndex) {
        if (Objects.nonNull(newValue)) {
            IDataEntityProperty propSrcopentryid;
            IDataModel model = this.getModel();
            DynamicObjectCollection processEntrys = newValue.getDynamicObjectCollection("processentry");
            List processList = processEntrys.stream().filter(o -> {
                Object bo = model.getValue(BIZTYPE);
                if (bo != null && "qcpp-003".equals(((DynamicObject)bo).getString("number"))) {
                    return o.getBoolean("firstcheck");
                }
                return "1013".equals(o.getString("checktype"));
            }).collect(Collectors.toList());
            DynamicObject process = (DynamicObject)processList.get(0);
            this.getModel().setValue("operationno", process.get("operationno"), rowIndex);
            this.getModel().setValue("processseq", process.get("parent"), rowIndex);
            this.getModel().setValue("oproperation", process.get("operation"), rowIndex);
            this.getModel().setValue("oprworkcenter", process.get("workcenter"), rowIndex);
            this.getModel().setValue("productionworkshop", process.get("productionworkshop"), rowIndex);
            this.getModel().setValue("operationdesc", process.get("operationdesc"), rowIndex);
            IDataEntityProperty propProcentryid = this.getModel().getProperty("route_procentryid");
            if (propProcentryid != null) {
                this.getModel().setValue("route_procentryid", process.get("route_procentryid"), rowIndex);
            }
            if ((propSrcopentryid = this.getModel().getProperty("srcopentryid")) != null) {
                this.getModel().setValue("srcopentryid", process.get("srcopentryid"), rowIndex);
            }
        } else {
            IDataEntityProperty propSrcopentryid;
            this.getModel().setValue("processseq", null, rowIndex);
            this.getModel().setValue("operationno", null, rowIndex);
            this.getModel().setValue("oproperation", null, rowIndex);
            this.getModel().setValue("oprworkcenter", null, rowIndex);
            this.getModel().setValue("productionworkshop", null, rowIndex);
            this.getModel().setValue("operationdesc", null, rowIndex);
            IDataEntityProperty propProcentryid = this.getModel().getProperty("route_procentryid");
            if (propProcentryid != null) {
                this.getModel().setValue("route_procentryid", null, rowIndex);
            }
            if ((propSrcopentryid = this.getModel().getProperty("srcopentryid")) != null) {
                this.getModel().setValue("srcopentryid", null, rowIndex);
            }
        }
    }

    private void matChangeDealRoute(Object newMat, int row) {
        IDataModel model = this.getModel();
        BasedataEdit qrControl = (BasedataEdit)this.getView().getControl(QROUTE);
        if (newMat == null || qrControl == null) {
            return;
        }
        Object value = model.getValue(QROUTE, row);
        if (value == null) {
            return;
        }
        DynamicObject mat = (DynamicObject)newMat;
        DynamicObject qroute = (DynamicObject)value;
        String processtype = qroute.getString("processtype");
        if ("A".equals(processtype) && qroute.getDynamicObject("material").getPkValue().toString().equals(mat.getPkValue().toString())) {
            return;
        }
        if ("B".equals(processtype) && this.checkMatByMaterialgroup(mat, qroute.getDynamicObject("materialgroup"))) {
            return;
        }
        if ("C".equals(processtype)) {
            return;
        }
        model.setValue(QROUTE, null, row);
    }

    private boolean checkMatByMaterialgroup(DynamicObject mat, DynamicObject materialControlGroup) {
        DynamicObjectCollection materialmftinfo = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)"mftcontrolentry.materialcontrol.id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)Long.parseLong(mat.getPkValue().toString()))});
        List collect = materialmftinfo.stream().map(info -> info.get("mftcontrolentry.materialcontrol.id").toString()).collect(Collectors.toList());
        return !collect.isEmpty() && collect.contains(materialControlGroup.getPkValue().toString());
    }

    public void setIgnorePro(String propName, ChangeData changeData, Map<String, Integer> mIngoreFields) {
        String baseDateIdPro = propName + "_id";
        if (mIngoreFields.containsKey(propName)) {
            BizChangeWinUtil.setIngoreField((String)propName, (DynamicObject)changeData.getDataEntity(), mIngoreFields);
        } else if (mIngoreFields.containsKey(baseDateIdPro)) {
            BizChangeWinUtil.setIngoreField((String)baseDateIdPro, (DynamicObject)changeData.getDataEntity(), mIngoreFields);
        }
    }

    public Boolean isBotpConvertresultView() {
        String parentEntityId;
        IFormView fv = this.getView();
        Boolean isBotpConvertresultView = Boolean.FALSE;
        IFormView parentFv = fv.getViewNoPlugin(fv.getFormShowParameter().getParentPageId());
        if (parentFv != null && StringUtils.equalsIgnoreCase((CharSequence)(parentEntityId = parentFv.getEntityId()), (CharSequence)"botp_convertresult")) {
            isBotpConvertresultView = Boolean.TRUE;
        }
        return isBotpConvertresultView;
    }

    protected boolean isFromDB(IDataModel model, String entryentityNumber) {
        DynamicObject entryObj;
        DynamicObject dataEntity = model.getDataEntity();
        boolean isObjFromDb = dataEntity.getDataEntityState().getFromDatabase();
        boolean isEntryObjFromDb = true;
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection(entryentityNumber);
        Iterator iterator = entryEntity.iterator();
        while (iterator.hasNext() && (isEntryObjFromDb = (entryObj = (DynamicObject)iterator.next()).getDataEntityState().getFromDatabase())) {
        }
        return isObjFromDb && isEntryObjFromDb;
    }

    protected void initTransacType() {
        IDataModel model = this.getModel();
        DynamicObject org = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)ORG);
        DynamicObject bizType = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)BIZTYPE);
        if (Objects.nonNull(org) && Objects.nonNull(bizType)) {
            Long orgId = org.getLong("id");
            Long bizTypeId = bizType.getLong("id");
            DynamicObject firstTransacType = TransacTypeHelper.getFirstDefaultTransacType((Long)orgId, (Long)bizTypeId);
            model.setValue(TRANSACTYPE, (Object)firstTransacType);
        } else {
            model.setValue(TRANSACTYPE, null);
        }
    }

    protected Set<Integer> buildRowSet(Integer ... rowIndexs) {
        HashSet<Integer> rowIndexSet = new HashSet<Integer>(16);
        for (Integer rowIndex : rowIndexs) {
            rowIndexSet.add(rowIndex);
        }
        return rowIndexSet;
    }
}

