/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.common;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.qmc.qcbd.business.helper.ZJMaterialHelper;

public class InspecListCommon
extends AbstractListPlugin {
    private static final String KEY_BILLLISTAP = "billlistap";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        List<Long> pkVals = this.getSelectPkVal();
        String entityNumber = ((ListView)this.getView()).getBillFormId();
        String errMessage = new ZJMaterialHelper().validZJ(entityNumber, pkVals);
        if (errMessage.length() > 0) {
            this.getView().showMessage(errMessage);
            evt.setCancel(true);
        }
    }

    private List<Long> getSelectPkVal() {
        ArrayList<Long> pkVals = new ArrayList<Long>();
        BillList list = (BillList)this.getControl(KEY_BILLLISTAP);
        ListSelectedRowCollection rows = list.getSelectedRows();
        for (ListSelectedRow row : rows) {
            Long pkVal = (Long)row.getPrimaryKeyValue();
            pkVals.add(pkVal);
        }
        return pkVals;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        HyperLinkClickEvent linkEvtent = e.getHyperLinkClickEvent();
        String fieldName = linkEvtent.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"billno")) {
            List<Long> pkVals = this.getSinglePkVal((BillList)linkEvtent.getSource());
            String entityNumber = ((ListView)this.getView()).getBillFormId();
            String errMessage = new ZJMaterialHelper().validZJ(entityNumber, pkVals);
            if (errMessage.length() > 0) {
                this.getView().showMessage(errMessage);
                e.setCancel(true);
            }
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        List<Long> pkVals = this.getSinglePkVal((BillList)evt.getSource());
        String entityNumber = ((ListView)this.getView()).getBillFormId();
        String errMessage = new ZJMaterialHelper().validZJ(entityNumber, pkVals);
        if (errMessage.length() > 0) {
            this.getView().showMessage(errMessage);
            evt.setCancel(true);
        }
    }

    private List<Long> getSinglePkVal(BillList billList) {
        Long pkId = (Long)billList.getFocusRowPkId();
        ArrayList<Long> pkVals = new ArrayList<Long>();
        pkVals.add(pkId);
        return pkVals;
    }
}

