/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.qmc.qcbd.business.commonmodel.helper.LotNumberHelper;
import kd.qmc.qcbd.business.commonmodel.util.ImportUtil;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCkvalHelper;
import kd.qmc.qcbd.common.util.DataImportUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.UserUtil;

public class InspectionImportCommon
extends AbstractBillPlugIn {
    private static final String ORG = "org";
    private static final String SYSTEM_TYPE = "qmc-qcbd-formplugin";

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        DynamicObject biztype = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"biztype");
        TreeMap<Integer, List<String>> errInfo = new TreeMap<Integer, List<String>>();
        this.validHead(errInfo, biztype);
        this.validMatEntry(e, errInfo, biztype);
    }

    private void validHead(Map<Integer, List<String>> errInfo, DynamicObject biztype) {
        DynamicObject transactypeBizType;
        IDataModel model = this.getModel();
        ArrayList<String> errInfoList = new ArrayList<String>(32);
        Date inspeenddate = (Date)model.getValue("inspeenddate");
        if (inspeenddate != null && !DataImportUtil.dateCheck((Date)inspeenddate)) {
            errInfoList.add(ResManager.loadKDString((String)"\u68c0\u9a8c\u5b8c\u6210\u65e5\u671f\u8d85\u51fa\u8303\u56f4\u3002", (String)"InspectionImportCommon_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        DynamicObject transactype = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"transactype");
        if (!(null == biztype || null == transactype || null != (transactypeBizType = transactype.getDynamicObject("biztypeid")) && Objects.equals(biztype.getPkValue(), transactypeBizType.getPkValue()))) {
            errInfoList.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0e\u8d28\u68c0\u4e8b\u52a1\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"InspectionImportCommon_43", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        if (!errInfoList.isEmpty()) {
            errInfo.put(0, errInfoList);
        }
    }

    private void validMatEntry(ImportDataEventArgs e, Map<Integer, List<String>> errInfo, DynamicObject biztype) {
        IDataModel model = this.getModel();
        HashMap orgUserCacheMap = new HashMap(10);
        HashMap unitCacheMap = new HashMap(10);
        DynamicObjectCollection entryEntity = model.getEntryEntity("matintoentity");
        DynamicObject orgObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)ORG);
        Map matrialCfgInfos = new HashMap(16);
        if (null != orgObj) {
            matrialCfgInfos = ImportUtil.getMatrialCfgInfos((DynamicObjectCollection)entryEntity, (String)"materialcfg", (Long)orgObj.getLong("id"));
        }
        if (entryEntity != null && !entryEntity.isEmpty()) {
            int firstMatIndex = 0;
            int nextMatRowIndex = 0;
            for (DynamicObject matRow : entryEntity) {
                BigDecimal sampRealNum;
                BigDecimal samunqualqty;
                BigDecimal unqualiqty;
                List usrlst;
                List deptids;
                Object io;
                DynamicObject proposer;
                List deptids2;
                DynamicObject inspectionstd;
                DynamicObject sampscheme;
                String lotnumber;
                DynamicObject location;
                DynamicObject warehouse;
                DynamicObject unitfield;
                DynamicObject materialcfg;
                ArrayList<String> matErrList = new ArrayList<String>(32);
                boolean importLegal = true;
                BigDecimal materialqty = matRow.getBigDecimal("materialqty");
                if (materialqty.compareTo(BigDecimal.ZERO) < 0) {
                    matErrList.add(ResManager.loadKDString((String)"\u7269\u6599\u4fe1\u606f\u6570\u91cf\u5e94\u5927\u4e8e0\u3002", (String)"InspectionImportCommon_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    importLegal = false;
                }
                if (!ImportUtil.available((DynamicObject)(materialcfg = matRow.getDynamicObject("materialcfg")))) {
                    matErrList.add(ResManager.loadKDString((String)"\u7269\u6599\u7684\u8d28\u68c0\u4fe1\u606f\u4e0d\u53ef\u7528\u3002", (String)"InspectionImportCommon_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    importLegal = false;
                } else if (!ImportUtil.matCfgCheck((DynamicObject)materialcfg, (DynamicObject)biztype, matrialCfgInfos)) {
                    matErrList.add(ResManager.loadKDString((String)"\u8be5\u7269\u6599\u672a\u914d\u7f6e\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u3002", (String)"InspectionImportCommon_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    importLegal = false;
                } else if (!"C".equals(materialcfg.getString("status"))) {
                    matErrList.add(ResManager.loadKDString((String)"\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u5c1a\u672a\u5ba1\u6838\u3002", (String)"InspectionImportCommon_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    importLegal = false;
                } else {
                    matRow.set("materialid", (Object)materialcfg.getDynamicObject("masterid"));
                }
                DynamicObject materialid = matRow.getDynamicObject("materialid");
                if (materialid == null) {
                    importLegal = false;
                }
                if (!ImportUtil.available((DynamicObject)(unitfield = matRow.getDynamicObject("unitfield")))) {
                    matErrList.add(ResManager.loadKDString((String)"\u5355\u4f4d\u975e\u53ef\u7528", (String)"InspectionImportCommon_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    importLegal = false;
                }
                if (materialid == null && unitfield != null) {
                    matErrList.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\uff0c\u518d\u8f93\u5165\u5355\u4f4d\u3002", (String)"InspectionImportCommon_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    importLegal = false;
                } else if (materialid != null && unitfield != null) {
                    DynamicObject baseunit = materialid.getDynamicObject("baseunit");
                    QFilter qFilter = new QFilter("materialid", "=", materialid.getPkValue());
                    Map measureUnitIds = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (String)"measureunitid", (QFilter[])new QFilter[]{qFilter});
                    List unitIds = measureUnitIds.values().stream().map(o -> o.getDynamicObject("measureunitid").getLong("id")).collect(Collectors.toList());
                    unitIds.add(baseunit.getLong("id"));
                    if (!unitIds.contains(unitfield.getLong("id"))) {
                        matErrList.add(ResManager.loadKDString((String)"\u7269\u6599\u65e0\u6cd5\u9009\u62e9\u8be5\u5355\u4f4d\u3002", (String)"InspectionImportCommon_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        importLegal = false;
                    }
                }
                if (unitfield == null) {
                    importLegal = false;
                }
                if (importLegal) {
                    ImportUtil.countBaseQty((DynamicObject)matRow, (DynamicObject)materialid, (DynamicObject)unitfield, (BigDecimal)materialqty, (String)"baseqty", unitCacheMap);
                }
                if (!ImportUtil.available((DynamicObject)(warehouse = matRow.getDynamicObject("warehouse")))) {
                    matErrList.add(ResManager.loadKDString((String)"\u4ed3\u5e93\u975e\u53ef\u7528", (String)"InspectionImportCommon_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if ((location = matRow.getDynamicObject("location")) != null) {
                    if (!location.getBoolean("enable")) {
                        matErrList.add(ResManager.loadKDString((String)"\u4ed3\u4f4d\u975e\u53ef\u7528", (String)"InspectionImportCommon_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    } else if (warehouse == null) {
                        matErrList.add(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u884c\u7684\u4ed3\u5e93\u3002", (String)"InspectionImportCommon_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    } else if (!ImportUtil.locationCheck((DynamicObject)warehouse, (DynamicObject)location)) {
                        matErrList.add(ResManager.loadKDString((String)"\u4ed3\u5e93\u65e0\u6cd5\u9009\u62e9\u8be5\u4ed3\u4f4d\u3002", (String)"InspectionImportCommon_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    }
                }
                if ((lotnumber = matRow.getString("lotnumber")) != null && !"".equals(lotnumber)) {
                    if (materialid == null) {
                        matErrList.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\uff0c\u518d\u8f93\u5165\u6279\u53f7\u3002", (String)"InspectionImportCommon_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    } else if (!LotNumberHelper.lotnumberCheck((DynamicObject)materialid)) {
                        matErrList.add(ResManager.loadKDString((String)"\u7269\u6599\u672a\u542f\u7528\u6279\u53f7\u3002", (String)"InspectionImportCommon_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    }
                }
                if (!ImportUtil.available((DynamicObject)(sampscheme = matRow.getDynamicObject("sampscheme")))) {
                    matErrList.add(ResManager.loadKDString((String)"\u62bd\u6837\u65b9\u6848\u4e0d\u53ef\u7528\u3002", (String)"InspectionImportCommon_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if (!ImportUtil.available((DynamicObject)(inspectionstd = matRow.getDynamicObject("inspectionstd")))) {
                    matErrList.add(ResManager.loadKDString((String)"\u68c0\u9a8c\u6807\u51c6\u4e0d\u53ef\u7528\u3002", (String)"InspectionImportCommon_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                ImportUtil.orgDealCache((ImportDataEventArgs)e, (int)firstMatIndex, (DynamicObject)matRow, (String)"matintoentity", (String)"supplyorg");
                DynamicObject supplyorg = matRow.getDynamicObject("supplyorg");
                if (!ImportUtil.available((DynamicObject)supplyorg)) {
                    matErrList.add(ResManager.loadKDString((String)"\u7533\u8bf7\u7ec4\u7ec7\u4e0d\u53ef\u7528\u3002", (String)"InspectionImportCommon_16", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                ImportUtil.orgDealCache((ImportDataEventArgs)e, (int)firstMatIndex, (DynamicObject)matRow, (String)"matintoentity", (String)"supplydep");
                DynamicObject supplydep = matRow.getDynamicObject("supplydep");
                if (!ImportUtil.available((DynamicObject)supplydep) || supplydep != null && ImportUtil.unitOrgIsFreeze((Long)Long.parseLong(supplydep.getPkValue().toString()))) {
                    matErrList.add(ResManager.loadKDString((String)"\u7533\u8bf7\u90e8\u95e8\u4e0d\u53ef\u7528\u3002", (String)"InspectionImportCommon_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if (supplyorg != null && supplydep != null && (deptids2 = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)((Long)supplyorg.getPkValue()), (boolean)false)) != null && !deptids2.isEmpty() && !deptids2.contains(supplydep.getPkValue())) {
                    matErrList.add(ResManager.loadKDString((String)"\u7533\u8bf7\u90e8\u95e8\u4e0d\u662f\u7533\u8bf7\u7ec4\u7ec7\u6240\u59d4\u6258\u7684\u884c\u653f\u7ec4\u7ec7\u3002", (String)"InspectionImportCommon_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if (!ImportUtil.available((DynamicObject)(proposer = matRow.getDynamicObject("proposer"))) || proposer != null && proposer.getBoolean("isforbidden")) {
                    matErrList.add(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u975e\u53ef\u7528", (String)"InspectionImportCommon_19", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                ImportUtil.orgDealCache((ImportDataEventArgs)e, (int)firstMatIndex, (DynamicObject)matRow, (String)"matintoentity", (String)"insdepartment");
                DynamicObject insdepartment = matRow.getDynamicObject("insdepartment");
                if (!ImportUtil.available((DynamicObject)insdepartment) || insdepartment != null && ImportUtil.unitOrgIsFreeze((Long)Long.parseLong(insdepartment.getPkValue().toString()))) {
                    matErrList.add(ResManager.loadKDString((String)"\u8d28\u68c0\u90e8\u95e8\u4e0d\u53ef\u7528\u3002", (String)"InspectionImportCommon_20", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if ((io = model.getValue(ORG)) == null && insdepartment != null) {
                    matErrList.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d28\u68c0\u7ec4\u7ec7\uff0c\u518d\u9009\u62e9\u8d28\u68c0\u90e8\u95e8\u3002", (String)"InspectionImportCommon_21", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                } else if (io != null && insdepartment != null && (deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)((Long)((DynamicObject)io).getPkValue()), (boolean)false)) != null && !deptids.isEmpty() && !deptids.contains(insdepartment.getPkValue())) {
                    matErrList.add(ResManager.loadKDString((String)"\u8d28\u68c0\u90e8\u95e8\u4e0d\u662f\u8d28\u68c0\u7ec4\u7ec7\u6240\u59d4\u6258\u7684\u884c\u653f\u7ec4\u7ec7\u3002", (String)"InspectionImportCommon_22", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                DynamicObject subinspector = matRow.getDynamicObject("subinspector");
                if (!ImportUtil.available((DynamicObject)subinspector) || subinspector != null && subinspector.getBoolean("isforbidden")) {
                    matErrList.add(ResManager.loadKDString((String)"\u8d28\u68c0\u5458\u975e\u53ef\u7528", (String)"InspectionImportCommon_23", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if (io == null && subinspector != null) {
                    matErrList.add(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d28\u68c0\u7ec4\u7ec7\uff0c\u518d\u9009\u62e9\u8d28\u68c0\u5458\u3002", (String)"InspectionImportCommon_24", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                } else if (io != null && subinspector != null && !(usrlst = UserUtil.getQualityOrgUserByOrgid((Long)Long.parseLong(((DynamicObject)io).getPkValue().toString()), orgUserCacheMap)).contains(Long.parseLong(subinspector.getPkValue().toString()))) {
                    matErrList.add(ResManager.loadKDString((String)"\u8d28\u68c0\u5458\u4e0d\u5728\u8d28\u68c0\u4e1a\u52a1\u7ec4\u5185\u3002", (String)"InspectionImportCommon_25", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                boolean qtyLegal = true;
                BigDecimal qualiqty = matRow.getBigDecimal("qualiqty");
                if (qualiqty.compareTo(materialqty) > 0) {
                    matErrList.add(ResManager.loadKDString((String)"\u5408\u683c\u6570\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u6570\u91cf\u3002", (String)"InspectionImportCommon_26", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    qtyLegal = false;
                }
                if (qualiqty.compareTo(BigDecimal.ZERO) < 0) {
                    matErrList.add(ResManager.loadKDString((String)"\u5408\u683c\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"InspectionImportCommon_27", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    qtyLegal = false;
                }
                if ((unqualiqty = matRow.getBigDecimal("unqualiqty")).compareTo(materialqty) > 0) {
                    matErrList.add(ResManager.loadKDString((String)"\u4e0d\u5408\u683c\u6570\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u6570\u91cf\u3002", (String)"InspectionImportCommon_28", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    qtyLegal = false;
                }
                if (unqualiqty.compareTo(BigDecimal.ZERO) < 0) {
                    matErrList.add(ResManager.loadKDString((String)"\u4e0d\u5408\u683c\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"InspectionImportCommon_29", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    qtyLegal = false;
                }
                if (materialqty.compareTo(qualiqty.add(unqualiqty)) != 0) {
                    matErrList.add(ResManager.loadKDString((String)"\u5408\u683c\u6570\u4e0e\u4e0d\u5408\u683c\u6570\u603b\u548c\u4e0d\u7b49\u4e8e\u68c0\u9a8c\u6570\u91cf\u3002", (String)"InspectionImportCommon_30", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    qtyLegal = false;
                }
                if (importLegal && qtyLegal) {
                    ImportUtil.countBaseQty((DynamicObject)matRow, (DynamicObject)materialid, (DynamicObject)unitfield, (BigDecimal)qualiqty, (String)"basequaliqty", unitCacheMap);
                    ImportUtil.countBaseQty((DynamicObject)matRow, (DynamicObject)materialid, (DynamicObject)unitfield, (BigDecimal)unqualiqty, (String)"baseunqlyqty", unitCacheMap);
                }
                boolean sampQtyLegal = true;
                BigDecimal sampqualqty = matRow.getBigDecimal("sampqualqty");
                if (sampqualqty.compareTo(BigDecimal.ZERO) < 0) {
                    matErrList.add(ResManager.loadKDString((String)"\u6837\u672c\u5408\u683c\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"InspectionImportCommon_31", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    sampQtyLegal = false;
                }
                if ((samunqualqty = matRow.getBigDecimal("samunqualqty")).compareTo(BigDecimal.ZERO) < 0) {
                    matErrList.add(ResManager.loadKDString((String)"\u6837\u672c\u4e0d\u5408\u683c\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"InspectionImportCommon_32", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    sampQtyLegal = false;
                }
                if (importLegal && sampQtyLegal) {
                    ImportUtil.countBaseQty((DynamicObject)matRow, (DynamicObject)materialid, (DynamicObject)unitfield, (BigDecimal)sampqualqty, (String)"basesampqlyqty", unitCacheMap);
                    ImportUtil.countBaseQty((DynamicObject)matRow, (DynamicObject)materialid, (DynamicObject)unitfield, (BigDecimal)samunqualqty, (String)"basesampuqlyqty", unitCacheMap);
                }
                DynamicObjectCollection sampEntry = matRow.getDynamicObjectCollection("subsampleresentity");
                BigDecimal rinsQty = matRow.getBigDecimal("rinsqty");
                if (rinsQty.compareTo(new BigDecimal(rinsQty.intValue())) > 0) {
                    matErrList.add(ResManager.loadKDString((String)"\u6837\u672c\u6570\u91cf\u5fc5\u987b\u4e3a\u6574\u6570\u3002", (String)"InspectionImportCommon_44", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if (rinsQty.compareTo(sampRealNum = new BigDecimal(sampEntry.size())) < 0) {
                    matErrList.add(ResManager.loadKDString((String)"\u6837\u672c\u6570\u91cf\u5e94\u5927\u4e8e\u7b49\u4e8e\u5b9e\u9645\u6837\u672c\u6570\u91cf\u3002", (String)"InspectionImportCommon_42", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                InspectCkvalHelper.completeData((IFormView)this.getView(), (DynamicObject)matRow, (int)(rinsQty.intValue() - sampRealNum.intValue()));
                DynamicObjectCollection inspsubentity = InspectCkvalHelper.validInspEntry(errInfo, (int)firstMatIndex, (int)nextMatRowIndex, (DynamicObject)matRow, (BigDecimal)rinsQty);
                if (!matErrList.isEmpty()) {
                    int so = firstMatIndex + nextMatRowIndex;
                    List<String> list = errInfo.get(so);
                    if (list == null) {
                        errInfo.put(so, matErrList);
                    } else {
                        list.addAll(matErrList);
                    }
                }
                ++firstMatIndex;
                nextMatRowIndex += Math.max(inspsubentity.size(), sampEntry.size()) - 1;
            }
        }
        for (Map.Entry<Integer, List<String>> err : errInfo.entrySet()) {
            e.setCancelMessages(Integer.valueOf(0), err.getKey(), err.getValue());
            e.setCancel(true);
        }
    }
}

