/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.common;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.common.util.TargetConfUtil;

public class TargetConfFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRYENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        Map targets;
        IFormView view = this.getView();
        long userId = UserServiceHelper.getCurrentUserId();
        String entityId = view.getEntityId();
        if (null != view.getParentView()) {
            entityId = view.getParentView().getEntityId();
        }
        if (CollectionUtils.isEmpty((Map)(targets = TargetConfUtil.getTargetByUser((String)entityId, (Long)userId, (Boolean)true, (IFormView)this.getView())))) {
            return;
        }
        this.refreshTable(targets);
    }

    private void refreshTable(Map<Long, Map<String, Object>> targets) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        TableValueSetter vs = TargetConfFormPlugin.getBillSetter();
        targets.forEach((orgId, targetMap) -> vs.addRow(new Object[]{orgId, targetMap.get("batchpassrate"), targetMap.get("batchunpassrate"), targetMap.get("passrate"), targetMap.get("unpassrate"), targetMap.get("ppmtarget")}));
        if (0 == vs.getCount()) {
            vs.addRow(new Object[]{-1L, 0, 0, 0, 0, 0});
        }
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        this.getView().updateView(ENTRYENTITY);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("chooseorg".equals(propName)) {
            Boolean chooseOrg = (Boolean)e.getChangeSet()[0].getNewValue();
            long userId = UserServiceHelper.getCurrentUserId();
            IFormView parentView = this.getView().getParentView();
            if (Objects.nonNull(parentView)) {
                String entityId = parentView.getEntityId();
                Map targets = TargetConfUtil.getTargetByUser((String)entityId, (Long)userId, (Boolean)chooseOrg, (IFormView)this.getView());
                this.refreshTable(targets);
            }
        }
    }

    public static TableValueSetter getBillSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("org", new Object[0]);
        vs.addField("batchpassrate", new Object[0]);
        vs.addField("batchunpassrate", new Object[0]);
        vs.addField("passrate", new Object[0]);
        vs.addField("unpassrate", new Object[0]);
        vs.addField("ppmtarget", new Object[0]);
        return vs;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
        this.addF7Listener(this, "org");
    }

    public void click(EventObject evt) {
        String retStr = "";
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            IDataModel model = this.getModel();
            retStr = this.saveConfig(model);
        }
        if (retStr.length() > 0) {
            this.getView().showTipNotification(retStr);
            return;
        }
        this.getView().close();
    }

    public String saveConfig(IDataModel model) {
        Boolean chooseorg = (Boolean)model.getValue("chooseorg");
        IFormView parentView = this.getView().getParentView();
        String entityId = null == parentView ? this.getView().getEntityId() : parentView.getEntityId();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        if (chooseorg.booleanValue()) {
            List emptyOrg = entryEntity.stream().filter(x -> null == x.getDynamicObject("org")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(emptyOrg)) {
                return ResManager.loadKDString((String)"\u7ec4\u7ec7\u5217\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TargetConfFormPlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]);
            }
            List orgList = entryEntity.stream().map(x -> x.getDynamicObject("org")).collect(Collectors.toList());
            Map<Object, List<DynamicObject>> orgMap = orgList.stream().collect(Collectors.groupingBy(x -> x.getPkValue()));
            if (orgMap.size() < entryEntity.getRowCount()) {
                return ResManager.loadKDString((String)"\u7ec4\u7ec7\u91cd\u590d\u3002", (String)"TargetConfFormPlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]);
            }
        }
        TargetConfUtil.saveTarget((String)entityId, (DynamicObjectCollection)entryEntity, (Boolean)chooseorg, (IFormView)this.getView());
        return "";
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        String sourceID = event.getProperty().getName();
        long userId = UserServiceHelper.getCurrentUserId();
        if ("org".equals(sourceID) && !PermissionServiceHelper.isAdminUser((long)userId) && !PermissionServiceHelper.isSuperUser((long)userId)) {
            String entityName = "";
            if (null != this.getView().getParentView()) {
                entityName = this.getView().getParentView().getEntityId();
            }
            if (StringUtils.isEmpty((String)entityName)) {
                return;
            }
            String entityTypeId = FormMetadataCache.getFormConfig((String)entityName).getEntityTypeId();
            String appId = this.getView().getFormShowParameter().getAppId();
            HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityTypeId, (String)"47150e89000000ac");
            QFilter qFilter = new QFilter("id", "in", (Object)allPermOrgs.getHasPermOrgs());
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }
}

