/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.common.inspectplan;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.BillTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.BizTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.LotNumberHelper;
import kd.qmc.qcbd.business.commonmodel.helper.control.CommonViewControlHelper;
import kd.qmc.qcbd.common.constant.inspectplan.InspectPlanConst;
import kd.qmc.qcbd.common.util.ChangeDataUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.OrgUnitUtil;

public class InspectPlanCommon
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final String PAGEID = "pageId";
    private static final String CLEANFIELDTIPS = "cleanFieldTips";
    private static final String NEWENTRY = "newentry";
    private static final String BIZTYPECHANGE = "biztypeChange";
    private static String[] arrStr = new String[]{"biztype", "unit", "org", "materialid", "materialcfgid", "locationid", "inspecorg", "qualityorg"};

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("materialentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        this.addF7Listener(this, arrStr);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }

    public void afterCreateNewData(EventObject e) {
        Long orgId;
        List deftoOrgs;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Object org = model.getValue("org");
        if (org != null && !(deftoOrgs = OrgUnitServiceHelper.getAllToOrg((String)"", (String)"06", (Long)(orgId = DynamicObjDataUtil.getDynamicObjectLongData((DynamicObject)((DynamicObject)org), (String)"id")), (boolean)true)).isEmpty()) {
            model.setValue("inspecorg", deftoOrgs.get(0));
        }
        BillTypeHelper.billTypeChange((IFormView)this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("materialentry");
        if (!entrys.isEmpty()) {
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject materialInfo = (DynamicObject)((DynamicObject)entrys.get(i)).get("materialid");
                this.newArrDateEnable(materialInfo, i);
            }
        }
    }

    public void afterCopyData(EventObject e) {
        IDataModel model = this.getModel();
        int size = model.getEntryEntity("materialentry").size();
        for (int i = 0; i < size; ++i) {
            if (null == model.getValue("materialcfgid", i)) {
                model.setValue("materialid", null, i);
                model.setValue("unit", null, i);
                model.setValue("baseunit", null, i);
            }
            model.setValue("scsystem", (Object)"qmc", i);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String sourceID = event.getProperty().getName();
        IDataModel model = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        switch (sourceID) {
            case "biztype": {
                BizTypeHelper.selectBizType((IDataModel)model, (IFormView)this.getView(), (ListShowParameter)showParameter);
                break;
            }
            case "unit": {
                this.filterUnit(event, model, showParameter);
                break;
            }
            case "org": {
                this.applyOrgPerFilter(event);
                this.changeBillnoEvent();
                break;
            }
            case "materialcfgid": {
                this.selectMaterial(model, showParameter, event);
                break;
            }
            case "locationid": {
                int rowIndex = event.getRow();
                this.beforeLocation(event, showParameter, model, rowIndex);
                break;
            }
            case "inspecorg": {
                Object org = this.getModel().getValue("org");
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u7ec4\u7ec7\u3002", (String)"InspectPlanCommon_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    break;
                }
                this.checkF7Inspecorg(event);
                break;
            }
            case "qualityorg": {
                ArrayList<Long> orgIds = new ArrayList<Long>(1);
                orgIds.add(DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"org")));
                CommonViewControlHelper.beforeRelationOrgF7((BeforeF7SelectEvent)event, orgIds);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        block17: for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (!ChangeDataUtil.isRealChanged((ChangeData)changeData)) continue;
            switch (fieldName) {
                case "materialid": {
                    this.getModel().setValue("applyqty", null, rowIndex);
                    this.lotnumberEnable((DynamicObject)newValue, rowIndex);
                    this.newArrDateEnable((DynamicObject)newValue, rowIndex);
                    continue block17;
                }
                case "billno": 
                case "org": {
                    this.changeBillnoEvent();
                    continue block17;
                }
                case "warehouseid": {
                    this.getModel().setValue("locationid", null, rowIndex);
                    continue block17;
                }
                case "materialcfgid": {
                    this.changeMaterialCfg(newValue, rowIndex);
                    continue block17;
                }
                case "biztype": {
                    InspectPlanConst.biztypeChange((Object)oldValue, (AbstractBillPlugIn)this);
                    continue block17;
                }
                case "billtype": {
                    BillTypeHelper.billTypeChange((IFormView)this.getView());
                    this.callBiztypeChange(MessageBoxResult.Yes);
                    continue block17;
                }
            }
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        if (e.getSource() != null) {
            this.lotnumberEnableinit(e);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (BIZTYPECHANGE.equals(e.getCallBackId())) {
            this.callBiztypeChange(e.getResult());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String key;
        super.afterDoOperation(event);
        switch (key = event.getOperateKey()) {
            case "newentry": {
                int count = this.getView().getModel().getEntryRowCount("materialentry");
                this.getView().setEnable(Boolean.FALSE, count - 1, new String[]{"productdate"});
                this.getView().setEnable(Boolean.FALSE, count - 1, new String[]{"arrdate"});
                break;
            }
            case "showinspview": {
                this.showQualPanel();
                break;
            }
        }
    }

    private void changeMaterialCfg(Object newValue, int rowIndex) {
        if (newValue != null) {
            DynamicObject mat = ((DynamicObject)newValue).getDynamicObject("masterid");
            this.getModel().setValue("materialid", (Object)mat, rowIndex);
        } else {
            this.getModel().setValue("materialid", null, rowIndex);
        }
    }

    private void lotnumberEnable(DynamicObject materialInfo, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        LotNumberHelper.lotnumberEnable((IDataModel)model, (IFormView)view, (DynamicObject)materialInfo, (int)rowIndex, (Boolean)Boolean.TRUE);
    }

    private void lotnumberEnableinit(EntryGridBindDataEvent e) {
        IFormView view = this.getView();
        IDataModel md = this.getModel();
        String billStatusStr = DynamicObjDataUtil.getDataModelStringData((IDataModel)md, (String)"billstatus");
        if (StringUtils.equalsIgnoreCase((CharSequence)billStatusStr, (CharSequence)"A")) {
            LotNumberHelper.lotnumberEntryGridBind((IDataModel)md, (IFormView)view, (EntryGridBindDataEvent)e, (String)"materialentry", (String)"materialid");
        }
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.isEmpty()) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            if (null == location) continue;
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    private void beforeLocation(BeforeF7SelectEvent e, ListShowParameter showParameter, IDataModel bill, int rowIndex) {
        DynamicObject warehouse = (DynamicObject)bill.getValue("warehouseid", rowIndex);
        if (null == warehouse) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u884c\u7684\u4ed3\u5e93\u3002", (String)"InspectPlanCommon_2", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
            List<Long> ids = this.getLoactionIds(locationCol);
            QFilter qFilter1 = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setFilter(qFilter1);
        }
    }

    private void selectMaterial(IDataModel model, ListShowParameter showParameter, BeforeF7SelectEvent event) {
        Object bizType = model.getValue("biztype");
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        if (null == bizType) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"InspectPlanCommon_3", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        Long bizTypeId = ((DynamicObject)bizType).getLong("id");
        qFilters.add(new QFilter("entryentity.inspecttype.id", "=", (Object)bizTypeId));
    }

    private void changeBillnoEvent() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put(PAGEID, this.getView().getPageId());
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction(CLEANFIELDTIPS, map);
    }

    private void filterUnit(BeforeF7SelectEvent event, IDataModel model, ListShowParameter showParameter) {
        int rowIndex = event.getRow();
        Object materialObject = model.getValue("materialid", rowIndex);
        if (null == materialObject) {
            this.materialTip(event);
            return;
        }
        DynamicObject material = (DynamicObject)materialObject;
        Object masterMaterial = material.get("masterid");
        if (masterMaterial == null) {
            this.materialTip(event);
        } else {
            DynamicObject baseunit = material.getDynamicObject("baseunit");
            QFilter qFilter = new QFilter("materialid", "=", masterMaterial);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_multimeasureunit", (String)"measureunitid", (QFilter[])new QFilter[]{qFilter});
            List unitIds = dynamicObjects.stream().map(o -> o.getLong("measureunitid")).collect(Collectors.toList());
            if (null != baseunit) {
                unitIds.add(baseunit.getLong("id"));
            }
            qFilter = new QFilter("id", "in", unitIds);
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private void materialTip(BeforeF7SelectEvent event) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"InspectPlanCommon_4", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
        event.setCancel(true);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    private void checkF7Inspecorg(BeforeF7SelectEvent event) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        List deftoOrgs = OrgUnitServiceHelper.getAllToOrg((String)"", (String)"06", (Long)Long.parseLong(org.getPkValue().toString()), (boolean)true);
        if (!deftoOrgs.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", (Object)deftoOrgs);
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void newArrDateEnable(DynamicObject materialInfo, int rowIndex) {
        if (materialInfo == null) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"productdate"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"arrdate"});
            return;
        }
        Object selectMateriaPkId = materialInfo.getPkValue();
        DynamicObject materialInvInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)selectMateriaPkId, (String)"bd_materialinventoryinfo");
        if (null == materialInvInfo) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"productdate"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"arrdate"});
            return;
        }
        boolean enableshelflifemgr = materialInvInfo.getBoolean("enableshelflifemgr");
        if (enableshelflifemgr) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"productdate"});
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"arrdate"});
        }
    }

    private void applyOrgPerFilter(BeforeF7SelectEvent event) {
        long userId = UserServiceHelper.getCurrentUserId();
        String entityName = this.getView().getEntityId();
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgList = OrgUnitUtil.getHasPerOrg((Long)userId, (String)appId, (String)entityName);
        if (null != orgList) {
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            parameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
        }
    }

    private void showQualPanel() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mpdm_qualitypanel");
        HashMap<String, Object> postParam = new HashMap<String, Object>(16);
        String entityId = view.getEntityId();
        postParam.put("call_entitynumber", entityId);
        postParam.put("call_type", "B");
        postParam.put("call_billid", model.getValue("id"));
        postParam.put("entry_field", "materialentry");
        postParam.put("material_field", "materialid");
        postParam.put("unit_field", "unit");
        postParam.put("baseunit_field", "baseunit");
        postParam.put("qty_field", "applyqty");
        String appId = MetadataServiceHelper.getDataEntityType((String)entityId).getAppId();
        postParam.put("inspect_appnumbers", appId);
        postParam.put("send_entitys", entityId);
        showParameter.getCustomParams().put("postParam", postParam);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(showParameter);
    }

    private void callBiztypeChange(MessageBoxResult result) {
        IDataModel model = this.getModel();
        switch (result) {
            case Yes: {
                DynamicObjectCollection matintoentity = model.getEntryEntity("materialentry");
                for (int i = matintoentity.size() - 1; i >= 0; --i) {
                    model.deleteEntryRow("materialentry", i);
                }
                this.getView().invokeOperation(NEWENTRY);
                break;
            }
            case Cancel: {
                model.beginInit();
                model.setValue("biztype", (Object)this.getPageCache().get("biztypetmp"));
                model.endInit();
                model.updateCache();
                this.getView().updateView("biztype");
                break;
            }
        }
    }
}

