/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.datamigrat;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.qmc.qcbd.business.helper.DataMigratHelper;
import kd.qmc.qcbd.common.util.CacheManagerQmcUtil;
import kd.qmc.qcbd.common.util.ChangeDataUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.DynamicObjPropUtil;

public class DataMigratPlugin
extends AbstractFormPlugin {
    private Log log = LogFactory.getLog(DataMigratPlugin.class);
    private static final String CALLBACK_FIELD = "callback_field";
    private static final String FORMID_SELECTFIELD = "botp_selectfield";
    private static final String CUSTPARAM_TREENODES = "treenodes";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String operateKey = op.getOperateKey();
        IDataModel dm = this.getModel();
        if ("autoreflex".equalsIgnoreCase(operateKey)) {
            this.log.info("\u5f00\u59cb\u81ea\u52a8\u6620\u5c04");
            dm.deleteEntryData("entryentity");
            this.buildRowDatas();
            this.log.info("\u7ed3\u675f\u81ea\u52a8\u6620\u5c04");
        } else if ("timeout".equalsIgnoreCase(operateKey)) {
            CacheManagerQmcUtil datarepaireUtil = new CacheManagerQmcUtil("datarepaire");
            datarepaireUtil.put("timeout", "true");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("srcfieldtagname");
        this.addClickListeners(fields.toArray(new String[fields.size()]));
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        ChangeData[] changeDatas;
        String propertyName;
        super.propertyChanged(evt);
        if (evt == null) {
            return;
        }
        super.propertyChanged(evt);
        IDataEntityProperty dataEntityProperty = evt.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return;
        }
        for (ChangeData changeSet : changeDatas = evt.getChangeSet()) {
            if (!ChangeDataUtil.isRealChanged((ChangeData)changeSet)) continue;
            this.propertyChanged(propertyName, changeSet);
        }
    }

    protected void propertyChanged(String propertyName, ChangeData changeSet) {
        switch (propertyName) {
            case "entitynumber": {
                this.buildFieldData();
                break;
            }
            case "srcfieldtagname": {
                this.updateSrcFieldTagName(changeSet);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "srcfieldtagname": {
                this.showSrcFieldTagList();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (actionId.startsWith("callback_field_") && returnData != null) {
            this.callBackFieldProp(actionId, String.valueOf(returnData));
        }
    }

    private void callBackFieldProp(String actionId, String fieldId) {
        IDataModel dm = this.getModel();
        String fieldname = actionId.replace("callback_field_", "");
        String entityNumber = this.getEntityNumber();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        int row = dm.getEntryCurrentRowIndex("entryentity");
        switch (fieldname) {
            case "srcfieldtagname": {
                this.clearFieldProp();
                if (this.buildRowData(mainEntityType, fieldId, row).booleanValue()) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5355\u636e\u4e2d\u6807\u5fd7\u5b57\u6bb5\u3002", (String)"DataMigratPlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void updateSrcFieldTagName(ChangeData changeSet) {
        Object srcfieldtagname = ChangeDataUtil.getNewValue((ChangeData)changeSet);
        if (StringUtils.isBlank((Object)srcfieldtagname)) {
            this.clearFieldProp();
        }
    }

    private void showSrcFieldTagList() {
        String entityNumber = this.getEntityNumber();
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4fee\u590d\u4e3b\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"DataMigratPlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
        }
        this.openBillFieldList("entryentity", entityNumber, "srcfieldtagname");
    }

    private String getEntityNumber() {
        IDataModel dm = this.getModel();
        String entityNumber = "";
        DynamicObject entityNumberObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"entitynumber");
        if (entityNumberObj != null) {
            entityNumber = entityNumberObj.getString("number");
        }
        return entityNumber;
    }

    private void buildFieldData() {
        IDataModel dm = this.getModel();
        dm.deleteEntryData("entryentity");
    }

    private Boolean buildRowData(MainEntityType mainEntityType, String fieldID, int row) {
        Boolean isbuildRowData = Boolean.FALSE;
        IDataModel dm = this.getModel();
        dm.beginInit();
        Map mapEntrys = mainEntityType.getAllEntities();
        for (EntityType entityType : mapEntrys.values()) {
            if (isbuildRowData.booleanValue()) break;
            if (!DynamicObjPropUtil.validProp((EntityType)entityType, (String)fieldID).booleanValue()) continue;
            this.setEntryRowData(entityType, fieldID, row);
            isbuildRowData = Boolean.TRUE;
        }
        dm.endInit();
        dm.updateCache();
        this.updateFieldProp(row);
        return isbuildRowData;
    }

    private void setEntryRowData(EntityType entityType, String fieldID, int row) {
        this.log.info("kd.qmc.qcbd.formplugin.datamigrat.DataMigratPlugin.setEntryRowData start");
        IDataModel dm = this.getModel();
        String tableName = entityType.getAlias();
        DynamicProperty prop = entityType.getProperty(fieldID);
        if (prop == null || StringUtils.isBlank((CharSequence)tableName)) {
            return;
        }
        String groupName = prop.getTableGroup();
        String fieldName = prop.getAlias();
        this.log.info("groupName" + groupName);
        this.log.info("fieldName" + fieldName);
        if (StringUtils.isNotBlank((CharSequence)groupName)) {
            tableName = tableName + "_" + groupName;
            dm.setValue("expfix", (Object)groupName, row);
        }
        String fieldCap = DynamicObjPropUtil.getPropCap((IDataEntityProperty)prop);
        dm.setValue("destable", (Object)tableName, row);
        dm.setValue("desfield", (Object)fieldName, row);
        dm.setValue("srctable", (Object)"", row);
        dm.setValue("srcfield", (Object)fieldName, row);
        dm.setValue("srcfieldtagname", (Object)fieldCap, row);
        dm.setValue("srcfieldtag", (Object)prop.getName(), row);
        IDataEntityType parentProp = null;
        if (prop.getParent() != null) {
            parentProp = prop.getParent().getParent();
        }
        if (parentProp != null) {
            dm.setValue("parentdestable", (Object)parentProp.getAlias(), row);
        }
        if (prop instanceof MuliLangTextProp) {
            dm.setValue("ismutilan", (Object)true, row);
        }
        this.log.info("kd.qmc.qcbd.formplugin.datamigrat.DataMigratPlugin.setEntryRowData end");
    }

    private void openBillFieldList(String entryentity, String entityNumber, String fieldname) {
        int row = this.getModel().getEntryCurrentRowIndex(entryentity);
        MainEntityType srcbillMainType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(srcbillMainType);
        parameter.setIncludePKField(true);
        if (row >= 0) {
            TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
            String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
            this.showBillFieldForm(nodesJson, this.getCallFieldKey(fieldname));
        }
    }

    private void showBillFieldForm(String nodesJson, String custumparam) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        showParameter.getCustomParams().put(CUSTPARAM_TREENODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, custumparam));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private String getCallFieldKey(String fieldname) {
        return "callback_field_" + fieldname;
    }

    private void clearFieldProp() {
        IDataModel dm = this.getModel();
        int row = dm.getEntryCurrentRowIndex("entryentity");
        dm.beginInit();
        dm.setValue("srctable", (Object)"", row);
        dm.setValue("srcfield", (Object)"", row);
        dm.setValue("destable", (Object)"", row);
        dm.setValue("desfield", (Object)"", row);
        dm.setValue("srcfieldtagname", (Object)"", row);
        dm.setValue("srcfieldtag", (Object)"", row);
        dm.endInit();
        dm.updateCache();
        this.updateFieldProp(row);
    }

    private void updateFieldProp(int row) {
        this.getView().updateView("srctable", row);
        this.getView().updateView("srcfield", row);
        this.getView().updateView("destable", row);
        this.getView().updateView("desfield", row);
        this.getView().updateView("srcfieldtagname", row);
        this.getView().updateView("srcfieldtag", row);
    }

    private void buildRowDatas() {
        this.log.info("kd.qmc.qcbd.formplugin.datamigrat.DataMigratPlugin.buildRowDatas start");
        IDataModel dm = this.getModel();
        Object entityNumberObj = dm.getValue("entitynumber");
        if (null == entityNumberObj) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4fee\u590d\u4e3b\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"DataMigratPlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
        }
        String entityNumber = ((DynamicObject)entityNumberObj).getString("number");
        this.log.info("entitynumber:" + entityNumber);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        Map mapEntrys = mainEntityType.getAllEntities();
        this.log.info("mapEntrys.keySet()" + mapEntrys.keySet());
        for (EntityType entityType : mapEntrys.values()) {
            DataEntityPropertyCollection props = entityType.getProperties();
            String tableName = entityType.getAlias();
            if (StringUtils.isBlank((CharSequence)tableName)) continue;
            this.log.info("tableName:" + tableName);
            List colNames = DataMigratHelper.toUpperList((List)DataMigratHelper.getTableCols((String)tableName));
            this.log.info("colNames : " + colNames);
            for (IDataEntityProperty prop : props) {
                String fieldName = entityType.getProperty(prop.getName()).getAlias();
                this.log.info("fieldName" + fieldName);
                this.log.info("colNames.contains(fieldName.toUpperCase())" + colNames.contains(fieldName.toUpperCase()));
                this.log.info("DynamicObjPropUtil.validProp(entityType, prop.getName()) :" + DynamicObjPropUtil.validProp((EntityType)entityType, (String)prop.getName()));
                if (!colNames.contains(fieldName.toUpperCase()) || !DynamicObjPropUtil.validProp((EntityType)entityType, (String)prop.getName()).booleanValue()) continue;
                int newRowIndex = dm.createNewEntryRow("entryentity");
                this.setEntryRowData(entityType, prop.getName(), newRowIndex);
            }
        }
        dm.endInit();
        dm.updateCache();
        this.getView().updateView();
        this.log.info("kd.qmc.qcbd.formplugin.datamigrat.DataMigratPlugin.buildRowDatas end");
    }
}

