/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.inspection;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.inspbill.project.CheckProjectCaleFactory;
import kd.qmc.qcbd.business.inspbill.project.ICheckProjectCaleStrategy;
import kd.qmc.qcbd.common.enums.ErrorTypeEnum;
import kd.qmc.qcbd.common.errorcode.QmcBaseErrorCode;
import kd.qmc.qcbd.common.errorcode.QmcErrorCode;
import kd.qmc.qcbd.common.errorcode.QmcErrorCodeUtils;
import kd.qmc.qcbd.common.model.inspbill.project.CheckProjectCaleModel;
import kd.qmc.qcbd.common.util.BigDecimalUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;
import kd.qmc.qcbd.formplugin.inspection.EntryByTplPlugin;

public class EntryByItemPlugin
extends EntryByTplPlugin {
    private static final String TAKE_SAMPID_MAP = "takeSampIdMap";
    private static final String ROW_INDEX = "rowIndex";
    private static final String TAKE_SAMP = "takesamp";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"samplenum_t"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("samplenum_t".equals(key)) {
            this.showSampChseForm();
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshEntryT(Integer.parseInt(this.getPageCache().get(ROW_INDEX)));
        Boolean pageEnable = this.isPageEnable();
        if (pageEnable.booleanValue()) {
            this.setPageEnable();
        } else {
            this.getView().setEnable(pageEnable, new String[]{"projentity_t", "advconap1"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("measuredval_deter_t".equals(name) || "measuredval_rat_t".equals(name)) {
            this.measureValChange(e);
        } else if ("samplenum_t".equals(name)) {
            this.samplenumChange(e);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "nextitem": {
                this.saveTabV();
                this.refreshEntryT(this.findTabNext("inspsubentity_v"));
                break;
            }
            case "previtem": {
                this.saveTabV();
                this.refreshEntryT(this.findTabPrev("inspsubentity_v"));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "nextitem": 
            case "previtem": {
                this.setPageEnable();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if ("retChooseSamp".equals(actionId) && returnData instanceof Map) {
            this.chooseSampBack((Map)returnData);
        }
    }

    @Override
    protected void saveTabV() {
        IDataModel model = this.getModel();
        String uqUuidT = ((DynamicObject)model.getEntryEntity("projentity_t").get(0)).getString("uquuid_t");
        DynamicObjectCollection sampEntityT = model.getEntryEntity("sampentity_t");
        DynamicObjectCollection subMeasureEntryV = model.getEntryEntity("submeasuredvalentity_v");
        Set colNameMove = subMeasureEntryV.getDynamicObjectType().getProperties().stream().filter(x -> x.getName().endsWith("_v")).map(IMetadata::getName).collect(Collectors.toSet());
        subMeasureEntryV.removeIf(x -> uqUuidT.equals(x.getString("projuuid_v")));
        model.updateEntryCache(subMeasureEntryV);
        for (DynamicObject sampObjT : sampEntityT) {
            Object sampId = sampObjT.get("samplenumid_t");
            if (null == sampId || 0L == (Long)sampId) continue;
            DynamicObject tempObj = subMeasureEntryV.addNew();
            Iterator iterator = colNameMove.iterator();
            block11: while (iterator.hasNext()) {
                String colNameV;
                switch (colNameV = (String)iterator.next()) {
                    case "exmapleid_v": {
                        tempObj.set("exmapleid_v", (Object)sampObjT.getLong("samplenumid_t"));
                        continue block11;
                    }
                    case "projuuid_v": {
                        tempObj.set("projuuid_v", (Object)uqUuidT);
                        continue block11;
                    }
                    case "samp_seq_v": {
                        tempObj.set("samp_seq_v", (Object)sampObjT.getInt("seq"));
                        continue block11;
                    }
                }
                tempObj.set(colNameV, sampObjT.get(colNameV.replace("_v", "_t")));
            }
        }
        model.updateEntryCache(subMeasureEntryV);
        this.getView().updateView("submeasuredvalentity_v");
    }

    private void samplenumChange(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        LinkedList<Integer> deleteRows = new LinkedList<Integer>();
        for (ChangeData changeData : changeSet) {
            if (!StringUtils.isNotEmpty((String)String.valueOf(changeData.getOldValue())) || !StringUtils.isEmpty((String)String.valueOf(changeData.getNewValue()))) continue;
            deleteRows.add(changeData.getRowIndex());
        }
        this.getModel().deleteEntryRows("sampentity_t", deleteRows.stream().mapToInt(i -> i).toArray());
    }

    private void measureValChange(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        CheckProjectCaleFactory ckProjFactory = CheckProjectCaleFactory.getInstance();
        IDataModel model = this.getModel();
        DynamicObject projEntityT = model.getEntryRowEntity("projentity_t", 0);
        String normType = projEntityT.getString("normtype_t");
        String matchFlag = "";
        DynamicObject matchFlagObj = projEntityT.getDynamicObject("matchflag_t");
        if (null != matchFlagObj) {
            matchFlag = matchFlagObj.getString("number");
        }
        ICheckProjectCaleStrategy ckProjStrategy = ckProjFactory.getCkProjectStrategy(matchFlag, normType);
        String specValue = projEntityT.getString("specvalue_t");
        BigDecimal topValue = projEntityT.getBigDecimal("topvalue_t");
        BigDecimal downValue = projEntityT.getBigDecimal("downvalue_t");
        for (ChangeData changeData : changeSet = e.getChangeSet()) {
            if (null == ckProjStrategy) continue;
            int rowIndex = changeData.getRowIndex();
            BigDecimal sampIdNo = BigDecimalUtil.toBigDecimal((Object)model.getValue("samplenumid_t", rowIndex));
            if (0L == sampIdNo.longValue()) {
                QmcErrorCodeUtils.showMessge((IFormView)this.getView(), (QmcErrorCode)QmcBaseErrorCode.getErrorInfo((ErrorTypeEnum)ErrorTypeEnum.Msg_NoSampId));
            }
            String measuredValDeter = String.valueOf(model.getValue("measuredval_deter_t", rowIndex));
            BigDecimal measuredValRat = (BigDecimal)model.getValue("measuredval_rat_t", rowIndex);
            CheckProjectCaleModel paramModel = new CheckProjectCaleModel(normType, matchFlag, specValue, topValue, downValue, measuredValDeter, measuredValRat);
            String measureJudgeRes = ckProjStrategy.judgmentResultMain(paramModel);
            model.setValue("measuredval_judge_t", (Object)measureJudgeRes, rowIndex);
        }
    }

    private void refreshEntryT(int rowIndex) {
        this.refreshProjEntryT(rowIndex);
        this.refreshSampEntryT(rowIndex);
    }

    private void refreshProjEntryT(int rowIndex) {
        IDataModel model = this.getModel();
        List colNames = model.getEntryEntity("projentity_t").getDynamicObjectType().getProperties().stream().filter(x -> x.getName().endsWith("_t")).map(IMetadata::getName).collect(Collectors.toList());
        model.beginInit();
        for (String colNameT : colNames) {
            model.setValue(colNameT, model.getValue(colNameT.replace("_t", "_v"), rowIndex), 0);
        }
        model.endInit();
        this.getView().updateView("projentity_t");
    }

    private void refreshSampEntryT(int rowIndex) {
        Object normType;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection measureEntity = model.getEntryEntity("submeasuredvalentity_v");
        String uqUuidV = ((DynamicObject)model.getEntryEntity("inspsubentity_v").get(rowIndex)).getString("uquuid_v");
        List samps = measureEntity.stream().filter(x -> uqUuidV.equals(x.getString("projuuid_v"))).sorted(Comparator.comparingInt(o -> o.getInt("seq"))).collect(Collectors.toList());
        model.deleteEntryData("sampentity_t");
        Set colNameTSet = this.getModel().getEntryEntity("sampentity_t").getDynamicObjectType().getProperties().stream().filter(x -> x.getName().endsWith("_t")).map(IMetadata::getName).collect(Collectors.toSet());
        colNameTSet.remove("samplenumid_t");
        colNameTSet.remove("samplenum_t");
        Map<Long, String> sampidMap = model.getEntryEntity("subsampleresentity_v").stream().collect(Collectors.toMap(x -> x.getLong("samplenumid_v"), x -> x.getString("samplenum_v")));
        int size = samps.size();
        if (size > 0) {
            int[] rows = model.batchCreateNewEntryRow("sampentity_t", size);
            model.beginInit();
            for (int i = 0; i < size; ++i) {
                int tempIndex = rows[i];
                DynamicObject sampObj = (DynamicObject)samps.get(i);
                long sampId = sampObj.getLong("exmapleid_v");
                model.setValue("samplenumid_t", (Object)sampId, tempIndex);
                model.setValue("samplenum_t", (Object)sampidMap.get(sampId), tempIndex);
                for (String colNameT : colNameTSet) {
                    model.setValue(colNameT, sampObj.get(colNameT.replace("_t", "_v")), tempIndex);
                }
            }
            model.endInit();
            view.updateView("sampentity_t");
        }
        IPageCache pageCache = this.getPageCache();
        String takeSampIdMap = pageCache.get(TAKE_SAMPID_MAP);
        if (!"false".equalsIgnoreCase(pageCache.get(TAKE_SAMP)) && StringUtils.isNotEmpty((String)takeSampIdMap)) {
            JSONObject takMapObj = JSON.parseObject((String)takeSampIdMap);
            List sampIdList = takMapObj.keySet().stream().map(Long::valueOf).collect(Collectors.toList());
            List sampIdChoosed = model.getEntryEntity("sampentity_t").stream().map(x -> x.getLong("samplenumid_t")).collect(Collectors.toList());
            sampIdList.removeAll(sampIdChoosed);
            sampIdList.sort(Comparator.comparingInt(Long::intValue));
            size = sampIdList.size();
            if (size > 0) {
                int[] rows = model.batchCreateNewEntryRow("sampentity_t", size);
                int i = 0;
                model.beginInit();
                for (Long sampIdStr : sampIdList) {
                    int tempIndex = rows[i++];
                    model.setValue("samplenumid_t", (Object)sampIdStr, tempIndex);
                    model.setValue("samplenum_t", takMapObj.get((Object)String.valueOf(sampIdStr)), tempIndex);
                }
                model.endInit();
                view.updateView("sampentity_t");
            }
        }
        if (0 == model.getEntryEntity("sampentity_t").size()) {
            this.createNewEntryRow();
        }
        Boolean isDeterShow = "B".equals(normType = model.getValue("normtype_t", 0)) ? Boolean.TRUE : Boolean.FALSE;
        view.setVisible(isDeterShow, new String[]{"measuredval_deter_t"});
        view.setVisible(Boolean.valueOf(isDeterShow == false), new String[]{"measuredval_rat_t"});
    }

    private void showSampChseForm() {
        IFormView view = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("qcbd_insp_sampchse");
        Set chooseIds = this.getModel().getEntryEntity("sampentity_t").stream().filter(x -> null != x.get("samplenumid_t")).map(x -> x.get("samplenumid_t")).collect(Collectors.toSet());
        Map<Long, String> sampIdMap = this.getModel().getEntryEntity("subsampleresentity_v").stream().collect(Collectors.toMap(x -> x.getLong("samplenumid_v"), x -> x.getString("samplenum_v")));
        showParameter.setCustomParam("sampIdMap", sampIdMap);
        showParameter.setCustomParam("chooseIds", chooseIds);
        IPageCache pageCache = this.getPageCache();
        showParameter.setCustomParam(TAKE_SAMP, (Object)pageCache.get(TAKE_SAMP));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "retChooseSamp"));
        view.showForm(showParameter);
    }

    private void chooseSampBack(Map<String, Object> retMap) {
        IDataModel model = this.getModel();
        String takesamp = String.valueOf(retMap.get(TAKE_SAMP));
        IPageCache pageCache = this.getPageCache();
        pageCache.put(TAKE_SAMP, takesamp);
        Map selectSampMap = (Map)retMap.get("sampIdMap");
        if ("true".equalsIgnoreCase(takesamp)) {
            pageCache.put(TAKE_SAMPID_MAP, JSON.toJSONString((Object)selectSampMap));
        }
        Set retSampIds = selectSampMap.keySet();
        DynamicObjectCollection sampEntryT = model.getEntryEntity("sampentity_t");
        Set chooseIds = sampEntryT.stream().filter(x -> null != x.get("samplenumid_t")).map(x -> x.getLong("samplenumid_t")).collect(Collectors.toSet());
        HashSet addSampIds = new HashSet(retSampIds);
        addSampIds.removeAll(chooseIds);
        chooseIds.removeAll(retSampIds);
        sampEntryT.removeIf(x -> 0L == x.getLong("samplenumid_t") || chooseIds.contains(x.getLong("samplenumid_t")));
        model.updateEntryCache(sampEntryT);
        this.getView().updateView("sampentity_t");
        List sortedIds = addSampIds.stream().sorted().collect(Collectors.toList());
        int size = sortedIds.size();
        if (0 == size) {
            return;
        }
        int[] rows = model.batchCreateNewEntryRow("sampentity_t", size);
        for (int i = 0; i < size; ++i) {
            int rowIndex = rows[i];
            Long sampId = (Long)sortedIds.get(i);
            model.setValue("samplenumid_t", (Object)sampId, rowIndex);
            model.setValue("samplenum_t", selectSampMap.get(sampId), rowIndex);
        }
    }

    private void setPageEnable() {
        IFormView view = this.getView();
        if (((Boolean)view.getFormShowParameter().getCustomParam("isInsp")).booleanValue()) {
            IDataModel model = this.getModel();
            String joinInspectStatus = DynamicObjDataUtil.getDataModelStringData((IDataModel)model, (String)"joininspectstatus_t");
            Boolean unEnable = StringQMCUtil.inside((String)joinInspectStatus, (String[])new String[]{"P", "Y"});
            view.setEnable(Boolean.valueOf(unEnable == false), new String[]{"projentity_t", "advconap1"});
        }
    }

    private void createNewEntryRow() {
        Map<Long, String> sampIdMap = this.getModel().getEntryEntity("subsampleresentity_v").stream().collect(Collectors.toMap(x -> x.getLong("samplenumid_v"), x -> x.getString("samplenum_v")));
        List sortedIds = sampIdMap.keySet().stream().sorted().collect(Collectors.toList());
        int size = sortedIds.size();
        int[] rows = this.getModel().batchCreateNewEntryRow("sampentity_t", size);
        for (int i = 0; i < size; ++i) {
            String sampIdStr = String.valueOf(sortedIds.get(i));
            Long sampId = Long.valueOf(sampIdStr);
            int rowIndex = rows[i];
            this.getModel().setValue("samplenumid_t", (Object)sampId, rowIndex);
            this.getModel().setValue("samplenum_t", (Object)sampIdMap.get(sampId), rowIndex);
        }
    }
}

