/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.inspection;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.inspbill.project.CheckProjectCaleFactory;
import kd.qmc.qcbd.business.inspbill.project.ICheckProjectCaleStrategy;
import kd.qmc.qcbd.common.model.inspbill.project.CheckProjectCaleModel;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;
import kd.qmc.qcbd.formplugin.inspection.EntryByTplPlugin;

public class EntryBySamplePlugin
extends EntryByTplPlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildInspEntryT();
        this.refreshEntryT(Integer.parseInt(this.getPageCache().get("rowIndex")));
        this.getView().setEnable(Boolean.valueOf(this.isPageEnable()), new String[]{"batfill"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        String fieldName = e.getProperty().getName();
        block7: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            switch (fieldName) {
                case "measuredval_rat_t": 
                case "measuredval_deter_t": {
                    this.measureValChange(changeData);
                    continue block7;
                }
            }
        }
    }

    private void measureValChange(ChangeData changeData) {
        ICheckProjectCaleStrategy ckProjStrategy;
        int rowIndex = changeData.getRowIndex();
        if (rowIndex < 0) {
            return;
        }
        IDataModel dm = this.getModel();
        String normType = DynamicObjDataUtil.getDataModelStringData((IDataModel)dm, (String)"normtype_t", (int)rowIndex);
        String matchFlag = "";
        DynamicObject matchFlagObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"matchflag_t", (int)rowIndex);
        if (null != matchFlagObj) {
            matchFlag = matchFlagObj.getString("number");
        }
        if (null == (ckProjStrategy = CheckProjectCaleFactory.getInstance().getCkProjectStrategy(matchFlag, normType))) {
            return;
        }
        String specValue = DynamicObjDataUtil.getDataModelStringData((IDataModel)dm, (String)"specvalue_t", (int)rowIndex);
        BigDecimal topValue = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"topvalue_t", (int)rowIndex);
        BigDecimal downValue = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"downvalue_t", (int)rowIndex);
        String measuredValDeter = DynamicObjDataUtil.getDataModelStringData((IDataModel)dm, (String)"measuredval_deter_t", (int)rowIndex);
        BigDecimal measuredValRat = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"measuredval_rat_t", (int)rowIndex);
        CheckProjectCaleModel paramModel = new CheckProjectCaleModel(normType, matchFlag, specValue, topValue, downValue, measuredValDeter, measuredValRat);
        String measureJudgeRes = ckProjStrategy.judgmentResultMain(paramModel);
        dm.setValue("measuredval_judge_t", (Object)measureJudgeRes, rowIndex);
    }

    private void buildInspEntryT() {
        IDataModel model = this.getModel();
        Set colTset = model.getEntryEntity("inspsubentity_t").getDynamicObjectType().getProperties().stream().filter(x -> x.getName().endsWith("_t")).map(IMetadata::getName).collect(Collectors.toSet());
        DynamicObjectCollection inspSubEntryV = model.getEntryEntity("inspsubentity_v");
        Set colVset = inspSubEntryV.getDynamicObjectType().getProperties().stream().filter(x -> x.getName().endsWith("_v")).map(IMetadata::getName).collect(Collectors.toSet());
        model.deleteEntryData("inspsubentity_t");
        int size = inspSubEntryV.size();
        if (0 == size) {
            return;
        }
        model.batchCreateNewEntryRow("inspsubentity_t", size);
        for (int i = 0; i < size; ++i) {
            DynamicObject inspSubObjV = (DynamicObject)inspSubEntryV.get(i);
            for (String colT : colTset) {
                String colV = colT.replace("_t", "_v");
                if (!colVset.contains(colV)) continue;
                model.setValue(colT, inspSubObjV.get(colV), i);
            }
        }
    }

    private void refreshEntryT(int rowIndex) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject subSampObjV = model.getEntryRowEntity("subsampleresentity_v", rowIndex);
        long sampIdV = subSampObjV.getLong("samplenumid_v");
        Label labsampid = (Label)view.getControl("labsampid");
        labsampid.setText(String.format(ResManager.loadKDString((String)"\u6837\u672c\u7f16\u53f7\uff1a%s", (String)"EntryBySamplePlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), subSampObjV.getString("samplenum_v")));
        Map<String, DynamicObject> sampMap = model.getEntryEntity("submeasuredvalentity_v").stream().filter(x -> sampIdV == x.getLong("exmapleid_v")).collect(Collectors.toMap(x -> x.getString("projuuid_v"), x -> x));
        DynamicObjectCollection inspSubEntryT = model.getEntryEntity("inspsubentity_t");
        int size = inspSubEntryT.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject inspSubObjT = (DynamicObject)inspSubEntryT.get(i);
            String uqUuid = inspSubObjT.getString("uquuid_t");
            if (sampMap.containsKey(uqUuid)) {
                DynamicObject backObjV = sampMap.get(uqUuid);
                inspSubObjT.set("measuredval_deter_t", backObjV.get("measuredval_deter_v"));
                inspSubObjT.set("measuredval_rat_t", backObjV.get("measuredval_rat_v"));
                inspSubObjT.set("measuredval_judge_t", backObjV.get("measuredval_judge_v"));
                inspSubObjT.set("measure_comment_t", backObjV.get("measure_comment_v"));
            } else {
                inspSubObjT.set("measuredval_deter_t", (Object)"");
                inspSubObjT.set("measuredval_rat_t", null);
                inspSubObjT.set("measuredval_judge_t", (Object)"");
                inspSubObjT.set("measure_comment_t", (Object)"");
            }
            String joinInspectStatus = DynamicObjDataUtil.getDataModelStringData((IDataModel)model, (String)"joininspectstatus_t", (int)i);
            Boolean unEnable = StringQMCUtil.inside((String)joinInspectStatus, (String[])new String[]{"P", "Y"}) != false || !"A".equals(this.getView().getParentView().getModel().getValue("billstatus"));
            if (unEnable.booleanValue()) {
                view.setEnable(Boolean.FALSE, i, new String[]{"measuredval_deter_t"});
                view.setEnable(Boolean.FALSE, i, new String[]{"measuredval_rat_t"});
                view.setEnable(Boolean.FALSE, i, new String[]{"measure_comment_t"});
                continue;
            }
            String normType = inspSubObjT.getString("normtype_t");
            Boolean isDeterEnable = "B".equals(normType) ? Boolean.TRUE : Boolean.FALSE;
            view.setEnable(isDeterEnable, i, new String[]{"measuredval_deter_t"});
            view.setEnable(Boolean.valueOf(isDeterEnable == false), i, new String[]{"measuredval_rat_t"});
        }
        model.updateEntryCache(inspSubEntryT);
        view.updateView("inspsubentity_t");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "nextsamp": {
                this.saveTabV();
                this.refreshEntryT(this.findTabNext("subsampleresentity_v"));
                break;
            }
            case "prevsamp": {
                this.saveTabV();
                this.refreshEntryT(this.findTabPrev("subsampleresentity_v"));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("batchfillentry".equals(operateKey)) {
            IDataModel model = this.getModel();
            DynamicObjectCollection inspSubEntry = model.getEntryEntity("inspsubentity_t");
            boolean findErrdata = inspSubEntry.stream().anyMatch(x -> "B".equals(x.getString("normtype_t")) && null != x.getBigDecimal("measuredval_rat_t") || "A".equals(x.getString("normtype_t")) && StringUtils.isNotEmpty((String)x.getString("measuredval_deter_t")));
            if (!findErrdata) {
                return;
            }
            int size = inspSubEntry.size();
            for (int i = 0; i < size; ++i) {
                String normType = ((DynamicObject)inspSubEntry.get(i)).getString("normtype_t");
                if ("B".equals(normType)) {
                    model.setValue("measuredval_rat_t", null, i);
                    continue;
                }
                model.setValue("measuredval_deter_t", (Object)"", i);
            }
        }
    }

    @Override
    protected void saveTabV() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
        Long sampIdLong = DynamicObjDataUtil.getDataModelLongData((IDataModel)model, (String)"samplenumid_v", (int)rowIndex);
        DynamicObjectCollection subMeasureV = model.getEntryEntity("submeasuredvalentity_v");
        Map<String, DynamicObject> subMeasureMap = subMeasureV.stream().filter(x -> sampIdLong.equals(x.getLong("exmapleid_v"))).collect(Collectors.toMap(x -> x.getString("projuuid_v"), x -> x));
        DynamicObjectCollection inspSubEntryV = model.getEntryEntity("inspsubentity_v");
        DynamicObjectCollection inspSubEntryT = model.getEntryEntity("inspsubentity_t");
        for (DynamicObject inspSubObj : inspSubEntryT) {
            String uquuidT = inspSubObj.getString("uquuid_t");
            DynamicObject measureObj = null;
            if (subMeasureMap.containsKey(uquuidT)) {
                measureObj = subMeasureMap.get(uquuidT);
            } else {
                BigDecimal ratVal = inspSubObj.getBigDecimal("measuredval_rat_t");
                if (ratVal != null || StringUtils.isNotEmpty((String)inspSubObj.getString("measuredval_deter_t")) || StringUtils.isNotEmpty((String)inspSubObj.getString("measure_comment_t"))) {
                    measureObj = subMeasureV.addNew();
                    measureObj.set("exmapleid_v", (Object)sampIdLong);
                    measureObj.set("projuuid_v", (Object)uquuidT);
                }
            }
            if (null == measureObj) continue;
            measureObj.set("measuredval_deter_v", inspSubObj.get("measuredval_deter_t"));
            measureObj.set("measuredval_rat_v", inspSubObj.get("measuredval_rat_t"));
            measureObj.set("measuredval_judge_v", inspSubObj.get("measuredval_judge_t"));
            measureObj.set("measure_comment_v", inspSubObj.get("measure_comment_t"));
        }
        model.updateEntryCache(inspSubEntryV);
        view.updateView("inspsubentity_v");
        model.updateEntryCache(subMeasureV);
        view.updateView("submeasuredvalentity_v");
    }
}

