/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.inspection;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.common.util.BigDecimalUtil;

public abstract class EntryByTplPlugin
extends AbstractFormPlugin {
    private static final String ROW_INDEX = "rowIndex";

    protected abstract void saveTabV();

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.takeTabData();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    private void takeTabData() {
        IFormView view = this.getView();
        Map params = view.getFormShowParameter().getCustomParams();
        this.getPageCache().put(ROW_INDEX, String.valueOf(params.get(ROW_INDEX)));
        this.takTabData("subsampleresentity", params);
        this.takTabData("inspsubentity", params);
        this.takTabData("submeasuredvalentity", params);
    }

    private void takTabData(String tabName, Map<String, Object> params) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        JSONArray tabArray = (JSONArray)params.get(tabName);
        if (tabArray.isEmpty()) {
            return;
        }
        String tabNameV = tabName + "_v";
        Set<String> filterKeys = this.filterKeys(tabArray, tabNameV);
        for (Object tabObj : tabArray) {
            int rowIndex = model.createNewEntryRow(tabNameV);
            JSONObject tabRow = (JSONObject)tabObj;
            for (String key : filterKeys) {
                String keyV = key + "_v";
                Object val = tabRow.get((Object)key);
                if ("measuredval_rat_v".equals(keyV)) {
                    Object object = val = "".equals(val) ? null : BigDecimalUtil.toBigDecimal((Object)val);
                }
                if (val instanceof JSONObject) {
                    model.setValue(keyV, ((JSONObject)val).get((Object)"id"), rowIndex);
                    continue;
                }
                model.setValue(keyV, val, rowIndex);
            }
            view.updateView(tabNameV);
        }
    }

    private Set<String> filterKeys(JSONArray tabArray, String tabNameV) {
        Set sourceKeys = ((JSONObject)tabArray.get(0)).keySet();
        DataEntityPropertyCollection tabVProps = this.getModel().getEntryEntity(tabNameV).getDynamicObjectType().getProperties();
        Set tabVPropNames = tabVProps.stream().map(IMetadata::getName).collect(Collectors.toSet());
        HashSet<String> filterKeys = new HashSet<String>(16);
        for (String key : sourceKeys) {
            if (!tabVPropNames.contains(key + "_v")) continue;
            filterKeys.add(key);
        }
        return filterKeys;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
            this.saveTabV();
            IDataModel model = this.getModel();
            DynamicObjectCollection measureEntryV = model.getEntryEntity("submeasuredvalentity_v");
            Map<Long, List<DynamicObject>> sampGroupMeasureV = measureEntryV.stream().collect(Collectors.groupingBy(x -> x.getLong("exmapleid_v")));
            Map<String, List<DynamicObject>> projGroupMeasureV = measureEntryV.stream().collect(Collectors.groupingBy(x -> x.getString("projuuid_v")));
            DynamicObjectCollection subSampV = model.getEntryEntity("subsampleresentity_v");
            DynamicObjectCollection inspSubEntryV = model.getEntryEntity("inspsubentity_v");
            int inspSize = inspSubEntryV.size();
            for (DynamicObject subSampObj : subSampV) {
                long sampleNumId = subSampObj.getLong("samplenumid_v");
                List<DynamicObject> sampMeasureList = sampGroupMeasureV.get(sampleNumId);
                long sampCount = CollectionUtils.isEmpty(sampMeasureList) ? 0L : sampMeasureList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getString("measuredval_deter_v")) || null != x.getBigDecimal("measuredval_rat_v")).count();
                subSampObj.set("sampckval_v", (Object)sampCount);
                if (0L == sampCount) {
                    subSampObj.set("sampleres_v", (Object)"");
                    continue;
                }
                if (sampMeasureList.stream().anyMatch(x -> "N".equals(x.getString("measuredval_judge_v")))) {
                    subSampObj.set("sampleres_v", (Object)"N");
                    continue;
                }
                if (inspSize == sampMeasureList.size() && sampMeasureList.stream().allMatch(x -> "Y".equals(x.getString("measuredval_judge_v")))) {
                    subSampObj.set("sampleres_v", (Object)"Y");
                    continue;
                }
                subSampObj.set("sampleres_v", (Object)"");
            }
            for (DynamicObject inspSubObj : inspSubEntryV) {
                String uqUuid = inspSubObj.getString("uquuid_v");
                List<DynamicObject> projMeasureList = projGroupMeasureV.get(uqUuid);
                long passCnt = CollectionUtils.isEmpty(projMeasureList) ? 0L : projMeasureList.stream().filter(x -> "Y".equals(x.getString("measuredval_judge_v"))).count();
                inspSubObj.set("projqualifiyqty_v", (Object)passCnt);
                long noPassCnt = CollectionUtils.isEmpty(projMeasureList) ? 0L : projMeasureList.stream().filter(x -> "N".equals(x.getString("measuredval_judge_v"))).count();
                inspSubObj.set("projunqualifiyqty_v", (Object)noPassCnt);
                long chooseSampQty = CollectionUtils.isEmpty(projMeasureList) ? 0L : (long)projMeasureList.size();
                inspSubObj.set("choosesampqty_v", (Object)chooseSampQty);
                long inspProjCnt = CollectionUtils.isEmpty(projMeasureList) ? 0L : projMeasureList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getString("measuredval_deter_v")) || null != x.getBigDecimal("measuredval_rat_v")).count();
                inspSubObj.set("projckval_v", (Object)inspProjCnt);
            }
            model.updateEntryCache(subSampV);
            model.updateEntryCache(inspSubEntryV);
            this.backTabData();
            this.getView().close();
        }
    }

    private void backTabData() {
        IDataModel model = this.getModel();
        HashMap<String, DynamicObjectCollection> backData = new HashMap<String, DynamicObjectCollection>(16);
        backData.put("subsampleresentity_v", model.getEntryEntity("subsampleresentity_v"));
        backData.put("inspsubentity_v", model.getEntryEntity("inspsubentity_v"));
        backData.put("submeasuredvalentity_v", model.getEntryEntity("submeasuredvalentity_v"));
        this.getView().returnDataToParent(backData);
    }

    protected int findTabNext(String tabNameV) {
        int rowCount;
        IDataModel model = this.getModel();
        int rowIndex = Integer.parseInt(this.getPageCache().get(ROW_INDEX));
        rowIndex = rowIndex == (rowCount = model.getEntryRowCount(tabNameV)) - 1 ? 0 : ++rowIndex;
        this.getPageCache().put(ROW_INDEX, String.valueOf(rowIndex));
        return rowIndex;
    }

    protected int findTabPrev(String tabNameV) {
        IDataModel model = this.getModel();
        int rowIndex = Integer.parseInt(this.getPageCache().get(ROW_INDEX));
        int rowCount = model.getEntryRowCount(tabNameV);
        rowIndex = 0 == rowIndex ? rowCount - 1 : --rowIndex;
        this.getPageCache().put(ROW_INDEX, String.valueOf(rowIndex));
        return rowIndex;
    }

    protected boolean isPageEnable() {
        IFormView view = this.getView();
        Map params = view.getFormShowParameter().getCustomParams();
        Object enable = params.get("enable");
        if (enable instanceof Boolean) {
            return (Boolean)enable;
        }
        return false;
    }
}

