/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.inspection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.BizTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.InspectStdHelper;
import kd.qmc.qcbd.business.commonmodel.helper.LotNumberHelper;
import kd.qmc.qcbd.business.commonmodel.helper.basedata.TransacTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.control.CommonViewControlHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectDealArgs;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProDimenHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProGlobalCache;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProMatchHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.InspproVoluationKeyModel;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.factory.InspectProVoluationFactory;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.impl.InspectProVoluationInspect;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillSampleHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCkvalHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCommonHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.JoinInspectHelper;
import kd.qmc.qcbd.common.enums.ErrorTypeEnum;
import kd.qmc.qcbd.common.enums.ShowTypeEnum;
import kd.qmc.qcbd.common.errorcode.QmcBaseErrorCode;
import kd.qmc.qcbd.common.errorcode.QmcErrorCode;
import kd.qmc.qcbd.common.errorcode.QmcErrorCodeUtils;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleResModel;
import kd.qmc.qcbd.common.model.joininspect.JoinInspectEntityModel;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;
import kd.qmc.qcbd.common.util.BigDecimalUtil;
import kd.qmc.qcbd.common.util.BizChangeWinUtil;
import kd.qmc.qcbd.common.util.ControlUtil;
import kd.qmc.qcbd.common.util.DataModelUtil;
import kd.qmc.qcbd.common.util.DeptSetUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.DynamicObjPropUtil;
import kd.qmc.qcbd.common.util.MainEntityTypeUtil;
import kd.qmc.qcbd.common.util.PageCacheQmcUtil;
import kd.qmc.qcbd.common.util.ParameterUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;
import kd.qmc.qcbd.common.util.UserUtil;
import kd.qmc.qcbd.formplugin.common.InSpecBillCommon;

public class InspectBillPlugin
extends InSpecBillCommon
implements CellClickListener,
BeforeF7SelectListener,
AfterF7SelectListener,
RowClickEventListener,
EntryGridBindDataListener {
    private static final Log logger = LogFactory.getLog(InspectBillPlugin.class);
    private static final String CACHE_OLDROW = "cache_oldrow";
    private Map<String, Integer> mIngoreEntryFields = new HashMap<String, Integer>(20);

    public void initialize() {
        super.initialize();
        EntryGrid matEntryGrid = (EntryGrid)this.getView().getControl("matintoentity");
        if (matEntryGrid != null) {
            matEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit projsamp;
        BasedataEdit insdepartment;
        BasedataEdit matchflag;
        EntryGrid entryGrid;
        BasedataEdit location;
        BasedataEdit subuser;
        BasedataEdit unit;
        BasedataEdit materialcfg;
        super.registerListener(e);
        BasedataEdit checkitems = (BasedataEdit)this.getView().getControl("inspectionitem");
        if (checkitems != null) {
            checkitems.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            checkitems.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if ((materialcfg = (BasedataEdit)this.getView().getControl("materialcfg")) != null) {
            materialcfg.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if ((unit = (BasedataEdit)this.getView().getControl("unitfield")) != null) {
            unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((subuser = (BasedataEdit)this.getView().getControl("subinspector")) != null) {
            subuser.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((location = (BasedataEdit)this.getView().getControl("location")) != null) {
            location.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryGrid = (EntryGrid)this.getView().getControl("matintoentity")) != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        Tab tab = (Tab)this.getView().getControl("tabap");
        if (tab != null) {
            tab.addItemClickListener((ItemClickListener)this);
        }
        if ((matchflag = (BasedataEdit)this.getView().getControl("matchflag")) != null) {
            matchflag.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((insdepartment = (BasedataEdit)this.getView().getControl("insdepartment")) != null) {
            insdepartment.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((projsamp = (BasedataEdit)this.getView().getControl("projsamp")) != null) {
            projsamp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        InspectCkvalHelper.addCellClick((String)"inspsubentity", (IFormView)this.getView(), (CellClickListener)this);
        InspectCkvalHelper.addCellClick((String)"subsampleresentity", (IFormView)this.getView(), (CellClickListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid source = (EntryGrid)evt.getSource();
        if (source == null) {
            return;
        }
        String entryKey = source.getEntryKey();
        int row = evt.getRow();
        if (row < 0) {
            return;
        }
        String rowStr = String.valueOf(row);
        IPageCache pc = this.getPageCache();
        String cacheRowKey = StringQMCUtil.getCaheKey((String[])new String[]{CACHE_OLDROW, entryKey});
        String oldRow = this.getPageCache().get(cacheRowKey);
        switch (entryKey) {
            case "matintoentity": {
                if (0 == source.getSelectRows().length) {
                    this.selectFirstMatRow(0);
                }
                if (!StringUtils.isBlank((CharSequence)oldRow) && (StringUtils.equalsIgnoreCase((CharSequence)oldRow, (CharSequence)rowStr) || row < 0)) break;
                this.setTagValue(row);
                break;
            }
        }
        pc.put(cacheRowKey, rowStr);
    }

    public void cellClick(CellClickEvent evt) {
        String fieldKey;
        EntryGrid source = (EntryGrid)evt.getSource();
        if (source == null) {
            return;
        }
        switch (fieldKey = evt.getFieldKey()) {
            case "sampckvalstr": 
            case "projckvalstr": {
                InspectCkvalHelper.showBillFieldForm((String)fieldKey, (IDataModel)this.getModel(), (IFormView)this.getView(), (IFormPlugin)this, (String)"backTabData", (Boolean)Boolean.TRUE);
                break;
            }
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        IDataModel model = this.getModel();
        switch (evt.getItemKey()) {
            case "bar_audit": {
                model.forceClearNoDataRow();
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"showtypeview", null, (boolean)true);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        BizTypeHelper.qrouteDeal((IFormView)this.getView());
        this.transacTypeDeal();
        this.computeSampQtyAfterDraw();
        this.selectFirstMatRow(0);
        boolean isFromDb = this.isFromDB(this.getModel(), "matintoentity");
        if (isFromDb && !this.isBotpConvertresultView().booleanValue()) {
            model.setDataChanged(false);
        }
        this.getPageCache().remove("cache_oldrow_matintoentity_");
        if (!model.getEntryEntity("matintoentity").isEmpty()) {
            InspectCkvalHelper.refreshCkValStr((IDataModel)model, (IFormView)this.getView());
        }
        this.setJoinInspectStdEnable(model);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "draw": {
                this.drawBeforeDoOpr(args);
                break;
            }
            case "queryjoininspect": {
                this.queryJoinInspect();
                break;
            }
            case "selectjoininspect": {
                this.selectJoinInspect();
                break;
            }
            case "previousentry": {
                ControlUtil.preEntryBeforeDoOpr((BeforeDoOperationEventArgs)args, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)"matintoentity");
                break;
            }
            case "nextentry": {
                ControlUtil.nextEntryBeforeDoOpr((BeforeDoOperationEventArgs)args, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)"matintoentity");
                break;
            }
            case "createsamp": {
                InspectCkvalHelper.addEntryRow((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "deleteentry-inspitem": {
                InspectCkvalHelper.deleteSubMeasures((int)this.getModel().getEntryCurrentRowIndex("inspsubentity"), (IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "selectinspectpro": {
                EntryGrid entryGrid = (EntryGrid)this.getControl("matintoentity");
                int[] selectRows = entryGrid.getSelectRows();
                InspectDealArgs inspectDealArgs = this.buildInspectDealArgs(selectRows);
                InspectProMatchHelper.selectInspectPro((IFormView)this.getView(), (IDataModel)this.getModel(), (AbstractFormPlugin)this, (int[])selectRows, (InspectDealArgs)inspectDealArgs);
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String oprKey;
        super.afterDoOperation(args);
        switch (oprKey = args.getOperateKey()) {
            case "newentry": {
                this.newEntryAfterOpr();
                break;
            }
            case "deleteentry": {
                this.clearCacheOldRow();
                this.clickTabSample();
                break;
            }
            case "previousentry": 
            case "nextentry": {
                InspectCkvalHelper.clickMaterialRow((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "newentry-inspitem": {
                InspectBillHelper.addNewItemEntry((IFormView)this.getView());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"selectJoinActionId", (CharSequence)actionId)) {
            this.selectJoinInspectCloseBack(closedCallBackEvent);
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String status = DynamicObjDataUtil.getDataModelStringData((IDataModel)model, (String)"billstatus");
        switch (actionId) {
            case "backTabData": {
                this.refreshCkVal(closedCallBackEvent, model, view, status);
                break;
            }
            case "inspectpro": {
                EntryGrid entryGrid = (EntryGrid)this.getControl("matintoentity");
                int[] selectRows = entryGrid.getSelectRows();
                InspectDealArgs args = this.buildInspectDealArgs(selectRows);
                InspectProMatchHelper.updateInspectPro((ClosedCallBackEvent)closedCallBackEvent, (int[])selectRows, (InspectDealArgs)args);
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object source = e.getSource();
        if (source instanceof FieldEdit) {
            FieldEdit fieldEdit = (FieldEdit)source;
            String fieldKey = fieldEdit.getFieldKey();
            int rowIndex = e.getRowIndex();
            switch (fieldKey) {
                case "materialqty": {
                    boolean permit = ControlUtil.dataChangePermit((IDataModel)model, (IFormView)view, (Object)fieldEdit, (int)rowIndex);
                    e.setCancel(!permit);
                    break;
                }
                case "qualiqty": 
                case "unqualiqty": {
                    this.qualifyAndUnqualifyCheck(e, fieldEdit, rowIndex);
                    break;
                }
                case "topvalue": {
                    BigDecimal downValue = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)this.getModel(), (String)"downvalue", (int)rowIndex);
                    BigDecimal oldValue = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)this.getModel(), (String)"topvalue", (int)rowIndex);
                    DynamicObject matchflagTop = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"matchflag", (int)rowIndex);
                    InspectStdHelper.topValueChange((IDataModel)model, (IFormView)view, (BeforeFieldPostBackEvent)e, (DynamicObject)matchflagTop, (BigDecimal)downValue, (BigDecimal)oldValue);
                    break;
                }
                case "downvalue": {
                    BigDecimal topValue = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)this.getModel(), (String)"topvalue", (int)rowIndex);
                    BigDecimal oldValue = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)this.getModel(), (String)"downvalue", (int)rowIndex);
                    DynamicObject matchflagDown = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"matchflag", (int)rowIndex);
                    InspectStdHelper.downValueChange((IDataModel)model, (IFormView)view, (BeforeFieldPostBackEvent)e, (DynamicObject)matchflagDown, (BigDecimal)topValue, (BigDecimal)oldValue);
                    break;
                }
                case "specvalue": {
                    InspectStdHelper.validSpecValue((IDataModel)model, (IFormView)view, (BeforeFieldPostBackEvent)e, (String)"specvalue");
                    break;
                }
                case "rinsqtyvalue": {
                    InspectCkvalHelper.modifyRinsQty((BeforeFieldPostBackEvent)e, (IDataModel)model, (IFormView)view);
                    break;
                }
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        InspectProGlobalCache inspectProGlobalCache = new InspectProGlobalCache();
        block49: for (ChangeData changeData : changeSet) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (InspectProDimenHelper.getBillFieldByType((String)this.getModel().getDataEntityType().getName(), (DynamicObject)this.getModel().getDataEntity().getDynamicObject("transactype")).contains(fieldName) && !StringUtils.equals((CharSequence)"biztype", (CharSequence)fieldName)) {
                this.matchInspectPro(this.buildRowSet(rowIndex), inspectProGlobalCache, new InspectDealArgs());
            }
            this.dealBizChange(changeData, fieldName);
            switch (fieldName) {
                case "materialid": {
                    this.materialChange(changeData, oldValue, newValue, rowIndex);
                    continue block49;
                }
                case "biztype": {
                    BizTypeHelper.biztypeChange((Object)oldValue, (AbstractBillPlugIn)this);
                    continue block49;
                }
                case "materialqty": {
                    this.updateMaterialQty(changeData);
                    continue block49;
                }
                case "qualiqty": 
                case "unqualiqty": {
                    this.updateJudQty(changeData, fieldName);
                    continue block49;
                }
                case "sampscheme": {
                    this.updateSampScheme(changeData);
                    continue block49;
                }
                case "inspectionstd": {
                    this.inspectionStdPropChange(changeData);
                    continue block49;
                }
                case "unitfield": {
                    this.updateUnitfield(changeData);
                    continue block49;
                }
                case "rinsqtyvalue": {
                    this.updateRinsQtyValue(changeData);
                    continue block49;
                }
                case "showtypeview": {
                    this.updateShowType(changeData);
                    continue block49;
                }
                case "rinsqty": {
                    this.updateRinsQty(changeData);
                    continue block49;
                }
                case "sampleres": {
                    InspectCkvalHelper.sampCkResChange((IDataModel)this.getModel(), (IFormView)this.getView());
                    continue block49;
                }
                case "projqualifiyqty": 
                case "projunqualifiyqty": {
                    InspectCkvalHelper.projqulifyChange((IDataModel)this.getModel(), (IFormView)this.getView(), (int)changeData.getRowIndex());
                    continue block49;
                }
                case "sampqualqty": 
                case "samunqualqty": {
                    InspectCkvalHelper.sampQualQtyChange((IDataModel)this.getModel(), (IFormView)this.getView(), (int)changeData.getRowIndex());
                    continue block49;
                }
                case "projsamp": {
                    InspectCkvalHelper.updateProjSamp((ChangeData)changeData, (IDataModel)this.getModel(), (IFormView)this.getView(), (Boolean)Boolean.TRUE);
                    continue block49;
                }
                case "projsampqty": {
                    InspectCkvalHelper.updateProjSampQty((ChangeData)changeData, (IDataModel)this.getModel(), (IFormView)this.getView(), (Boolean)Boolean.TRUE);
                    continue block49;
                }
                case "specvalue": {
                    InspectStdHelper.dealSpecValue((IDataModel)this.getModel(), (IFormView)this.getView(), (Object)newValue, (String)"specvalue", (int)rowIndex);
                    InspectCkvalHelper.deleteSubMeasures((int)changeData.getRowIndex(), (IDataModel)this.getModel(), (IFormView)this.getView());
                    continue block49;
                }
                case "inspectionitem": 
                case "normtype": 
                case "matchflag": 
                case "topvalue": 
                case "downvalue": {
                    InspectCkvalHelper.deleteSubMeasures((int)changeData.getRowIndex(), (IDataModel)this.getModel(), (IFormView)this.getView());
                    continue block49;
                }
                case "transactype": {
                    this.transacTypeChange(changeData);
                    continue block49;
                }
                case "supplyorg": {
                    DeptSetUtil.changeBizOrg((IDataModel)this.getModel(), (Object)newValue, (String)"supplydep", (int)rowIndex);
                    continue block49;
                }
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        String key = e.getProperty().getName();
        String errStr = this.validBeforeF7Select(e);
        if (errStr.length() > 0) {
            this.getView().showTipNotification(errStr);
            e.setCancel(true);
        }
        int rowIndex = e.getRow();
        DynamicObject material = (DynamicObject)model.getValue("materialid", rowIndex);
        switch (key) {
            case "unitfield": {
                ControlUtil.unitCheck((BeforeF7SelectEvent)e, (IFormView)this.getView(), (DynamicObject)material);
                break;
            }
            case "subinspector": {
                QFilter qFilterx = UserUtil.getQualityOrgUserByOrgid((Long)((Long)org.getPkValue()));
                e.addCustomQFilter(qFilterx);
                break;
            }
            case "matchflag": {
                InspectStdHelper.setFilterMatchflag((BeforeF7SelectEvent)e, (IDataModel)model, (String)"inspsubentity", (String)"normtype");
                break;
            }
            case "inspectionitem": {
                this.getPageCache().put("inspRowIndex", String.valueOf(this.getModel().getEntryCurrentRowIndex("inspsubentity")));
                break;
            }
            case "insdepartment": {
                ArrayList<Long> orgIds = new ArrayList<Long>(1);
                orgIds.add(DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"org")));
                CommonViewControlHelper.beforeRelationOrgF7((BeforeF7SelectEvent)e, orgIds);
                break;
            }
        }
        PageCacheQmcUtil.clearPageCacheContainKey((IPageCache)this.getPageCache(), (String)"errormessage");
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        ControlUtil.setAfterF7InputPk((AfterF7SelectEvent)e);
        this.inspItemAfterF7(e);
    }

    public void afterCopyData(EventObject e) {
        IDataModel model = this.getModel();
        int size = model.getEntryEntity("matintoentity").size();
        for (int i = 0; i < size; ++i) {
            if (null == model.getValue("materialcfg", i)) {
                model.setValue("materialid", null, i);
                model.setValue("unitfield", null, i);
                model.setValue("baseunit", null, i);
            }
            DataModelUtil.deleteSubEntry((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"matintoentity", (String)"subsampleresentity", (int)i);
            DataModelUtil.deleteSubEntry((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"matintoentity", (String)"submeasuredvalentity", (int)i);
            model.setValue("scsystem", (Object)"qmc", i);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        IDataModel md = this.getModel();
        String billStatusStr = DynamicObjDataUtil.getDataModelStringData((IDataModel)md, (String)"billstatus");
        if (StringUtils.equalsIgnoreCase((CharSequence)billStatusStr, (CharSequence)"A")) {
            LotNumberHelper.lotnumberEntryGridBind((IDataModel)this.getModel(), (IFormView)this.getView(), (EntryGridBindDataEvent)e, (String)"matintoentity", (String)"materialid");
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        IDataModel dm = fv.getModel();
        if (dm == null) {
            return;
        }
        String billStatus = DynamicObjDataUtil.getDataModelStringData((IDataModel)dm, (String)"billstatus");
        evt.setSkipNoField(true);
        if (StringQMCUtil.inside((String)billStatus, (String[])new String[]{"B", "C"}).booleanValue()) {
            evt.setCheckDataChange(false);
        } else {
            Map ingoreFields = InspectBillHelper.getIngoreFields();
            BizChangeWinUtil.setIngoreHeadFields((IDataModel)dm, (Map)ingoreFields);
            Map ingoreEntryFields = InspectBillHelper.getIngoreEntryFields();
            BizChangeWinUtil.setIngoreEntryFields((IDataModel)dm, (String)"matintoentity", (Map)ingoreEntryFields);
        }
    }

    private void materialChange(ChangeData changeData, Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (oldValue != null) {
            model.setValue("unitfield", null, rowIndex);
            model.setValue("materialqty", null, rowIndex);
            model.setValue("baseunit", null, rowIndex);
            model.setValue("rinsqty", null, rowIndex);
        }
        if (newValue instanceof DynamicObject) {
            DynamicObject material = (DynamicObject)newValue;
            DynamicObject unit = material.getDynamicObject("baseunit");
            if (unit != null) {
                Long unitId = (Long)unit.getPkValue();
                model.setValue("unitfield", (Object)unitId, rowIndex);
                model.setValue("baseunit", (Object)unitId, rowIndex);
            }
            LotNumberHelper.lotnumberEnable((IDataModel)this.getModel(), (IFormView)this.getView(), (DynamicObject)material, (int)rowIndex, (Boolean)Boolean.TRUE);
        }
        this.caleBaseQty(changeData);
    }

    private void updateMaterialQty(ChangeData changeData) {
        this.updateJudMatchQty(changeData);
        this.matQtyChangeSamQty(changeData.getRowIndex());
    }

    private void matQtyChangeSamQty(int rowIndex) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        CkSampleCaleResModel sampResModel = InspectCkvalHelper.getSampInfoByMatRow((IDataModel)model, (int)rowIndex);
        this.sampschemeChange(rowIndex, false);
        InspectCommonHelper.updateSampAndProjSampQtyCommon((int)rowIndex, (IDataModel)model, (IFormView)view, (BigDecimal)sampResModel.getRinsQty(), (Boolean)Boolean.TRUE);
    }

    private void sampschemeChange(int rowIndex, boolean isClick) {
        IDataModel dm = this.getModel();
        CkSampleCaleResModel sampleResModel = InspectCkvalHelper.getSampInfoByMatRow((IDataModel)this.getModel(), (int)rowIndex);
        this.setInspSampleVal(dm, sampleResModel, rowIndex, isClick);
    }

    private void newEntryAfterOpr() {
        IDataModel dm = this.getModel();
        boolean upRinsqtyFlag = this.updateRinsqtyVal(dm);
        if (upRinsqtyFlag) {
            this.clickTabSample();
        }
    }

    private boolean updateRinsqtyVal(IDataModel dm) {
        int rowIndex = dm.getEntryCurrentRowIndex("matintoentity");
        if (rowIndex == -1) {
            return false;
        }
        dm.setValue("rinsqtyvalue", dm.getValue("rinsqty"), rowIndex);
        return true;
    }

    private void clickTabSample() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("matintoentity");
        int curIndex = this.getModel().getEntryCurrentRowIndex("matintoentity");
        int entryRowCount = this.getModel().getEntryRowCount("matintoentity");
        if (curIndex > -1) {
            entryGrid.entryRowClick(Integer.valueOf(curIndex));
            entryGrid.clickCell("materialcfg", curIndex);
        } else if (entryRowCount == 0) {
            this.clearSampleSchemHead();
            this.getView().updateView("samplingtypeview");
        }
    }

    private void clearSampleSchemHead() {
        IDataModel dm = this.getModel();
        Set<String> fieldSet = this.getSampleSchemViewField();
        dm.beginInit();
        for (String field : fieldSet) {
            dm.setValue(field, null);
        }
        dm.endInit();
        dm.updateCache();
        for (String field : fieldSet) {
            this.getView().updateView(field);
        }
    }

    private void updateSampleSchemHeadView() {
        IFormView fv = this.getView();
        Set<String> fieldSet = this.getSampleSchemViewField();
        for (String field : fieldSet) {
            fv.updateView(field);
        }
    }

    private Set<String> getSampleSchemViewField() {
        HashSet<String> fieldSet = new HashSet<String>(10);
        fieldSet.add("sampschemeview");
        fieldSet.add("samplingqtyinsview");
        fieldSet.add("rinsqtyvalue");
        fieldSet.add("showtypeview");
        return fieldSet;
    }

    private void clearCacheOldRow() {
        String cacheRowKey = StringQMCUtil.getCaheKey((String[])new String[]{CACHE_OLDROW, "matintoentity"});
        this.getPageCache().put(cacheRowKey, "");
    }

    private boolean isFocusRow(String entry, int rowIndex) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entry);
        int row = entryGrid.getEntryState().getFocusRow();
        return row == rowIndex;
    }

    private DynamicObjectCollection getSubEntry(int parentRowIndex, String subEntry) {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection parentRowObjs = billObj.getDynamicObjectCollection("matintoentity");
        DynamicObject parentRowObj = (DynamicObject)parentRowObjs.get(parentRowIndex);
        return parentRowObj.getDynamicObjectCollection(subEntry);
    }

    private void setInspSampleVal(IDataModel dm, CkSampleCaleResModel resModel, int rowIndex, boolean isClick) {
        DynamicObject recColl = resModel.getAcceptyObj();
        BigDecimal sc = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)recColl, (String)"samppercentage");
        String fl = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)recColl, (String)"formula");
        String ssc = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)recColl, (String)"samplingsizecode");
        String inspectionrule = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)recColl, (String)"inspectionrule");
        boolean isfocuse = this.isFocusRow("matintoentity", rowIndex);
        if (!isClick) {
            dm.setValue("samppercentage", (Object)sc, rowIndex);
            dm.setValue("formula", (Object)fl, rowIndex);
            dm.setValue("acstr", (Object)resModel.getAcceptyQty(), rowIndex);
            dm.setValue("re", (Object)resModel.getRejQty(), rowIndex);
            dm.setValue("samplingsize", (Object)resModel.getSampleSize(), rowIndex);
            BigDecimal rinsQtyCal = resModel.getRinsQty();
            InspectCommonHelper.setRinsQty((int)rowIndex, (IDataModel)dm, (BigDecimal)rinsQtyCal);
        }
        if (isfocuse) {
            String acstr = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)recColl, (String)"acstr");
            String re = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)recColl, (String)"re");
            BigDecimal rinsqty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"rinsqty", (int)rowIndex);
            BigDecimal samplingsize = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"samplingsize", (int)rowIndex);
            DynamicObjectCollection subRowObjs = this.getSubEntry(rowIndex, "subentryentity");
            subRowObjs.clear();
            DynamicObject se = new DynamicObject(subRowObjs.getDynamicObjectType());
            se.set("samplingsizecodeview", (Object)ssc);
            se.set("samppercentageview", (Object)sc);
            se.set("formulaview", (Object)fl);
            se.set("acstrview", (Object)acstr);
            se.set("review", (Object)re);
            se.set("samplingsizeview", (Object)samplingsize);
            se.set("inspectionruleview", (Object)inspectionrule);
            se.getDataEntityState().setBizChanged(false);
            subRowObjs.add((Object)se);
            dm.updateEntryCache(subRowObjs);
            this.getView().updateView("subentryentity");
            dm.setValue("samplingqtyinsview", (Object)samplingsize);
            dm.setValue("rinsqtyvalue", (Object)rinsqty);
            this.getView().updateView("rinsqtyvalue");
        }
    }

    private void setTagValue(int row) {
        DynamicObject baseunit;
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("rinsqtyvalue", model.getValue("rinsqty", row));
        model.setValue("showtypeview", model.getValue("showtype", row));
        model.endInit();
        model.updateCache();
        this.updateSampleSchemHeadView();
        model.setValue("sampschemeview", model.getValue("sampscheme", row));
        model.setValue("unitview", model.getValue("unitfield", row));
        this.sampschemeChange(row, true);
        DynamicObject material = (DynamicObject)model.getValue("materialid", row);
        DynamicObject dynamicObject = baseunit = Objects.nonNull(material) ? material.getDynamicObject("baseunit") : null;
        if (null != baseunit) {
            model.setValue("baseunit", (Object)baseunit);
        }
        this.setShowTypeTabVisble(row);
        InspectCkvalHelper.refreshCkValStr((IDataModel)model, (IFormView)this.getView());
    }

    @Override
    public void callBiztypeChange(MessageBoxResult result) {
        super.callBiztypeChange(result);
        IDataModel mode = this.getModel();
        switch (result) {
            case Yes: {
                DynamicObjectCollection matintoentity = mode.getEntryEntity("matintoentity");
                for (int i = matintoentity.size() - 1; i >= 0; --i) {
                    mode.deleteEntryRow("matintoentity", i);
                }
                this.getView().invokeOperation("newentry");
                BizTypeHelper.qrouteDeal((IFormView)this.getView());
                this.initTransacType();
                break;
            }
            case Cancel: {
                mode.beginInit();
                mode.setValue("biztype", (Object)this.getPageCache().get("biztypetmp"));
                mode.endInit();
                mode.updateCache();
                this.getView().updateView("biztype");
                break;
            }
        }
    }

    private QmcErrorCode validDrawBeforeDoOpr() {
        QmcErrorCode qmcErr = null;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            qmcErr = QmcBaseErrorCode.getErrorInfo((ErrorTypeEnum)ErrorTypeEnum.Msg_MustZJOrg);
        }
        DynamicObject biztype = (DynamicObject)this.getModel().getValue("biztype");
        if (qmcErr == null && biztype == null) {
            qmcErr = QmcBaseErrorCode.getErrorInfo((ErrorTypeEnum)ErrorTypeEnum.Msg_MustBizType);
        }
        return qmcErr;
    }

    private void drawBeforeDoOpr(BeforeDoOperationEventArgs args) {
        QmcErrorCode qmcErr = this.validDrawBeforeDoOpr();
        if (qmcErr != null) {
            QmcErrorCodeUtils.showMessge((IFormView)this.getView(), (QmcErrorCode)qmcErr);
            args.setCancel(true);
            return;
        }
        if (this.getModel().getEntryRowCount("matintoentity") == 1 && this.getModel().getValue("materialid", 0) == null) {
            this.getModel().deleteEntryRow("matintoentity", 0);
        }
        ControlUtil.deleteEmptyRows((IDataModel)this.getModel(), (String)"matintoentity", (String)"materialid");
    }

    private void caleBaseQty(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        DynamicObject materialidObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"materialid", (int)rowIndex);
        DynamicObject unitfieldObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"unitfield", (int)rowIndex);
        DynamicObject baseunitObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"baseunit", (int)rowIndex);
        BigDecimal baseqty = BigDecimal.ZERO;
        BigDecimal basequaliqty = BigDecimal.ZERO;
        BigDecimal baseunqlyqty = BigDecimal.ZERO;
        HashMap cacheCovertQtyMap = new HashMap(16);
        if (materialidObj != null && unitfieldObj != null && baseunitObj != null) {
            BigDecimal materialQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"materialqty", (int)rowIndex);
            BigDecimal qualiqty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"qualiqty", (int)rowIndex);
            BigDecimal unqualiqty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"unqualiqty", (int)rowIndex);
            baseqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)materialidObj), (Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)unitfieldObj), (BigDecimal)materialQty, (DynamicObject)baseunitObj, cacheCovertQtyMap);
            basequaliqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)materialidObj), (Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)unitfieldObj), (BigDecimal)qualiqty, (DynamicObject)baseunitObj, cacheCovertQtyMap);
            baseunqlyqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)materialidObj), (Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)unitfieldObj), (BigDecimal)unqualiqty, (DynamicObject)baseunitObj, cacheCovertQtyMap);
        }
        dm.beginInit();
        dm.setValue("baseqty", (Object)baseqty, rowIndex);
        dm.setValue("basequaliqty", (Object)basequaliqty, rowIndex);
        dm.setValue("baseunqlyqty", (Object)baseunqlyqty, rowIndex);
        dm.endInit();
        fv.updateView("baseqty", rowIndex);
        fv.updateView("basequaliqty", rowIndex);
        fv.updateView("baseunqlyqty", rowIndex);
    }

    private void updateJudQty(ChangeData changeData, String fieldName) {
        int rowIndex = changeData.getRowIndex();
        IDataModel dm = this.getModel();
        IFormView fv = this.getView();
        DynamicObject materialidObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"materialid", (int)rowIndex);
        DynamicObject unitfieldObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"unitfield", (int)rowIndex);
        DynamicObject baseunitObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"baseunit", (int)rowIndex);
        BigDecimal materialQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"materialqty", (int)rowIndex);
        if (materialidObj == null || unitfieldObj == null || baseunitObj == null) {
            return;
        }
        BigDecimal qtyVal = BigDecimalUtil.toBigDecimal((Object)changeData.getNewValue());
        switch (fieldName) {
            case "qualiqty": {
                BigDecimal unQuliQtyVal = materialQty.subtract(qtyVal);
                if (unQuliQtyVal.compareTo(BigDecimal.ZERO) < 0) {
                    unQuliQtyVal = BigDecimal.ZERO;
                }
                dm.setValue("unqualiqty", (Object)unQuliQtyVal, rowIndex);
                fv.updateView("unqualiqty", rowIndex);
                break;
            }
            case "unqualiqty": {
                BigDecimal quliQtyVal = materialQty.subtract(qtyVal);
                if (quliQtyVal.compareTo(BigDecimal.ZERO) < 0) {
                    quliQtyVal = BigDecimal.ZERO;
                }
                dm.setValue("qualiqty", (Object)quliQtyVal, rowIndex);
                fv.updateView("qualiqty", rowIndex);
                break;
            }
        }
        this.caleBaseQty(changeData);
    }

    private void updateSampScheme(ChangeData changeData) {
        IDataModel dm = this.getModel();
        Object newValue = changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        if (this.isFocusRow("matintoentity", rowIndex)) {
            dm.setValue("sampschemeview", newValue);
        }
        this.sampschemeChange(rowIndex, false);
    }

    private void updateUnitfield(ChangeData changeData) {
        IDataModel model = this.getModel();
        Object newValue = changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        if (this.isFocusRow("matintoentity", rowIndex)) {
            model.setValue("unitview", newValue);
        }
        this.getView().updateView("unitview");
        this.caleBaseQty(changeData);
    }

    private void updateRinsQtyValue(ChangeData changeData) {
        IDataModel dm = this.getModel();
        BigDecimal rinsQty = BigDecimalUtil.toBigDecimal((Object)changeData.getNewValue());
        int curIndex = dm.getEntryCurrentRowIndex("matintoentity");
        if (curIndex < 0) {
            return;
        }
        dm.setValue("rinsqty", (Object)rinsQty, curIndex);
    }

    private void updateRinsQty(ChangeData changeData) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        InspectCkvalHelper.updateRinsQtyRealValue((ChangeData)changeData, (IDataModel)model, (IFormView)view);
        BigDecimal rinsQtyValue = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"rinsqtyvalue");
        BigDecimal rinsQty = BigDecimalUtil.toBigDecimal((Object)changeData.getNewValue());
        if (rinsQtyValue.compareTo(rinsQty) == 0) {
            return;
        }
        model.beginInit();
        model.setValue("rinsqtyvalue", (Object)rinsQty);
        model.endInit();
        view.updateView("rinsqtyvalue");
    }

    private void updateShowType(ChangeData changeData) {
        IDataModel dm = this.getModel();
        Object newValue = changeData.getNewValue();
        int curIndex = dm.getEntryCurrentRowIndex("matintoentity");
        if (curIndex < 0) {
            return;
        }
        dm.setValue("showtype", newValue, curIndex);
        this.setShowTypeTabVisble(curIndex);
        InspectCkvalHelper.refreshCkValStr((IDataModel)dm, (IFormView)this.getView());
    }

    private void setShowTypeTabVisble(int rowIndex) {
        IDataModel dm = this.getModel();
        int curIndex = dm.getEntryCurrentRowIndex("matintoentity");
        if (curIndex < 0 || rowIndex != curIndex) {
            return;
        }
        IFormView fv = this.getView();
        String showtype = DynamicObjDataUtil.getDataModelStringData((IDataModel)dm, (String)"showtype", (int)rowIndex);
        if (StringUtils.equalsIgnoreCase((CharSequence)showtype, (CharSequence)ShowTypeEnum.ByProject.getValue())) {
            fv.setVisible(Boolean.TRUE, new String[]{"adv_project"});
            fv.setVisible(Boolean.FALSE, new String[]{"adv_example"});
        } else if (StringUtils.equalsIgnoreCase((CharSequence)showtype, (CharSequence)ShowTypeEnum.ByExample.getValue())) {
            fv.setVisible(Boolean.FALSE, new String[]{"adv_project"});
            fv.setVisible(Boolean.TRUE, new String[]{"adv_example"});
        }
    }

    private void dealBizChange(ChangeData changeData, String fieldName) {
        String fieldNameId = fieldName + "_id";
        if (this.mIngoreEntryFields == null || this.mIngoreEntryFields.size() <= 0) {
            this.mIngoreEntryFields = InspectBillHelper.getIngoreEntryFields();
        }
        if (changeData.getDataEntity().getDataEntityType().getProperties().containsKey((Object)fieldNameId)) {
            fieldName = fieldNameId;
        }
        if (!this.mIngoreEntryFields.containsKey(fieldName)) {
            return;
        }
        BizChangeWinUtil.setIngoreField((String)fieldName, (DynamicObject)changeData.getDataEntity(), this.mIngoreEntryFields);
    }

    private String validBeforeF7Select(BeforeF7SelectEvent e) {
        String errStr = "";
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        HashSet<String> validOrgKeys = new HashSet<String>(10){};
        validOrgKeys.add("insdepartment");
        validOrgKeys.add("subinspector");
        if (org == null && validOrgKeys.contains(key)) {
            QmcErrorCode qmcErr = QmcBaseErrorCode.getErrorInfo((ErrorTypeEnum)ErrorTypeEnum.Msg_MustZJOrg);
            errStr = qmcErr.getErrorCode().getMessage();
        }
        return errStr;
    }

    private void matchInspectPro(Set<Integer> rowIndexSet, InspectProGlobalCache inspectProGlobalCache, InspectDealArgs args) {
        args.setBillData(this.getModel().getDataEntity(true));
        args.setView(this.getView());
        args.setFactory((InspectProVoluationFactory)new InspectProVoluationInspect());
        InspproVoluationKeyModel voluationKeyModel = args.getVoluationKeyModel();
        voluationKeyModel.setEntryKey("matintoentity");
        voluationKeyModel.setInspectDeptKey("insdepartment");
        voluationKeyModel.setInspectUserKey("subinspector");
        voluationKeyModel.setInspectStdKey("inspectionstd");
        voluationKeyModel.setInspectSampKey("sampscheme");
        voluationKeyModel.setInspectWsKey("wsrule");
        args.setRowIndexSet(rowIndexSet);
        InspectProMatchHelper.inspectProDeal((InspectDealArgs)args, (InspectProGlobalCache)inspectProGlobalCache);
    }

    private void matchInspProAfterDraw() {
        HashSet<Integer> rowIndexSet = new HashSet<Integer>(16);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("matintoentity");
        for (int i = 0; i < entrys.size(); ++i) {
            if (!DynamicObjPropUtil.isFirstDrawByDyo((DynamicObject)((DynamicObject)entrys.get(i))).booleanValue()) continue;
            rowIndexSet.add(i);
        }
        InspectDealArgs args = new InspectDealArgs();
        args.setDrawNow(Boolean.valueOf(rowIndexSet.size() > 0));
        this.matchInspectPro(rowIndexSet, new InspectProGlobalCache(), args);
    }

    private void computeSampQtyAfterDraw() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getEntryEntity("matintoentity");
        for (int i = 0; i < entrys.size(); ++i) {
            BigDecimal maxProjSampQty;
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Boolean isFirstDraw = DynamicObjPropUtil.isFirstDrawByDyo((DynamicObject)entry);
            if (!isFirstDraw.booleanValue()) continue;
            DynamicObjectCollection projEntrys = entry.getDynamicObjectCollection("inspsubentity");
            String rule = InspectCommonHelper.getSampNumRule((IDataModel)model);
            Boolean joininspectFlag = DynamicObjDataUtil.getDataModelBooleanData((IDataModel)model, (String)"joininspectflag");
            for (DynamicObject projEntry : projEntrys) {
                DynamicObject projSamp;
                if (joininspectFlag.booleanValue() && projEntry.getBoolean("isjoininspect") || BigDecimal.ZERO.compareTo(projEntry.getBigDecimal("projsampqty")) != 0 || !Objects.nonNull(projSamp = projEntry.getDynamicObject("projsamp"))) continue;
                CkSampleCaleModel sampleModel = new CkSampleCaleModel(projSamp, entry.getBigDecimal("materialqty"), entry.getDynamicObject("unitfield"), rule);
                CkSampleCaleResModel resModel = InspectBillSampleHelper.getSampleInfo((CkSampleCaleModel)sampleModel);
                InspectBillSampleHelper.setCKProjectSampleRow((DynamicObject)entry, (DynamicObject)projEntry, (CkSampleCaleResModel)resModel);
            }
            Optional<BigDecimal> maxProjSampQtyOpt = projEntrys.stream().map(o -> o.getBigDecimal("projsampqty")).max(Comparator.naturalOrder());
            BigDecimal matSampQty = entry.getBigDecimal("rinsqty");
            if (!maxProjSampQtyOpt.isPresent() || (maxProjSampQty = maxProjSampQtyOpt.get()).compareTo(matSampQty) <= 0) continue;
            model.setValue("rinsqty", (Object)maxProjSampQty, i);
        }
    }

    private void selectFirstMatRow(int rowIndex) {
        IDataModel dm = this.getModel();
        DynamicObjectCollection entryEntity = dm.getEntryEntity("matintoentity");
        if (!entryEntity.isEmpty() && null != dm.getValue("materialid", rowIndex)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("matintoentity");
            entryGrid.selectRows(rowIndex);
            this.setTagValue(rowIndex);
        } else if (!entryEntity.isEmpty()) {
            this.setShowTypeTabVisble(rowIndex);
        }
    }

    private void inspItemAfterF7(AfterF7SelectEvent e) {
        ListSelectedRowCollection selectedRowColls = e.getListSelectedRowCollection();
        if (selectedRowColls.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        BasedataEdit basedataEdit = (BasedataEdit)e.getSource();
        String key = basedataEdit.getKey();
        if ("inspectionitem".equals(key)) {
            int matRowIndex = model.getEntryCurrentRowIndex("matintoentity");
            DynamicObjectCollection subEntry = this.getSubEntry(matRowIndex, "inspsubentity");
            DynamicObjectType dynamicObjectType = subEntry.getDynamicObjectType();
            int inspSubIndex = Integer.parseInt(this.getPageCache().get("inspRowIndex"));
            DynamicObject inspRow = (DynamicObject)subEntry.get(inspSubIndex);
            DynamicObject inspItemObj = BusinessDataServiceHelper.loadSingle((Object)selectedRowColls.getPrimaryKeyValues()[0], (String)"qcbd_inspectionitems");
            DynamicObjectCollection entryEntity = inspItemObj.getDynamicObjectCollection("entryentity");
            int size = entryEntity.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject inspRowTemp = 0 == i ? inspRow : new DynamicObject(dynamicObjectType);
                inspRowTemp.set("inspectionitem", (Object)inspItemObj);
                this.copyItemData(inspRowTemp, (DynamicObject)entryEntity.get(i), inspSubIndex + i);
                if (0 == i) continue;
                subEntry.add(inspSubIndex + i, inspRowTemp);
            }
            int nowSize = subEntry.size();
            for (int i = inspSubIndex; i < nowSize; ++i) {
                int endAddIndex = inspSubIndex + size;
                if (i < endAddIndex) {
                    this.getModel().setValue("projckresult", (Object)"", i);
                }
                ((DynamicObject)subEntry.get(i)).set("seq", (Object)(i + 1));
            }
            model.updateEntryCache(subEntry);
            view.updateView("inspsubentity");
        }
    }

    private void copyItemData(DynamicObject inspRow, DynamicObject inspItem, int rowIndex) {
        inspRow.set("inspectmethod", inspItem.get("checkmethod"));
        inspRow.set("inspectioncontent", inspItem.get("checkcontent"));
        inspRow.set("inspectbasis", inspItem.get("checkbasis"));
        inspRow.set("inspectinstruct", inspItem.get("checkinstruct"));
        inspRow.set("keyquality", inspItem.get("keyquality"));
        inspRow.set("inspecunitid", inspItem.get("unit"));
        inspRow.set("projckvalstr", (Object)InspectCkvalHelper.getCkValStr());
        if (StringUtils.isEmpty((CharSequence)inspRow.getString("uquuid"))) {
            inspRow.set("uquuid", (Object)Uuid16.create().toString());
        }
        inspRow.set("seq", (Object)(rowIndex + 1));
        inspRow.set("inspectfreq", null);
        inspRow.set("normtype", (Object)"");
        inspRow.set("matchflag", null);
        inspRow.set("specvalue", (Object)"");
        inspRow.set("topvalue", null);
        inspRow.set("downvalue", null);
        inspRow.set("projqualifiyqty", (Object)0);
        inspRow.set("projunqualifiyqty", (Object)0);
        inspRow.set("projsampqty", (Object)0);
        inspRow.set("projsamp", null);
        inspRow.set("projacceptqty", (Object)0);
    }

    protected void transacTypeChange(ChangeData changeData) {
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        if (Objects.nonNull(newValue)) {
            IDataModel model = this.getModel();
            this.initTransacTypeControl(newValue);
            boolean matchFlag = TransacTypeHelper.isChangeDimenOfTransacType((DynamicObject)oldValue, (DynamicObject)newValue);
            int matRowCount = model.getEntryRowCount("matintoentity");
            HashSet<Integer> rowIndexSet = new HashSet<Integer>(16);
            for (int i = 0; i < matRowCount; ++i) {
                rowIndexSet.add(i);
            }
            if (matchFlag) {
                this.matchInspectPro(rowIndexSet, new InspectProGlobalCache(), new InspectDealArgs());
            }
            for (Integer rowIndex : rowIndexSet) {
                this.sampschemeChange(rowIndex, false);
            }
            int curIndex = -1 == model.getEntryCurrentRowIndex("matintoentity") ? 0 : model.getEntryCurrentRowIndex("matintoentity");
            Object curValue = model.getValue("rinsqty", curIndex);
            model.beginInit();
            model.setValue("rinsqtyvalue", curValue);
            model.endInit();
            this.getView().updateView("rinsqtyvalue");
        }
    }

    private void initTransacTypeControl(DynamicObject transacType) {
        boolean inspItemMod = transacType.getBoolean("inspitemmodflg");
        this.getModel().setValue("inspitemmodflg", (Object)inspItemMod);
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(inspItemMod), new String[]{"additem", "deleteitem", "selectjoininspect"});
        boolean inspSampShow = transacType.getBoolean("inspsampprojflag");
        view.setVisible(Boolean.valueOf(inspSampShow), new String[]{"flexpanelap3"});
        boolean ckvalFlag = transacType.getBoolean("ckvalflag");
        view.setVisible(Boolean.valueOf(ckvalFlag), new String[]{"projckvalstr", "sampckvalstr"});
    }

    private void selectJoinInspect() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int curMatRowIndex = model.getEntryCurrentRowIndex("matintoentity");
        if (curMatRowIndex < 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u884c\u3002", (String)"InspectBillPlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
        } else if (Objects.isNull(model.getEntryRowEntity("matintoentity", curMatRowIndex).get("materialid"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u3002", (String)"InspectBillPlugin_2", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
        } else {
            String appId = model.getDataEntityType().getAppId();
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)(appId + "_joininspect"), (boolean)true, (int)2, (boolean)true);
            showParameter.setSelectedEntity("inspsubentity");
            ControlUtil.setListSelectedMode((ListShowParameter)showParameter, (boolean)false);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectJoinActionId"));
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            DynamicObjectCollection projEntrys = ((DynamicObject)model.getEntryEntity("matintoentity").get(curMatRowIndex)).getDynamicObjectCollection("inspsubentity");
            Set joinInspEntryidSet = projEntrys.stream().map(o -> o.getLong("joininspentryid")).filter(o -> o > 0L).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(joinInspEntryidSet)) {
                filters.add(new QFilter("matintoentity.inspsubentity.id", "not in", joinInspEntryidSet));
            }
            showParameter.getListFilterParameter().setQFilters(filters);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void selectJoinInspectCloseBack(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        HashMap cacheMap = new HashMap(16);
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (Objects.nonNull(returnData)) {
            DynamicObject[] joinInspectInfoArr;
            int matRowIndex = model.getEntryCurrentRowIndex("matintoentity");
            DynamicObject curMatEntry = (DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("matintoentity").get(matRowIndex);
            Set billIds = Arrays.stream(returnData.getPrimaryKeyValues()).map(o -> (Long)o).collect(Collectors.toSet());
            Set entryIds = Arrays.stream(returnData.getEntryPrimaryKeyValues()).map(o -> (Long)o).collect(Collectors.toSet());
            HashSet subEntryIds = (HashSet)Arrays.stream(returnData.getSubEntryPrimaryKeyValues()).map(o -> (Long)o).collect(Collectors.toSet());
            IFormView view = this.getView();
            JoinInspectEntityModel entityModel = JoinInspectHelper.getEntityModel((String)view.getEntityId());
            String otherSelectFields = "isjoininspect,inspectmethod,inspectfreq,inspectbasis,inspectinstruct,inspecunitid";
            for (DynamicObject inspectInfo : joinInspectInfoArr = JoinInspectHelper.getInspectInfoCommon((String)entityModel.getJoinInspectBill(), billIds, entryIds, null, (String)"C", (String[])new String[]{otherSelectFields})) {
                DynamicObjectCollection joinMatEntrys = inspectInfo.getDynamicObjectCollection("matintoentity");
                for (DynamicObject joinMatEntry : joinMatEntrys) {
                    ArrayList<Integer> seqs = new ArrayList<Integer>();
                    DynamicObjectCollection joinProjEntrys = joinMatEntry.getDynamicObjectCollection("inspsubentity");
                    for (DynamicObject joinProjEntry : joinProjEntrys) {
                        if (!subEntryIds.contains(joinProjEntry.getLong("id"))) continue;
                        seqs.add(joinProjEntry.getInt("seq"));
                    }
                    JoinInspectHelper.chooseJoinData((DynamicObject)joinMatEntry, seqs);
                    JoinInspectHelper.joinRowToInspRow((DynamicObject)joinMatEntry, (DynamicObject)curMatEntry, (JoinInspectEntityModel)entityModel, (Boolean)Boolean.TRUE, cacheMap);
                }
            }
            BigDecimal rinsQtyValue = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"rinsqtyvalue");
            BigDecimal rinsQty = curMatEntry.getBigDecimal("rinsqty");
            if (rinsQty.compareTo(rinsQtyValue) > 0) {
                model.setValue("rinsqtyvalue", (Object)rinsQty);
            }
            DynamicObjectCollection inspSubEntry = curMatEntry.getDynamicObjectCollection("inspsubentity");
            for (DynamicObject inspRow : inspSubEntry) {
                int projCakVal = inspRow.getBigDecimal("projckval").intValue();
                int chooseSampQty = inspRow.getBigDecimal("choosesampqty").intValue();
                inspRow.set("projckvalstr", (Object)InspectCkvalHelper.getCkValStr((int)projCakVal, (int)chooseSampQty));
            }
            model.updateEntryCache(inspSubEntry);
            view.updateView("inspsubentity");
            view.updateView("sampqualqty", matRowIndex);
            view.updateView("samunqualqty", matRowIndex);
            view.updateView("samplingresult", matRowIndex);
        }
    }

    private void queryJoinInspect() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int curMatRowIndex = model.getEntryCurrentRowIndex("matintoentity");
        if (curMatRowIndex < 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u884c\u3002", (String)"InspectBillPlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
        } else {
            EntryGrid itemGrid = (EntryGrid)this.getControl("inspsubentity");
            int[] rows = itemGrid.getSelectRows();
            Set itemJoinInspectIds = rows.length > 0 ? model.getEntryEntity("inspsubentity").stream().filter(o -> ArrayUtils.contains((int[])rows, (int)(o.getInt("seq") - 1))).map(o -> o.getLong("joininspentryid")).collect(Collectors.toSet()) : model.getEntryEntity("inspsubentity").stream().map(o -> o.getLong("joininspentryid")).collect(Collectors.toSet());
            itemJoinInspectIds.remove(0L);
            if (CollectionUtils.isEmpty(itemJoinInspectIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u7684\u8054\u5408\u68c0\u9a8c\u5355\u3002", (String)"InspectBillPlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
                return;
            }
            String appId = model.getDataEntityType().getAppId();
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)(appId + "_joininspect_skip"), (boolean)true, (int)0, (boolean)false);
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            QFilter qFilter = new QFilter("matintoentity.inspsubentity.id", "in", itemJoinInspectIds);
            filters.add(qFilter);
            showParameter.getListFilterParameter().setQFilters(filters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void updateJudMatchQty(ChangeData changeData) {
        BigDecimal qualiqty;
        IDataModel model = this.getModel();
        int rowIndex = changeData.getRowIndex();
        DynamicObject materialidObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"materialid", (int)rowIndex);
        DynamicObject unitfieldObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"unitfield", (int)rowIndex);
        DynamicObject baseunitObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"baseunit", (int)rowIndex);
        if (materialidObj == null || unitfieldObj == null || baseunitObj == null) {
            return;
        }
        BigDecimal materialQty = BigDecimalUtil.toBigDecimal((Object)changeData.getNewValue());
        if (materialQty.compareTo(qualiqty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"qualiqty", (int)rowIndex)) < 0) {
            qualiqty = materialQty;
            model.setValue("qualiqty", (Object)qualiqty, rowIndex);
        }
        BigDecimal unqualiqty = materialQty.subtract(qualiqty);
        model.setValue("unqualiqty", (Object)unqualiqty, rowIndex);
    }

    private void setJoinInspectStdEnable(IDataModel model) {
        DynamicObjectCollection matEntrys = this.getModel().getEntryEntity("matintoentity");
        Boolean joininspectFlag = DynamicObjDataUtil.getDataModelBooleanData((IDataModel)model, (String)"joininspectflag");
        if (joininspectFlag.booleanValue()) {
            for (int i = 0; i < matEntrys.size(); ++i) {
                DynamicObjectCollection projEntrys;
                boolean hasJoinProj;
                DynamicObject matEntry = (DynamicObject)matEntrys.get(i);
                if (matEntry.getLong("srcbillid") <= 0L || !(hasJoinProj = (projEntrys = matEntry.getDynamicObjectCollection("inspsubentity")).stream().anyMatch(o -> o.getBoolean("isjoininspect")))) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"inspectionstd"});
            }
        }
    }

    private void transacTypeDeal() {
        DynamicObject transacType = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"transactype");
        if (Objects.nonNull(transacType)) {
            this.matchInspProAfterDraw();
            this.initTransacTypeControl(transacType);
        }
        if (DynamicObjPropUtil.isFirstDrawByDyo((DynamicObject)this.getModel().getDataEntity(true)).booleanValue() && Objects.isNull(transacType)) {
            this.initTransacType();
        }
        List applyBillEntityNames = MainEntityTypeUtil.getInheritChildNumberLst((String[])new String[]{"qcp_inspecapplypbill"});
        for (DynamicObject entry : this.getModel().getEntryEntity("matintoentity")) {
            if (!applyBillEntityNames.contains(entry.getString("srcbillentity"))) continue;
            this.getView().setEnable(Boolean.FALSE, new String[]{"transactype"});
            break;
        }
    }

    private void qualifyAndUnqualifyCheck(BeforeFieldPostBackEvent e, FieldEdit fieldEdit, int rowIndex) {
        String fieldKey;
        String isCheck;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object billStatus = model.getValue("billstatus");
        if ("B".equals(billStatus) && !"true".equalsIgnoreCase(isCheck = ParameterUtil.getQmcSystemProp((String)"inspect_submit_check", (String)(fieldKey = fieldEdit.getFieldKey())))) {
            return;
        }
        boolean permit = ControlUtil.dataChangePermit((IDataModel)model, (IFormView)view, (Object)fieldEdit, (int)rowIndex);
        e.setCancel(!permit);
    }

    private void inspectionStdPropChange(ChangeData changeData) {
        IDataModel model = this.getModel();
        InspectStdHelper.inspectionstdChange((DynamicObject)model.getDataEntity(true), (IFormView)this.getView(), (Object)changeData.getNewValue(), (int)changeData.getRowIndex());
        int matRowIndex = this.getModel().getEntryCurrentRowIndex("matintoentity");
        int realMatRowCurIndex = matRowIndex > 0 ? matRowIndex : 0;
        model.beginInit();
        model.setValue("rinsqtyvalue", model.getValue("rinsqty", realMatRowCurIndex));
        model.endInit();
        this.getView().updateView("rinsqtyvalue");
    }

    private void refreshCkVal(ClosedCallBackEvent closedCallBackEvent, IDataModel model, IFormView view, String status) {
        if ("A".equals(status)) {
            Object returnData = closedCallBackEvent.getReturnData();
            logger.info("\u68c0\u9a8c\u5355\u56de\u8c03\u6570\u636e\uff1areturnData" + returnData);
            if (null != returnData) {
                HashMap retDataMap = (HashMap)returnData;
                InspectCkvalHelper.refreshSubSamp((Map)retDataMap, (IDataModel)model, (IFormView)view, (Boolean)Boolean.TRUE);
                InspectCkvalHelper.refreshSubInsp((Map)retDataMap, (IDataModel)model, (IFormView)view, (Boolean)Boolean.TRUE);
                InspectCkvalHelper.refreshBackTab((Map)retDataMap, (IDataModel)model, (IFormView)view);
                InspectCkvalHelper.refreshCkValStr((IDataModel)this.getModel(), (IFormView)view);
            }
        }
    }

    private InspectDealArgs buildInspectDealArgs(int[] selectRows) {
        InspectDealArgs args = new InspectDealArgs();
        args.setBillData(this.getModel().getDataEntity(true));
        args.setView(this.getView());
        args.setFactory((InspectProVoluationFactory)new InspectProVoluationInspect());
        InspproVoluationKeyModel voluationKeyModel = args.getVoluationKeyModel();
        voluationKeyModel.setEntryKey("matintoentity");
        voluationKeyModel.setInspectDeptKey("insdepartment");
        voluationKeyModel.setInspectUserKey("subinspector");
        voluationKeyModel.setInspectStdKey("inspectionstd");
        voluationKeyModel.setInspectSampKey("sampscheme");
        voluationKeyModel.setInspectWsKey("wsrule");
        if (selectRows.length != 0) {
            HashSet<Integer> rowIndexSet = new HashSet<Integer>();
            rowIndexSet.add(selectRows[0]);
            args.setRowIndexSet(rowIndexSet);
        }
        return args;
    }
}

