/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.inspection;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.BizTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.InspectStdHelper;
import kd.qmc.qcbd.business.commonmodel.helper.LotNumberHelper;
import kd.qmc.qcbd.business.commonmodel.helper.basedata.TransacTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.control.CommonViewControlHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectDealArgs;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProDimenHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProGlobalCache;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProMatchHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.InspproVoluationKeyModel;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.factory.InspectProVoluationFactory;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.impl.InspectProVoluationJoinInspect;
import kd.qmc.qcbd.business.custom.ext.IJoinInspAfterUpdateMeasureVal;
import kd.qmc.qcbd.business.custom.ext.JoinInspUpdateMeasureValImpl;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillSampleHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCkvalHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCommonHelper;
import kd.qmc.qcbd.common.constant.inspect.InspItemInfo;
import kd.qmc.qcbd.common.constant.inspect.JoinInspUpdateMeasureArgs;
import kd.qmc.qcbd.common.constant.inspect.JoininspectConst;
import kd.qmc.qcbd.common.model.InspectProjModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleResModel;
import kd.qmc.qcbd.common.util.BigDecimalUtil;
import kd.qmc.qcbd.common.util.BizChangeWinUtil;
import kd.qmc.qcbd.common.util.ControlUtil;
import kd.qmc.qcbd.common.util.DataModelUtil;
import kd.qmc.qcbd.common.util.DeptSetUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.DynamicObjPropUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;
import kd.qmc.qcbd.common.util.UserUtil;
import kd.qmc.qcbd.formplugin.common.InSpecBillCommon;

public class JoinInspectBillPlugin
extends InSpecBillCommon
implements EntryGridBindDataListener,
AfterF7SelectListener,
CellClickListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(JoinInspectBillPlugin.class);
    private static final String SYSTEM_TYPE = "qmc-qcbd-formplugin";

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("matintoentity");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit inspectStd = (BasedataEdit)this.getView().getControl("inspectionstd");
        inspectStd.addAfterF7SelectListener((AfterF7SelectListener)this);
        inspectStd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit matchFlag = (BasedataEdit)this.getView().getControl("matchflag");
        matchFlag.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit joinInspector = (BasedataEdit)this.getView().getControl("joininspector");
        joinInspector.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit inspectItem = (BasedataEdit)this.getView().getControl("inspectionitem");
        inspectItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        inspectItem.addAfterF7SelectListener((AfterF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("matintoentity");
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        InspectCkvalHelper.addCellClick((String)"inspsubentity", (IFormView)this.getView(), (CellClickListener)this);
        InspectCkvalHelper.addCellClick((String)"subsampleresentity", (IFormView)this.getView(), (CellClickListener)this);
    }

    @Override
    public void afterBindData(EventObject e) {
        DynamicObject transacType;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        CommonViewControlHelper.selectFirstMatRow((IDataModel)model, (IFormView)view, (String)"matintoentity", (String)"materialid");
        CommonViewControlHelper.bizTypeChangeFieldVisible((IDataModel)model, (IFormView)this.getView());
        DynamicObjectCollection entrys = model.getEntryEntity("matintoentity");
        if (!entrys.isEmpty()) {
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject materialInfo = ((DynamicObject)entrys.get(i)).getDynamicObject("materialid");
                LotNumberHelper.lotnumberEnable((IDataModel)model, (IFormView)view, (DynamicObject)materialInfo, (int)i, (Boolean)Boolean.FALSE);
            }
        }
        if (!model.getEntryEntity("matintoentity").isEmpty()) {
            InspectCkvalHelper.refreshCkValStr((IDataModel)model, (IFormView)view);
        }
        if (Objects.nonNull(transacType = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"transactype"))) {
            this.initTransacTypeControl(transacType);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection matEntry = dataEntity.getDynamicObjectCollection("matintoentity");
        for (DynamicObject matRow : matEntry) {
            DynamicObjectCollection inspSubEntrys = matRow.getDynamicObjectCollection("inspsubentity");
            for (DynamicObject inspSubRow : inspSubEntrys) {
                inspSubRow.set("uquuid", (Object)Uuid16.create().toString());
            }
            model.updateEntryCache(inspSubEntrys);
        }
        this.getView().updateView("inspsubentity");
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        evt.setSkipNoField(true);
        String billStatus = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)"billstatus");
        if (StringQMCUtil.inside((String)billStatus, (String[])new String[]{"B", "C"}).booleanValue()) {
            evt.setCheckDataChange(false);
        } else {
            BizChangeWinUtil.setIngoreEntryFields((IDataModel)this.getModel(), (String)"matintoentity", (Map)JoininspectConst.M_INGORE_ENTRYFIELDS);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        IDataModel md = this.getModel();
        String billStatusStr = DynamicObjDataUtil.getDataModelStringData((IDataModel)md, (String)"billstatus");
        if (StringUtils.equalsIgnoreCase((CharSequence)billStatusStr, (CharSequence)"A")) {
            LotNumberHelper.lotnumberEntryGridBind((IDataModel)this.getModel(), (IFormView)this.getView(), (EntryGridBindDataEvent)e, (String)"matintoentity", (String)"materialid");
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        InspectCkvalHelper.refreshCkValStr((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object source = e.getSource();
        int rowIndex = e.getRowIndex();
        if (source instanceof FieldEdit) {
            String fieldKey;
            FieldEdit fieldEdit = (FieldEdit)source;
            switch (fieldKey = fieldEdit.getFieldKey()) {
                case "topvalue": {
                    BigDecimal downValue = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)this.getModel(), (String)"downvalue", (int)rowIndex);
                    BigDecimal oldValue = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)this.getModel(), (String)"topvalue", (int)rowIndex);
                    DynamicObject matchflagTop = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"matchflag", (int)rowIndex);
                    InspectStdHelper.topValueChange((IDataModel)model, (IFormView)view, (BeforeFieldPostBackEvent)e, (DynamicObject)matchflagTop, (BigDecimal)downValue, (BigDecimal)oldValue);
                    break;
                }
                case "downvalue": {
                    BigDecimal topValue = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)this.getModel(), (String)"topvalue", (int)rowIndex);
                    BigDecimal oldValue = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)this.getModel(), (String)"downvalue", (int)rowIndex);
                    DynamicObject matchflagDown = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"matchflag", (int)rowIndex);
                    InspectStdHelper.downValueChange((IDataModel)model, (IFormView)view, (BeforeFieldPostBackEvent)e, (DynamicObject)matchflagDown, (BigDecimal)topValue, (BigDecimal)oldValue);
                    break;
                }
                case "specvalue": {
                    InspectStdHelper.validSpecValue((IDataModel)model, (IFormView)view, (BeforeFieldPostBackEvent)e, (String)"specvalue");
                    break;
                }
                case "rinsqtyvalue": {
                    InspectCkvalHelper.modifyRinsQty((BeforeFieldPostBackEvent)e, (IDataModel)model, (IFormView)view);
                    break;
                }
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        InspectProGlobalCache inspectProGlobalCache = new InspectProGlobalCache();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        block33: for (ChangeData changeData : changeSet) {
            BizChangeWinUtil.dealEntryBizChange((ChangeData)changeData, (String)propName, (Map)JoininspectConst.M_INGORE_ENTRYFIELDS);
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (InspectProDimenHelper.getBillFieldByType((String)this.getModel().getDataEntityType().getName(), (DynamicObject)this.getModel().getDataEntity().getDynamicObject("transactype")).contains(propName) && !StringUtils.equals((CharSequence)"biztype", (CharSequence)propName)) {
                this.matchInspectPro(this.buildRowSet(rowIndex), inspectProGlobalCache);
            }
            switch (propName) {
                case "biztype": {
                    BizTypeHelper.biztypeChange((Object)oldValue, (AbstractBillPlugIn)this);
                    continue block33;
                }
                case "materialid": {
                    this.materialChange(newValue, oldValue, rowIndex, inspectProGlobalCache);
                    continue block33;
                }
                case "inspectionstd": {
                    this.inspectStdChange(newValue, rowIndex);
                    continue block33;
                }
                case "materialqty": {
                    InspectCommonHelper.updateSampAndProjSampQtyCommon((int)rowIndex, (IDataModel)model, (IFormView)view, (BigDecimal)BigDecimal.ZERO, (Boolean)Boolean.FALSE);
                    continue block33;
                }
                case "rinsqty": {
                    InspectCkvalHelper.updateRinsQtyRealValue((ChangeData)changeData, (IDataModel)model, (IFormView)view);
                    continue block33;
                }
                case "projqualifiyqty": 
                case "projunqualifiyqty": {
                    InspectCkvalHelper.projqulifyChange((IDataModel)model, (IFormView)view, (int)changeData.getRowIndex());
                    continue block33;
                }
                case "projsamp": {
                    InspectCkvalHelper.updateProjSamp((ChangeData)changeData, (IDataModel)model, (IFormView)view, (Boolean)Boolean.FALSE);
                    continue block33;
                }
                case "projsampqty": {
                    InspectCkvalHelper.updateProjSampQty((ChangeData)changeData, (IDataModel)model, (IFormView)view, (Boolean)Boolean.FALSE);
                    continue block33;
                }
                case "specvalue": {
                    InspectStdHelper.dealSpecValue((IDataModel)model, (IFormView)view, (Object)newValue, (String)"specvalue", (int)rowIndex);
                    InspectCkvalHelper.deleteSubMeasures((int)changeData.getRowIndex(), (IDataModel)model, (IFormView)view);
                    continue block33;
                }
                case "inspectionitem": 
                case "normtype": 
                case "matchflag": 
                case "topvalue": 
                case "downvalue": {
                    InspectCkvalHelper.deleteSubMeasures((int)changeData.getRowIndex(), (IDataModel)model, (IFormView)view);
                    continue block33;
                }
                case "transactype": {
                    this.transacTypeChange((DynamicObject)oldValue, (DynamicObject)newValue);
                    continue block33;
                }
                case "supplyorg": {
                    DeptSetUtil.changeBizOrg((IDataModel)this.getModel(), (Object)newValue, (String)"supplydep", (int)rowIndex);
                    continue block33;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "previousentry": {
                ControlUtil.preEntryBeforeDoOpr((BeforeDoOperationEventArgs)args, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)"matintoentity");
                break;
            }
            case "nextentry": {
                ControlUtil.nextEntryBeforeDoOpr((BeforeDoOperationEventArgs)args, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)"matintoentity");
                break;
            }
            case "createsamp": {
                InspectCkvalHelper.addEntryRow((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "deleteentry-inspitem": {
                InspectCkvalHelper.deleteSubMeasures((int)this.getModel().getEntryCurrentRowIndex("inspsubentity"), (IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "selectinspectpro": {
                EntryGrid entryGrid = (EntryGrid)this.getControl("matintoentity");
                int[] selectRows = entryGrid.getSelectRows();
                InspectDealArgs inspectDealArgs = this.buildInspectDealArgs(selectRows);
                InspectProMatchHelper.selectInspectPro((IFormView)this.getView(), (IDataModel)this.getModel(), (AbstractFormPlugin)this, (int[])selectRows, (InspectDealArgs)inspectDealArgs);
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String oprKey;
        super.afterDoOperation(args);
        switch (oprKey = args.getOperateKey()) {
            case "previousentry": 
            case "nextentry": {
                InspectCkvalHelper.clickMaterialRow((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "newentry-inspitem": {
                InspectBillHelper.addNewItemEntry((IFormView)this.getView());
                break;
            }
            case "updatemeasures": {
                this.updateMeasureValues();
                break;
            }
            case "clearmeasures": {
                this.clearMeasureValuesConfirm();
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        super.beforeF7Select(e);
        BasedataEdit basedataEdit = (BasedataEdit)e.getSource();
        switch (key = basedataEdit.getKey()) {
            case "unit": {
                int rowIndex = e.getRow();
                DynamicObject material = (DynamicObject)this.getModel().getValue("materialid", rowIndex);
                ControlUtil.unitCheck((BeforeF7SelectEvent)e, (IFormView)this.getView(), (DynamicObject)material);
                break;
            }
            case "inspectionstd": {
                ControlUtil.setListSelectedMode((ListShowParameter)((ListShowParameter)e.getFormShowParameter()), (boolean)false);
                break;
            }
            case "matchflag": {
                InspectStdHelper.setFilterMatchflag((BeforeF7SelectEvent)e, (IDataModel)this.getModel(), (String)"inspsubentity", (String)"normtype");
                break;
            }
            case "joininspector": {
                QFilter qFilterx = UserUtil.getQualityOrgUserByOrgid((Long)DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"org").getLong("id"));
                e.addCustomQFilter(qFilterx);
                break;
            }
            case "inspectionitem": {
                this.getPageCache().put("inspRowIndex", String.valueOf(this.getModel().getEntryCurrentRowIndex("inspsubentity")));
                break;
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        String key;
        ControlUtil.setAfterF7InputPk((AfterF7SelectEvent)e);
        ListSelectedRowCollection selectedRowColls = e.getListSelectedRowCollection();
        if (selectedRowColls.isEmpty()) {
            return;
        }
        BasedataEdit basedataEdit = (BasedataEdit)e.getSource();
        switch (key = basedataEdit.getKey()) {
            case "inspectionstd": {
                this.inspectStdAfterF7(selectedRowColls, e.getCurrentRowIndex());
                break;
            }
            case "inspectionitem": {
                this.checkItemAfterF7(selectedRowColls, this.getModel().getEntryCurrentRowIndex("matintoentity"), Integer.parseInt(this.getPageCache().get("inspRowIndex")));
                break;
            }
        }
    }

    public void cellClick(CellClickEvent evt) {
        String fieldKey;
        EntryGrid source = (EntryGrid)evt.getSource();
        if (source == null) {
            return;
        }
        switch (fieldKey = evt.getFieldKey()) {
            case "sampckvalstr": 
            case "projckvalstr": {
                InspectCkvalHelper.showBillFieldForm((String)fieldKey, (IDataModel)this.getModel(), (IFormView)this.getView(), (IFormPlugin)this, (String)"backTabData", (Boolean)Boolean.FALSE);
                break;
            }
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        logger.info("\u68c0\u9a8c\u5355\u8c03\u7528\u56de\u8c03\u51fd\u6570\u5f00\u59cb...");
        switch (actionId = evt.getActionId()) {
            case "backTabData": {
                this.backTabDataCloseback(evt);
                break;
            }
            case "selectdata": {
                this.updateMeasureValCloseback(evt);
                break;
            }
            case "inspectpro": {
                EntryGrid entryGrid = (EntryGrid)this.getControl("matintoentity");
                int[] selectRows = entryGrid.getSelectRows();
                InspectDealArgs args = this.buildInspectDealArgs(selectRows);
                InspectProMatchHelper.updateInspectPro((ClosedCallBackEvent)evt, (int[])selectRows, (InspectDealArgs)args);
                break;
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "clearmeasurevalues": {
                this.clearMeasureValuesCallback(e);
                break;
            }
        }
    }

    private void materialChange(Object newValue, Object oldValue, int rowIndex, InspectProGlobalCache inspectProGlobalCache) {
        IDataModel model = this.getModel();
        if (oldValue != null) {
            model.setValue("materialqty", null, rowIndex);
            model.setValue("rinsqty", null, rowIndex);
        }
        if (newValue instanceof DynamicObject) {
            DynamicObject material = (DynamicObject)newValue;
            LotNumberHelper.lotnumberEnable((IDataModel)this.getModel(), (IFormView)this.getView(), (DynamicObject)material, (int)rowIndex, (Boolean)Boolean.TRUE);
        }
    }

    private void inspectStdChange(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (Objects.isNull(newValue)) {
            DataModelUtil.deleteSubEntry((IDataModel)model, (IFormView)view, (String)"matintoentity", (String)"inspsubentity", (int)rowIndex);
            InspectCkvalHelper.clearExampleInfo((IDataModel)model, (IFormView)view, (int)rowIndex);
        } else {
            DynamicObject entry = (DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("matintoentity").get(rowIndex);
            if (Objects.nonNull(entry.getDynamicObject("materialcfg"))) {
                DynamicObjectCollection projEntrys = entry.getDynamicObjectCollection("inspsubentity");
                projEntrys.clear();
                InspectProjModel projModel = new InspectProjModel(true);
                InspectStdHelper.setProjEntryByStd((DynamicObject)((DynamicObject)newValue), (DynamicObjectCollection)projEntrys, (InspectProjModel)projModel, (boolean)true);
                for (DynamicObject projEntry : projEntrys) {
                    projEntry.set("uquuid", (Object)Uuid16.create().toString());
                    projEntry.set("projckvalstr", (Object)InspectCkvalHelper.getCkValStr());
                }
                model.updateEntryCache(projEntrys);
                model.updateCache();
                InspectCommonHelper.updateSampAndProjSampQtyCommon((int)rowIndex, (IDataModel)this.getModel(), (IFormView)this.getView(), (BigDecimal)BigDecimal.ZERO, (Boolean)Boolean.FALSE);
                view.updateView("inspsubentity");
            }
        }
    }

    private void matchInspectPro(Set<Integer> rowIndexSet, InspectProGlobalCache inspectProGlobalCache) {
        InspectDealArgs args = new InspectDealArgs();
        args.setBillData(this.getModel().getDataEntity(true));
        args.setView(this.getView());
        args.setFactory((InspectProVoluationFactory)new InspectProVoluationJoinInspect());
        InspproVoluationKeyModel voluationKeyModel = args.getVoluationKeyModel();
        voluationKeyModel.setEntryKey("matintoentity");
        voluationKeyModel.setInspectStdKey("inspectionstd");
        args.setRowIndexSet(rowIndexSet);
        InspectProMatchHelper.inspectProDeal((InspectDealArgs)args, (InspectProGlobalCache)inspectProGlobalCache);
    }

    private void checkItemAfterF7(ListSelectedRowCollection selectedRowColls, int rowIndex, int curProjRowIndex) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection subProjEntrys = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"inspsubentity", (int)rowIndex);
        InspectProjModel projModel = new InspectProjModel(true);
        DynamicObjectCollection returnDyos = InspectStdHelper.checkItemAfterF7((int)curProjRowIndex, (ListSelectedRowCollection)selectedRowColls, (DynamicObjectCollection)subProjEntrys, (InspectProjModel)projModel);
        for (DynamicObject returnDyo : returnDyos) {
            for (String field : JoininspectConst.ITEM_AFTERF7_CLEARFIELDS) {
                returnDyo.set(field, null);
            }
            String uqUuid = returnDyo.getString("uquuid");
            if (kd.bos.util.StringUtils.isEmpty((String)uqUuid)) {
                returnDyo.set("uquuid", (Object)Uuid16.create().toString());
            }
            returnDyo.set("projckvalstr", (Object)InspectCkvalHelper.getCkValStr());
        }
        model.updateEntryCache(subProjEntrys);
        for (int i = 0; i < subProjEntrys.size(); ++i) {
            model.setValue("inspectionitem", ((DynamicObject)subProjEntrys.get(i)).get("inspectionitem"), i);
        }
        view.updateView("inspsubentity");
    }

    private void inspectStdAfterF7(ListSelectedRowCollection selectedRowColls, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObjectCollection projEntrys = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"inspsubentity", (int)rowIndex);
        projEntrys.clear();
        InspectProjModel projModel = new InspectProjModel(true);
        InspectStdHelper.inspectStdAfterF7((ListSelectedRowCollection)selectedRowColls, (DynamicObjectCollection)projEntrys, (InspectProjModel)projModel, (boolean)true);
        model.updateEntryCache(projEntrys);
        for (DynamicObject projEntry : projEntrys) {
            projEntry.set("uquuid", (Object)Uuid16.create().toString());
            projEntry.set("projckvalstr", (Object)InspectCkvalHelper.getCkValStr());
        }
        int selectLength = selectedRowColls.getEntryPrimaryKeyValues().length;
        if (selectLength > 1) {
            for (int i = selectLength; i > 1; --i) {
                model.deleteEntryRow("matintoentity", rowIndex + i - 1);
            }
        }
        for (DynamicObject inspsubEntry : projEntrys) {
            ControlUtil.setValueWithoutPropchange((IDataModel)model, (IFormView)this.getView(), (String)"projsamp", (Object)inspsubEntry.getDynamicObject("projsamp"), (int)(inspsubEntry.getInt("seq") - 1), (int)rowIndex);
        }
        InspectCommonHelper.updateSampAndProjSampQtyCommon((int)rowIndex, (IDataModel)this.getModel(), (IFormView)this.getView(), (BigDecimal)BigDecimal.ZERO, (Boolean)Boolean.FALSE);
        this.getView().updateView("matintoentity");
        EntryGrid matGrid = (EntryGrid)this.getControl("matintoentity");
        matGrid.selectRows(rowIndex);
    }

    private void transacTypeChange(DynamicObject oldValue, DynamicObject newValue) {
        if (Objects.nonNull(newValue)) {
            IDataModel model = this.getModel();
            this.initTransacTypeControl(newValue);
            boolean matchFlag = TransacTypeHelper.isChangeDimenOfTransacType((DynamicObject)oldValue, (DynamicObject)newValue);
            if (matchFlag) {
                HashSet<Integer> rowIndexSet = new HashSet<Integer>(16);
                for (int i = 0; i < model.getEntryRowCount("matintoentity"); ++i) {
                    rowIndexSet.add(i);
                }
                this.matchInspectPro(rowIndexSet, new InspectProGlobalCache());
            }
            this.updateSampleVal();
        }
    }

    private void initTransacTypeControl(DynamicObject transacType) {
        boolean inspItemMod = transacType.getBoolean("inspitemmodflg");
        this.getModel().setValue("inspitemmodflg", (Object)inspItemMod);
        this.getView().setVisible(Boolean.valueOf(inspItemMod), new String[]{"additem", "deleteitem", "selectjoininspect"});
        boolean ckvalFlag = transacType.getBoolean("ckvalflag");
        this.getView().setVisible(Boolean.valueOf(ckvalFlag), new String[]{"projckvalstr", "sampckvalstr", "updatemeasureitem"});
    }

    private void updateSampleVal() {
        IDataModel dm = this.getModel();
        DynamicObject billObj = dm.getDataEntity();
        String rule = InspectCommonHelper.getSampNumRule((DynamicObject)billObj);
        DynamicObjectCollection matEntrys = dm.getEntryEntity("matintoentity");
        for (int i = 0; i < matEntrys.size(); ++i) {
            DynamicObject matEntry = (DynamicObject)matEntrys.get(i);
            if (!DynamicObjPropUtil.isFirstDrawByDyo((DynamicObject)matEntry).booleanValue()) continue;
            DynamicObjectCollection subProjEntrys = matEntry.getDynamicObjectCollection("inspsubentity");
            this.setProjectSample(subProjEntrys, matEntry, rule);
            Optional<BigDecimal> maxProjSampQtyOpt = subProjEntrys.stream().map(o -> o.getBigDecimal("projsampqty")).max(Comparator.naturalOrder());
            if (!maxProjSampQtyOpt.isPresent()) continue;
            BigDecimal maxProjSamQty = maxProjSampQtyOpt.get();
            BigDecimal rinsQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)dm, (String)"rinsqty");
            if (null != rinsQty && maxProjSamQty.compareTo(rinsQty) <= 0) continue;
            dm.setValue("rinsqty", (Object)maxProjSamQty, i);
        }
        this.getView().updateView("inspsubentity");
    }

    private void setProjectSample(DynamicObjectCollection subProjEntrys, DynamicObject matEntry, String rule) {
        BigDecimal qty = matEntry.getBigDecimal("materialqty");
        DynamicObject unitObj = matEntry.getDynamicObject("unit");
        for (DynamicObject subProjEntry : subProjEntrys) {
            DynamicObject projSamp = subProjEntry.getDynamicObject("projsamp");
            if (!Objects.nonNull(projSamp)) continue;
            CkSampleCaleModel sampleModel = new CkSampleCaleModel(projSamp, qty, unitObj, rule);
            sampleModel.setSampeSchemObj(projSamp);
            CkSampleCaleResModel sampleResModel = InspectBillSampleHelper.getSampleInfo((CkSampleCaleModel)sampleModel);
            subProjEntry.set("projsamp", (Object)sampleResModel.getSampleSchemObj());
            subProjEntry.set("projsampqty", (Object)sampleResModel.getRinsQty());
            subProjEntry.set("projacceptqty", (Object)sampleResModel.getAcceptyQty());
        }
    }

    private void backTabDataCloseback(ClosedCallBackEvent evt) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String status = DynamicObjDataUtil.getDataModelStringData((IDataModel)model, (String)"billstatus");
        if ("A".equals(status)) {
            Object returnData = evt.getReturnData();
            logger.info("\u68c0\u9a8c\u5355\u56de\u8c03\u6570\u636e\uff1areturnData" + returnData);
            if (null != returnData) {
                HashMap retDataMap = (HashMap)returnData;
                InspectCkvalHelper.refreshSubSamp((Map)retDataMap, (IDataModel)model, (IFormView)view, (Boolean)Boolean.FALSE);
                InspectCkvalHelper.refreshSubInsp((Map)retDataMap, (IDataModel)model, (IFormView)view, (Boolean)Boolean.FALSE);
                InspectCkvalHelper.refreshBackTab((Map)retDataMap, (IDataModel)model, (IFormView)view);
                InspectCkvalHelper.refreshCkValStr((IDataModel)this.getModel(), (IFormView)view);
            }
        }
    }

    @Override
    public void callBiztypeChange(MessageBoxResult result) {
        super.callBiztypeChange(result);
        IDataModel model = this.getModel();
        switch (result) {
            case Yes: {
                model.deleteEntryData("matintoentity");
                this.getView().invokeOperation("newentry");
                CommonViewControlHelper.bizTypeChangeFieldVisible((IDataModel)model, (IFormView)this.getView());
                this.initTransacType();
                break;
            }
            case Cancel: {
                ControlUtil.setValueWithoutPropchange((IDataModel)model, (IFormView)this.getView(), (String)"biztype", (Object)this.getPageCache().get("biztypetmp"));
                break;
            }
        }
    }

    private void updateMeasureValCloseback(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData instanceof ListSelectedRowCollection) {
            LinkedList<InspItemInfo> inspItemInfos = this.buildInspItemInfos((ListSelectedRowCollection)returnData);
            JoinInspUpdateMeasureArgs args = new JoinInspUpdateMeasureArgs(inspItemInfos, (AbstractFormPlugin)this);
            PluginProxy<IJoinInspAfterUpdateMeasureVal> pluginProxy = this.getPluginProxy();
            pluginProxy.callAfter(p -> {
                p.afterSelectData(args);
                return null;
            });
            if (!args.isCancel()) {
                pluginProxy.callAfter(p -> {
                    p.afterUpdateView(args);
                    return null;
                });
            }
        }
    }

    private LinkedList<InspItemInfo> buildInspItemInfos(ListSelectedRowCollection returnData) {
        ListSelectedRowCollection selectedRows = returnData;
        Set<Object> billIdSet = selectedRows.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toSet());
        Set<Object> matRowIdSet = selectedRows.stream().map(x -> x.getEntryPrimaryKeyValue()).collect(Collectors.toSet());
        Set inspRowIdSet = selectedRows.stream().map(x -> x.getSubEntryPrimaryKeyValue()).collect(Collectors.toSet());
        HashSet<String> uquuidSet = new HashSet<String>(16);
        String inspItemSelectField = "id, matintoentity.id, matintoentity.inspsubentity.id, matintoentity.inspsubentity.inspectionitem, matintoentity.inspsubentity.inspectioncontent, matintoentity.inspsubentity.keyquality, matintoentity.inspsubentity.normtype, matintoentity.inspsubentity.uquuid";
        QFilter inspItemFilter = new QFilter("id", "in", billIdSet).and("matintoentity.id", "in", matRowIdSet).and("matintoentity.inspsubentity.id", "in", inspRowIdSet);
        String inspItemOrderBys = "id ASC, matintoentity.id ASC, matintoentity.inspsubentity.id ASC";
        DataSet inspItemDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.getView().getEntityId(), (String)inspItemSelectField, (QFilter[])inspItemFilter.toArray(), (String)inspItemOrderBys);
        LinkedList<InspItemInfo> inspItemInfos = new LinkedList<InspItemInfo>();
        while (inspItemDataSet.hasNext()) {
            this.addNewInspItem(inspItemInfos, inspItemDataSet.next(), uquuidSet);
        }
        this.completeMeasureValues(billIdSet, matRowIdSet, uquuidSet, inspItemInfos);
        LinkedList<InspItemInfo> orderByInspItemInfos = new LinkedList<InspItemInfo>();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            Object billId = listSelectedRow.getPrimaryKeyValue();
            Object matRowId = listSelectedRow.getEntryPrimaryKeyValue();
            Object inspSubRowId = listSelectedRow.getSubEntryPrimaryKeyValue();
            Optional<InspItemInfo> optional = inspItemInfos.stream().filter(x -> x.getBillId().equals(billId) && x.getMatRowId().equals(matRowId) && x.getInspRowid().equals(inspSubRowId)).findFirst();
            optional.ifPresent(x -> orderByInspItemInfos.add((InspItemInfo)x));
        }
        return orderByInspItemInfos;
    }

    private void completeMeasureValues(Set<Object> billIdSet, Set<Object> matRowIdSet, Set<String> uquuidSet, LinkedList<InspItemInfo> inspItemInfos) {
        String measureSelectField = "id, matintoentity.id, matintoentity.submeasuredvalentity.projuuid, matintoentity.submeasuredvalentity.samp_seq, matintoentity.submeasuredvalentity.measuredval_deter, matintoentity.submeasuredvalentity.measuredval_rat, matintoentity.submeasuredvalentity.measure_comment";
        QFilter measureFilter = new QFilter("id", "in", billIdSet).and("matintoentity.id", "in", matRowIdSet).and("matintoentity.submeasuredvalentity.projuuid", "in", uquuidSet);
        String measureOrderBys = "id ASC, matintoentity.id ASC, matintoentity.submeasuredvalentity.projuuid ASC, matintoentity.submeasuredvalentity.samp_seq ASC";
        DataSet measureDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.getView().getEntityId(), (String)measureSelectField, (QFilter[])measureFilter.toArray(), (String)measureOrderBys);
        while (measureDataSet.hasNext()) {
            Row row = measureDataSet.next();
            String measureRatStr = row.getString("matintoentity.submeasuredvalentity.measuredval_rat");
            BigDecimal measureRat = null;
            if (BigDecimalUtil.stringIsDouble((String)measureRatStr)) {
                measureRat = new BigDecimal(measureRatStr);
            }
            InspItemInfo.MeasureValue measureValue = new InspItemInfo.MeasureValue(row.getString("matintoentity.submeasuredvalentity.measuredval_deter"), measureRat, row.getString("matintoentity.submeasuredvalentity.measure_comment"));
            Optional<InspItemInfo> optional = inspItemInfos.stream().filter(x -> x.getBillId().equals(row.getLong("id")) && x.getMatRowId().equals(row.getLong("matintoentity.id")) && x.getUquuid().equals(row.getString("matintoentity.submeasuredvalentity.projuuid"))).findFirst();
            optional.ifPresent(x -> x.getMeasureValues().add(measureValue));
        }
    }

    private void addNewInspItem(LinkedList<InspItemInfo> inspItemInfos, Row row, Set<String> uquuidSet) {
        String uquuid = row.getString("matintoentity.inspsubentity.uquuid");
        InspItemInfo inspItemInfo = new InspItemInfo(row.getLong("matintoentity.inspsubentity.inspectionitem"), row.getString("matintoentity.inspsubentity.inspectioncontent"), row.getString("matintoentity.inspsubentity.keyquality"), row.getString("matintoentity.inspsubentity.normtype"), row.getLong("id"), row.getLong("matintoentity.id"), row.getLong("matintoentity.inspsubentity.id"), uquuid);
        LinkedList measureVals = new LinkedList();
        inspItemInfo.setMeasureValues(measureVals);
        inspItemInfos.add(inspItemInfo);
        uquuidSet.add(uquuid);
    }

    private void updateMeasureValues() {
        JoinInspUpdateMeasureArgs args = new JoinInspUpdateMeasureArgs((AbstractFormPlugin)this);
        PluginProxy<IJoinInspAfterUpdateMeasureVal> pluginProxy = this.getPluginProxy();
        pluginProxy.callAfter(p -> {
            p.beforeBuildListShowParameter(args);
            return null;
        });
        if (args.isCancel()) {
            return;
        }
        String entityId = this.getView().getEntityId();
        String entityLayoutId = (String)args.getListLayOutReflex().get(entityId);
        String formId = null == entityLayoutId ? entityId : entityLayoutId;
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)formId, (boolean)true, (int)0, (boolean)false);
        args.setListShowParameter(listShowParameter);
        pluginProxy.callAfter(p -> {
            p.afterBuildListShowParameter(args);
            return null;
        });
        if (!args.isCancel()) {
            this.getView().showForm((FormShowParameter)args.getListShowParameter());
        }
    }

    private void clearMeasureValues() {
        IFormView view = this.getView();
        EntryGrid inspSubGrid = (EntryGrid)view.getControl("inspsubentity");
        int[] selectRows = inspSubGrid.getSelectRows();
        int length = selectRows.length;
        LinkedList<InspItemInfo> inspItemInfos = new LinkedList<InspItemInfo>();
        for (int i = 0; i < length; ++i) {
            inspItemInfos.add(new InspItemInfo());
        }
        JoinInspUpdateMeasureArgs args = new JoinInspUpdateMeasureArgs(inspItemInfos, (AbstractFormPlugin)this);
        args.setOperate("clear");
        PluginProxy<IJoinInspAfterUpdateMeasureVal> pluginProxy = this.getPluginProxy();
        pluginProxy.callAfter(p -> {
            p.afterUpdateView(args);
            return null;
        });
    }

    private PluginProxy<IJoinInspAfterUpdateMeasureVal> getPluginProxy() {
        JoinInspUpdateMeasureValImpl defaultPlugin = new JoinInspUpdateMeasureValImpl();
        return PluginProxy.create((Object)defaultPlugin, IJoinInspAfterUpdateMeasureVal.class, (String)"QMC_QCBD_JOININSP_UPDATE_MEASUREVAL", null);
    }

    private void clearMeasureValuesConfirm() {
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)view.getControl("inspsubentity");
        int count = entryGrid.getSelectRows().length;
        if (0 == count) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u68c0\u9a8c\u9879\u76ee\u5206\u5f55\u3002", (String)"JoinInspectBillPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
            return;
        }
        ConfirmCallBackListener listener = new ConfirmCallBackListener("clearmeasurevalues", (IFormPlugin)this);
        view.showConfirm(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684%s\u6761\u5206\u5f55\u6e05\u7a7a\u5b9e\u6d4b\u503c\u540e\u5c06\u4e0d\u80fd\u6062\u590d\uff0c\u786e\u5b9a\u8981\u6e05\u7a7a\u5b9e\u6d4b\u503c\u5417\uff1f", (String)"JoinInspectBillPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), count), MessageBoxOptions.OKCancel, listener);
    }

    private void clearMeasureValuesCallback(MessageBoxClosedEvent e) {
        switch (e.getResult()) {
            case Yes: {
                this.clearMeasureValues();
                break;
            }
            case Cancel: {
                break;
            }
        }
    }

    private InspectDealArgs buildInspectDealArgs(int[] selectRows) {
        InspectDealArgs args = new InspectDealArgs();
        args.setBillData(this.getModel().getDataEntity(true));
        args.setView(this.getView());
        args.setFactory((InspectProVoluationFactory)new InspectProVoluationJoinInspect());
        InspproVoluationKeyModel voluationKeyModel = args.getVoluationKeyModel();
        voluationKeyModel.setEntryKey("matintoentity");
        voluationKeyModel.setInspectStdKey("inspectionstd");
        if (selectRows.length != 0) {
            HashSet<Integer> rowIndexSet = new HashSet<Integer>();
            rowIndexSet.add(selectRows[0]);
            args.setRowIndexSet(rowIndexSet);
        }
        return args;
    }
}

