/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.inspection;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class SampleChoosePlugin
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map sampIdMap = (Map)parameter.getCustomParam("sampIdMap");
        JSONArray chooseIds = (JSONArray)parameter.getCustomParam("chooseIds");
        String takedamp = (String)parameter.getCustomParam("takesamp");
        Boolean isTakesamp = null == takedamp || Boolean.parseBoolean(takedamp);
        model.setValue("takesamp", (Object)isTakesamp);
        List sortedIds = sampIdMap.keySet().stream().sorted().collect(Collectors.toList());
        int size = sortedIds.size();
        int[] rows = model.batchCreateNewEntryRow("sampentity", size);
        for (int i = 0; i < size; ++i) {
            String sampIdStr = (String)sortedIds.get(i);
            Long sampId = Long.valueOf(sampIdStr);
            int rowIndex = rows[i];
            model.setValue("sampnoid", (Object)sampIdStr, rowIndex);
            model.setValue("sampno", sampIdMap.get(sampIdStr), rowIndex);
            if (!chooseIds.contains((Object)sampId)) continue;
            model.setValue("choose", (Object)Boolean.TRUE, rowIndex);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
            this.retChooseSamp();
            this.getView().close();
        } else if ("btncancel".equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    private void retChooseSamp() {
        HashMap<String, Object> retParam = new HashMap<String, Object>(16);
        Map<Long, String> sampIdMap = this.getModel().getEntryEntity("sampentity").stream().filter(x -> x.getBoolean("choose")).collect(Collectors.toMap(x -> x.getLong("sampnoid"), x -> x.getString("sampno")));
        retParam.put("sampIdMap", sampIdMap);
        retParam.put("takesamp", this.getModel().getValue("takesamp"));
        this.getView().returnDataToParent(retParam);
    }
}

