/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.qualitypanel;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class InspectResSumPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String POST_PARAM = "postParam";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addContainerClickListener("sendqtycontainer", "qualifyvaluepanel", "unqualifyvaluepanel");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshKanBan();
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Container) {
            String containerKey;
            Container container = (Container)source;
            switch (containerKey = container.getKey()) {
                case "sendqtycontainer": {
                    this.showBillLists("apply_type");
                    break;
                }
                case "qualifyvaluepanel": {
                    this.showBillLists("inspect_type");
                    break;
                }
                case "unqualifyvaluepanel": {
                    this.showBillLists("baddeal_type");
                    break;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "refresh": {
                this.refreshKanBan();
                break;
            }
        }
    }

    private void addContainerClickListener(String ... containerNames) {
        for (String containerName : containerNames) {
            Container billnoflexpanelap = (Container)this.getControl(containerName);
            billnoflexpanelap.addClickListener((ClickListener)this);
        }
    }

    private JSONObject getBillInfoPostParam(String entityType) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        JSONObject postParam = (JSONObject)view.getFormShowParameter().getCustomParam(POST_PARAM);
        JSONObject clonePostParam = postParam.clone();
        int rowIndex = model.getEntryCurrentRowIndex("inspectentry");
        Long entryId = DynamicObjDataUtil.getDataModelLongData((IDataModel)model, (String)"srcentryid", (int)rowIndex);
        clonePostParam.put("call_type", (Object)"E");
        clonePostParam.put("call_entryid", (Object)entryId);
        clonePostParam.put("entityType", (Object)entityType);
        return clonePostParam;
    }

    private void refreshKanBan() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection inspectEntry = model.getEntryEntity("inspectentry");
        inspectEntry.clear();
        JSONObject postParam = (JSONObject)view.getFormShowParameter().getCustomParam(POST_PARAM);
        if (null == postParam || postParam.isEmpty()) {
            return;
        }
        Map retParam = (Map)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"InspectResultService", (String)"getInspectKanBanResult", (Object[])new Object[]{postParam});
        if (!((Boolean)retParam.get("successful")).booleanValue()) {
            view.showErrorNotification(retParam.get("message").toString());
            return;
        }
        List data = (List)retParam.get("data");
        for (Map entryData : data) {
            DynamicObject newEntry = inspectEntry.addNew();
            newEntry.set("srcentryid", entryData.get("call_entryid"));
            newEntry.set("material", entryData.get("material_id"));
            newEntry.set("materialnumber", entryData.get("material_number"));
            newEntry.set("materialname", this.emptyReplace(entryData.get("material_name")));
            String modelnum = String.valueOf(entryData.get("material_modelnum"));
            newEntry.set("materialmodelnum", (Object)(StringUtils.isNotEmpty((CharSequence)modelnum) ? modelnum : "-"));
            newEntry.set("qty", entryData.get("material_qty"));
            newEntry.set("unit", entryData.get("unit_id"));
            newEntry.set("unitshow", entryData.get("unit_name"));
            newEntry.set("sendqty", entryData.get("send_qty"));
            newEntry.set("qualifyqty", entryData.get("qualified_qty"));
            StringBuilder handModeName = new StringBuilder();
            StringBuilder unqualifyQtyStr = new StringBuilder();
            handModeName.append(ResManager.loadKDString((String)"\u4e0d\u5408\u683c\u603b\u6570\uff1a", (String)"InspectResSumPlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            handModeName.append(System.lineSeparator());
            unqualifyQtyStr.append(((BigDecimal)entryData.get("baddeal_qty")).toPlainString());
            unqualifyQtyStr.append(System.lineSeparator());
            Object unqualifiedInfo = entryData.get("unqualified_info");
            if (!(unqualifiedInfo instanceof List)) continue;
            StringBuilder handMode = new StringBuilder();
            for (Object unqualifiedInfoObj : (List)unqualifiedInfo) {
                Map infoMap = (Map)unqualifiedInfoObj;
                handMode.append(infoMap.get("handmodeid"));
                handMode.append("#");
                handModeName.append(infoMap.get("handmodename"));
                handModeName.append("\uff1a");
                handModeName.append(System.lineSeparator());
                unqualifyQtyStr.append(((BigDecimal)infoMap.get("unqualified_qty")).toPlainString());
                unqualifyQtyStr.append(System.lineSeparator());
            }
            newEntry.set("handmode", (Object)handMode.toString());
            newEntry.set("handmodename", this.emptyReplace(handModeName.toString()));
            newEntry.set("unqulifyqtystr", (Object)unqualifyQtyStr.toString());
        }
        model.updateEntryCache(inspectEntry);
        view.updateView("inspectentry");
    }

    private void showBillLists(String entityType) {
        JSONObject postParam = this.getBillInfoPostParam(entityType);
        Map billInfos = (Map)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"InspectResultService", (String)"getTbillInfos", (Object[])new Object[]{postParam});
        Set entrySet = billInfos.entrySet();
        for (Map.Entry entry : entrySet) {
            this.showFormList((String)entry.getKey(), (Set)entry.getValue());
        }
    }

    private void showFormList(String entity, Set<Object> idSet) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)entity, (boolean)true, (int)0, (boolean)false);
        listShowParameter.getCustomParams().put("ignoreDefaultFilter", "true");
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        filters.add(new QFilter("id", "in", idSet));
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private Object emptyReplace(Object origin) {
        if (origin instanceof String) {
            if (StringUtils.isEmpty((CharSequence)origin.toString())) {
                return "-";
            }
            return origin;
        }
        return origin;
    }
}

