/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.repairtool;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.business.repairtool.DataRepairUpgradeHelper;
import kd.qmc.qcbd.common.errorcode.QmcErrorCode;
import kd.qmc.qcbd.common.errorcode.QmcErrorCodeUtils;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.MainEntityTypeUtil;
import kd.qmc.qcbd.formplugin.repairtool.model.RepairToolModel;
import kd.qmc.qcbd.formplugin.repairtool.task.RepaireBillTypeTask;
import kd.qmc.qcbd.formplugin.repairtool.task.RepaireBizTypeTask;
import kd.qmc.qcbd.formplugin.repairtool.task.RepaireInspectCfgTask;
import kd.qmc.qcbd.formplugin.repairtool.task.RepaireInspproBiztypeTask;
import kd.qmc.qcbd.formplugin.repairtool.task.RepaireTransacTypeTask;

public class RepairToolFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
TabSelectListener {
    private static final String QMC_REPAIRDATA_FIX = "qmc_repairdata_";
    private static final String TASK_TASKINFO = "taskinfo";
    private static final String TASK_ATTRKEY = "attrkey";
    private static final String QCBD_SELECTDATA = "qcbd_selectdata";
    private static final Log logger = LogFactory.getLog(RepairToolFormPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit f7Control;
        super.registerListener(e);
        Button btnnext = (Button)this.getControl("btnnext");
        btnnext.addClickListener((ClickListener)this);
        Button btnprev = (Button)this.getControl("btnprev");
        btnprev.addClickListener((ClickListener)this);
        Button btnvaliddata = (Button)this.getControl("btnvaliddata");
        btnvaliddata.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"selectdata"});
        Tab tabGuidecontent = (Tab)this.getView().getControl("guidecontent");
        if (tabGuidecontent != null) {
            tabGuidecontent.addTabSelectListener((TabSelectListener)this);
            tabGuidecontent.addItemClickListener((ItemClickListener)this);
        }
        if (null != (f7Control = (BasedataEdit)this.getView().getControl("entity"))) {
            f7Control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (f7Control = (BasedataEdit)this.getView().getControl("biztype"))) {
            f7Control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (f7Control = (BasedataEdit)this.getView().getControl("biztype_pro"))) {
            f7Control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (f7Control = (BasedataEdit)this.getView().getControl("entryobjectid"))) {
            f7Control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.addEntryKeyData(this.getTabRepairToolModelLst());
        this.setInspproBiztypeCombo();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String sourceId = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (sourceId) {
            case "entity": {
                QFilter qFilter = new QFilter("bizapp.bizcloud.number", "=", (Object)"QMC");
                qFilter.and("number", "not like", (Object)"%_ext");
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "biztype": {
                showParameter.getListFilterParameter().setFilter(new QFilter("domain", "=", (Object)"8"));
                break;
            }
            case "biztype_pro": {
                this.bitypeProBeforeF7(evt, showParameter);
                break;
            }
            case "entryobjectid": {
                RepairToolModel model = this.getTabModel();
                QFilter qfilters = new QFilter("1", "!=", (Object)"1");
                if (model != null) {
                    qfilters = new QFilter("number", "in", model.getEntitynumbers());
                }
                showParameter.getListFilterParameter().setFilter(qfilters);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "datarepair": {
                if (!DynamicObjDataUtil.getDataModelBooleanData((IDataModel)this.getModel(), (String)"isbyfixbill").booleanValue() || !StringUtils.isBlank((CharSequence)DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)"dataid_tag"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"RepairToolFormPlugin_9", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String oprKey;
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (oprKey = source.getOperateKey()) {
            case "datarepair": {
                RepairToolModel model = this.getTabModel();
                if (model == null) break;
                this.dispatch(model);
                break;
            }
            case "tag_no": {
                RepairToolModel model = this.getTabModel();
                if (model == null) break;
                DataRepairUpgradeHelper.updateDataStatus((String)model.getAttrkey(), (String)"0");
                break;
            }
            case "tag_yes": {
                RepairToolModel model = this.getTabModel();
                if (model == null) break;
                DataRepairUpgradeHelper.updateDataStatus((String)model.getAttrkey(), (String)"1");
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control ctl = (Control)evt.getSource();
        switch (ctl.getKey()) {
            case "btnnext": 
            case "btnprev": {
                this.isRepairValidBeforeClick(evt);
                break;
            }
            case "btnvaliddata": {
                this.valiData(evt);
                break;
            }
            case "selectdata": {
                this.openSelectData();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"biztype_combo", (CharSequence)propName)) {
            this.getModel().setValue("biztype_pro", null);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        DynamicObject entryobjectidObjs;
        String number;
        RepairToolModel model = this.getTabModel();
        IDataModel dm = this.getModel();
        List<Object> entityNumbers = new ArrayList();
        if (Objects.nonNull(model)) {
            entityNumbers = model.getEntitynumbers();
        }
        String string = number = (entryobjectidObjs = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"entryobjectid")) == null ? "" : entryobjectidObjs.getString("number");
        if (!entityNumbers.contains(number)) {
            dm.setValue("entryobjectid", null);
            dm.setValue("dataid", null);
            dm.setValue("dataid_tag", null);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)number, (CharSequence)"")) {
            dm.setValue("dataid", null);
            dm.setValue("dataid_tag", null);
        }
    }

    private List<RepairToolModel> getTabRepairToolModelLst() {
        ArrayList<RepairToolModel> toolLst = new ArrayList<RepairToolModel>(16);
        toolLst.add(new RepairToolModel("tabpageap", "biztype_updata", ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"RepairToolFormPlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), Collections.singletonList("qcbd_biztype"), new RepaireBizTypeTask()));
        toolLst.add(new RepairToolModel("tabpageap1", "billtype_updata", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"RepairToolFormPlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), Collections.singletonList("bos_billtype"), new RepaireBillTypeTask()));
        toolLst.add(new RepairToolModel("tabpageap2", "bd_inspect_cfg_updata", ResManager.loadKDString((String)"\u7269\u6599\u8d28\u68c0\u4fe1\u606f", (String)"RepairToolFormPlugin_2", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), Collections.singletonList("bd_inspect_cfg"), new RepaireInspectCfgTask()));
        List allLst = MainEntityTypeUtil.getInheritChildNumberLst((String[])new String[]{"qcp_baddealpbill", "qcp_inspecpbill", "qcp_inspecapplypbill", "qcbd_joininspect", "qcbd_acceptrecord"});
        toolLst.add(new RepairToolModel("tabpageap3", "transactype_updata", ResManager.loadKDString((String)"\u8d28\u68c0\u4e8b\u52a1\u7c7b\u578b", (String)"RepairToolFormPlugin_7", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), allLst, new RepaireTransacTypeTask()));
        toolLst.add(new RepairToolModel("tabpageap4", "insppro_biztype_updata", ResManager.loadKDString((String)"\u68c0\u9a8c\u65b9\u6848-\u4e1a\u52a1\u7c7b\u578b\u5b57\u6bb5", (String)"RepairToolFormPlugin_8", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), Collections.singletonList("qcbd_inspectpro"), new RepaireInspproBiztypeTask()));
        return toolLst;
    }

    private void dispatch(RepairToolModel model) {
        if (model == null || model.getFactory() == null) {
            return;
        }
        String className = model.getFactory().getClass().getName();
        String jobName = QMC_REPAIRDATA_FIX + className;
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("qcbd");
        jobInfo.setJobType(JobType.REALTIME);
        String jobCaption = ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u6267\u884c\u8fdb\u5ea6", (String)"RepairToolFormPlugin_10", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]);
        jobInfo.setName(jobCaption);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(className);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(TASK_ATTRKEY, model.getAttrkey());
        this.setFvIniParams(params);
        model.getFactory().initParam(this.getView(), params);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, jobName);
        JobForm.dispatch((JobInfo)jobInfo, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    private void setFvIniParams(Map<String, Object> params) {
        IDataModel dm = this.getModel();
        params.put("isrepairestard", DynamicObjDataUtil.getDataModelBooleanData((IDataModel)dm, (String)"isrepairestard"));
        params.put("isbyfixbill", DynamicObjDataUtil.getDataModelBooleanData((IDataModel)dm, (String)"isbyfixbill"));
        DynamicObject entryobjectidObjs = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"entryobjectid");
        String number = entryobjectidObjs == null ? "" : entryobjectidObjs.getString("number");
        params.put("entryobjectid", number);
        params.put("dataid_tag", DynamicObjDataUtil.getDataModelStringData((IDataModel)dm, (String)"dataid_tag"));
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (actionId.contains(QMC_REPAIRDATA_FIX)) {
            this.updateRepairDataRes(returnData);
        } else if (QCBD_SELECTDATA.equals(actionId) && returnData != null) {
            this.getModel().setValue("dataid_tag", returnData);
            this.getModel().setValue("dataid", (Object)"selected part data");
        }
    }

    private void addEntryKeyData(List<RepairToolModel> models) {
        DynamicObject[] colls;
        QFilter qfilters = new QFilter("number", "=", (Object)"qmc_dataupdate_S");
        for (DynamicObject coll : colls = BusinessDataServiceHelper.load((String)"qcbd_sysconfig", (String)"entryentity.seq,entryentity.attrkey,entryentity.attrvalue,entryentity.attrkeycaption", (QFilter[])qfilters.toArray())) {
            DynamicObjectCollection entryObjs = coll.getDynamicObjectCollection("entryentity");
            for (RepairToolModel model : models) {
                Optional<DynamicObject> opObj = entryObjs.stream().filter(p -> StringUtils.equalsIgnoreCase((CharSequence)p.getString(TASK_ATTRKEY), (CharSequence)model.getAttrkey())).findAny();
                if (opObj.isPresent()) continue;
                DynamicObject entryObj = entryObjs.addNew();
                entryObj.set(TASK_ATTRKEY, (Object)model.getAttrkey());
                entryObj.set("attrvalue", (Object)"1");
                String tabkey = model.getTabkey();
                String tabkeySuffix = tabkey.substring(tabkey.length() - 1);
                if (!tabkeySuffix.matches("^[+-]?\\d+[.\\d]?\\d*+$")) {
                    entryObj.set("seq", (Object)0);
                } else {
                    entryObj.set("seq", (Object)Integer.valueOf(tabkeySuffix));
                }
                entryObj.set("attrkeycaption", (Object)model.getAttrkeyCaption());
            }
        }
        SaveServiceHelper.save((DynamicObject[])colls);
    }

    private Boolean isRepairValidBeforeClick(BeforeClickEvent evt) {
        Optional<DynamicObject> other;
        Boolean isRepairFlag = Boolean.TRUE;
        RepairToolModel model = this.getTabModel();
        if (model == null) {
            return isRepairFlag;
        }
        QFilter qfilters = new QFilter("number", "=", (Object)"qmc_dataupdate_S");
        qfilters.and("entryentity.attrkey", "=", (Object)model.getAttrkey());
        DynamicObjectCollection configObjs = QueryServiceHelper.query((String)"qcbd_sysconfig", (String)"entryentity.attrkey,entryentity.attrvalue", (QFilter[])qfilters.toArray());
        Optional<DynamicObject> excuting = configObjs.stream().filter(p -> StringUtils.equalsIgnoreCase((CharSequence)p.getString("entryentity.attrvalue"), (CharSequence)"2")).findAny();
        String strMsg = "";
        if (excuting.isPresent()) {
            strMsg = ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RepairToolFormPlugin_3", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]);
        }
        if ((other = configObjs.stream().filter(p -> !StringUtils.equalsIgnoreCase((CharSequence)p.getString("entryentity.attrvalue"), (CharSequence)"1")).findAny()).isPresent()) {
            strMsg = ResManager.loadKDString((String)"\u70b9\u51fb\u6570\u636e\u4fee\u590d\u6309\u94ae\uff0c\u5b8c\u6210\u4fee\u590d\u540e\u65b9\u53ef\u70b9\u51fb\u4e0a\u4e00\u6b65\u6216\u4e0b\u4e00\u6b65\u6309\u94ae\u3002", (String)"RepairToolFormPlugin_4", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]);
        }
        if (strMsg.length() > 0) {
            isRepairFlag = Boolean.FALSE;
            QmcErrorCodeUtils.showMessge((IFormView)this.getView(), (QmcErrorCode)QmcErrorCodeUtils.create((String)"repaircode", (String)strMsg));
            evt.setCancel(true);
        }
        return isRepairFlag;
    }

    private void valiData(BeforeClickEvent evt) {
        Boolean isRepairFlag = Boolean.TRUE;
        RepairToolModel model = this.getTabModel();
        if (model == null) {
            return;
        }
        this.setValidMessage(evt, model, isRepairFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValidMessage(BeforeClickEvent evt, RepairToolModel model, Boolean validFlag) {
        block6: {
            String strMsg = "";
            if (model == null || model.getFactory() == null) {
                return;
            }
            try {
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put(TASK_ATTRKEY, model.getAttrkey());
                this.setFvIniParams(params);
                model.getFactory().initParam(this.getView(), params);
                strMsg = model.getFactory().validData(params);
                if (strMsg == null || strMsg.length() <= 0) break block6;
                validFlag = Boolean.FALSE;
            }
            catch (Exception ex) {
                try {
                    strMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
                    logger.error("validData:" + strMsg);
                    if (strMsg == null || strMsg.length() <= 0) break block6;
                    validFlag = Boolean.FALSE;
                }
                catch (Throwable throwable) {
                    if (strMsg != null && strMsg.length() > 0) {
                        validFlag = Boolean.FALSE;
                        strMsg = String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u672a\u901a\u8fc7\uff1a%s", (String)"RepairToolFormPlugin_5", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), strMsg);
                        QmcErrorCodeUtils.showMessge((IFormView)this.getView(), (QmcErrorCode)QmcErrorCodeUtils.create((String)"repaircode", (String)strMsg));
                        evt.setCancel(true);
                    }
                    throw throwable;
                }
                strMsg = String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u672a\u901a\u8fc7\uff1a%s", (String)"RepairToolFormPlugin_5", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), strMsg);
                QmcErrorCodeUtils.showMessge((IFormView)this.getView(), (QmcErrorCode)QmcErrorCodeUtils.create((String)"repaircode", (String)strMsg));
                evt.setCancel(true);
            }
            strMsg = String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u672a\u901a\u8fc7\uff1a%s", (String)"RepairToolFormPlugin_5", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), strMsg);
            QmcErrorCodeUtils.showMessge((IFormView)this.getView(), (QmcErrorCode)QmcErrorCodeUtils.create((String)"repaircode", (String)strMsg));
            evt.setCancel(true);
        }
    }

    private RepairToolModel getTabModel() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        return this.getTabRepairToolModel(currentTab);
    }

    private RepairToolModel getTabRepairToolModel(String tabkey) {
        List<RepairToolModel> toolLst = this.getTabRepairToolModelLst();
        Optional<RepairToolModel> modelOpt = toolLst.stream().filter(p -> StringUtils.equalsIgnoreCase((CharSequence)p.getTabkey(), (CharSequence)tabkey)).findFirst();
        RepairToolModel model = null;
        if (modelOpt.isPresent()) {
            model = modelOpt.get();
        }
        return model;
    }

    private void updateRepairDataRes(Object returnData) {
        String taskInfoStr;
        TaskInfo taskInfo;
        if (returnData == null) {
            return;
        }
        Map result = (Map)returnData;
        if (result.containsKey(TASK_TASKINFO) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)(taskInfoStr = (String)result.get(TASK_TASKINFO)), TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            HashMap reData = (HashMap)JSON.parseObject((String)data, HashMap.class);
            Boolean issuncess = Boolean.parseBoolean(reData.get("success").toString());
            if (issuncess.booleanValue()) {
                QmcErrorCodeUtils.showMessge((IFormView)this.getView(), (QmcErrorCode)QmcErrorCodeUtils.create((String)"repaircode", (String)ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"RepairToolFormPlugin_6", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), (int)4));
            } else {
                String errMsg = "";
                if (reData.get("errMsg") != null) {
                    errMsg = reData.get("errMsg").toString();
                }
                QmcErrorCodeUtils.showMessge((IFormView)this.getView(), (QmcErrorCode)QmcErrorCodeUtils.create((String)"repaircode", (String)("error:" + errMsg)));
            }
        }
    }

    private void setInspproBiztypeCombo() {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"qcbd_inspectpro");
        Map fieldMap = mainEntityType.getAllFields();
        ComboProp bizTypeCombo = (ComboProp)fieldMap.get("biztype");
        List inspproComboList = bizTypeCombo.getComboItems();
        ArrayList<ComboItem> curComboList = new ArrayList<ComboItem>(inspproComboList.size());
        ArrayList<ValueMapItem> curComboModelList = new ArrayList<ValueMapItem>(inspproComboList.size());
        for (ValueMapItem item : inspproComboList) {
            String itemStr = item.getValue();
            LocaleString itemName = item.getName();
            String itemNameStr = itemName.getLocaleValue();
            itemNameStr = itemNameStr + "(" + itemStr + ")";
            ComboItem comItem = new ComboItem();
            LocaleString setItemName = new LocaleString(itemNameStr);
            comItem.setValue(itemStr);
            comItem.setCaption(setItemName);
            curComboList.add(comItem);
            ValueMapItem valueMapItem = new ValueMapItem();
            valueMapItem.setValue(itemStr);
            valueMapItem.setName(itemName);
            curComboModelList.add(valueMapItem);
        }
        ComboEdit biztypeCombo = (ComboEdit)this.getView().getControl("biztype_combo");
        biztypeCombo.setComboItems(curComboList);
        ComboProp property = (ComboProp)this.getModel().getProperty("biztype_combo");
        property.setComboItems(curComboModelList);
    }

    private void openSelectData() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(QCBD_SELECTDATA);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        String entityId = this.getEntityId();
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            return;
        }
        fsp.setCustomParam("entityid", (Object)entityId);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, QCBD_SELECTDATA));
        this.getView().showForm(fsp);
    }

    private String getEntityId() {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("entryobjectid");
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"KsqlToolBillPlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            return "";
        }
        return dynamicObject.getString("number");
    }

    private void bitypeProBeforeF7(BeforeF7SelectEvent evt, ListShowParameter showParameter) {
        String bizTypeOldValue = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)"biztype_combo");
        if (StringUtils.isBlank((CharSequence)bizTypeOldValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u68c0\u9a8c\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"RepairToolFormPlugin_11", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
        }
        DynamicObject inspproBiztypeReflex = BusinessDataServiceHelper.loadSingleFromCache((Object)1597180334154288128L, (String)"qcbd_sysconfig");
        DynamicObjectCollection reflexEntrys = inspproBiztypeReflex.getDynamicObjectCollection("entryentity");
        Optional<DynamicObject> bizTypeOpt = reflexEntrys.stream().filter(o -> StringUtils.equals((CharSequence)bizTypeOldValue, (CharSequence)o.getString(TASK_ATTRKEY))).findFirst();
        Long biztypeId = 0L;
        if (bizTypeOpt.isPresent()) {
            biztypeId = bizTypeOpt.get().getLong("attrvalue");
        }
        QFilter qFilter = new QFilter("domain", "=", (Object)"8");
        if (biztypeId > 0L) {
            qFilter.and("id", "=", (Object)biztypeId);
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
    }
}

