/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.repairtool.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.UpgradeSqlUtil;
import kd.qmc.qcbd.formplugin.repairtool.factory.IRepairToolUpdateTask;
import kd.qmc.qcbd.formplugin.repairtool.task.RepaireBaseTask;

public class RepaireInspproBiztypeTask
extends RepaireBaseTask
implements IRepairToolUpdateTask {
    @Override
    public void initParam(IFormView fv, Map<String, Object> params) {
        super.initParam(fv, params);
        IDataModel model = fv.getModel();
        DynamicObject biztypeDyo = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"biztype_pro");
        if (Objects.nonNull(biztypeDyo)) {
            Long bizTypeId = biztypeDyo.getLong("id");
            params.put("biztypeid", bizTypeId);
        }
        String biztypeStr = DynamicObjDataUtil.getDataModelStringData((IDataModel)model, (String)"biztype_combo");
        params.put("biztypestr", biztypeStr);
        ComboProp biztypeCombo = (ComboProp)model.getProperty("biztype_combo");
        for (ValueMapItem comboItem : biztypeCombo.getComboItems()) {
            if (!StringUtils.equals((CharSequence)biztypeStr, (CharSequence)comboItem.getValue())) continue;
            params.put("biztypename", comboItem.getName().getLocaleValue());
        }
        DynamicObjectCollection dimenDyoCol = DynamicObjDataUtil.getDataModelDynamicObjectCollectionData((IDataModel)model, (String)"promatchdimen");
        if (!CollectionUtils.isEmpty((Collection)dimenDyoCol)) {
            Set dimenPkSet = dimenDyoCol.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toSet());
            params.put("dimen", dimenPkSet);
        }
    }

    @Override
    public String validData(Map<String, Object> params) {
        super.validData(params);
        String algoKey = this.getClass().getName();
        DBRoute routeQmc = new DBRoute("qmc");
        StringBuilder validMgs = new StringBuilder("old biztype value ");
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fbizstypeid from t_qcbd_inspectpro where fbiztypeid = 0 and fbizstypeid !=' ' group by fbizstypeid", new Object[0]);
        DataSet rows = DB.queryDataSet((String)algoKey, (DBRoute)routeQmc, (SqlBuilder)sql);
        for (Row row : rows) {
            String oldBiztypeValue = row.getString("fbizstypeid");
            validMgs.append(oldBiztypeValue);
            validMgs.append("\uff0c");
        }
        validMgs.deleteCharAt(validMgs.length() - 1);
        validMgs.append("has not repaired\u3002");
        SqlBuilder sqlDimen = new SqlBuilder();
        sqlDimen.append("select top 1 a.fid t_qcbd_inspectpro a left join t_qcbd_pro_mulpmd b on a.fid = b.fid where b.fid is null;", new Object[0]);
        rows = DB.queryDataSet((String)algoKey, (DBRoute)routeQmc, (SqlBuilder)sqlDimen);
        if (rows.hasNext()) {
            validMgs.append("field promatchdimen has not repaired\u3002");
        }
        SqlBuilder sqlStdEntry = new SqlBuilder();
        sqlStdEntry.append("select top 1 a.fid from t_qcbd_inspro_ent a inner join t_qcbd_schemeproj b on a.fentryid = b.fentryid where a.finspectstdid = 0;", new Object[0]);
        rows = DB.queryDataSet((String)algoKey, (DBRoute)routeQmc, (SqlBuilder)sqlStdEntry);
        if (rows.hasNext()) {
            validMgs.append("field stdentryid has not repaired\u3002");
        }
        return validMgs.toString();
    }

    @Override
    public void repaireData(RequestContext rc, Map<String, Object> params, HashMap<String, Object> resultMap) throws KDException {
        String successKey = "success";
        String errMsgKey = "errMsg";
        resultMap.put(successKey, true);
        resultMap.put(errMsgKey, "");
        DBRoute routeQmc = new DBRoute("qmc");
        StringBuilder errMsg = new StringBuilder();
        if (((Boolean)params.get("isrepairestard")).booleanValue()) {
            String sql = this.getSql();
            UpgradeResult resultStd = UpgradeSqlUtil.excuteSqlNoTransaction((String)sql, (DBRoute)routeQmc, null);
            this.appedErrmsg(resultStd, resultMap, successKey, errMsg);
            resultStd = (UpgradeResult)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"InspectProService", (String)"repairBiztypeValueExtend", (Object[])new Object[]{resultStd});
            this.appedErrmsg(resultStd, resultMap, successKey, errMsg);
            resultStd = (UpgradeResult)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"InspectProService", (String)"repairDimen", (Object[])new Object[]{resultStd, "", null, null});
            this.appedErrmsg(resultStd, resultMap, successKey, errMsg);
            resultStd = (UpgradeResult)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"InspectProService", (String)"repairProjEntryStdid", (Object[])new Object[]{resultStd});
            this.appedErrmsg(resultStd, resultMap, successKey, errMsg);
        }
        Long bizTypeId = (Long)params.get("biztypeid");
        String biztypeStr = (String)params.get("biztypestr");
        String biztypeName = (String)params.get("biztypename");
        Collection dimenCollection = (Collection)params.get("dimen");
        Object[] dimenIdArr = new Object[]{};
        if (!CollectionUtils.isEmpty((Collection)dimenCollection)) {
            dimenIdArr = dimenCollection.toArray();
        }
        Long[] dimenIdArrLong = (Long[])Arrays.stream(dimenIdArr).map(o -> Long.valueOf(o.toString())).toArray(Long[]::new);
        if (((Boolean)params.get("isbyfixbill")).booleanValue()) {
            this.executeAccurate(params, resultMap, successKey, routeQmc, errMsg, dimenIdArrLong);
        }
        if (StringUtils.isNotBlank((CharSequence)biztypeStr)) {
            UpgradeResult result = new UpgradeResult();
            if (Objects.nonNull(bizTypeId)) {
                String sql = "update t_qcbd_inspectpro set fbiztypeid = ? where fbizstypeid = ?";
                result = UpgradeSqlUtil.excuteSqlNoTransaction((String)sql, (DBRoute)routeQmc, (Object[])new Object[]{bizTypeId, biztypeStr});
                this.appedErrmsg(result, resultMap, successKey, errMsg);
                ArrayList maps = new ArrayList(10);
                HashMap<String, Object> map = new HashMap<String, Object>(3);
                map.put("bizTypeId", bizTypeId);
                map.put("biztypeStr", biztypeStr);
                map.put("biztypeName", biztypeName);
                maps.add(map);
                DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"InspectProService", (String)"addBiztypeReflex", (Object[])new Object[]{maps});
            }
            result = (UpgradeResult)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"InspectProService", (String)"repairDimen", (Object[])new Object[]{result, biztypeStr, null, dimenIdArrLong});
            this.appedErrmsg(result, resultMap, successKey, errMsg);
        }
        resultMap.put(errMsgKey, errMsg.toString());
    }

    private void executeAccurate(Map<String, Object> params, HashMap<String, Object> resultMap, String successKey, DBRoute routeQmc, StringBuilder errMsg, Long[] dimenIdArr) {
        Object[] dataIdArray = (Long[])Arrays.stream(params.get("dataid_tag").toString().split(",")).map(Long::valueOf).toArray(Long[]::new);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid,fbizstypeid from t_qcbd_inspectpro where fbiztypeid = 0 and", new Object[0]);
        sql.appendIn("fid", dataIdArray);
        DynamicObjectCollection inspectPros = new ORMImpl().toPlainDynamicObjectCollection(DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("qmc"), (SqlBuilder)sql));
        Map<String, List<DynamicObject>> bizTypeGroupMap = inspectPros.stream().collect(Collectors.groupingBy(o -> o.getString("fbizstypeid")));
        DynamicObject inspproBiztypeReflex = BusinessDataServiceHelper.loadSingleFromCache((Object)1597180334154288128L, (String)"qcbd_sysconfig");
        Map<String, Long> inspproBiztypeReflexMap = inspproBiztypeReflex.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(o -> o.getString("attrkey"), o -> o.getLong("attrvalue"), (a, b) -> a));
        SqlBuilder updateSql = new SqlBuilder();
        for (Map.Entry<String, List<DynamicObject>> biTypeGroup : bizTypeGroupMap.entrySet()) {
            String key = biTypeGroup.getKey();
            if (StringUtils.isBlank((CharSequence)key)) continue;
            Long bizTypeId = inspproBiztypeReflexMap.get(key);
            if (Objects.isNull(bizTypeId)) {
                resultMap.put(successKey, false);
                errMsg.append(String.format(ResManager.loadKDString((String)"\u68c0\u9a8c\u4e1a\u52a1\u7c7b\u578b%s\u5728\u8d28\u91cf\u7ba1\u7406\u7cfb\u7edf\u53c2\u6570\u2018insppro_biztype_reflex_S\u2019\u4e2d\u4e0d\u5b58\u5728\u6620\u5c04\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"RepaireInspproBiztypeTask_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), key));
                continue;
            }
            updateSql.append("update t_qcbd_inspectpro set fbiztypeid = ? where fbizstypeid = ? and", new Object[]{bizTypeId, key});
            updateSql.appendIn("fid ", biTypeGroup.getValue().stream().map(o -> o.getLong("fid")).toArray());
            updateSql.append(";", new Object[0]);
        }
        UpgradeResult result = UpgradeSqlUtil.buildResult((UpgradeResult)new UpgradeResult(), (boolean)true, (String)"database execution sucess");
        try {
            if (!updateSql.isEmpty()) {
                DB.execute((DBRoute)routeQmc, (SqlBuilder)updateSql);
            }
        }
        catch (Exception e) {
            result = UpgradeSqlUtil.buildResult((UpgradeResult)result, (boolean)false, (String)("database execution failed,errorInfo\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        this.appedErrmsg(result, resultMap, successKey, errMsg);
        result = (UpgradeResult)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"InspectProService", (String)"repairDimen", (Object[])new Object[]{result, null, dataIdArray, dimenIdArr});
        this.appedErrmsg(result, resultMap, successKey, errMsg);
    }

    private void appedErrmsg(UpgradeResult resultStd, HashMap<String, Object> resultMap, String successKey, StringBuilder errMsg) {
        if (!resultStd.isSuccess()) {
            resultMap.put(successKey, false);
            errMsg.append(resultStd.getErrorInfo());
        }
    }

    private String getSql() {
        return "update t_qcbd_inspectpro set fbiztypeid = 959929179238017024 where fbizstypeid = '0' and fbiztypeid = 0;update t_qcbd_inspectpro set fbiztypeid = 960042976074041344 where fbizstypeid = '1' and fbiztypeid = 0;update t_qcbd_inspectpro set fbiztypeid = 1157790804945938432 where fbizstypeid = '2' and fbiztypeid = 0;update t_qcbd_inspectpro set fbiztypeid = 1157791038325170176 where fbizstypeid = '3' and fbiztypeid = 0;update t_qcbd_inspectpro set fbiztypeid = 960041773667747840 where fbizstypeid = '4' and fbiztypeid = 0;update t_qcbd_inspectpro set fbiztypeid = 960042738642880512 where fbizstypeid = '5' and fbiztypeid = 0;update t_qcbd_inspectpro set fbiztypeid = 1176040910430171136 where fbizstypeid = '6' and fbiztypeid = 0;update t_qcbd_inspectpro set fbiztypeid = 1377522299225319424 where fbizstypeid = '7' and fbiztypeid = 0;update t_qcbd_inspectpro set fbiztypeid = 1408539848628799488 where fbizstypeid = '8' and fbiztypeid = 0;update t_qcbd_inspectpro set fbiztypeid = 959929527046481920 where fbizstypeid = '9' and fbiztypeid = 0;";
    }
}

