/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.repairtool.task;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.formplugin.repairtool.factory.IRepairToolUpdateTask;
import kd.qmc.qcbd.formplugin.repairtool.task.RepaireBaseTask;

public class RepaireTransacTypeTask
extends RepaireBaseTask
implements IRepairToolUpdateTask {
    private static final String[] repairTablesStd = new String[]{"T_QCP_BADDEALN", "T_QCP_INSPBILL", "T_QCP_INSPECAPPLYN", "T_QCP_JOININSPECT", "T_QCPP_BADDEAL", "T_QCPP_INSPBILL", "T_QCPP_INSPECAPPLY", "T_QCPP_JOININSPECT", "T_QCAS_BADDEAL", "T_QCAS_INSPBILL", "T_QCAS_INSPECAPPLY", "T_QCAS_JOININSPECT", "T_QCNP_BADDEAL", "T_QCNP_INSPBILL", "T_QCNP_INSPECAPPLY", "T_QCNP_JOININSPECT"};

    @Override
    public void initParam(IFormView fv, Map<String, Object> params) {
        DynamicObjectCollection biztypeDyoCol;
        super.initParam(fv, params);
        IDataModel model = fv.getModel();
        DynamicObject entityDyo = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"entity");
        if (Objects.nonNull(entityDyo)) {
            params.put("entity", entityDyo.getString("number"));
        }
        if (!CollectionUtils.isEmpty((Collection)(biztypeDyoCol = DynamicObjDataUtil.getDataModelDynamicObjectCollectionData((IDataModel)model, (String)"biztype")))) {
            List bizTypePkList = biztypeDyoCol.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).distinct().collect(Collectors.toList());
            params.put("biztype", bizTypePkList);
        }
    }

    @Override
    public String validData(Map<String, Object> params) {
        String entityName;
        super.validData(params);
        DBRoute routeQmc = new DBRoute("qmc");
        StringBuilder validMgs = new StringBuilder();
        Boolean isrepairestard = (Boolean)params.get("isrepairestard");
        if (isrepairestard.booleanValue()) {
            for (String table : repairTablesStd) {
                this.getSingleTableValid(routeQmc, validMgs, table);
            }
        }
        if (Objects.isNull(entityName = (String)params.get("entity"))) {
            if (!isrepairestard.booleanValue()) {
                validMgs.append(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u201c\u4fee\u590d\u6807\u51c6\u6570\u636e\u201d\u6216\u5f55\u5165\u4fee\u590d\u5b9e\u4f53\u3002", (String)"RepaireTransacTypeTask_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getSingleTableValid(routeQmc, validMgs, MetadataServiceHelper.getDataEntityType((String)entityName).getAlias());
            if (StringUtils.isBlank((CharSequence)validMgs)) {
                validMgs.append(ResManager.loadKDString((String)"\u5f53\u524d\u4fee\u590d\u5b9e\u4f53\u6570\u636e\u4fee\u590d\u9a8c\u8bc1\u901a\u8fc7\u3002", (String)"RepaireTransacTypeTask_2", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            }
        }
        return validMgs.toString();
    }

    private void getSingleTableValid(DBRoute routeQmc, StringBuilder validMgs, String table) {
        SqlBuilder sql = new SqlBuilder();
        sql.append(String.format("select count(1) count from %s where ftransactypeid = 0", table), new Object[0]);
        DataSet rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)routeQmc, (SqlBuilder)sql);
        if (((Row)rows.iterator().next()).getInteger("count") > 1) {
            validMgs.append(table);
            validMgs.append(":");
            validMgs.append(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fee\u590d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RepaireTransacTypeTask_3", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            validMgs.append("\r\n");
        }
    }

    @Override
    public void repaireData(RequestContext rc, Map<String, Object> params, HashMap<String, Object> resultMap) throws KDException {
        UpgradeResult result;
        UpgradeResult resultStd;
        String successKey = "success";
        String errMsgKey = "errMsg";
        resultMap.put(successKey, true);
        resultMap.put(errMsgKey, "");
        StringBuilder errMsg = new StringBuilder();
        if (((Boolean)params.get("isbyfixbill")).booleanValue() && !(resultStd = (UpgradeResult)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"TransacTypeService", (String)"executeAccurate", (Object[])new Object[]{params})).isSuccess()) {
            resultMap.put(successKey, false);
            errMsg.append(resultStd.getErrorInfo());
            resultMap.put(errMsgKey, errMsg.toString());
        }
        if (((Boolean)params.get("isrepairestard")).booleanValue() && !(resultStd = (UpgradeResult)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"TransacTypeService", (String)"executeStd", null)).isSuccess()) {
            resultMap.put(successKey, false);
            errMsg.append(resultStd.getErrorInfo());
            resultMap.put(errMsgKey, errMsg.toString());
        }
        String entityName = (String)params.get("entity");
        Collection biztype = (Collection)params.get("biztype");
        Object[] bizTypeIdArr = new Object[]{};
        if (!CollectionUtils.isEmpty((Collection)biztype)) {
            bizTypeIdArr = biztype.toArray();
        }
        if (StringUtils.isNotBlank((CharSequence)entityName) && bizTypeIdArr.length > 0 && !(result = (UpgradeResult)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"TransacTypeService", (String)"repairDataSingleBill", (Object[])new Object[]{entityName, bizTypeIdArr, null})).isSuccess()) {
            resultMap.put(successKey, false);
            errMsg.append(result.getErrorInfo());
            resultMap.put(errMsgKey, errMsg.toString());
        }
    }
}

