/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.rpt;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class QcbdChartRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit bdBizType = (MulBasedataEdit)this.getControl("biztype");
        if (!Objects.isNull(bdBizType)) {
            bdBizType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String keyName;
        switch (keyName = event.getProperty().getName()) {
            case "biztype": {
                this.bdBizTypeFilter(event);
                break;
            }
        }
    }

    private void bdBizTypeFilter(BeforeF7SelectEvent event) {
        String viewId = this.getView().getEntityId();
        String entityId = this.getEntityId(viewId);
        QFilter billTypeFilter = new QFilter("billformid", "=", (Object)entityId);
        billTypeFilter.and("enable", "=", (Object)"1");
        DynamicObject[] idCol = BusinessDataServiceHelper.load((String)"bos_billtype", (String)"id,number,name", (QFilter[])new QFilter[]{billTypeFilter});
        HashSet<Long> bizTypeSet = new HashSet<Long>();
        if (!Objects.isNull(entityId)) {
            this.getBizSet(entityId, idCol, bizTypeSet);
        }
        ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
        QFilter filter = new QFilter("id", "in", bizTypeSet);
        parameter.getListFilterParameter().setFilter(filter);
        event.setFormShowParameter((FormShowParameter)parameter);
    }

    private void getBizSet(String entityId, DynamicObject[] idCol, Set<Long> bizTypeSet) {
        BillEntityType mainEntityType = (BillEntityType)MetadataServiceHelper.getDataEntityType((String)entityId);
        for (DynamicObject type : idCol) {
            DynamicObject billTypeParam = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)entityId, (String)mainEntityType.getBillTypePara(), (long)type.getLong("id"));
            DataEntityPropertyCollection propertiesCol = billTypeParam.getDynamicObjectType().getProperties();
            if (!propertiesCol.containsKey((Object)"entryentity")) continue;
            DynamicObjectCollection billCol = billTypeParam.getDynamicObjectCollection("entryentity");
            Set tempIdSet = billCol.stream().map(dym -> dym.getLong("biztypenumber.id")).collect(Collectors.toSet());
            bizTypeSet.addAll(tempIdSet);
        }
    }

    private String getEntityId(String viewId) {
        String entityId = null;
        switch (viewId) {
            case "qcqs_manuinsbadealrpt": {
                entityId = "qcpp_manubaddeal";
                break;
            }
            case "qcqs_manuinsquarpt": {
                entityId = "qcpp_manuinspec";
                break;
            }
            case "qcqs_insbadealrpt": {
                entityId = "qcp_baddeal";
                break;
            }
            case "qcqs_insquarpt": {
                entityId = "qcp_incominginspct";
                break;
            }
            case "qcqs_saleinsbadealrpt": {
                entityId = "qcas_salebaddeal";
                break;
            }
            case "qcqs_saleinsquarpt": {
                entityId = "qcas_saleinspec";
                break;
            }
            case "qcqs_invbalinsbadealrpt": {
                entityId = "qcnp_invbalbaddeal";
                break;
            }
            case "qcqs_invbalinsquarpt": {
                entityId = "qcnp_invbalinspec";
                break;
            }
        }
        return entityId;
    }
}

