/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.smallbaddealfix;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.qmc.qcbd.business.helper.BadDealSqlHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class SmallBadDealHistoryFix
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
CellClickListener {
    private static final String MODEBILLTYPE = "modebilltype";
    private static final String ENTITY = "entitynumber";
    private static final String NEWHANDMODE = "newhandmode";
    private static final String OLDHANDMETHED = "oldhandmethed";
    private static final String NUMBER = "number";
    private static final String ENTRYENTITY = "entryentity";
    private static final String BADDEALBILLNUM = "entryentity.modebilltype.id";
    private static final String HANDMETHED = "handmethed";
    private static final String ENTITYNUMCHG = "entityNumChg";
    private static final String SQLCODE = "sqlcode";
    private static final String STATUS = "status";
    private static final String AUDITSTATE = "C";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String status = this.getModel().getDataEntity().getString(STATUS);
        if (AUDITSTATE.equals(status)) {
            this.setOldhandmethed();
            this.showSql();
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid grid;
        BasedataEdit newMode;
        super.registerListener(e);
        BasedataEdit billType = (BasedataEdit)this.getView().getControl(MODEBILLTYPE);
        if (null != billType) {
            billType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (newMode = (BasedataEdit)this.getView().getControl(NEWHANDMODE))) {
            newMode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (grid = (EntryGrid)this.getView().getControl(ENTRYENTITY))) {
            grid.addCellClickListener((CellClickListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        Control source = (Control)event.getSource();
        String key = source.getKey();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (NEWHANDMODE.equals(key)) {
            DynamicObject billType = this.getModel().getDataEntity().getDynamicObject(MODEBILLTYPE);
            if (null == billType) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4fee\u590d\u5355\u636e\u7c7b\u578b\u3002", (String)"SmallBadDealHistoryFix_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            QFilter filter = new QFilter(BADDEALBILLNUM, "=", (Object)billType.getLong("id"));
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeArr;
        String changField = e.getProperty().getName();
        for (ChangeData chgData : changeArr = e.getChangeSet()) {
            Object newValue = chgData.getNewValue();
            Object oldValue = chgData.getOldValue();
            if (!MODEBILLTYPE.equals(changField)) continue;
            this.entityNumChg(oldValue, this);
            if (null != newValue) {
                this.setEntity(newValue);
                this.setOldhandmethed();
                continue;
            }
            this.setEntity(newValue);
            ComboEdit coEdit = (ComboEdit)this.getView().getControl(OLDHANDMETHED);
            ArrayList emptyList = new ArrayList();
            coEdit.setComboItems(emptyList);
        }
    }

    private void setEntity(Object newValue) {
        if (null == newValue) {
            this.getModel().setValue(ENTITY, null);
        } else {
            DynamicObject billType = (DynamicObject)newValue;
            DynamicObject form = billType.getDynamicObject("billformid");
            this.getModel().setValue(ENTITY, (Object)form);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String backId = messageBoxClosedEvent.getCallBackId();
        IDataModel model = this.getModel();
        if (ENTITYNUMCHG.equals(backId)) {
            switch (messageBoxClosedEvent.getResult()) {
                case Yes: {
                    DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
                    for (int i = entryEntity.size() - 1; i >= 0; --i) {
                        model.deleteEntryRow(ENTRYENTITY, i);
                    }
                    this.getView().invokeOperation("newentry");
                    break;
                }
                case Cancel: {
                    model.beginInit();
                    model.setValue(MODEBILLTYPE, (Object)this.getPageCache().get("modebilltypetmp"));
                    model.setValue(ENTITY, (Object)this.getPageCache().get("entitynumbertmp"));
                    model.endInit();
                    model.updateCache();
                    this.getView().updateView(MODEBILLTYPE);
                    this.getView().updateView(ENTITY);
                    this.setOldhandmethed();
                    this.getView().setEnable(Boolean.valueOf(true), 0, new String[]{NEWHANDMODE, OLDHANDMETHED});
                    break;
                }
            }
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String key = cellClickEvent.getFieldKey();
        if (OLDHANDMETHED.equals(key)) {
            DynamicObject entityNum = this.getModel().getDataEntity().getDynamicObject(ENTITY);
            ComboEdit coEdit = (ComboEdit)this.getView().getControl(OLDHANDMETHED);
            ComboProp coEditProperty = (ComboProp)coEdit.getProperty();
            List strList = coEditProperty.getComboItems();
            if (strList.isEmpty() && null == entityNum) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4fee\u590d\u5355\u636e\u7c7b\u578b\u3002", (String)"SmallBadDealHistoryFix_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("audit".equals(opKey)) {
            this.showSql();
        }
    }

    private void showSql() {
        IDataModel model = this.getModel();
        DynamicObject entityNum = model.getDataEntity().getDynamicObject(ENTITY);
        DynamicObjectCollection entryEntity = model.getDataEntity().getDynamicObjectCollection(ENTRYENTITY);
        BadDealSqlHelper helper = new BadDealSqlHelper();
        String sqlprint = helper.badDealSqlStr(entityNum, entryEntity);
        CodeEdit codeEdit = (CodeEdit)this.getView().getControl(SQLCODE);
        codeEdit.setText(sqlprint);
    }

    private void setOldhandmethed() {
        DynamicObject entity = this.getModel().getDataEntity().getDynamicObject(ENTITY);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entity.getString(NUMBER));
        Map fieldMap = mainEntityType.getAllFields();
        ComboProp handMethed = (ComboProp)fieldMap.get(HANDMETHED);
        List strList = handMethed.getComboItems();
        ArrayList<ComboItem> comList = new ArrayList<ComboItem>(strList.size());
        for (ValueMapItem item : strList) {
            String itemStr = item.getValue();
            LocaleString itemName = item.getName();
            String itemNameStr = itemName.getLocaleValue();
            ComboItem comItem = new ComboItem();
            itemNameStr = itemNameStr + "(" + itemStr + ")";
            LocaleString setItemName = new LocaleString(itemNameStr);
            comItem.setValue(itemStr);
            comItem.setCaption(setItemName);
            comList.add(comItem);
        }
        ComboEdit oldHandMode = (ComboEdit)this.getView().getControl(OLDHANDMETHED);
        oldHandMode.setComboItems(comList);
    }

    private void entityNumChg(Object oldValue, AbstractBillPlugIn abp) {
        if (oldValue != null) {
            String entityNumId = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)((DynamicObject)oldValue), (String)"id");
            DynamicObject entiy = this.getModel().getDataEntity().getDynamicObject(ENTITY);
            if (null != entiy) {
                String entityId = entiy.getString("id");
                abp.getPageCache().put("entitynumbertmp", entityId);
            }
            abp.getPageCache().put("modebilltypetmp", entityNumId);
            ConfirmCallBackListener listener = new ConfirmCallBackListener(ENTITYNUMCHG, (IFormPlugin)abp);
            abp.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u590d\u5355\u636e\u7c7b\u578b\u4f1a\u6e05\u7a7a\u5904\u7406\u65b9\u5f0f\u6620\u5c04\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SmallBadDealHistoryFix_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, listener);
        }
    }
}

