/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.task;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.qmc.qcbd.business.helper.ZJMaterialHelper;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;

public class BaseUnitQtyConVertTask
extends AbstractTask {
    private Log log = LogFactory.getLog(BaseUnitQtyConVertTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            DynamicObject[] applyIncomeBills = this.getDatas("qcp_inspecapply", "materialentry.materielid", "materialentry.unit", "materialentry.applyqty", "materialentry.baseunit", "materialentry.baseqty", "materialentry.basejoinqty");
            DynamicObject[] applyManuBills = this.getDatas("qcpp_manuinspecapply", "materialentry.materielid", "materialentry.unit", "materialentry.applyqty", "materialentry.baseunit", "materialentry.baseqty", "materialentry.basejoinqty");
            DynamicObject[] inspecIncomeBills = this.getDatas("qcp_incominginspct", "matintoentity.materialid", "matintoentity.unitfield", "matintoentity.materialqty", "matintoentity.baseunit", "matintoentity.baseqty", "matintoentity.basejoinqty");
            DynamicObject[] inspecManuBills = this.getDatas("qcpp_manuinspec", "matintoentity.materialid", "matintoentity.unitfield", "matintoentity.materialqty", "matintoentity.baseunit", "matintoentity.baseqty", "matintoentity.basejoinqty");
            DynamicObject[] baddealIncomeBills = this.getDatas("qcp_baddeal", "materialentry.materielid", "materialentry.unit", "materialentry.unqualiqty", "materialentry.baseunit", "materialentry.baseqty", "materialentry.joinbaseqty");
            DynamicObject[] baddealManuBills = this.getDatas("qcpp_manubaddeal", "materialentry.materielid", "materialentry.unit", "materialentry.unqualiqty", "materialentry.baseunit", "materialentry.baseqty", "materialentry.joinbaseqty");
            this.repairData(applyIncomeBills, "qcp_inspecapply", "materialentry", "materialentry.materielid", "materialentry.unit", "materialentry.applyqty", "materialentry.basejoinqty");
            this.repairData(applyManuBills, "qcpp_manuinspecapply", "materialentry", "materialentry.materielid", "materialentry.unit", "materialentry.applyqty", "materialentry.basejoinqty");
            this.repairData(inspecIncomeBills, "qcp_incominginspct", "matintoentity", "matintoentity.materialid", "matintoentity.unitfield", "matintoentity.materialqty", "matintoentity.basejoinqty");
            this.repairData(inspecManuBills, "qcpp_manuinspec", "matintoentity", "matintoentity.materialid", "matintoentity.unitfield", "matintoentity.materialqty", "matintoentity.basejoinqty");
            this.repairData(baddealIncomeBills, "qcp_baddeal", "materialentry", "materialentry.materielid", "materialentry.unit", "materialentry.unqualiqty", "materialentry.joinbaseqty");
            this.repairData(baddealManuBills, "qcpp_manubaddeal", "materialentry", "materialentry.materielid", "materialentry.unit", "materialentry.unqualiqty", "materialentry.joinbaseqty");
            new ZJMaterialHelper().repairZJMaterial();
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            String err = ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u4fee\u590d\u5931\u8d25\uff0c\u51fa\u9519\u539f\u56e0\uff1a", (String)"BaseUnitQtyConVertTask_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]);
            throw new KDException((Throwable)e, new ErrorCode("BaseUnitQtyConVertTask", e.getMessage() != null ? err + e.getMessage() : err + e.toString()), new Object[0]);
        }
    }

    private void repairData(DynamicObject[] dynamicObjects, String billKey, String entryId, String matId, String unitId, String qty, String baseJoinQty) {
        Arrays.stream(dynamicObjects).forEach(o -> {
            DynamicObjectCollection entrys = o.getDynamicObjectCollection(entryId);
            entrys.stream().forEach(entry -> {
                Object baseunitObject;
                DynamicObject mat = entry.getDynamicObject(matId.substring(matId.indexOf(".") + 1));
                DynamicObject unit = entry.getDynamicObject(unitId.substring(unitId.indexOf(".") + 1));
                BigDecimal srcqty = entry.getBigDecimal(qty.substring(qty.indexOf(".") + 1));
                BigDecimal srcJoinQty = entry.getBigDecimal("joinqty");
                if (Objects.nonNull(mat) && Objects.nonNull(unit) && Objects.nonNull(baseunitObject = mat.get("baseunit"))) {
                    DynamicObject baseunit = (DynamicObject)baseunitObject;
                    entry.set("baseunit", (Object)baseunit);
                    BigDecimal qtyConvert = BaseUnitQtyConVertUtil.getQtyConvert((Long)((Long)mat.getPkValue()), (Long)((Long)unit.getPkValue()), (BigDecimal)srcqty, (DynamicObject)baseunit);
                    entry.set("baseqty", (Object)qtyConvert);
                    BigDecimal joinQtyConvert = BaseUnitQtyConVertUtil.getQtyConvert((Long)((Long)mat.getPkValue()), (Long)((Long)unit.getPkValue()), (BigDecimal)srcJoinQty, (DynamicObject)baseunit);
                    if (StringUtils.equals((CharSequence)billKey, (CharSequence)"qcp_incominginspct") || StringUtils.equals((CharSequence)billKey, (CharSequence)"qcpp_manuinspec")) {
                        BigDecimal qualiqty = entry.getBigDecimal("qualiqty");
                        BigDecimal baseQualiqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)((Long)mat.getPkValue()), (Long)((Long)unit.getPkValue()), (BigDecimal)qualiqty, (DynamicObject)baseunit);
                        BigDecimal unqualiqty = entry.getBigDecimal("unqualiqty");
                        BigDecimal baseQnqualiqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)((Long)mat.getPkValue()), (Long)((Long)unit.getPkValue()), (BigDecimal)unqualiqty, (DynamicObject)baseunit);
                        BigDecimal sampqualqty = entry.getBigDecimal("sampqualqty");
                        BigDecimal baseSampqualqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)((Long)mat.getPkValue()), (Long)((Long)unit.getPkValue()), (BigDecimal)sampqualqty, (DynamicObject)baseunit);
                        BigDecimal samunqualqty = entry.getBigDecimal("samunqualqty");
                        BigDecimal baseSamunqualqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)((Long)mat.getPkValue()), (Long)((Long)unit.getPkValue()), (BigDecimal)samunqualqty, (DynamicObject)baseunit);
                        DBRoute dbRoute = DBRoute.of((String)o.getDataEntityType().getDBRouteKey());
                        String sql = "delete from t_qcp_matintoentity_n where fid=? and fentryid=?";
                        Object[] params = new Object[]{o.getLong("id"), entry.getLong("id")};
                        DB.execute((DBRoute)dbRoute, (String)sql, (Object[])params);
                        sql = "insert into t_qcp_matintoentity_n (fid,fentryid,fbasequaliqty,fbaseunqlyqty,fbasesampqlyqty,fbasesampuqlyqty,fbasejoinqty) values (?,?,?,?,?,?,?)";
                        Object[] params1 = new Object[]{o.getLong("id"), entry.getLong("id"), baseQualiqty, baseQnqualiqty, baseSampqualqty, baseSamunqualqty, joinQtyConvert};
                        DB.execute((DBRoute)dbRoute, (String)sql, (Object[])params1);
                    } else {
                        entry.set(baseJoinQty.substring(baseJoinQty.indexOf(".") + 1), (Object)joinQtyConvert);
                    }
                }
            });
        });
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private DynamicObject[] getDatas(String billKey, String matId, String unit, String qty, String baseunit, String baseqty, String baseJoinQty) {
        QFilter qFilterJoin;
        StringBuilder selectFilds = new StringBuilder();
        String douhao = ",";
        selectFilds.append("billno").append(douhao).append(matId).append(douhao).append(unit).append(douhao).append(qty).append(douhao).append(baseunit).append(douhao).append(baseqty).append(douhao).append(baseJoinQty);
        QFilter qFilterMust = new QFilter(matId, "!=", (Object)BigDecimal.ZERO);
        qFilterMust.and(unit, "!=", (Object)BigDecimal.ZERO);
        qFilterMust.and(qty, "!=", (Object)BigDecimal.ZERO);
        QFilter qFilterUnit = new QFilter(baseunit, "=", (Object)BigDecimal.ZERO);
        qFilterUnit.or(QFilter.isNull((String)baseunit));
        if (StringUtils.equals((CharSequence)billKey, (CharSequence)"qcp_incominginspct") || StringUtils.equals((CharSequence)billKey, (CharSequence)"qcpp_manuinspec")) {
            qFilterJoin = new QFilter("matintoentity.joinqty", "!=", (Object)BigDecimal.ZERO);
            qFilterJoin.and(baseJoinQty, "=", (Object)BigDecimal.ZERO);
            qFilterJoin.or("matintoentity.basequaliqty", "=", (Object)BigDecimal.ZERO);
            qFilterJoin.or("matintoentity.baseunqlyqty", "=", (Object)BigDecimal.ZERO);
            qFilterJoin.or("matintoentity.basesampqlyqty", "=", (Object)BigDecimal.ZERO);
            qFilterJoin.or("matintoentity.basesampuqlyqty", "=", (Object)BigDecimal.ZERO);
            selectFilds = selectFilds.append(douhao).append("matintoentity.basequaliqty").append(douhao).append("matintoentity.baseunqlyqty").append(douhao).append("matintoentity.basesampqlyqty").append(douhao).append("matintoentity.basesampuqlyqty").append(douhao).append("matintoentity.joinqty").append(douhao).append("matintoentity.qualiqty").append(douhao).append("matintoentity.unqualiqty").append(douhao).append("matintoentity.sampqualqty").append(douhao).append("matintoentity.samunqualqty");
        } else {
            qFilterJoin = new QFilter("materialentry.joinqty", "!=", (Object)BigDecimal.ZERO);
            qFilterJoin.and(baseJoinQty, "=", (Object)BigDecimal.ZERO);
            selectFilds = selectFilds.append(douhao).append("materialentry.joinqty");
        }
        qFilterMust.and(qFilterUnit.or(qFilterJoin));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)billKey, (String)selectFilds.toString(), (QFilter[])new QFilter[]{qFilterMust});
        return dynamicObjects;
    }
}

