/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.task;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.common.util.CopyUtil;
import kd.qmc.qcbd.formplugin.task.SynResult;

public class SynRouteTask
extends AbstractTask {
    private static final String ENTITY_PDM_ROUTE = "pdm_route";
    private static final Log log = LogFactory.getLog(SynRouteTask.class);

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        QFilter[] filter;
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        QFilter inspcetQfilter = new QFilter("processentry.checktype", "=", (Object)"1013").or("processentry.firstcheck", "=", (Object)true);
        qFilter.and(inspcetQfilter);
        if (params.get("filter") != null && !StringUtils.isEmpty((String)params.get("filter").toString()) && (filter = (QFilter[])SerializationUtils.fromJsonString((String)params.get("filter").toString(), QFilter[].class)) != null) {
            for (QFilter f : filter) {
                String value = f.getValue().toString();
                if (value.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
                    f.__setValue((Object)Timestamp.valueOf(value));
                }
                qFilter.and(f);
            }
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        try {
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u8bfb\u53d6\u5236\u9020\u5de5\u827a\u8def\u7ebf\u3002", (String)"SynRouteTask_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), null);
            DynamicObject[] synPdmRoute = this.getSynPdmRoute(qFilter);
            Thread.sleep(1500L);
            if (this.isStop()) {
                this.stop();
            }
            int s = 0;
            if (synPdmRoute != null) {
                s = synPdmRoute.length;
            }
            this.feedbackProgress(0, String.format(ResManager.loadKDString((String)"\u6709%s\u6761\u5236\u9020\u5de5\u827a\u8def\u7ebf\u9700\u8981\u540c\u6b65\u3002", (String)"SynRouteTask_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), s), null);
            Thread.sleep(1500L);
            if (this.isStop()) {
                this.stop();
            }
            this.feedbackProgress(30, ResManager.loadKDString((String)"\u5f00\u59cb\u540c\u6b65\u5236\u9020\u5de5\u827a\u8def\u7ebf\u3002", (String)"SynRouteTask_2", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), null);
            Map<Object, Object> map = new HashMap(16);
            if (synPdmRoute != null) {
                map = this.syncPdmProcessRoute(synPdmRoute);
            }
            Thread.sleep(1500L);
            if (this.isStop()) {
                this.stop();
            }
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u5236\u9020\u5de5\u827a\u8def\u7ebf\u5df2\u540c\u6b65\u5b8c\u6210\u3002", (String)"SynRouteTask_3", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), null);
            Thread.sleep(1500L);
            resultMap.put("success", map.get("success"));
            resultMap.put("errMsg", map.get("errMsg"));
            resultMap.put("successPkIds", map.get("successPkIds"));
            resultMap.put("successNumbers", map.get("successNumbers"));
            resultMap.put("failResult", map.get("failResult"));
            resultMap.put("totleCount", s);
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
        }
        this.feedbackCustomdata(resultMap);
    }

    private DynamicObject[] getSynPdmRoute(QFilter qFilter) {
        List<QFilter> dealTime = this.dealTime(qFilter);
        dealTime.add(new QFilter("origin", "=", (Object)"A"));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"qcbd_qmcroute", (String)"qcbd_qmcroute", (String)"manurouteid", (QFilter[])dealTime.toArray(new QFilter[0]), null);
        Set manuRouteIds = query.stream().map(a -> a.getLong("manurouteid")).collect(Collectors.toSet());
        DynamicObject[] routes = BusinessDataServiceHelper.load((String)ENTITY_PDM_ROUTE, (String)"id,number", (QFilter[])new QFilter[]{qFilter});
        List routeIds = Arrays.stream(routes).map(a -> a.getLong("id")).collect(Collectors.toList());
        routeIds = routeIds.stream().filter(a -> !manuRouteIds.contains(a)).collect(Collectors.toList());
        DynamicObject[] processroutes = BusinessDataServiceHelper.load((Object[])routeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITY_PDM_ROUTE));
        return processroutes;
    }

    private Map<String, Object> syncPdmProcessRoute(DynamicObject[] processroutes) {
        ArrayList<DynamicObject> qmcRouteAl = new ArrayList<DynamicObject>();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        List<Object> successPkIds = new ArrayList();
        List<Object> successNumbers = new ArrayList();
        ArrayList<SynResult> failResult = new ArrayList<SynResult>();
        if (processroutes.length == 0) {
            map.put("success", false);
            map.put("errMsg", ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5931\u8d25\uff0c\u53ef\u540c\u6b65\u6570\u636e\u4e3a0\u6761\u3002", (String)"SynRouteTask_4", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
        }
        if (processroutes.length != 0) {
            for (DynamicObject dynamicObject : processroutes) {
                DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)"qcbd_qmcroute");
                CopyUtil.copyPropertiesWithId((DynamicObject)dataEntity, (DynamicObject)dynamicObject);
                this.dealSpecialField(dataEntity, dynamicObject);
                qmcRouteAl.add(dataEntity);
            }
        }
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("strictvalidation", String.valueOf(false));
        OperationResult saveResult = SaveServiceHelper.saveOperate((String)"qcbd_qmcroute", (DynamicObject[])qmcRouteAl.toArray(new DynamicObject[0]), (OperateOption)saveOption);
        if (saveResult.getSuccessPkIds() != null && !saveResult.getSuccessPkIds().isEmpty()) {
            successPkIds = saveResult.getSuccessPkIds().stream().map(a -> Long.parseLong(a.toString())).collect(Collectors.toList());
            DynamicObjectCollection query = QueryServiceHelper.query((String)"qcbd_qmcroute", (String)"qcbd_qmcroute", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", successPkIds)}, null);
            successNumbers = query.stream().map(a -> a.getString("number")).collect(Collectors.toList());
            map.put("success", true);
        }
        if (!saveResult.isSuccess()) {
            ValidateResultCollection validateResult = saveResult.getValidateResult();
            HashMap<Integer, StringBuilder> m = new HashMap<Integer, StringBuilder>(16);
            List validateErrors = validateResult.getValidateErrors();
            for (ValidateResult validateResult2 : validateErrors) {
                List allErrorInfo = validateResult2.getAllErrorInfo();
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    int index = operateErrorInfo.getDataEntityIndex();
                    String message = operateErrorInfo.getMessage();
                    StringBuilder stringBuild = (StringBuilder)m.get(index);
                    if (stringBuild == null) {
                        m.put(index, new StringBuilder(message));
                        continue;
                    }
                    stringBuild.append(message);
                }
            }
            for (Map.Entry entry : m.entrySet()) {
                String number = ((DynamicObject)qmcRouteAl.get((Integer)entry.getKey())).getString("number");
                SynResult r = new SynResult(0L, number, ((StringBuilder)entry.getValue()).toString());
                failResult.add(r);
            }
            map.put("success", true);
        }
        map.put("successPkIds", successPkIds);
        map.put("successNumbers", successNumbers);
        map.put("failResult", failResult);
        return map;
    }

    private void dealSpecialField(DynamicObject data, DynamicObject sourceData) {
        data.set("origin", (Object)"A");
        data.set("qauditor", data.get("auditor"));
        data.set("manurouteid", sourceData.get("id"));
        data.set("syntime", (Object)TimeServiceHelper.now());
        DynamicObject bomversion = sourceData.getDynamicObject("bomversion");
        if (bomversion != null) {
            data.set("bomversionstr", (Object)bomversion.getString("number"));
            DynamicObject version = bomversion.getDynamicObject("version");
            if (version != null) {
                data.set("bomtypestr", (Object)version.getString("number"));
            }
        }
        data.set("bomversion", null);
        DynamicObjectCollection srcProcessentrys = sourceData.getDynamicObjectCollection("processentry");
        DynamicObjectCollection tarProcessentrys = data.getDynamicObjectCollection("processentry");
        if (srcProcessentrys != null && tarProcessentrys != null && srcProcessentrys.size() == tarProcessentrys.size()) {
            for (int i = 0; i < tarProcessentrys.size(); ++i) {
                DynamicObject tarProcessentry = (DynamicObject)tarProcessentrys.get(i);
                DynamicObject srcProcessentry = (DynamicObject)srcProcessentrys.get(i);
                if (tarProcessentry == null || srcProcessentry == null) continue;
                tarProcessentry.set("route_procentryid", srcProcessentry.get("id"));
            }
        }
    }

    private List<QFilter> dealTime(QFilter qf) {
        return Arrays.stream(qf.recombine()).filter(f -> !(f.getValue() instanceof Timestamp)).collect(Collectors.toList());
    }
}

