/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.task;

import java.util.Date;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class WsNextStageTask
extends AbstractTask {
    private Log log = LogFactory.getLog(WsNextStageTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            DynamicObject[] objs;
            Date now = new Date();
            for (DynamicObject obj : objs = this.getData()) {
                DynamicObject stage;
                Date resetTime = obj.getDate("resettime");
                Date jpendTime = obj.getDate("jpendtm");
                String curStageNumber = obj.getString("curstage.number");
                DynamicObject wsRule = obj.getDynamicObject("wsrule");
                DynamicObjectCollection wsRuleEntrys = wsRule.getDynamicObjectCollection("entryentity");
                if (Objects.nonNull(resetTime) && resetTime.compareTo(now) < 0) {
                    stage = wsRuleEntrys.stream().filter(x -> x.getBoolean("starttage")).findFirst().get();
                    obj.set("curstage", (Object)stage.getDynamicObject("currentstage"));
                    obj.set("nexstage", (Object)stage.getDynamicObject("currentstage"));
                    obj.set("resettime", null);
                    obj.set("billno", null);
                    obj.set("inspectauditdate", null);
                    obj.set("jpendtm", null);
                    obj.set("jpleftnum", null);
                    continue;
                }
                if (!"4".equals(curStageNumber) || !Objects.nonNull(jpendTime) || jpendTime.compareTo(now) >= 0) continue;
                stage = wsRuleEntrys.stream().filter(x -> "4".equals(x.getDynamicObject("currentstage").getString("number"))).findFirst().get();
                obj.set("curstage", (Object)stage.getDynamicObject("nextstage"));
                obj.set("nexstage", (Object)stage.getDynamicObject("nextstage"));
                obj.set("jpendtm", null);
                obj.set("jpleftnum", null);
            }
            SaveServiceHelper.save((DynamicObject[])objs);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            String err = ResManager.loadKDString((String)"\u4e0b\u4e00\u68c0\u9a8c\u9636\u6bb5\u66f4\u65b0\u5931\u8d25\uff0c\u51fa\u9519\u539f\u56e0\uff1a", (String)"WsNextStageTask_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]);
            throw new KDException((Throwable)e, new ErrorCode("WsNextStageTask", e.getMessage() != null ? err + e.getMessage() : err + e.toString()), new Object[0]);
        }
    }

    private DynamicObject[] getData() {
        String selectFilds = "billno,wsrule,resettime,jpendtm,inspectauditdate,curstage,nexstage,jpendtm,jpleftnum";
        Date now = new Date();
        QFilter qFilter = new QFilter("resettime", "<=", (Object)now);
        qFilter.or("jpendtm", "<=", (Object)now);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"qcbd_widestrict_rec", (String)selectFilds, (QFilter[])new QFilter[]{qFilter});
        return dynamicObjects;
    }
}

