/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.formplugin.urgentpass;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.qmc.qcbd.business.commonmodel.helper.BillTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.BizTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.LotNumberHelper;
import kd.qmc.qcbd.common.platform.org.PlatformOrgUnitServiceHelper;
import kd.qmc.qcbd.common.util.ControlUtil;
import kd.qmc.qcbd.common.util.DeptSetUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class UrgentpassBillPlugin
extends AbstractBillPlugIn
implements EntryGridBindDataListener,
BeforeF7SelectListener {
    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("materialentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit inspecOrgEdit = (BasedataEdit)this.getView().getControl("inspectorg");
        inspecOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizTypeEdit = (BasedataEdit)this.getView().getControl("biztype");
        bizTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addF7Listener(this, "unit", "location");
        BasedataEdit materialcfg = (BasedataEdit)this.getView().getControl("materialcfg");
        materialcfg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void afterCreateNewData(EventObject e) {
        List deftoOrgs;
        super.afterCreateNewData(e);
        BillTypeHelper.billTypeChange((IFormView)this.getView());
        Object org = this.getModel().getValue("org");
        if (org != null && !(deftoOrgs = PlatformOrgUnitServiceHelper.getAllToOrg((String)"", (String)"06", (Long)Long.parseLong(((DynamicObject)org).getPkValue().toString()), (boolean)true)).isEmpty()) {
            this.getModel().setValue("inspectorg", deftoOrgs.get(0));
        }
        DynamicObject bizOrgDynamicObject = (DynamicObject)this.getModel().getValue("org");
        DeptSetUtil.changeBizOrg((IDataModel)this.getModel(), (Object)bizOrgDynamicObject, (String)"applydept");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        IDataModel md = this.getModel();
        String billStatusStr = DynamicObjDataUtil.getDataModelStringData((IDataModel)md, (String)"billstatus");
        if (StringUtils.equalsIgnoreCase((CharSequence)billStatusStr, (CharSequence)"A")) {
            LotNumberHelper.lotnumberEntryGridBind((IDataModel)this.getModel(), (IFormView)this.getView(), (EntryGridBindDataEvent)e, (String)"materialentry", (String)"materialid");
        }
    }

    public void afterCopyData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObjectCollection matEntrys = model.getEntryEntity("materialentry");
        for (int i = 0; i < matEntrys.size(); ++i) {
            if (null == model.getValue("materialcfg", i)) {
                model.setValue("materialid", null, i);
                model.setValue("unit", null, i);
                model.setValue("baseunit", null, i);
            }
            model.setValue("srcsystem", (Object)"qmc", i);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        IDataModel model = this.getModel();
        String sourceId = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        int rowIndex = event.getRow();
        switch (sourceId) {
            case "org": {
                this.cleanFieldTips();
                break;
            }
            case "biztype": {
                BizTypeHelper.selectBizType((IDataModel)model, (IFormView)this.getView(), (ListShowParameter)showParameter);
                break;
            }
            case "unit": {
                DynamicObject material = (DynamicObject)model.getValue("materialid", rowIndex);
                ControlUtil.unitCheck((BeforeF7SelectEvent)event, (IFormView)this.getView(), (DynamicObject)material);
                break;
            }
            case "inspectorg": {
                this.filterF7Inspecorg(event);
                break;
            }
            case "materialcfg": {
                this.materialCfgBeforeF7(model, showParameter);
                break;
            }
            case "location": {
                this.locationBeforeF7(event, showParameter, model, rowIndex);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] valueSet;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        block20: for (ChangeData changeData : valueSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            switch (propName) {
                case "billno": {
                    this.cleanFieldTips();
                    continue block20;
                }
                case "org": {
                    this.cleanFieldTips();
                    DeptSetUtil.changeBizOrg((IDataModel)this.getModel(), (Object)newValue, (String)"applydept");
                    continue block20;
                }
                case "billtype": {
                    BillTypeHelper.billTypeChange((IFormView)this.getView());
                    this.callBiztypeChange(MessageBoxResult.Yes);
                    continue block20;
                }
                case "materialcfg": {
                    this.materialCfgChange(newValue, rowIndex);
                    continue block20;
                }
                case "materialid": {
                    model.setValue("qty", null, rowIndex);
                    this.materialChanged((DynamicObject)newValue, rowIndex);
                    continue block20;
                }
                case "biztype": {
                    BizTypeHelper.biztypeChange((Object)oldValue, (AbstractBillPlugIn)this);
                    continue block20;
                }
                case "location": {
                    if (this.locationCheck(newValue, rowIndex) || newValue == null) continue block20;
                    this.getModel().setValue("location", oldValue, rowIndex);
                    continue block20;
                }
                case "warehouse": {
                    this.getModel().setValue("location", null, rowIndex);
                    continue block20;
                }
            }
        }
    }

    private void filterF7Inspecorg(BeforeF7SelectEvent event) {
        DynamicObject org = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u7ec4\u7ec7\u3002", (String)"UrgentpassBillPlugin_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
        } else {
            List deftoOrgs = PlatformOrgUnitServiceHelper.getAllToOrg((String)"", (String)"06", (Long)Long.parseLong(org.getPkValue().toString()), (boolean)true);
            if (!deftoOrgs.isEmpty()) {
                QFilter qFilter = new QFilter("id", "in", (Object)deftoOrgs);
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        switch (e.getCallBackId()) {
            case "biztypeChange": {
                this.callBiztypeChange(e.getResult());
                break;
            }
        }
    }

    public void callBiztypeChange(MessageBoxResult result) {
        IDataModel model = this.getModel();
        switch (result) {
            case Yes: {
                DynamicObjectCollection matintoentity = model.getEntryEntity("materialentry");
                for (int i = matintoentity.size() - 1; i >= 0; --i) {
                    model.deleteEntryRow("materialentry", i);
                }
                this.getView().invokeOperation("newentry");
                BizTypeHelper.qrouteDeal((IFormView)this.getView());
                break;
            }
            case Cancel: {
                model.beginInit();
                model.setValue("biztype", (Object)this.getPageCache().get("biztypetmp"));
                model.endInit();
                model.updateCache();
                this.getView().updateView("biztype");
                break;
            }
        }
    }

    private void locationBeforeF7(BeforeF7SelectEvent e, ListShowParameter showParameter, IDataModel bill, int rowIndex) {
        DynamicObject warehouse = (DynamicObject)bill.getValue("warehouse", rowIndex);
        if (null == warehouse) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u884c\u7684\u4ed3\u5e93\u3002", (String)"UrgentpassBillPlugin_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
            List<Long> ids = this.getLoactionIds(locationCol);
            QFilter qFilter = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void materialCfgBeforeF7(IDataModel model, ListShowParameter showParameter) {
        Object bizType = model.getValue("biztype");
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        if (null == bizType) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"UrgentpassBillPlugin_2", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]));
            qFilters.add(new QFilter("id", "=", (Object)-1L));
            return;
        }
        Long bizTypeId = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"biztype").getLong("id");
        qFilters.add(new QFilter("entryentity.inspecttype.id", "=", (Object)bizTypeId));
    }

    private void materialChanged(DynamicObject materialInfo, int rowIndex) {
        if (materialInfo != null) {
            this.getModel().setValue("unit", null, rowIndex);
            DynamicObject unit = materialInfo.getDynamicObject("baseunit");
            if (unit != null) {
                Long unitId = (Long)unit.getPkValue();
                this.getModel().setValue("unit", (Object)unitId, rowIndex);
            }
            LotNumberHelper.lotnumberEnable((IDataModel)this.getModel(), (IFormView)this.getView(), (DynamicObject)materialInfo, (int)rowIndex, (Boolean)Boolean.TRUE);
        }
    }

    private void materialCfgChange(Object newValue, int rowIndex) {
        if (newValue != null) {
            DynamicObject m = ((DynamicObject)newValue).getDynamicObject("masterid");
            this.getModel().setValue("materialid", (Object)m, rowIndex);
        } else {
            this.getModel().setValue("materialid", null, rowIndex);
        }
    }

    private boolean locationCheck(Object locationObj, int rowIndex) {
        boolean f = false;
        DynamicObject wareHouse = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"warehouse", (int)rowIndex);
        if (wareHouse != null && locationObj != null) {
            DynamicObjectCollection locationCol = wareHouse.getDynamicObjectCollection("entryentity");
            DynamicObject location = (DynamicObject)locationObj;
            for (DynamicObject wareHouseEntry : locationCol) {
                DynamicObject locationW = wareHouseEntry.getDynamicObject("location");
                if (!Objects.equals(location.getPkValue(), locationW.getPkValue())) continue;
                f = true;
                break;
            }
        }
        return f;
    }

    private void cleanFieldTips() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("pageId", this.getView().getPageId());
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("cleanFieldTips", map);
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }
}

