/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.errorcode;

import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.qmc.qcbd.common.errorcode.QmcErrorCode;
import kd.qmc.qcbd.common.errorcode.QmcErrorLevel;

public class QmcErrorCodeUtils {
    private static final String PREFIX = "kd.qmc.qcbd.";

    public static QmcErrorCode create(String code, String message) {
        return QmcErrorCodeUtils.create(PREFIX, code, message, QmcErrorLevel.Error.getValue());
    }

    public static QmcErrorCode create(String code, String message, int scmErrorLevel) {
        return QmcErrorCodeUtils.create(PREFIX, code, message, scmErrorLevel);
    }

    public static QmcErrorCode create(String prefix, String code, String message) {
        return QmcErrorCodeUtils.create(prefix, code, message, QmcErrorLevel.Error.getValue());
    }

    public static QmcErrorCode create(String prefix, String code, String message, int scmErrorLevel) {
        return new QmcErrorCode(new ErrorCode(prefix + code, message), scmErrorLevel);
    }

    public static String getCodeErrorMessage(ErrorCode errorCode) {
        KDException kde = new KDException(errorCode, new Object[0]);
        return kde.getMessage();
    }

    public static String getCodeErrorMessage(ErrorCode errorCode, Object ... args) {
        KDException kde = new KDException(errorCode, args);
        return kde.getMessage();
    }

    public static void showMessge(IFormView formView, QmcErrorCode scmErrorCode) {
        if (scmErrorCode == null) {
            return;
        }
        switch (scmErrorCode.getErrorLevel()) {
            case 0: {
                formView.showErrorNotification(scmErrorCode.getErrorCode().getMessage());
                break;
            }
            case 1: {
                formView.showErrorNotification(scmErrorCode.getErrorCode().getMessage());
                break;
            }
            case 2: {
                formView.showErrorNotification(scmErrorCode.getErrorCode().getMessage());
                break;
            }
            case 3: {
                formView.showTipNotification(scmErrorCode.getErrorCode().getMessage(), Integer.valueOf(5000));
                break;
            }
            case 4: {
                formView.showSuccessNotification(scmErrorCode.getErrorCode().getMessage(), Integer.valueOf(3000));
                break;
            }
        }
    }
}

