/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.errorcode;

import kd.bos.dataentity.resource.ResManager;

public enum QmcErrorLevel {
    FatalError(QmcErrorLevel.getFatalErrorName(), 0),
    Warning(QmcErrorLevel.getWarningName(), 1),
    Error(QmcErrorLevel.getErrorName(), 2),
    Info(QmcErrorLevel.getInfoName(), 3),
    SuccessInfo(QmcErrorLevel.getSuccessInfoName(), 4);

    private String name;
    private int value;

    private QmcErrorLevel(String name, int value) {
        this.name = name;
        this.value = value;
    }

    private static String getFatalErrorName() {
        return ResManager.loadKDString((String)"\u4e2d\u65ad\u9519\u8bef", (String)"QmcErrorLevel_0", (String)"qmc-qcbd-common", (Object[])new Object[0]);
    }

    private static String getWarningName() {
        return ResManager.loadKDString((String)"\u8b66\u544a", (String)"QmcErrorLevel_1", (String)"qmc-qcbd-common", (Object[])new Object[0]);
    }

    private static String getErrorName() {
        return ResManager.loadKDString((String)"\u9519\u8bef", (String)"QmcErrorLevel_2", (String)"qmc-qcbd-common", (Object[])new Object[0]);
    }

    private static String getInfoName() {
        return ResManager.loadKDString((String)"\u4e00\u822c\u63d0\u793a", (String)"QmcErrorLevel_3", (String)"qmc-qcbd-common", (Object[])new Object[0]);
    }

    private static String getSuccessInfoName() {
        return ResManager.loadKDString((String)"\u6210\u529f\u63d0\u793a", (String)"QmcErrorLevel_4", (String)"qmc-qcbd-common", (Object[])new Object[0]);
    }

    private String getEnumName() {
        switch (this) {
            case FatalError: {
                return QmcErrorLevel.getFatalErrorName();
            }
            case Warning: {
                return QmcErrorLevel.getWarningName();
            }
            case Error: {
                return QmcErrorLevel.getErrorName();
            }
            case Info: {
                return QmcErrorLevel.getInfoName();
            }
            case SuccessInfo: {
                return QmcErrorLevel.getSuccessInfoName();
            }
        }
        return "";
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.getEnumName();
    }

    public static String getName(int value) {
        String name = null;
        for (QmcErrorLevel type : QmcErrorLevel.values()) {
            if (type.getValue() != value) continue;
            name = type.name;
            break;
        }
        return name;
    }

    public static QmcErrorLevel valueOf(int level) {
        QmcErrorLevel errorLevel = FatalError;
        switch (level) {
            case 1: {
                errorLevel = Warning;
                break;
            }
            case 2: {
                errorLevel = Error;
                break;
            }
            case 3: {
                errorLevel = Info;
                break;
            }
            case 4: {
                errorLevel = SuccessInfo;
                break;
            }
            default: {
                errorLevel = FatalError;
            }
        }
        return errorLevel;
    }
}

