/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class BaseUnitQtyConVertUtil {
    private static Log log = LogFactory.getLog(BaseUnitQtyConVertUtil.class);

    public static BigDecimal getQtyConvert(Long materialId, Long srcUnit, BigDecimal srcqty, DynamicObject baseunit) {
        HashMap<String, DynamicObject> cacheMap = new HashMap<String, DynamicObject>();
        return BaseUnitQtyConVertUtil.getQtyConvert(materialId, srcUnit, srcqty, baseunit, cacheMap);
    }

    public static BigDecimal getQtyConvert(Long materialId, Long srcUnit, BigDecimal srcqty, DynamicObject baseunit, Map<String, DynamicObject> cacheMap) {
        BigDecimal baseQty = BigDecimal.ZERO;
        if (cacheMap == null) {
            cacheMap = new HashMap<String, DynamicObject>();
        }
        if (materialId != null && srcUnit != null && baseunit != null && srcqty != null && srcqty.compareTo(BigDecimal.ZERO) != 0) {
            Long baseunitId = (Long)baseunit.getPkValue();
            if (srcUnit.equals(baseunitId)) {
                baseQty = srcqty;
            } else {
                DynamicObject muConv = BaseUnitQtyConVertUtil.getMUConv(materialId, srcUnit, baseunitId, cacheMap);
                if (muConv != null) {
                    int numberator = muConv.getInt("numerator");
                    int denominator = muConv.getInt("denominator");
                    if (denominator != 0) {
                        baseQty = srcqty.multiply(new BigDecimal(numberator)).divide(new BigDecimal(denominator), BaseUnitQtyConVertUtil.getPrecision(baseunit), BaseUnitQtyConVertUtil.getPrecisionaccount(baseunit));
                    }
                }
            }
        }
        return baseQty;
    }

    private static DynamicObject getMUConv(Long materialId, Long srcUnit, Long baseunitId, Map<String, DynamicObject> cacheMap) {
        DynamicObject muConv = null;
        try {
            String convKey = BaseUnitQtyConVertUtil.getUnitRateConvCacheKey(materialId, srcUnit, baseunitId);
            muConv = cacheMap.get(convKey);
            if (muConv == null) {
                muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit, (Long)baseunitId);
                cacheMap.put(convKey, muConv);
            }
        }
        catch (Exception e) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)materialId, (String)"bd_material");
            log.error(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7269\u6599\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\u62a5\u9519\uff0c\u7269\u6599\u7f16\u7801\uff1a%1$s\uff0c\u8be6\u7ec6\u62a5\u9519\u4fe1\u606f\uff1a%2$s\u3002", (String)"BaseUnitQtyConVertUtil_0", (String)"qmc-qcbd-common", (Object[])new Object[0]), dynamicObject.getString("number"), e));
        }
        return muConv;
    }

    private static int getPrecisionaccount(DynamicObject baseunit) {
        int precisionaccount = baseunit.getInt("precisionaccount");
        switch (precisionaccount) {
            case 1: {
                return 4;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        return 4;
    }

    private static int getPrecision(DynamicObject baseunit) {
        int result = 2;
        Object precision = baseunit.get("precision");
        if (Objects.nonNull(precision)) {
            result = (Integer)precision;
        }
        return result;
    }

    private static String getUnitRateConvCacheKey(Long materialId, Long srcUnitId, Long desUnitId) {
        StringBuilder cachekeySb = new StringBuilder("unitRateCache_").append("_").append(materialId).append("_").append(srcUnitId).append("_").append(desUnitId);
        return cachekeySb.toString();
    }

    public static BigDecimal getBaseQty(DynamicObject dyncObj, String materialProp, String unitProp, String qtyProp, Map<String, DynamicObject> cacheMap) {
        DynamicObject materialObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData(dyncObj, materialProp);
        DynamicObject unitObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData(dyncObj, unitProp);
        BigDecimal qty = DynamicObjDataUtil.getDynamicObjectBigDecimalData(dyncObj, qtyProp);
        BigDecimal baseQty = null;
        if (materialObj == null || unitObj == null || qty == null) {
            return baseQty;
        }
        long materialObjId = DynamicObjDataUtil.getDynamicObjectPK(materialObj);
        long unitObjId = DynamicObjDataUtil.getDynamicObjectPK(unitObj);
        DynamicObject baseObj = materialObj.getDynamicObject("baseunit");
        baseQty = BaseUnitQtyConVertUtil.getQtyConvert(materialObjId, unitObjId, qty, baseObj, cacheMap);
        return baseQty;
    }
}

