/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;

public class BigDecimalUtil {
    public static BigDecimal subtractObject(Object dec1, Object dec2) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).subtract(BigDecimalUtil.toBigDecimal(dec2));
    }

    public static BigDecimal divideObject(Object dec1, Object dec2, int scale) {
        return BigDecimalUtil.divideObject(dec1, dec2, scale, 4);
    }

    public static BigDecimal divideObject(Object dec1, Object dec2, int scale, int roundingMode) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        if (BigDecimalUtil.toBigDecimal(dec2).signum() == 0) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).divide(BigDecimalUtil.toBigDecimal(dec2), scale, roundingMode);
    }

    public static BigDecimal multiplyObject(Object dec1, Object dec2, int scale) {
        if (dec1 == null || dec2 == null) {
            return null;
        }
        BigDecimal obj = BigDecimalUtil.toBigDecimal(dec1).multiply(BigDecimalUtil.toBigDecimal(dec2));
        return obj.setScale(scale, 6);
    }

    public static BigDecimal addObject(Object dec1, Object dec2) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).add(BigDecimalUtil.toBigDecimal(dec2));
    }

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            return BigDecimal.ZERO;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Integer) {
            return new BigDecimal(((Integer)obj).toString());
        }
        if (obj instanceof Long) {
            return new BigDecimal(((Long)obj).toString());
        }
        if (obj instanceof Double) {
            return new BigDecimal(((Double)obj).toString());
        }
        String str = obj.toString().trim();
        if (str.toLowerCase().indexOf(101) > -1) {
            if (StringUtils.isNumeric((String)str)) {
                return new BigDecimal(str);
            }
            return BigDecimal.ZERO;
        }
        if (str.matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
            return new BigDecimal(str);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getNullToZero(DynamicObject obj, String key) {
        BigDecimal value = obj.getBigDecimal(key);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value;
    }

    public static BigDecimal patternNum(BigDecimal obj, String pattern) {
        DecimalFormat df = new DecimalFormat(pattern);
        return new BigDecimal(df.format(obj));
    }

    public static BigDecimal formatRoundHalfUp(BigDecimal obj) {
        if (obj == null) {
            return obj;
        }
        return obj.setScale(0, 4);
    }

    public static BigDecimal toBigDecimalNull(Object obj) {
        if (null == obj) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(obj);
    }

    public static boolean stringIsDouble(String numberStr) {
        return StringUtils.isNotEmpty((String)numberStr) && StringUtils.isNumeric((String)numberStr.replaceFirst("-", ""));
    }

    public static BigDecimal parserBigDecimal(String numberStr, int maxSize) {
        if (StringUtils.isEmpty((String)numberStr)) {
            return null;
        }
        return new BigDecimal(BigDecimalUtil.parserBigDecimalStr(numberStr, maxSize));
    }

    public static String parserBigDecimalStr(String numberStr, int maxSize) {
        if (StringUtils.isEmpty((String)numberStr)) {
            return "";
        }
        int length = numberStr.length();
        int pointIndex = numberStr.indexOf(".");
        if (0 == pointIndex) {
            return "0" + numberStr;
        }
        if (length == pointIndex + 1) {
            return numberStr.substring(0, pointIndex);
        }
        int realPointSize = length - pointIndex - 1;
        if (realPointSize > maxSize) {
            int subIndex = length - (realPointSize - maxSize);
            return BigDecimalUtil.dealLeftZero(numberStr.substring(0, subIndex));
        }
        return BigDecimalUtil.dealLeftZero(numberStr);
    }

    private static String dealLeftZero(String numberStr) {
        int zeroIndex = -1;
        char[] chars = numberStr.toCharArray();
        int length = chars.length;
        for (int i = 0; i < length && '0' == chars[i]; ++i) {
            if ('0' != chars[i] || i + 1 >= length || '.' == chars[i + 1]) continue;
            zeroIndex = i;
        }
        if (-1 == zeroIndex) {
            return numberStr;
        }
        return numberStr.substring(zeroIndex + 1);
    }
}

