/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.qmc.qcbd.common.model.BillEntryQtyModel;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;

public class BillEntryRowOpUtil {
    private static final Integer defUnitPrecision = 10;

    public static void setQtyValue(IFormView billView, IDataModel model, Integer srcRowIndex, List<Integer> newRowIndex, Map<Integer, BillEntryQtyModel> rowQtyMap, String qtyFieldKey, String qtyBaseFieldKey) {
        if (rowQtyMap.isEmpty()) {
            return;
        }
        Object scSystem = model.getValue("scsystem", srcRowIndex.intValue());
        Object auxpty = model.getValue("auxpty", srcRowIndex.intValue());
        model.beginInit();
        BillEntryQtyModel qtyModel = rowQtyMap.get(srcRowIndex);
        BillEntryRowOpUtil.setRowQtyValue(model, qtyFieldKey, qtyBaseFieldKey, qtyModel, srcRowIndex);
        for (Integer rowIndex : newRowIndex) {
            qtyModel = rowQtyMap.get(rowIndex);
            BillEntryRowOpUtil.setRowQtyValue(model, qtyFieldKey, qtyBaseFieldKey, qtyModel, rowIndex);
            model.setValue("scsystem", scSystem, rowIndex.intValue());
            model.setValue("auxpty", auxpty, rowIndex.intValue());
        }
        model.endInit();
        model.updateCache();
        BillEntryRowOpUtil.drawRowQty(billView, srcRowIndex, qtyFieldKey, qtyBaseFieldKey);
        for (Integer rowIndex : newRowIndex) {
            BillEntryRowOpUtil.drawRowQty(billView, rowIndex, qtyFieldKey, qtyBaseFieldKey);
            billView.updateView("scsystem", rowIndex.intValue());
            billView.updateView("auxpty", rowIndex.intValue());
        }
    }

    private static void drawRowQty(IFormView billView, Integer srcRowIndex, String qtyFieldKey, String qtyBaseFieldKey) {
        billView.updateView(qtyFieldKey, srcRowIndex.intValue());
        billView.updateView(qtyBaseFieldKey, srcRowIndex.intValue());
    }

    private static void setRowQtyValue(IDataModel model, String qtyFieldKey, String qtyBaseFieldKey, BillEntryQtyModel qtyModel, Integer rowIndex) {
        model.setValue(qtyFieldKey, (Object)qtyModel.getQty(), rowIndex.intValue());
        model.setValue(qtyBaseFieldKey, (Object)qtyModel.getBaseQty(), rowIndex.intValue());
    }

    public static final void setQtyValue(DynamicObjectCollection matEntrys, Integer srcRowIndex, List<Integer> newRowIndex, Map<Integer, BillEntryQtyModel> rowQtyMap, String qtyFieldKey, String qtyBaseFieldKey) {
        if (rowQtyMap.isEmpty()) {
            return;
        }
        DynamicObject srcRowDyo = (DynamicObject)matEntrys.get(srcRowIndex.intValue());
        Object scSystem = srcRowDyo.get("scsystem");
        Object auxpty = srcRowDyo.get("auxpty");
        BillEntryQtyModel qtyModel = rowQtyMap.get(srcRowIndex);
        BillEntryRowOpUtil.setRowQtyValue(srcRowDyo, qtyFieldKey, qtyBaseFieldKey, qtyModel);
        for (Integer rowIndex : newRowIndex) {
            qtyModel = rowQtyMap.get(rowIndex);
            DynamicObject rowDyo = (DynamicObject)matEntrys.get(rowIndex.intValue());
            BillEntryRowOpUtil.setRowQtyValue(rowDyo, qtyFieldKey, qtyBaseFieldKey, qtyModel);
            rowDyo.set("scsystem", scSystem);
            rowDyo.set("auxpty", auxpty);
        }
    }

    private static void setRowQtyValue(DynamicObject srcRowDyo, String qtyFieldKey, String qtyBaseFieldKey, BillEntryQtyModel qtyModel) {
        srcRowDyo.set(qtyFieldKey, (Object)qtyModel.getQty());
        srcRowDyo.set(qtyBaseFieldKey, (Object)qtyModel.getBaseQty());
    }

    public static Map<Integer, BillEntryQtyModel> getRowIndexQtyMapping(DynamicObjectCollection billEntrys, String qtyFieldKey, String materialKey, String unitKey, String unitBaseKey, Integer srcRowIndex, List<Integer> newRowIndex) {
        int rowCount = newRowIndex.size() + 1;
        HashMap<Integer, BillEntryQtyModel> rowQtyMap = new HashMap<Integer, BillEntryQtyModel>(rowCount);
        if (billEntrys.isEmpty() || newRowIndex.isEmpty()) {
            return rowQtyMap;
        }
        DynamicObject entry = (DynamicObject)billEntrys.get(srcRowIndex.intValue());
        BigDecimal srcQty = entry.getBigDecimal(qtyFieldKey);
        if (srcQty == null || BigDecimal.ZERO.compareTo(srcQty) == 0) {
            return rowQtyMap;
        }
        DynamicObject unit = entry.getDynamicObject(unitKey);
        Integer unitPrecision = defUnitPrecision;
        if (unit != null) {
            unitPrecision = unit.getInt("precision");
        }
        DynamicObject materialObj = entry.getDynamicObject(materialKey);
        DynamicObject baseunitObj = entry.getDynamicObject(unitBaseKey);
        if (unit == null || materialObj == null || baseunitObj == null) {
            return rowQtyMap;
        }
        BigDecimal average = srcQty.divide(new BigDecimal(rowCount), (int)unitPrecision, RoundingMode.DOWN);
        BigDecimal multiply = average.multiply(new BigDecimal(newRowIndex.size()));
        BigDecimal lastRowQty = srcQty.subtract(multiply);
        rowQtyMap.put(srcRowIndex, BillEntryRowOpUtil.getBillEntryQtyModel(average, null));
        for (int i = 0; i < newRowIndex.size() - 1; ++i) {
            rowQtyMap.put(newRowIndex.get(i), BillEntryRowOpUtil.getBillEntryQtyModel(average, null));
        }
        rowQtyMap.put(newRowIndex.get(newRowIndex.size() - 1), BillEntryRowOpUtil.getBillEntryQtyModel(lastRowQty, null));
        BillEntryRowOpUtil.updateBaseQty((Long)materialObj.getPkValue(), (Long)unit.getPkValue(), baseunitObj, rowQtyMap);
        return rowQtyMap;
    }

    private static void updateBaseQty(Long materialId, Long srcUnit, DynamicObject baseunit, Map<Integer, BillEntryQtyModel> rowQtyMap) {
        HashMap<String, DynamicObject> cacheMap = new HashMap<String, DynamicObject>(16);
        for (Map.Entry<Integer, BillEntryQtyModel> entry : rowQtyMap.entrySet()) {
            BillEntryQtyModel model = entry.getValue();
            BigDecimal qtybase = BaseUnitQtyConVertUtil.getQtyConvert(materialId, srcUnit, model.getQty(), baseunit, cacheMap);
            model.setBaseQty(qtybase);
        }
    }

    private static BillEntryQtyModel getBillEntryQtyModel(BigDecimal qty, BigDecimal baseQty) {
        BillEntryQtyModel model = new BillEntryQtyModel();
        model.setQty(qty);
        model.setBaseQty(baseQty);
        return model;
    }
}

