/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;

public class BizChangeWinUtil {
    public static void setIgnoreBizChanged(IDataModel dm, String entryNumber, Map<String, String> mapField) {
        DynamicObject headObj = dm.getDataEntity();
        DynamicObjectType headType = headObj.getDynamicObjectType();
        DataEntityState headState = headObj.getDataEntityState();
        HashSet<String> cgStoreFieldSet = new HashSet<String>(16);
        DynamicObjectCollection colls = dm.getEntryEntity(entryNumber);
        for (DynamicObject coll : colls) {
            DataEntityState entityState = coll.getDataEntityState();
            if (!entityState.isBizChanged()) continue;
            Iterable changeProps = entityState.getBizChangedProperties();
            for (IDataEntityProperty changeProp : changeProps) {
                String changePropKey = changeProp.getName();
                cgStoreFieldSet.add(changePropKey);
            }
        }
        for (Map.Entry<String, String> entry : mapField.entrySet()) {
            String storageField = entry.getKey();
            String viewField = entry.getValue();
            DynamicProperty storeProp = headType.getProperty(viewField);
            if (cgStoreFieldSet.contains(storageField)) continue;
            headState.setBizChanged(storeProp.getOrdinal(), false);
        }
    }

    public static void setIngoreEntryFields(IDataModel dm, String entryNumber, Map<String, Integer> ingoreEntryFields) {
        DynamicObjectCollection colls = dm.getEntryEntity(entryNumber);
        if (Objects.nonNull(colls)) {
            for (DynamicObject coll : colls) {
                DataEntityState entityState = coll.getDataEntityState();
                if (!entityState.isBizChanged()) continue;
                Iterable changeProps = entityState.getBizChangedProperties();
                for (IDataEntityProperty changeProp : changeProps) {
                    String changePropKey = changeProp.getName();
                    if (!ingoreEntryFields.containsKey(changePropKey)) continue;
                    BizChangeWinUtil.setIngoreField(changePropKey, coll, ingoreEntryFields);
                }
            }
        }
    }

    public static void setIngoreHeadFields(IDataModel dm, Map<String, Integer> ingoreFields) {
        DynamicObject dyncObj = dm.getDataEntity();
        DataEntityState entityState = dyncObj.getDataEntityState();
        if (!entityState.isBizChanged()) {
            return;
        }
        Iterable changeProps = entityState.getBizChangedProperties();
        for (IDataEntityProperty changeProp : changeProps) {
            String changePropKey = changeProp.getName();
            if (!ingoreFields.containsKey(changePropKey)) continue;
            entityState.setBizChanged(changeProp.getOrdinal(), Boolean.FALSE.booleanValue());
        }
    }

    public static void setIngoreField(String fieldName, DynamicObject dyncObj, Map<String, Integer> ingoreFields) {
        DynamicProperty prop;
        Integer ordinal = ingoreFields.get(fieldName);
        DataEntityState objState = dyncObj.getDataEntityState();
        DynamicObjectType objType = dyncObj.getDynamicObjectType();
        if (ordinal.compareTo(-1) == 0 && (prop = objType.getProperty(fieldName)) != null) {
            ordinal = prop.getOrdinal();
            ingoreFields.put(fieldName, prop.getOrdinal());
        }
        if (ordinal.compareTo(0) >= 0) {
            objState.setBizChanged(ordinal.intValue(), Boolean.FALSE.booleanValue());
        }
    }

    public static Boolean isPropChanged(DataEntityState entityState, String propName) {
        Boolean isPropChanged = Boolean.FALSE;
        if (!entityState.isBizChanged()) {
            return isPropChanged;
        }
        Iterable changeProps = entityState.getBizChangedProperties();
        for (IDataEntityProperty changeProp : changeProps) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)changeProp.getName(), (CharSequence)propName)) continue;
            isPropChanged = Boolean.TRUE;
            break;
        }
        return isPropChanged;
    }

    public static void dealEntryBizChange(ChangeData changeData, String fieldName, Map<String, Integer> mIngoreEntryFields) {
        String fieldNameId = fieldName + "_id";
        if (changeData.getDataEntity().getDataEntityType().getProperties().containsKey((Object)fieldNameId)) {
            fieldName = fieldNameId;
        }
        if (!mIngoreEntryFields.containsKey(fieldName)) {
            return;
        }
        BizChangeWinUtil.setIngoreField(fieldName, changeData.getDataEntity(), mIngoreEntryFields);
    }
}

