/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.qmc.qcbd.common.model.calculator.ICustCalculator;

public class CalculatorEval {
    private static Log logger = LogFactory.getLog(CalculatorEval.class);
    private int callOrder;
    private String str;
    private int pos = -1;
    private int ch;

    public CalculatorEval(String str) {
        this.str = str;
        this.callOrder = 0;
    }

    void nextChar() {
        logger.info("-------\u516c\u5f0f\u89e3\u6790----nextChar----callOrder=" + this.callOrder++);
        this.ch = ++this.pos < this.str.length() ? (int)this.str.charAt(this.pos) : -1;
        logger.info("-------\u516c\u5f0f\u89e3\u6790----nextChar----ch=" + this.ch);
    }

    boolean eat(int charToEat) {
        while (this.ch == 32) {
            this.nextChar();
        }
        logger.info("--\u516c\u5f0f\u89e3\u6790-------eat----------callOrder=" + this.callOrder++);
        logger.info("---------eat----------ch=" + this.ch);
        logger.info("---------eat----------charToEat=" + charToEat);
        if (this.ch == charToEat) {
            this.nextChar();
            return true;
        }
        return false;
    }

    public BigDecimal parse() {
        logger.info("-------\u516c\u5f0f\u89e3\u6790----parse----callOrder=" + this.callOrder++);
        this.nextChar();
        BigDecimal x = this.parseExpression();
        if (this.pos < this.str.length()) {
            throw new NullPointerException("Unexpected: " + (char)this.ch);
        }
        logger.info("-------\u516c\u5f0f\u89e3\u6790----parse----x=" + x);
        return x;
    }

    private BigDecimal parseExpression() {
        logger.info("-------\u516c\u5f0f\u89e3\u6790----parseExpression----callOrder=" + this.callOrder++);
        BigDecimal x = this.parseTerm();
        while (true) {
            if (this.eat(43)) {
                x = x.add(this.parseTerm());
                continue;
            }
            if (!this.eat(45)) break;
            x = x.subtract(this.parseTerm());
        }
        return x;
    }

    private BigDecimal parseTerm() {
        logger.info("-------\u516c\u5f0f\u89e3\u6790----parseTerm----callOrder=" + this.callOrder++);
        BigDecimal x = this.parseFactor();
        while (true) {
            if (this.eat(42)) {
                x = x.multiply(this.parseFactor());
                continue;
            }
            if (!this.eat(47)) break;
            x = x.divide(this.parseFactor());
        }
        return x;
    }

    private BigDecimal parseFactor() {
        logger.info("-------\u516c\u5f0f\u89e3\u6790----parseFactor----callOrder=" + this.callOrder++);
        if (this.eat(43)) {
            return this.parseFactor();
        }
        if (this.eat(45)) {
            return this.parseFactor().negate();
        }
        return this.deal();
    }

    private BigDecimal deal() {
        BigDecimal x;
        logger.info("-------\u516c\u5f0f\u89e3\u6790----deal----callOrder=" + this.callOrder++);
        int startPos = this.pos;
        if (this.eat(40)) {
            x = this.parseExpression();
            this.eat(41);
        } else if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
            while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                this.nextChar();
            }
            x = new BigDecimal(this.str.substring(startPos, this.pos));
        } else if (this.ch >= 97 && this.ch <= 122) {
            while (this.ch >= 97 && this.ch <= 122) {
                this.nextChar();
            }
            x = this.fxdeal(this.str.substring(startPos, this.pos), this.parseFactor());
        } else {
            throw new NullPointerException("Unexpected: " + (char)this.ch);
        }
        return x;
    }

    private BigDecimal fxdeal(String func, BigDecimal x) {
        logger.info("-------\u516c\u5f0f\u89e3\u6790----fxdeal----callOrder=" + this.callOrder++);
        if (func.equals("sqrt")) {
            x = new BigDecimal(String.valueOf(Math.sqrt(x.doubleValue())));
        } else if (func.equals("sqr")) {
            x = new BigDecimal(String.valueOf(Math.pow(x.doubleValue(), 2.0)));
        } else if (func.equals("cube")) {
            x = new BigDecimal(String.valueOf(Math.pow(x.doubleValue(), 3.0)));
        } else if (func.equals("reciproc")) {
            x = BigDecimal.ONE.divide(x);
        } else {
            BigDecimal inParam;
            PluginProxy pluginProxy = PluginProxy.create(ICustCalculator.class, (String)"QMC_QCBD_ICustCalculator");
            List bigDecimals = pluginProxy.callReplace(arg_0 -> CalculatorEval.lambda$fxdeal$0(func, inParam = x, arg_0));
            if (CollectionUtils.isNotEmpty((Collection)bigDecimals)) {
                x = (BigDecimal)bigDecimals.get(0);
            } else {
                throw new KDBizException("Unknown function: " + func);
            }
        }
        return x;
    }

    private static /* synthetic */ BigDecimal lambda$fxdeal$0(String func, BigDecimal inParam, ICustCalculator p) {
        return p.runFormula(func, inParam);
    }
}

